<?php
    /**
     * @class  blogshop
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  blogshop 모듈의 high class
     **/

    class blogshop extends ModuleObject {

        var $allowed_blogshop_take_type_values = array('0','1','2','3');
        var $allowed_blogshop_pay_type_values = array('0','1','0|@|1');

        var $ezcro_hostname = "www.ezcro.com";
        var $ezcro_router_home = "http://xe.ezcro.com/";
        var $ezcro_paymodule_url = "http://www.ezcro.com/php/common/flex/paymodule/paymodule.html?skin_name=xe";

        var $triggers = array(
            array('document.updateDocument', 'blogshop', 'controller', 'triggerUpdateDocument', 'after'),
            array('document.insertDocument', 'blogshop', 'controller', 'triggerInsertDocument', 'after'),
            array('moduleHandler.proc', 'blogshop', 'view', 'triggerModuleHandlerProc', 'after'),
        );

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
        	@ini_set('default_socket_time',300);

            $oModuleController = &getController('module');

            // $this->triggers 트리거 일괄 추가
            foreach($this->triggers as $trigger) {
                $oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
            }

            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // $this->triggers 트리거 일괄 검사
            foreach($this->triggers as $trigger) {
                if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
            }

            if(!$oDB->isColumnExists("blogshop","blogshop_member_srl")) return true;
            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // $this->triggers 트리거 일괄 업데이트
            foreach($this->triggers as $trigger) {
                if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) {
                    $oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
                }
            }

            if(!$oDB->isColumnExists("blogshop","blogshop_member_srl")) $oDB->addColumn('blogshop',"blogshop_member_srl","number",11,0,true);
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
            ;
        }

        /**
         * @brief 블로그샵 사용자 입력값 유효성 체크
         **/
        function checkValidBlogshopInfo($args) {
            foreach($args as $key => $val ) {
                switch($key) {
                    case 'blogshop_srl' : break;
                    case 'blogshop_mem_auth_code' :
                        if(trim($val) == null )
                            return array(-1,'msg_failed_blogshop_mem_auth_code');
                    break;
                    case 'blogshop_title' :
                        if(trim($val) == "")
                            return array(-1,'msg_failed_blogshop_title');
                    break;
                    case 'blogshop_content' :
                        if(trim($val) == "")
                            return array(-1,'msg_failed_blogshop_content');
                    break;
                	case 'blogshop_take_type' :
                        if(!in_array($val,$this->allowed_blogshop_take_type_values))
                            return array(-1,'msg_failed_blogshop_take_type');
                    break;
                	case 'blogshop_pay_type' :
                        if(!in_array($val,$this->allowed_blogshop_pay_type_values))
                            return array(-1,'msg_failed_blogshop_pay_type');
                    break;
                    /*
                	case 'blogshop_mem_email' :
                        $regexp = "/^[^0-9][A-z0-9_]+([.][A-z0-9_]+)*[@][A-z0-9_]+([.][A-z0-9_]+)*[.][A-z]{2,4}$/";
                        if(!preg_match($regexp, $val))
                            return array(-1,'msg_failed_valided_email_address');
                    break;
                    */
                    case 'blogshop_pro_num' :
                        if(!is_numeric($val))
                            return array(-1,'msg_nan_blogshop_pro_num');
                        if($val < 1 || $val > 999)
                            return array(-1,'msg_failed_blogshop_num');
                    break;
                    case 'blogshop_price' :
                        if(!is_numeric($val))
                            return array(-1,'msg_nan_blogshop_pro_price');
                        if($val < 5000 || $val > 100000000)
                            return array(-1,'msg_failed_blogshop_blogshop_price');
                    break;
                    default:
                        if(!trim($val))
                            return array(-1,'msg_invalid_request');
                    break;
                } // end switch
           } // end foreach
           return array(1,'successed');
        }

        /**
         * @brief chunk값이 포함된 http 컨텐츠에서 unchunk 시켜 반환함.
         **/
        function unchunkHttpResponse($str = null) {
            if (!is_string($str) or strlen($str) < 1) {
                return false;
            }
            $crlf = "\r\n";
            $add = strlen($crlf);
            $tmp = $str;
            $str = "";
            do {
                $tmp = ltrim($tmp);
                $pos = strpos($tmp, $crlf);
                if ($pos === false) {
                    return false;
                }
                $len = hexdec(substr($tmp,0,$pos));
                if (!is_numeric($len) or $len < 0) {
                    return false;
                }
                $str .= substr($tmp, ($pos + $add), $len);
                $tmp  = substr($tmp, ($len + $pos + $add));
                $check = trim($tmp);
            } while(!empty($check));
            unset($tmp);
            return $str;
        }
    }
?>
