if(typeof(XmlJsFilterExecuteFilter) == 'undefined') {
	function XmlJsFilterExecuteFilter(filter, value) {
	    switch(filter) {
	        case "email" :
	        case "email_address" :
	                var regx = /^[_0-9a-zA-Z-]+(\.[_0-9a-zA-Z-]+)*@[0-9a-zA-Z-]+(\.[0-9a-zA-Z-]+)*$/;
	                return regx.test(value);
	            break;
	        case "userid" :
	        case "user_id" :
	                var regx = /^[a-zA-Z]+([_0-9a-zA-Z]+)*$/;
	                return regx.test(value);
	            break;
	        case "homepage" :
	                var regx = /^(http|https|ftp|mms):\/\/[0-9a-z-]+(\.[_0-9a-z-\/\~]+)+(:[0-9]{2,4})*$/;
	                return regx.test(value);
	            break;
	        case "korean" :
	                var regx = /^[가-힣]*$/;
	                return regx.test(value);
	            break;
	        case "korean_number" :
	                var regx = /^[가-힣0-9]*$/;
	                return regx.test(value);
	            break;
	        case "alpha" :
	                var regx = /^[a-zA-Z]*$/;
	                return regx.test(value);
	            break;
	        case "alpha_number" :
	                var regx = /^[a-zA-Z][a-zA-Z0-9\_]*$/;
	                return regx.test(value);
	            break;
	        case "number" :
	            return !isNaN(value);
	        break;
	    }
	
	    return null;
	}
}