<?php
    /**
     * @class  blogshopModel
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  blogshop 모듈의 model class
     **/

    class blogshopModel extends blogshop {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 블로그샵 저장
         **/
        function insertBlogshop($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            
            $logged_info = Context::get('logged_info');
            $args->blogshop_member_srl = $logged_info->member_srl;
            $output = executeQuery("blogshop.insertBlogshop", $args);
            $output->add('blogshop_srl',$args->blogshop_srl);
            return $output;
        }
        
        /**
         * @brief 블로그샵 수정
         **/
        function updateBlogshop($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');

            // 물품정보수정
            $output = executeQuery("blogshop.updateBlogshop", $args);
                        
            $output->add('blogshop_srl',$args->blogshop_srl);
            return $output;
        }    
        
        /**
         * @brief 블로그샵 인증 정보 수정
         **/
        function updateBlogshopAuthInfo($args) {
            if(!$args->blogshop_document_srl || !$args->blogshop_mem_email || !$args->blogshop_mem_auth_code || !$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.updateBlogshopAuthInfo", $args);
            return $output;
        }  
        
        /**
         * @brief 블로그샵 삭제
         **/
        function deleteBlogshop($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.deleteBlogshop", $args);
            return $output;
        }
        
        /**
         * @brief blogshop_document_srl으로 블로그샵 검색
         **/
        function getBlogshopByBlogshopDocumentSrl($args) {
            if(!$args->blogshop_document_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQueryArray("blogshop.getBlogshopByBlogshopDocumentSrl", $args);
            return $output;
        }
        
        /**
         * @brief blogshop_document_srl으로 블로그샵 개수 검색
         **/
        function getBlogshopCountByBlogshopDocumentSrl($args) {
            if(!$args->blogshop_document_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.getBlogshopCountByBlogshopDocumentSrl", $args);
            return ($output->data->cnt > 0) ? $output->data->cnt : 0;
        }
        
        /**
         * @brief blogshop_srl으로 블로그샵 개수 검색
         **/
        function getBlogshopCountByBlogshopSrl($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.getBlogshopCountByBlogshopSrl", $args);
            return ($output->data->cnt > 0) ? $output->data->cnt : 0;
        }
        
         /**
         * @brief 상품 거래번호 업데이트
         **/
        function updateBlogshopDealNumber($args) {
            if(!$args->blogshop_srl || !$args->blogshop_document_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.updateBlogshopDealNumber", $args);
            return $output;
        }  
        
         /**
         * @brief blogshop_srl으로 블로그샵 검색
         **/
        function getBlogshopByBlogshopSrl($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.getBlogshopByBlogshopSrl", $args);
            return $output;
        }  
        
         /**
         * @brief 블로그샵 document 가져오기
         **/
        function getBlogshopDocumentsList($args) {            
            $output = executeQuery("blogshop.getBlogshopDocumentsList", $args);
            return $output;
        }         

         /**
         * @brief blogshop_document_srl으로 유효한 블로그샵 데이터 가져오기
         **/        
        function getBlogshopValidDataByBlogshopDocumentSrl($args) {
            if(!$args->blogshop_srl) return new Object(-1, 'msg_invalid_request');
            $output = executeQuery("blogshop.getBlogshopValidDataByBlogshopDocumentSrl",$args);
            return $output;
        }
         
    }
?>
