function contents_encode(contents, html) { 
	if(!html) {
		contents = contents.replace(/&/g, "&amp;");
		contents = contents.replace(/</g, "&lt;");
		contents = contents.replace(/>/g, "&gt;");
		contents = contents.replace(/\"/g, "&quot;");
	}
	contents = contents.replace(/(\r\n|\n)/g, "<br />");
	return contents;
} 

function contents_decode(contents) { 
	contents = contents.replace(/<br([^>]*)>/ig,"\n");
	contents = contents.replace(/&nbsp;/g, " ");
	contents = contents.replace(/&lt;/g, "<");
	contents = contents.replace(/&gt;/g, ">");
	contents = contents.replace(/&quot;/g, '"');
	contents = contents.replace(/&amp;/g, "&");
	return contents;
} 

function setCursor(elem) { 
	if (window.getSelection) {
		elem.select();
		window.getSelection();
		window.getSelection().collapseToEnd();
	} else {
		elem.focus();
		elem.val(elem.val());
	}
} 

function quiet_toggle(from, to) {
	(from.style.display) ? from.style.display = '' : from.style.display = 'none';
	jQuery('#' + to).toggle();
}

function document_do(trigger, obj) {
	if (trigger == 'delete') {
		var summary = contents_decode(xGetElementById('document_delete_'+obj).summary.value);
		if (summary.length > 100) summary = summary.substring(0,100) + "...";
		if (confirm('‘'+summary+'’ \n\n'+confirm_delete)) return procFilter(xGetElementById('document_delete_'+obj), delete_document);
	} else if(trigger == 'search') {
		var keyword = xGetElementById('quiet_keyword').value;
		if (keyword.substr(0,1) == ':') {
			switch (keyword) {
				case ':설정' : if(settings_address) location.href = settings_address; break;
				case ':settings' : if(settings_address) location.href = settings_address; break;
				case ':en' : doChangeLangType('en'); break;
				case ':ko' : doChangeLangType('ko'); break;
				case ':kr' : doChangeLangType('ko'); break;
				case ':fr' : doChangeLangType('fr'); break;
				case ':ge' : doChangeLangType('ge'); break;
				case ':jp' : doChangeLangType('jp'); break;
				case ':es' : doChangeLangType('es'); break;
				case ':mn' : doChangeLangType('mn'); break;
				case ':ru' : doChangeLangType('ru'); break;
				case ':vi' : doChangeLangType('vi'); break;
				case ':zh' : doChangeLangType('zh-CN'); break;
				case ':zh-CN' : doChangeLangType('zh-CN'); break;
				case ':cn' : doChangeLangType('zh-CN'); break;
				case ':zh-TW' : doChangeLangType('zh-TW'); break;
				case ':tw' : doChangeLangType('zh-TW'); break;
				default: obj.search_keyword.value = keyword; return procFilter(obj, search);
			}
		} else {
			var strReg = new RegExp("[^>]*\\:");
			obj.search_keyword.value = keyword;
			obj.search_target.value = xGetElementById('quiet_target').value;
			if(keyword.match(strReg)) {
				for(var item in search_option) {
					if(search_option[item] == keyword.match(strReg)) {
						obj.search_target.value = item;
						obj.search_keyword.value = keyword.replace(strReg, '');
						break;
					}
				}
			}
			return procFilter(obj, search);
		}
	} else if (trigger == 'write') {
		current_url = current_url.setQuery('page','');
		if(!obj.title.value && obj.nick_name.value) obj.title.value = obj.nick_name.value;
		obj.content.value = contents_encode(obj.quiet_text.value, obj.is_html.checked);
		return procFilter(obj, insert);
	} else if (trigger == 'write_e') {
		current_url = current_url.setQuery('page','');
		if(!obj.title.value && obj.nick_name.value) obj.title.value = obj.nick_name.value;
		return procFilter(obj, insert);
	} else if (trigger == 'edit') {
		if(list_type == 'link') {
			var documentObj = jQuery('#document_edit_' + obj);
			(documentObj.css('display') == 'none') ? documentObj.show() : documentObj.hide();
		} else {
			var documentObj = jQuery('#document_' + obj);
			var contents = contents_decode(jQuery("#document_" + obj + " .document_edit [name=content]").val());
			var textarea = jQuery("#document_" + obj + " .document_edit textarea");
			textarea.val(contents);
			if (documentObj.hasClass('mode_view')) {
				documentObj.removeClass('mode_view');
				documentObj.addClass('mode_edit');
				setCursor(textarea);
				if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
			} else {
				documentObj.addClass('mode_edit');
				setCursor(textarea);
				if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
			}
		}
	} else if (trigger == 'view') {
		var documentObj = jQuery('#document_' + obj);
		if (documentObj.hasClass('mode_edit')) documentObj.removeClass('mode_edit');
		documentObj.addClass('mode_view');
	} else if (trigger == 'reply') {
		if(jQuery("#document_" + obj + " .comment_write").css("display") == "none") {
			jQuery("#document_" + obj + " .comment_write").show();
			var textarea = jQuery("#document_" + obj + " .comment_write textarea");
			setCursor(textarea);
			if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
			location.href = "#comment_write_" + obj;
		} else {
			jQuery("#document_" + obj + " .comment_write").hide();
		}
	}
}

function trackback_delete_complete (ret_obj) {
	var message = ret_obj['message'];
	//alert(message);
	location.reload();
}


function trackback_delete (srl) {
	var fo_obj = xGetElementById('trackback_delete_'+srl);
	if(confirm('‘'+fo_obj.summary.value+'’ \n\n'+confirm_delete)) {
		var validator = xe.getApp('validator')[0];
		if(!validator) return false;
		if(!fo_obj.elements['_filter']) jQuery(fo_obj).prepend('<input type="hidden" name="_filter" value="" />');
		fo_obj.elements['_filter'].value = 'delete_trackback';
		validator.cast('ADD_CALLBACK', ['delete_trackback', function(form){
			var params={}, responses=[], elms=form.elements, data=jQuery(form).serializeArray();
			jQuery.each(data, function(i, field){
				var val = jQuery.trim(field.value);
				if(!val) return true;
				if(/\[\]$/.test(field.name)) field.name = field.name.replace(/\[\]$/, '');
				if(params[field.name]) params[field.name] += '|@|'+val;
				else params[field.name] = field.value;
			});
			responses = ['error','message','mid','document_srl','page'];
			exec_xml('board','procBoardDeleteTrackback', params, trackback_delete_complete, responses, params, form);
		}]);
		validator.cast('VALIDATE', [fo_obj,'delete_trackback']);
		return false;
	}
}

function comment_delete_complete(ret_obj) {
	var document_srl = ret_obj['document_srl'];
	var url = current_url.setQuery('document_srl',document_srl).setQuery('act','').setQuery('comment_srl','');
	if (location.href == url) {
		location.reload();
	} else {
		location.href = url;
	}
}

function comment_delete(fo_obj) {
	var validator = xe.getApp('validator')[0];
	if(!validator) return false;
	if(!fo_obj.elements['_filter']) jQuery(fo_obj).prepend('<input type="hidden" name="_filter" value="" />');
	fo_obj.elements['_filter'].value = 'delete_comment';
	validator.cast('ADD_CALLBACK', ['delete_comment', function(form){
		var params={}, responses=[], elms=form.elements, data=jQuery(form).serializeArray();
		jQuery.each(data, function(i, field){
			var val = jQuery.trim(field.value);
			if(!val) return true;
			if(/\[\]$/.test(field.name)) field.name = field.name.replace(/\[\]$/, '');
			if(params[field.name]) params[field.name] += '|@|'+val;
			else params[field.name] = field.value;
		});
		responses = ['error','message','mid','document_srl','page'];
		exec_xml('board','procBoardDeleteComment', params, comment_delete_complete, responses, params, form);
	}]);
	validator.cast('VALIDATE', [fo_obj,'delete_comment']);
	return false;

}

function comment_write_complete(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];
	var mid = ret_obj['mid'];
	var document_srl = ret_obj['document_srl'];
	var comment_srl = ret_obj['comment_srl'];

	var url = current_url.setQuery('document_srl',document_srl).setQuery('act','');
	if (allow_comment_srl) url = url.setQuery('comment_srl',comment_srl)+"#comment_"+comment_srl;

	//alert(message);
	if (location.href == url) {
		location.reload();
	} else {
		location.href = url;
	}
}

function comment_write(fo_obj) {
	var validator = xe.getApp('validator')[0];
	if(!validator) return false;
	if(!fo_obj.elements['_filter']) jQuery(fo_obj).prepend('<input type="hidden" name="_filter" value="" />');
	fo_obj.elements['_filter'].value = 'insert_comment';
	validator.cast('ADD_CALLBACK', ['insert_comment', function(form){
		var params={}, responses=[], elms=form.elements, data=jQuery(form).serializeArray();
		jQuery.each(data, function(i, field){
			var val = jQuery.trim(field.value);
			if(!val) return true;
			if(/\[\]$/.test(field.name)) field.name = field.name.replace(/\[\]$/, '');
			if(params[field.name]) params[field.name] += '|@|'+val;
			else params[field.name] = field.value;
		});
		responses = ['error','message','mid','document_srl','comment_srl'];
		exec_xml('board','procBoardInsertComment', params, comment_write_complete, responses, params, form);
	}]);
	validator.cast('VALIDATE', [fo_obj,'insert_comment']);
	return false;
}

function comment_do(trigger, obj) {
	var commentObj = jQuery('#comment_' + obj);
	if (trigger == 'submit') {
		var contents = obj.quiet_text.value.trim();
		contents = contents_encode(contents, obj.is_html.checked);
		obj.content.value = contents;
		return procFilter(obj, comment_write);
	} else if (trigger == 'submit_e') {
		return procFilter(obj, comment_write);
	} else if (trigger == 'delete') {
		var summary = contents_decode(xGetElementById('comment_delete_'+obj).summary.value);
		if (summary.length > 100) summary = summary.substring(0,100) + "...";
		if (confirm('‘'+contents_decode(summary)+'’ \n\n'+confirm_delete)) return procFilter(xGetElementById('comment_delete_'+obj), comment_delete);
	} else if (trigger == 'edit') {
		var contents = contents_decode(jQuery("#comment_" + obj+ " .comment_edit [name=content]").val());
		var textarea = jQuery("#comment_" + obj+ " .comment_edit textarea");
		textarea.val(contents);
		if (commentObj.hasClass('mode_view')) {
			commentObj.removeClass('mode_view');
			commentObj.addClass('mode_edit');
			setCursor(textarea);
			if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
		} else if(commentObj.hasClass('mode_edit')) {
			commentObj.removeClass('mode_edit');
			commentObj.addClass('mode_view');
		} else {
			commentObj.addClass('mode_edit');
			setCursor(textarea);
			if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
		}
	} else if (trigger == 'reply') {
		var textarea = jQuery("#comment_" + obj+ " .comment_reply textarea");
		if (commentObj.hasClass('mode_view')) {
			commentObj.removeClass('mode_view');
			commentObj.addClass('mode_reply');
			setCursor(textarea);
			if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
		} else if(commentObj.hasClass('mode_reply')) {
			commentObj.removeClass('mode_reply');
			commentObj.addClass('mode_view');
		} else {
			commentObj.addClass('mode_reply');
			setCursor(textarea);
			if(use_autoresize && !textarea.attr('autoresize')) textarea.autoResize().trigger('change');
		}
	} else {
		if(commentObj.hasClass('mode_view')) commentObj.removeClass('mode_view');
		if(commentObj.hasClass('mode_edit')) commentObj.removeClass('mode_edit');
		if(commentObj.hasClass('mode_reply')) commentObj.removeClass('mode_reply');
		commentObj.addClass('mode_view');
	}
}