<?php
    /**
     * @class  sdocumentAdminView
     * @author zero (zero@nzeo.com)
     * @brief  sdocument 모듈의 admin view 클래스
     **/

    class sdocumentAdminView extends sdocument {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 목록 출력 (관리자용)
         **/
        function dispSdocumentAdminList() {
            // 목록을 구하기 위한 옵션
            $args->page = Context::get('page'); ///< 페이지
            $args->list_count = 30; ///< 한페이지에 보여줄 글 수
            $args->page_count = 10; ///< 페이지 네비게이션에 나타날 페이지의 수

            $args->search_target = Context::get('search_target'); ///< 검색 대상 (title, contents...)
            $args->search_keyword = Context::get('search_keyword'); ///< 검색어

            $args->sort_index = 'list_order'; ///< 소팅 값

            $args->module_srl = Context::get('module_srl');

            // 목록 구함, sdocument->getSdocumentList 에서 걍 알아서 다 해버리는 구조이다... (아.. 이거 나쁜 버릇인데.. ㅡ.ㅜ 어쩔수 없다)
            $oSdocumentModel = &getModel('sdocument');
            $output = $oSdocumentModel->getSdocumentList($args);

            // 템플릿에 쓰기 위해서 sdocument_model::getSdocumentList() 의 return object에 있는 값들을 세팅
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('sdocument_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿에서 사용할 검색옵션 세팅
            $count_search_option = count($this->search_option);
            for($i=0;$i<$count_search_option;$i++) {
                $search_option[$this->search_option[$i]] = Context::getLang($this->search_option[$i]);
            }
            Context::set('search_option', $search_option);

            // 템플릿 지정
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile('sdocument_list');
        }

        /**
         * @brief 문서 모듈 설정 
         **/
        function dispSdocumentAdminConfig() {
            $oSdocumentModel = &getModel('sdocument');
            $config = $oSdocumentModel->getSdocumentConfig();
            Context::set('config',$config);

            // 템플릿 파일 지정
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile('sdocument_config');
        }

        function dispSdocumentAdminAlias() {
            $args->document_srl = Context::get('document_srl');
            if(!$args->document_srl) return $this->dispSdocumentAdminList();

            $oModel = &getModel('sdocument');
            $oSdocument = $oModel->getSdocument($args->document_srl);
            if(!$oSdocument->isExists()) return $this->dispSdocumentAdminList();
            Context::set('oSdocument', $oSdocument);

            $output = executeQueryArray('sdocument.getAliases', $args);
            if(!$output->data)
            {
                $aliases = array();
            }
            else
            {
                $aliases = $output->data; 
            }


            Context::set('aliases', $aliases);

            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile('sdocument_alias');
        }

        function dispSdocumentAdminTrashList() {
            // 목록을 구하기 위한 옵션
            $args->page = Context::get('page'); ///< 페이지
            $args->list_count = 30; ///< 한페이지에 보여줄 글 수
            $args->page_count = 10; ///< 페이지 네비게이션에 나타날 페이지의 수

            $args->sort_index = 'list_order'; ///< 소팅 값
            $args->order_type = 'desc'; ///< 소팅 정렬 값

            $args->module_srl = Context::get('module_srl');

            // 목록을 구함
            $oSdocumentAdminModel = &getAdminModel('sdocument');
            $output = $oSdocumentAdminModel->getSdocumentTrashList($args);

            // 템플릿에 쓰기 위해서 sdocument_admin_model::getSdocumentTrashList() 의 return object에 있는 값들을 세팅
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('sdocument_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿 지정
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile('sdocument_trash_list');
        }
    }
?>
