<?php
    /**
     * @class  sboardView
     * @author zero (zero@nzeo.com)
     * @brief  sboard 모듈의 View class
     **/

    class sboardView extends sboard {

        /**
         * @brief 초기화
         * sboard 모듈은 일반 사용과 관리자용으로 나누어진다.\n
         **/
        function init() {
            /**
             * 기본 모듈 정보들 설정 (list_count, page_count는 게시판 모듈 전용 정보이고 기본 값에 대한 처리를 함)
             **/
            if($this->module_info->list_count) $this->list_count = $this->module_info->list_count;
            if($this->module_info->search_list_count) $this->search_list_count = $this->module_info->search_list_count;
            if($this->module_info->page_count) $this->page_count = $this->module_info->page_count;
            $this->except_notice = $this->module_info->except_notice == 'N' ? false : true;

            /**
             * 상담 기능 체크. 현재 게시판의 관리자이면 상담기능을 off시킴
             * 현재 사용자가 비로그인 사용자라면 글쓰기/댓글쓰기/목록보기/글보기 권한을 제거함
             **/
            if($this->module_info->consultation == 'Y' && !$this->grant->manager) {
                $this->consultation = true; 
                if(!Context::get('is_logged')) $this->grant->list = $this->grant->write_sdocument = $this->grant->view = false;
            } else {
                $this->consultation = false;
            }

            /**
             * 스킨 경로를 미리 template_path 라는 변수로 설정함
             * 스킨이 존재하지 않는다면 xe_sboard로 변경
             **/
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = 'xe_splanner';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);

            /**
             * 확장 변수 사용시 미리 확장변수의 대상 키들을 가져와서 context set
             **/
            $oSdocumentModel = &getModel('sdocument');
            $extra_keys = $oSdocumentModel->getExtraKeys($this->module_info->module_srl);
            Context::set('extra_keys', $extra_keys);
			
            /** 
             * 게시판 전반적으로 사용되는 javascript, JS 필터 추가
             **/
            Context::addJsFilter($this->module_path.'tpl/filter', 'input_password.xml');
            Context::addJsFile($this->module_path.'tpl/js/sboard.js');
        }

        /**
         * @brief 목록 및 선택된 글 출력
         **/
        function dispSboardContent() {
            /**
             * 목록보기 권한 체크 (모든 권한은 ModuleObject에서 xml 정보와 module_info의 grant 값을 비교하여 미리 설정하여 놓음)
             **/
            if(!$this->grant->access || !$this->grant->list) return $this->dispSboardMessage('msg_not_permitted');

            /**
             * 카테고리를 사용하는지 확인후 사용시 카테고리 목록을 구해와서 Context에 세팅
             **/
            $this->dispSboardCategoryList();

            /**
             * 목록이 노출될때 같이 나오는 검색 옵션을 정리하여 스킨에서 쓸 수 있도록 context set
             * 확장변수에서 검색 선택된 항목이 있으면 역시 추가
             **/
            // 템플릿에서 사용할 검색옵션 세팅 (검색옵션 key값은 미리 선언되어 있는데 이에 대한 언어별 변경을 함)
            foreach($this->search_option as $opt) $search_option[$opt] = Context::getLang($opt);
            $extra_keys = Context::get('extra_keys');
            if($extra_keys) {
                foreach($extra_keys as $key => $val) {
                    if($val->search == 'Y') $search_option['extra_vars'.$val->idx] = $val->name;
                }
            }
            Context::set('search_option', $search_option);

            // 게시글을 가져옴
            $this->dispSboardContentView();

            // 공지사항 목록을 구해서 context set (공지사항을 매페이지 제일 상단에 위치하기 위해서)
            $this->dispSboardNoticeList();

            // 목록
            $this->dispSboardContentList();

            /** 
             * 사용되는 javascript 필터 추가
             **/
            Context::addJsFilter($this->module_path.'tpl/filter', 'search.xml');

            // template_file을 list.html로 지정
            $this->setTemplateFile('list');
        }

        /**
         * @brief 카테고리 항목을 구해와서 스킨에서 사용할 수 있도록 세팅
         **/
        function dispSboardCategoryList(){
            // 카테고리를 사용할때에만 데이터를 추출
            if($this->module_info->use_category=='Y') {
                $oSdocumentModel = &getModel('sdocument');
                Context::set('category_list', $oSdocumentModel->getCategoryList($this->module_srl));
            }
        }

        /**
         * @brief 선택된 게시글이 있을 경우 글을 가져와서 스킨에서 사용하도록 세팅
         **/
        function dispSboardContentView(){
            // 요청된 변수 값들을 정리
            $document_srl = Context::get('document_srl');
            $page = Context::get('page');

            // sdocument model 객체 생성 
            $oSdocumentModel = &getModel('sdocument');

            /**
             * 요청된 문서 번호가 있다면 문서를 구함
             **/
            if($document_srl) {
                $oSdocument = $oSdocumentModel->getSdocument($document_srl);

                // 해당 문서가 존재할 경우 필요한 처리를 함
                if($oSdocument->isExists()) {

                    // 글과 요청된 모듈이 다르다면 오류 표시
                    if($oSdocument->get('module_srl')!=$this->module_info->module_srl ) return $this->stop('msg_invalid_request');

                    // 관리 권한이 있다면 권한을 부여
                    if($this->grant->manager) $oSdocument->setGrant();

                    // 상담기능이 사용되고 공지사항이 아니고 사용자의 글도 아니면 무시
                    if($this->consultation && !$oSdocument->isNotice()) {
                        $logged_info = Context::get('logged_info');
                        if($oSdocument->get('member_srl')!=$logged_info->member_srl) $oSdocument = $oSdocumentModel->getSdocument(0);
                    }

                // 요청된 문서번호의 문서가 없으면 document_srl null 처리 및 경고 메세지 출력
                } else {
                    Context::set('document_srl','',true);
                    $this->alertMessage('msg_not_founded');
                }

            /**
             * 요청된 문서 번호가 아예 없다면 빈 문서 객체 생성
             **/
            } else {
                $oSdocument = $oSdocumentModel->getSdocument(0);
            }

            /**
             * 글 보기 권한을 체크해서 권한이 없으면 오류 메세지 출력하도록 처리
             **/
            if($oSdocument->isExists()) {
                if(!$this->grant->view && !$oSdocument->isGranted()) {
                    $oSdocument = $oSdocumentModel->getSdocument(0);
                    Context::set('document_srl','',true);
                    $this->alertMessage('msg_not_permitted');
                } else {
                    // 브라우저 타이틀에 글의 제목을 추가
                    Context::addBrowserTitle($oSdocument->getTitleText());

                    // 조회수 증가 (비밀글일 경우 권한 체크)
                    if(!$oSdocument->isSecret() || $oSdocument->isGranted()) $oSdocument->updateReadedCount();

                    // 비밀글일때 컨텐츠를 보여주지 말자.
                    if($oSdocument->isSecret() && !$oSdocument->isGranted()) $oSdocument->add('content',Context::getLang('thisissecret'));
                }
            }

            // 스킨에서 사용할 oSdocument 변수 세팅
            $oSdocument->add('module_srl', $this->module_srl);
            Context::set('oSdocument', $oSdocument);

            /** 
             * 사용되는 javascript 필터 추가
             **/
        
//            return new Object();
        }

        /**
         * @brief 선택된 글이 있을 경우 첨부파일에 대한 정보를 API 에서 사용할 수 있도록 세팅
         **/
        function dispSboardContentFileList(){
            $oSdocumentModel = &getModel('sdocument');
            $document_srl = Context::get('document_srl');
            $oSdocument = $oSdocumentModel->getSdocument($document_srl);
            Context::set('file_list',$oSdocument->getUploadedFiles());
        }


        /**
         * @brief 공지사항이 있을 경우 API에서 사용할 수 있게 하기 위해서 세팅
         **/
        function dispSboardNoticeList(){
            // 스타일이 planner이면 날짜 포함. yijoh
			$lstyle = Context::get('listStyle');
			if(!$lstyle) $lstyle = $this->module_info->default_style;
			if(substr($lstyle,0,4) == 'plan')
			{
				$tmp_y = Context::get('pYear');
				$tmp_m = Context::get('pMonth');
				if(!$tmp_y || !$tmp_m) $plan_date = date("Ym") * 100;
				else $plan_date = $tmp_y * 10000 + $tmp_m * 100;
				$args->plan_sdate = $plan_date;
				$args->plan_edate = $plan_date + 32;
			}

            $oSdocumentModel = &getModel('sdocument');
            $args->module_srl = $this->module_srl; 
            $notice_output = $oSdocumentModel->getNoticeList($args);
            Context::set('notice_list', $notice_output->data);
        }

        /**
         * @brief 게시글 목록
         **/
        function dispSboardContentList(){
            // 만약 목록 보기 권한이 없을 경우 목록을 보여주지 않음
            if(!$this->grant->list) {
                Context::set('sdocument_list', array());
                Context::set('total_count', 0);
                Context::set('total_page', 1);
                Context::set('page', 1);
                Context::set('page_navigation', new PageHandler(0,0,1,10));
                return;
            }

            $oSdocumentModel = &getModel('sdocument');

            // 목록을 구하기 위한 대상 모듈/ 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
            $args->module_srl = $this->module_srl; 
            $args->page = Context::get('page');
            $args->list_count = $this->list_count; 
            $args->page_count = $this->page_count; 

            // 스타일이 planner이면 날짜 포함. yijoh
			$lstyle = Context::get('listStyle');
			if(!$lstyle) $lstyle = $this->module_info->default_style;
			if(substr($lstyle,0,4) == 'plan')
			{
				$tmp_y = Context::get('pYear');
				$tmp_m = Context::get('pMonth');
				if(!$tmp_y || !$tmp_m) $plan_date = date("Ym") * 100;
				else $plan_date = $tmp_y * 10000 + $tmp_m * 100;
				$args->plan_sdate = $plan_date;
				$args->plan_edate = $plan_date + 32;
			}

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target'); 
            $args->search_keyword = Context::get('search_keyword'); 

            // 카테고리를 사용한다면 카테고리 값을 받음
            if($this->module_info->use_category=='Y') $args->category_srl = Context::get('category'); ///< 카테고리 사용시 선택된 카테고리

            // 지정된 정렬값이 없다면 스킨에서 설정한 정렬 값을 이용함
            $args->sort_index = Context::get('sort_index');
            $args->order_type = Context::get('order_type');
            if(!in_array($args->sort_index, $this->order_target)) $args->sort_index = $this->module_info->order_target?$this->module_info->order_target:'list_order';
            if(!in_array($args->order_type, array('asc','desc'))) $args->order_type = $this->module_info->order_type?$this->module_info->order_type:'asc';

            // 특정 문서의 permalink로 직접 접속할 경우 page값을 직접 구함
            $_get = $_GET;
            if(count($_get)==2) unset($_get['mid']);
            if(count($_get)==1 && ($_GET['document_srl'] || $_GET['entry'])) {
                $oSdocument = $oSdocumentModel->getSdocument(Context::get('document_srl'));
                if($oSdocument->isExists() && !$oSdocument->isNotice()) {
                    $page = $oSdocumentModel->getSdocumentPage($oSdocument, $args);
                    Context::set('page', $page);
                    $args->page = $page;
                }
            }

            // 만약 카테고리가 있거나 검색어가 있으면list_count를 search_list_count 로 이용
            if($args->category_srl || $args->search_keyword) $args->list_count = $this->search_list_count;

            // 상담 기능이 on되어 있으면 현재 로그인 사용자의 글만 나타나도록 옵션 변경
            if($this->consultation) {
                $logged_info = Context::get('logged_info');
                $args->member_srl = $logged_info->member_srl;
            }

            // 일반 글을 구해서 context set
            $output = $oSdocumentModel->getSdocumentList($args, $this->except_notice);
            Context::set('sdocument_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            // 목록 설정값을 세팅
            $oSboardModel = &getModel('sboard');
            Context::set('list_config', $oSboardModel->getListConfig($this->module_info->module_srl));
        }

        /**
         * @brief 태그 목록 모두 보기
         **/
        function dispSboardTagList() {
            // 만약 목록 보기 권한조치 없을 경우 태그 목록도 보여주지 않음
            if(!$this->grant->list) return $this->dispSboardMessage('msg_not_permitted');

            // 태그 모델 객체에서 태그 목록을 구해옴
            $oTagModel = &getModel('tag');

            $obj->mid = $this->module_info->mid;
            $obj->list_count = 10000;
            $output = $oTagModel->getTagList($obj);

            // 내용을 랜덤으로 정렬
            if(count($output->data)) {
                $numbers = array_keys($output->data);
                shuffle($numbers);

                if(count($output->data)) {
                    foreach($numbers as $k => $v) {
                        $tag_list[] = $output->data[$v];
                    }
                }
            }

            Context::set('tag_list', $tag_list);

            $this->setTemplateFile('tag_list');
        }
        
        /**
         * @brief 글 작성 화면 출력
         **/
        function dispSboardWrite() {
            // 권한 체크
            if(!$this->grant->write_sdocument) return $this->dispSboardMessage('msg_not_permitted');

            $oSdocumentModel = &getModel('sdocument');

            /**
             * 카테고리를 사용하는지 확인후 사용시 카테고리 목록을 구해와서 Context에 세팅, 권한도 함께 체크
             **/
            if($this->module_info->use_category=='Y') {
                // 로그인한 사용자의 그룹 정보를 구함
                if(Context::get('is_logged')) {
                    $logged_info = Context::get('logged_info');
                    $group_srls = array_keys($logged_info->group_list);
                } else {
                    $group_srls = array();
                }
                $group_srls_count = count($group_srls);

                // 카테고리 목록을 구하고 권한을 체크
                $normal_category_list = $oSdocumentModel->getCategoryList($this->module_srl);
                if(count($normal_category_list)) {
                    foreach($normal_category_list as $category_srl => $category) {
                        $is_granted = true;
                        if($category->group_srls) {
                            $category_group_srls = explode(',',$category->group_srls);
                            $is_granted = false;
                            if(count(array_intersect($group_srls, $category_group_srls))) $is_granted = true; 

                        }
                        if($is_granted) $category_list[$category_srl] = $category;
                    }
                }
                Context::set('category_list', $category_list);
            }

            // GET parameter에서 document_srl을 가져옴
            $document_srl = Context::get('document_srl');
            $oSdocument = $oSdocumentModel->getSdocument(0, $this->grant->manager);
            $oSdocument->setSdocument($document_srl);
            $oSdocument->add('module_srl', $this->module_srl);

            // 글을 수정하려고 할 경우 권한이 없는 경우 비밀번호 입력화면으로
            if($oSdocument->isExists()&&!$oSdocument->isGranted()) return $this->setTemplateFile('input_password_form');
            if(!$oSdocument->isExists()) {
                $oModuleModel = &getModel('module');
                $point_config = $oModuleModel->getModulePartConfig('point',$this->module_srl);
                $logged_info = Context::get('logged_info');
                $oPointModel = &getModel('point');
                $pointForInsert = $point_config["insert_sdocument"];
                if($pointForInsert < 0) {
                    if( !$logged_info ) return $this->dispSboardMessage('msg_not_permitted');
                    else if (($oPointModel->getPoint($logged_info->member_srl) + $pointForInsert )< 0 ) return $this->dispSboardMessage('msg_not_enough_point');
                }
            }

            Context::set('document_srl',$document_srl);
            Context::set('oSdocument', $oSdocument);

            // 확장변수처리를 위해 xml_js_filter를 직접 header에 적용
            $oSdocumentController = &getController('sdocument');
            $oSdocumentController->addXmlJsFilter($this->module_info->module_srl);

            // 존재하는 글이면 확장변수 값을 context set
            if($oSdocument->isExists()) Context::set('extra_keys', $oSdocument->getExtraVars());

            /** 
             * 사용되는 javascript 필터 추가
             **/
            Context::addJsFilter($this->module_path.'tpl/filter', 'insert.xml');

            $this->setTemplateFile('write_form');
        }

        /**
         * @brief 문서 삭제 화면 출력
         **/
        function dispSboardDelete() {
            // 권한 체크
            if(!$this->grant->write_sdocument) return $this->dispSboardMessage('msg_not_permitted');

            // 삭제할 문서번호를 가져온다
            $document_srl = Context::get('document_srl');

            // 지정된 글이 있는지 확인
            if($document_srl) {
                $oSdocumentModel = &getModel('sdocument');
                $oSdocument = $oSdocumentModel->getSdocument($document_srl);
            }

            // 삭제하려는 글이 없으면 에러
            if(!$oSdocument->isExists()) return $this->dispSboardContent();

            // 권한이 없는 경우 비밀번호 입력화면으로
            if(!$oSdocument->isGranted()) return $this->setTemplateFile('input_password_form');

            Context::set('oSdocument',$oSdocument);

            /** 
             * 필요한 필터 추가
             **/
            Context::addJsFilter($this->module_path.'tpl/filter', 'delete_sdocument.xml');

            $this->setTemplateFile('delete_form');
        }


        /**
         * @brief 메세지 출력
         **/
        function dispSboardMessage($msg_code) {
            $msg = Context::getLang($msg_code);
            if(!$msg) $msg = $msg_code;
            Context::set('message', $msg);
            $this->setTemplateFile('message');
        }

        /**
         * @brief 오류메세지를 system alert로 출력하는 method
         * 특별한 오류를 알려주어야 하는데 별도의 디자인까지는 필요 없을 경우 페이지를 모두 그린후에
         * 오류를 출력하도록 함
         **/
        function alertMessage($message) {
            $script =  sprintf('<script type="text/javascript"> xAddEventListener(window,"load", function() { alert("%s"); } );</script>', Context::getLang($message));
            Context::addHtmlHeader( $script );
        }

    }
?>
