<?php
    /**
     * @class  sdocumentAdminController
     * @author zero (zero@nzeo.com)
     * @brief  sdocument 모듈의 admin controller 클래스
     **/

    class sdocumentAdminController extends sdocument {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 관리자 페이지에서 선택된 문서들 삭제
         **/
        function procSdocumentAdminDeleteChecked() {
            // 선택된 글이 없으면 오류 표시
            $cart = Context::get('cart');
            if(!$cart) return $this->stop('msg_cart_is_null');
            $document_srl_list= explode('|@|', $cart);
            $sdocument_count = count($document_srl_list);
            if(!$sdocument_count) return $this->stop('msg_cart_is_null');

            // 글삭제
            $oSdocumentController = &getController('sdocument');
            for($i=0;$i<$sdocument_count;$i++) {
                $document_srl = trim($document_srl_list[$i]);
                if(!$document_srl) continue;

                $oSdocumentController->deleteSdocument($document_srl, true);
            }

            $this->setMessage( sprintf(Context::getLang('msg_checked_sdocument_is_deleted'), $sdocument_count) );
        }

        /** 
         * @brief 특정 게시물들의 소속 모듈 변경 (게시글 이동시에 사용)
         **/
        function moveSdocumentModule($document_srl_list, $module_srl, $category_srl) {
            if(!count($document_srl_list)) return;

            $oSdocumentModel = &getModel('sdocument');
            $oSdocumentController = &getController('sdocument');

            $oDB = &DB::getInstance();
            $oDB->begin();

            $triggerObj->document_srls = implode(',',$document_srl_list);
            $triggerObj->module_srl = $module_srl;
            $triggerObj->category_srl = $category_srl;

            // Call trigger (before)
            $output = ModuleHandler::triggerCall('sdocument.moveSdocumentModule', 'before', $triggerObj);
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            for($i=count($document_srl_list)-1;$i>=0;$i--) {
                $document_srl = $document_srl_list[$i];
                $oSdocument = $oSdocumentModel->getSdocument($document_srl);
                if(!$oSdocument->isExists()) continue;

                $source_category_srl = $oSdocument->get('category_srl');

                unset($obj);
                $obj = $oSdocument->getObjectVars();

                // 대상 모듈이 다를 경우 첨부파일 이동
                if($module_srl != $obj->module_srl && $oSdocument->hasUploadedFiles()) {
                    $oFileController = &getController('file');

                    $files = $oSdocument->getUploadedFiles();
                    foreach($files as $key => $val) {
                        $file_info = array();
                        $file_info['tmp_name'] = $val->uploaded_filename;
                        $file_info['name'] = $val->source_filename;
                        $inserted_file = $oFileController->insertFile($file_info, $module_srl, $obj->document_srl, $val->download_count, true);
                        if($inserted_file && $inserted_file->toBool()) {
                            // 이미지/동영상등일 경우
                            if($val->direct_download == 'Y') {
                                $source_filename = substr($val->uploaded_filename,2);
                                $target_filename = substr($inserted_file->get('uploaded_filename'),2);
                                $obj->content = str_replace($source_filename, $target_filename, $obj->content);

                            // binary 파일일 경우
                            } else {
                                $obj->content = str_replace('file_srl='.$val->file_srl, 'file_srl='.$inserted_file->get('file_srl'), $obj->content);
                                $obj->content = str_replace('sid='.$val->sid, 'sid='.$inserted_file->get('sid'), $obj->content);
                            }
                        }

                        // 기존 파일 삭제
                        $oFileController->deleteFile($val->file_srl);
                    }

                    // 등록된 모든 파일을 유효로 변경
                    $oFileController->setFilesValid($obj->document_srl);
                }

                if($module_srl != $obj->module_srl)
                {
                    $oSdocumentController->deleteSdocumentAliasBySdocument($obj->document_srl);
                }

                // 게시물의 모듈 이동
                $obj->module_srl = $module_srl;
                $obj->category_srl = $category_srl;
                $output = executeQuery('sdocument.updateSdocumentModule', $obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }

                // 카테고리가 변경되었으면 검사후 없는 카테고리면 0으로 세팅
                if($source_category_srl != $category_srl) {
                    if($source_category_srl) $oSdocumentController->updateCategoryCount($oSdocument->get('module_srl'), $source_category_srl);
                    if($category_srl) $oSdocumentController->updateCategoryCount($module_srl, $category_srl);
                }

            }

            $args->document_srls = implode(',',$document_srl_list);
            $args->module_srl = $module_srl;

            // 태그
            $output = executeQuery('tag.updateTagModule', $args);
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // Call trigger (before)
            $output = ModuleHandler::triggerCall('sdocument.moveSdocumentModule', 'after', $triggerObj);
            if(!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }
            
            $oDB->commit();
            return new Object();
        }

        /** 
         * @brief 게시글의 복사
         **/
        function copySdocumentModule($document_srl_list, $module_srl, $category_srl) {
            if(!count($document_srl_list)) return;

            $oSdocumentModel = &getModel('sdocument');
            $oSdocumentController = &getController('sdocument');

            $oFileModel = &getModel('file');

            $oDB = &DB::getInstance();
            $oDB->begin();

            for($i=count($document_srl_list)-1;$i>=0;$i--) {
                $document_srl = $document_srl_list[$i];
                $oSdocument = $oSdocumentModel->getSdocument($document_srl);
                if(!$oSdocument->isExists()) continue;

                $obj = null;
                $obj = $oSdocument->getObjectVars();
                $obj->module_srl = $module_srl;
                $obj->document_srl = getNextSequence();
                $obj->category_srl = $category_srl;
                $obj->password_is_hashed = true;

                // 첨부파일 미리 등록
                if($oSdocument->hasUploadedFiles()) {
                    $files = $oSdocument->getUploadedFiles();
                    foreach($files as $key => $val) {
                        $file_info = array();
                        $file_info['tmp_name'] = $val->uploaded_filename;
                        $file_info['name'] = $val->source_filename;
                        $oFileController = &getController('file');
                        $inserted_file = $oFileController->insertFile($file_info, $module_srl, $obj->document_srl, 0, true);

                        // 이미지/동영상등일 경우
                        if($val->direct_download == 'Y') {
                            $source_filename = substr($val->uploaded_filename,2);
                            $target_filename = substr($inserted_file->get('uploaded_filename'),2);
                            $obj->content = str_replace($source_filename, $target_filename, $obj->content);

                        // binary 파일일 경우
                        } else {
                            $obj->content = str_replace('file_srl='.$val->file_srl, 'file_srl='.$inserted_file->get('file_srl'), $obj->content);
                            $obj->content = str_replace('sid='.$val->sid, 'sid='.$inserted_file->get('sid'), $obj->content);
                        }
                    }
                }
                
                // 글의 등록
                $output = $oSdocumentController->insertSdocument($obj, true);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }

                $copied_srls[$document_srl] = $obj->document_srl;
            }
            $oDB->commit();

            $output = new Object();
            $output->add('copied_srls', $copied_srls);
            return $output;
        }

        /**
         * @brief 특정 모듈의 전체 문서 삭제
         **/
        function deleteModuleSdocument($module_srl) {
            $args->module_srl = $module_srl;
            $output = executeQuery('sdocument.deleteModuleSdocument', $args);
            return $output;
        }

        /**
         * @brief 문서 모듈의 기본설정 저장
         **/
        function procSdocumentAdminInsertConfig() {
            // 기본 정보를 받음
            $config = Context::gets('thumbnail_type');

            // module Controller 객체 생성하여 입력
            $oModuleController = &getController('module');
            $output = $oModuleController->insertModuleConfig('sdocument',$config);
            return $output;
        }


        /**
         * @brief 모든 생성된 썸네일 삭제
         **/
        function procSdocumentAdminDeleteAllThumbnail() {

            // files/attaches/images/ 디렉토리를 순환하면서 thumbnail_*.jpg 파일을 모두 삭제 (1.0.4 이전까지)
            $this->deleteThumbnailFile('./files/attach/images');

            // files/cache/thumbnails 디렉토리 자체를 삭제 (1.0.5 이후 변경된 썸네일 정책)
            FileHandler::removeFilesInDir('./files/cache/thumbnails');

            $this->setMessage('success_deleted');
        }

        function deleteThumbnailFile($path) {
            $directory = dir($path);
            while($entry = $directory->read()) {
                if ($entry != "." && $entry != "..") {
                    if (is_dir($path."/".$entry)) {
                        $this->deleteThumbnailFile($path."/".$entry);
                    } else {
                        if(!preg_match('/^thumbnail_([^\.]*)\.jpg$/i',$entry)) continue;
                        FileHandler::removeFile($path.'/'.$entry);
                    }
                }
            }
            $directory->close();
        }

        /**
         * @brief 모듈의 확장 변수 추가 또는 수정
         **/
        function procSdocumentAdminInsertExtraVar() {
            $module_srl = Context::get('module_srl');
            $var_idx = Context::get('var_idx');
            $name = Context::get('name');
            $type = Context::get('type');
            $is_required = Context::get('is_required');
            $default = Context::get('default');
            $desc = Context::get('desc');
            $search = Context::get('search');
			$eid = Context::get('eid');

            if(!$module_srl || !$name || !$eid) return new Object(-1,'msg_invalid_request');

            // idx가 지정되어 있지 않으면 최고 값을 지정
            if(!$var_idx) {
                $obj->module_srl = $module_srl;
                $output = executeQuery('sdocument.getSdocumentMaxExtraKeyIdx', $obj);
                $var_idx = $output->data->var_idx+1;
            }

			// 이미 존재하는 모듈 이름인지 체크
			$obj->module_srl = $module_srl;
			$obj->var_idx = $var_idx;
			$obj->eid = $eid;
            $output = executeQuery('sdocument.isExistsExtraKey', $obj);
            if(!$output->toBool() || $output->data->count) {
                return new Object(-1, 'msg_extra_name_exists');
            }

            // insert or update
            $oSdocumentController = &getController('sdocument');
            $output = $oSdocumentController->insertSdocumentExtraKey($module_srl, $var_idx, $name, $type, $is_required, $search, $default, $desc, $eid);
            if(!$output->toBool()) return $output;

            $this->setMessage('success_registed');
        }

        /**
         * @brief 모듈의 확장 변수 삭제
         **/
        function procSdocumentAdminDeleteExtraVar() {
            $module_srl = Context::get('module_srl');
            $var_idx = Context::get('var_idx');
            if(!$module_srl || !$var_idx) return new Object(-1,'msg_invalid_request');

            $oSdocumentController = &getController('sdocument');
            $output = $oSdocumentController->deleteSdocumentExtraKeys($module_srl, $var_idx);
            if(!$output->toBool()) return $output;

            $this->setMessage('success_deleted');
        }
 
        /**
         * @brief 확장변수 순서 조절
         **/
        function procSdocumentAdminMoveExtraVar() {
            $type = Context::get('type');
            $module_srl = Context::get('module_srl');
            $var_idx = Context::get('var_idx');

            if(!$type || !$module_srl || !$var_idx) return new Object(-1,'msg_invalid_request');

            $oModuleModel = &getModel('module');
            $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
            if(!$module_info->module_srl) return new Object(-1,'msg_invalid_request');

            $oSdocumentModel = &getModel('sdocument');
            $extra_keys = $oSdocumentModel->getExtraKeys($module_srl);
            if(!$extra_keys[$var_idx]) return new Object(-1,'msg_invalid_request');

            if($type == 'up') $new_idx = $var_idx-1;
            else $new_idx = $var_idx+1;
            if($new_idx<1) return new Object(-1,'msg_invalid_request');

            // 바꿀 idx가 없으면 바로 업데이트
            if(!$extra_keys[$new_idx]) {
                $args->module_srl = $module_srl;
                $args->var_idx = $var_idx;
                $args->new_idx = $new_idx;
                $output = executeQuery('sdocument.updateSdocumentExtraKeyIdx', $args);
                if(!$output->toBool()) return $output;
                $output = executeQuery('sdocument.updateSdocumentExtraVarIdx', $args);
                if(!$output->toBool()) return $output;
            // 있으면 기존의 꺼랑 교체
            } else {
                $args->module_srl = $module_srl;
                $args->var_idx = $new_idx;
                $args->new_idx = -10000;
                $output = executeQuery('sdocument.updateSdocumentExtraKeyIdx', $args);
                if(!$output->toBool()) return $output;
                $output = executeQuery('sdocument.updateSdocumentExtraVarIdx', $args);
                if(!$output->toBool()) return $output;

                $args->var_idx = $var_idx;
                $args->new_idx = $new_idx;
                $output = executeQuery('sdocument.updateSdocumentExtraKeyIdx', $args);
                if(!$output->toBool()) return $output;
                $output = executeQuery('sdocument.updateSdocumentExtraVarIdx', $args);
                if(!$output->toBool()) return $output;

                $args->var_idx = -10000;
                $args->new_idx = $var_idx;
                $output = executeQuery('sdocument.updateSdocumentExtraKeyIdx', $args);
                if(!$output->toBool()) return $output;
                $output = executeQuery('sdocument.updateSdocumentExtraVarIdx', $args);
                if(!$output->toBool()) return $output;
            }
        }

        function procSdocumentAdminInsertAlias() {
            $args = Context::gets('module_srl','document_srl', 'alias_title');
            $alias_srl = Context::get('alias_srl');
            if(!$alias_srl) 
            {
                $args->alias_srl = getNextSequence();
                $query = "sdocument.insertAlias";
            }
            else 
            {
                $args->alias_srl = $alias_srl;
                $query = "sdocument.updateAlias";
            }
            $output = executeQuery($query, $args);
            if(!$output->toBool())
            {
                return $output;
            }
        }

        function procSdocumentAdminDeleteAlias() {
            $alias_srl = Context::get('alias_srl');
            $args->alias_srl = $alias_srl;
            $output = executeQuery("sdocument.deleteAlias", $args);
            if (!$output->toBool())
            {
                return $output;
            }
        }

        function procSdocumentAdminRestoreTrash() {
            $trash_srl = Context::get('trash_srl');
			$this->restoreTrash($trash_srl);
        }

		function restoreTrash($trash_srl){
            $oDB = &DB::getInstance();
            $oSdocumentModel = &getModel('sdocument');

            $trash_args->trash_srl = $trash_srl;

            $output = executeQuery('sdocument.getTrash', $trash_args);
            if (!$output->toBool()) {
                return $output;
            }

            $sdocument_args->document_srl = $output->data->document_srl;
            $sdocument_args->module_srl = $output->data->module_srl;
            $sdocument_args->member_srl = $output->data->member_srl;

            $oSdocument = $oSdocumentModel->getSdocument($sdocument_args->document_srl);

            // begin transaction
            $oDB->begin();

            $output = executeQuery('sdocument.updateSdocument', $sdocument_args);
            if (!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            $output = executeQuery('sdocument.deleteTrash', $trash_args);
            if (!$output->toBool()) {
                $oDB->rollback();
                return $output;
            }

            // 임시 저장되었던 글이 아닌 경우, 등록된 첨부파일의 상태를 유효로 지정
            if($oSdocument->hasUploadedFiles() && $sdocument_args->member_srl != $sdocument_args->module_srl) {
                $args->upload_target_srl = $oSdocument->document_srl;
                $args->isvalid = 'Y';
                executeQuery('file.updateFileValid', $args);
            }

            // commit
            $oDB->commit();
			return $output;
		}

    }
?>
