<?php
    /**
     * @class  sboardWAP
     * @author zero (zero@nzeo.com)
     * @brief  sboard 모듈의 WAP class
     **/

    class sboardWAP extends sboard {

        /**
         * @brief wap procedure method
         **/
        function procWAP(&$oMobile) {
            // 권한 체크
            if(!$this->grant->list || $this->module_info->consultation == 'Y') return $oMobile->setContent(Context::getLang('msg_not_permitted'));

            // sdocument model 객체 생성
            $oSdocumentModel = &getModel('sdocument');

            // 선택된 게시글이 있을 경우
            $document_srl = Context::get('document_srl');
            if($document_srl) {
                $oSdocument = $oSdocumentModel->getSdocument($document_srl);
                if($oSdocument->isExists()) {
                    // 권한 확인
                    if(!$this->grant->view) return $oMobile->setContent(Context::getLang('msg_not_permitted'));

                    // 글 제목 설정
                    Context::setBrowserTitle($oSdocument->getTitleText());

                    {

                        // 내용 지정 (태그를 모두 제거한 내용을 설정)
                        $content = strip_tags(str_replace('<p>','<br>&nbsp;&nbsp;&nbsp;',$oSdocument->getContent(false,false,false)),'<br><b><i><u><em><small><strong><big>');


                        $content = '<b>'.$oSdocument->getNickName().'</b> ('.$oSdocument->getRegdate("Y-m-d").")<br>\r\n".$content;
                        
                        // 내용 설정
                        $oMobile->setContent( $content );

                        // 상위 페이지를 목록으로 돌아가기로 지정
                        $oMobile->setUpperUrl( getUrl('document_srl',''), Context::getLang('cmd_list') );

                    }

                    return;
                }
            }

            // 게시글 목록
            $args->module_srl = $this->module_srl; 
            $args->page = Context::get('page');; 
            $args->list_count = 9;
            $args->sort_index = $this->module_info->order_target?$this->module_info->order_target:'list_order';
            $args->order_type = $this->module_info->order_type?$this->module_info->order_type:'asc';
            $output = $oSdocumentModel->getSdocumentList($args, $this->except_notice);
            $sdocument_list = $output->data;
            $page_navigation = $output->page_navigation;

            $childs = array();
            if($sdocument_list && count($sdocument_list)) {
                foreach($sdocument_list as $key => $val) {
                    $href = getUrl('mid',$_GET['mid'],'document_srl',$val->document_srl);
                    $obj = null;
                    $obj['href'] = $val->getPermanentUrl();

                    $title = htmlspecialchars($val->getTitleText());
                    $obj['link'] = $obj['text'] = '['.$val->getNickName().'] '.$title;
                    $childs[] = $obj;
                }
                $oMobile->setChilds($childs); 
            }

            $totalPage = $page_navigation->last_page;
            $page = (int)Context::get('page');
            if(!$page) $page = 1;

            // next/prevUrl 지정
            if($page>1) $oMobile->setPrevUrl(getUrl('mid',$_GET['mid'],'page',$page-1), sprintf('%s (%d/%d)', Context::getLang('cmd_prev'), $page-1, $totalPage));

            if($page<$totalPage) $oMobile->setNextUrl(getUrl('mid',$_GET['mid'],'page',$page+1), sprintf('%s (%d/%d)', Context::getLang('cmd_next'), $page+1, $totalPage));

            $oMobile->mobilePage = $page;
            $oMobile->totalPage = $totalPage;
        }
    }

?>
