<?php
    /**
     * @class  sboardController
     * @author zero (zero@nzeo.com)
     * @brief  sboard 모듈의 Controller class
     **/

    class sboardController extends sboard {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 문서 입력
         **/
        function procSboardInsertSdocument() {
            // 권한 체크
            if(!$this->grant->write_sdocument) return new Object(-1, 'msg_not_permitted');
            $logged_info = Context::get('logged_info');

debugPrint("procSboardInsertSdocument\n".print_r($obj,true));
            // 글작성시 필요한 변수를 세팅
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
            if($obj->is_notice!='Y'||!$this->grant->manager) $obj->is_notice = 'N';

            settype($obj->title, "string");
            if($obj->title == '') $obj->title = cut_str(strip_tags($obj->content),20,'...');
            //그래도 없으면 Untitled
            if($obj->title == '') $obj->title = 'Untitled';

            // 관리자가 아니라면 게시글 색상/굵기 제거
            if(!$this->grant->manager) {
                unset($obj->title_color);
                unset($obj->title_bold);
            }

            // sdocument module의 model 객체 생성
            $oSdocumentModel = &getModel('sdocument');

            // sdocument module의 controller 객체 생성
            $oSdocumentController = &getController('sdocument');

            // 이미 존재하는 글인지 체크
            $oSdocument = $oSdocumentModel->getSdocument($obj->document_srl, $this->grant->manager);

            // 익명 설정일 경우 여러가지 요소를 미리 제거 (알림용 정보들 제거)
            if($this->module_info->use_anonymous == 'Y') {
                $obj->notify_message = 'N';
                $obj->member_srl = -1*$logged_info->member_srl;
                $obj->user_id = '';
                $obj->user_name = $obj->nick_name = 'anonymous';
                $bAnonymous = true;
            }
            else
            {
                $bAnonymous = false;
            }

            // 이미 존재하는 경우 수정
            if($oSdocument->isExists() && $oSdocument->document_srl == $obj->document_srl) {
				if(!$oSdocument->isGranted()) return new Object(-1,'msg_not_permitted');
                $output = $oSdocumentController->updateSdocument($oSdocument, $obj);
                $msg_code = 'success_updated';

            // 그렇지 않으면 신규 등록
            } else {
                $output = $oSdocumentController->insertSdocument($obj, $bAnonymous);
                $msg_code = 'success_registed';
                $obj->document_srl = $output->get('document_srl');

            }

            // 오류 발생시 멈춤
            if(!$output->toBool()) return $output;

            // 결과를 리턴
            $this->add('mid', Context::get('mid'));
            $this->add('document_srl', $output->get('document_srl'));

            // 성공 메세지 등록
            $this->setMessage($msg_code);
        }

        /**
         * @brief 문서 삭제
         **/
        function procSboardDeleteSdocument() {
            // 문서 번호 확인
            $document_srl = Context::get('document_srl');

            // 문서 번호가 없다면 오류 발생
            if(!$document_srl) return $this->doError('msg_invalid_sdocument');

            // sdocument module model 객체 생성
            $oSdocumentController = &getController('sdocument');

            // 삭제 시도
            $output = $oSdocumentController->deleteSdocument($document_srl, $this->grant->manager);
            if(!$output->toBool()) return $output;

            // 성공 메세지 등록
            $this->add('mid', Context::get('mid'));
            $this->add('page', $output->get('page'));
            $this->setMessage('success_deleted');
        }


        /**
         * @brief 문서와 댓글의 비밀번호를 확인
         **/
        function procSboardVerificationPassword() {
            // 비밀번호와 문서 번호를 받음
            $password = Context::get('password');
            $document_srl = Context::get('document_srl');

            $oMemberModel = &getModel('member');

			// 문서번호에 해당하는 글이 있는지 확인
			$oSdocumentModel = &getModel('sdocument');
			$oSdocument = $oSdocumentModel->getSdocument($document_srl);
			if(!$oSdocument->isExists()) return new Object(-1, 'msg_invalid_request');

			// 문서의 비밀번호와 입력한 비밀번호의 비교
			if(!$oMemberModel->isValidPassword($oSdocument->get('password'),$password)) return new Object(-1, 'msg_invalid_password');

			$oSdocument->setGrant();
        }

        /**
         * @brief 아이디 클릭시 나타나는 팝업메뉴에 "작성글 보기" 메뉴를 추가하는 trigger
         **/
        function triggerMemberMenu(&$obj) {
            $member_srl = Context::get('target_srl');
            $mid = Context::get('cur_mid');

            if(!$member_srl || !$mid) return new Object();

            $logged_info = Context::get('logged_info');

            // 호출된 모듈의 정보 구함
            $oModuleModel = &getModel('module');
            $cur_module_info = $oModuleModel->getModuleInfoByMid($mid);

            if($cur_module_info->module != 'sboard') return new Object();

            // 자신의 아이디를 클릭한 경우
            if($member_srl == $logged_info->member_srl) {
                $member_info = $logged_info;
            } else {
                $oMemberModel = &getModel('member');
                $member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl);
            }

            if(!$member_info->user_id) return new Object();

            // 아이디로 검색기능 추가
            $url = getUrl('','mid',$mid,'search_target','user_id','search_keyword',$member_info->user_id);
            $oMemberController = &getController('member');
            $oMemberController->addMemberPopupMenu($url, 'cmd_view_own_sdocument', './modules/member/tpl/images/icon_view_written.gif');

            return new Object();
        }

    }
?>
