<?php
    /**
     * @class  sboardAPI
     * @author sol(sol@ngleader.com)
     * @brief  sboard 모듈의 View Action에 대한 API 처리
     **/

    class sboardAPI extends sboard {

/* dispSboardContent 는 사용하지 않는다..
        function dispSboardContent(&$oModule) {
        }
*/

        /**
         * @brief 공지사항 목록
         **/
        function dispSboardNoticeList(&$oModule) {
             $oModule->add('notice_list',$this->arrangeContentList(Context::get('notice_list')));
        }


        /**
         * @brief 컨텐츠 목록
         **/
        function dispSboardContentList(&$oModule) {
            $sdocument_list = $this->arrangeContentList(Context::get('sdocument_list'));
            $oModule->add('sdocument_list',$sdocument_list);
            $oModule->add('page_navigation',Context::get('page_navigation'));
        }


        /**
         * @brief 카테고리(분류) 목록
         **/
        function dispSboardCatogoryList(&$oModule) {
            $oModule->add('category_list',Context::get('category_list'));
        }

        /**
         * @brief 게시물 보기
         **/
        function dispSboardContentView(&$oModule) {
            $oSdocument = Context::get('oSdocument');
            $extra_vars = $oSdocument->getExtraVars();
            $oSdocument->add('extra_vars',$this->arrangeExtraVars($extra_vars));
            $oModule->add('oSdocument',$this->arrangeContent($oSdocument));
        }


        /**
         * @brief 컨텐츠의 파일 목록
         **/
        function dispSboardContentFileList(&$oModule) {
            $oModule->add('file_list',$this->arrangeFile(Context::get('file_list')));
        }


        /**
         * @brief 태그 목록
         **/
        function dispSboardTagList(&$oModule) {
            $oModule->add('tag_list',Context::get('tag_list'));
        }

        /**
         * @brief 컨텐츠 목록
         **/

        function arrangeContentList($content_list) {
            $output = array();
            if(count($content_list)) {
                foreach($content_list as $key => $val) $output[] = $this->arrangeContent($val);
            }
            return $output;
        }


        function arrangeContent($content) {
            $output = null;
            if($content){
                $output= $content->gets('document_srl','category_srl','is_secret','nick_name','user_id','user_name','title','content','tags','regdate','last_update','extra_vars');
            }
            return $output;
        }

        function arrangeFile($file_list) {
            $output = array();
            if(count($file_list) > 0) {
                foreach($file_list as $key => $val){
                    $item = null;
                    $item->sid = $val->sid;
                    $item->download_count = $val->download_count;
                    $item->source_filename = $val->source_filename;
                    $item->uploaded_filename = $val->uploaded_filename;
                    $item->file_size = $val->file_size;
                    $item->regdate = $val->regdate;
                    $item->download_url = $val->download_url;
                    $output[] = $item;
                }
            }
            return $output;
        }

        function arrangeExtraVars($list) {
            $output = array();
            if(count($list)) {
                foreach($list as $key => $val){
                    $item = null;
                    $item->name = $val->name;
                    $item->type = $val->type;
                    $item->desc = $val->desc;
                    $item->value = $val->value;
                    $output[] = $item;
                }
            }
            return $output;
        }
    }
?>
