function printPage(currentPage, countPerPage, totalCount, pageSizePerPaging, functionName){
    
    var prevLink = '';
    var nextLink = '';
    
    var lastPageOfAll = Math.ceil(totalCount / countPerPage);
    var prevPage = (Math.ceil(currentPage / pageSizePerPaging)-1)*pageSizePerPaging;
    var firstPageOfThisPaging = prevPage + 1;
    var nextPage = firstPageOfThisPaging + pageSizePerPaging;
    var lastPageOfThisPaging = (prevPage + pageSizePerPaging) >= lastPageOfAll ? lastPageOfAll : prevPage + pageSizePerPaging;


    
    if(prevPage != 0) {
      prevLink = '<li><a href="' + getPageLink(prevPage, functionName) + '"><img src="http://bimage.interpark.com/renewPark/openAPI/btn_05_prev01.gif" align="absmiddle" class="btn"></a></li>';
    }
    
    if(lastPageOfAll != lastPageOfThisPaging){
      nextLink = '<li><a href="' + getPageLink(nextPage, functionName) + '"><img src="http://bimage.interpark.com/renewPark/openAPI/btn_05_next01.gif" align="absmiddle" class="btn"></a></li>';
    }

    
    var pagingNumberHtml = '';
    for(i=firstPageOfThisPaging ; i<=lastPageOfThisPaging; i++){
      if(i == currentPage) pagingNumberHtml = pagingNumberHtml + '<li class="on"><a href="' + getPageLink(i, functionName) + '">' + i + '</a></li>';
      else pagingNumberHtml = pagingNumberHtml + '<li><a href="' + getPageLink(i, functionName) + '">' + i + '</a></li>';
    }
    
    var pagingHtml = prevLink +  pagingNumberHtml + nextLink;
                     
    return pagingHtml;

}

function getPageLink(page, functionName){
  return "javascript:" + functionName + "(" + page + ");";
}

