<?php
    /**
     * @class JW_player
     * @author 왜만지냐 (123@kimwoosuk.com)
     * @brief 동영상, 이미지를 삽입하는 위젯
     * @version 1.0
     **/

    class JW_player extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 위젯 변수 설정
            $widget_info->movie_1 = $args->location_1;
            $widget_info->movie_2 = $args->location_2;
            $widget_info->image_1 = $args->images_1;    
            
            $widget_info->list_1 = $args->list_1;
            if(!$widget_info->list_1) $widget_info->list_1 = 3;
            
            $widget_info->caption_1 = $args->caption_1;    
            
            $widget_info->width_1 = $args->play_width_1;
            if(!$widget_info->width_1) $widget_info->width_1 = 640;
            
            $widget_info->height_1 = $args->play_height_1;
            if(!$widget_info->height_1) $widget_info->height_1 = 360;
            
            $widget_info->fit_1 = $args->play_fit_1;
            $widget_info->skin_1 = $args->play_skin_1;
                        
            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            $tpl_file = 'default';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>
