<?php
##
## this file name is 'class.planner123_widget_holiday_usa.php'
##
## calendar_planner function object -- get some information for planner
##
## [author]
##  - Keysung Chung
##  - http://chungfamily.woweb.net/
##	 * (class.planner123_main.php 파일에서 휴일과 기념일만 분리한 파일로
##	 * 편리를 위해 분리하나 사용은 class.planner123_main.php 파일과 같이 사용해야됨).
##
## [changes]
##  - 2010.10.10 : 미국 휴일및 기념일 함수.
##
//--------------------------------------------------------------------------------

class planner123_widget_holiday extends Object
{

//--------------------------------------------------------------------------------------
    /**
     * @function: fn_HolidayChk($pYear, $pMonth)
     * @return  : array
     * @brief:    휴일 여부
     **/
Function fn_HolidayChk($pYear, $pMonth) {
	/******************************************************
	*휴일은 음력에서 1.1(설)/8.15(추석)/4.8(석가탄신일) 이 있으며
	*양력으로 1.1(신정)/3.1(삼일절)/5.5(어린이날)/6.6(현충일)/8.15(광복절)/10.3(개천절)/12.25(성탄절) 이다.  
	  (4.5: 2006년부터 식목일은 법정 공휴일에서 법정기념일 기년일로바뀜)
	  (7.17: 2008년 부터 제헌절은 법정 공휴일에서 법정기념일 기년일로바뀜)
	*설과 추석은 앞뒤로 하루씩 휴일이 더해진다.
	*******************************************************/

//	For	($i = 0; $i<13; $i++) {
//		For ($j = 0; $j <32; $j++ ) {
//			$aHoli[$i][$j] = null;
//		}
//	}
	$aHoli = null;

/***
	//대한민국 양력 휴일(국경일,기념일중 휴일) 
	$aHoli[1][1] = "신정 ";
	$aHoli[3][1] = "삼일절 ";
	$aHoli[5][5] = "어린이날 ";
	$aHoli[6][6] = "현충일 ";
//	$aHoli[7][17] = "제헌절 ";	// 국경일이나 휴일아님
	$aHoli[8][15] = "광복절 ";
	$aHoli[10][3] = "개천절 ";
//	$aHoli[10][9] = "한글날 ";	// 국경일이나 휴일아님
	$aHoli[12][25] = "성탄절 ";

	//대한민국 음력휴일
	//(설날)
	$temp01 = explode("-",planner123_widget_main::fn_lun2sol($pYear,1,1));
	$iLunYmd =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2], $temp01[0]));
	$iLunYmdpre =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]-1, $temp01[0]));
	$iLunYmdnext =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]+1, $temp01[0]));

	$temp02 = explode("-",$iLunYmd);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."설날";
	$temp02 = explode("-",$iLunYmdpre);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."설연휴";
	$temp02 = explode("-",$iLunYmdnext);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."설연휴";


	//(추석)
	$temp01 = explode("-",planner123_widget_main::fn_lun2sol($pYear,8,15));
	$iLunYmd =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2], $temp01[0]));
	$iLunYmdpre =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]-1, $temp01[0]));
	$iLunYmdnext =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]+1, $temp01[0]));

	$temp02 = explode("-",$iLunYmd);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."추석";
	$temp02 = explode("-",$iLunYmdpre);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."추석연휴";
	$temp02 = explode("-",$iLunYmdnext);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."추석연휴";


	//(석가탄신일)
	$temp01 = explode("-",planner123_widget_main::fn_lun2sol($pYear,4,8));
	$iLunYmd =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2], $temp01[0]));
	$temp02 = explode("-",$iLunYmd);
	$aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."석가탄신일";
***/

//미국 휴일 *********************************************************************
	// 양력 휴일(국경일,기념일중 휴일) 
	$aHoli[1][1] = "New Year's Day ";
	$aHoli[7][4] = "Independence Day ";
	$aHoli[11][11] = "Veteran's Day ";
	$aHoli[12][25] = "Christmas ";

    // 몇월 몇번째 무슨요일 형식 기념일 설정 (예: 상공의날- 3월 셋째 수요일은 ($pYear, 월=3, 일=3, 수=3) 형식으로)
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 1, 3, 1));  // 1월 3째 월요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Martin Luther King's Day";
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 2, 3, 1));  // 2월 3째 월요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." President Day";
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 9, 1, 1));  // 9월 1째 월요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Labor Day";
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 10, 2, 1));  // 10월 2째 월요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Columbus Day";
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 11, 4, 4));  // 11월 4째 목요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Thanksgiving Day";

    // 몇월, 끝에서 몇번째 무슨요일 형식 기념일 설정  (예: Victoria Day=끝에서 1번째 월요일)
    $temp02 = explode("-",planner123_widget_main::fn_nslastweekday($pYear, 5, 1, 1));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Memorial Day";

    //(부활절)
    if (function_exists('easter_days')) {	// 부활절함수 있으면...
		$temp01 = explode("-",planner123_widget_main::fn_easterday($pYear));
	} else {
		$temp01 = explode("-",planner123_widget_main::fn_easterday_2($pYear));
	}
    $iYmd =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2], $temp01[0]));
    $iYmdpre =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]-2, $temp01[0]));
    $iYmdnext =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]+1, $temp01[0]));

//  $temp02 = explode("-",$iYmdpre);
//  $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."Good Friday";
    $temp02 = explode("-",$iYmd);
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Easter Sunday";
//  $temp02 = explode("-",$iYmdnext);
//  $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."Easter Monday";

	return $aHoli;
}

//------------------------------------------------------------------------
    /**
     * @function: fn_MemdayChk($pYear, $pMonth)
     * @return  : boolean
     * @brief:    기념일 여부
     **/
Function fn_MemdayChk($pYear, $pMonth) {
    /******************************************************
    *법정 기념일과 공휴일이 아닌 국경일
    *음력 기념일 등
    *******************************************************/
    $aHoli = null;

//음력 기념일  $aMoon[월][일][평달=0, 윤달=1, 윤달및평달=2] 형식으로....
//음력은 일년에 같은 월 같은 날이 두번 들어 있을 수 있음.
//  $aMoon[11][9][0] = $aMoon[11][9][0]."<B>조부기일</B><BR>";  // 음력11월 9일 (평달)
//  $aMoon[8][26][0] = $aMoon[8][26][0]."조카생일<BR>";         // 음력8월 26일 (평달)
//  $aMoon[5][16][1] = $aMoon[5][16][1]." <B>**윤달테스트**</B>";    // 음력윤달 (윤달만 적용)
//  $aMoon[3][20][2] = $aMoon[3][20][2]." <B>**윤달및평달테스트**</B>";    // 윤달및 평달: (윤달, 윤달 없으면 평달)
//  $aMoon[11][24][0] = $aMoon[11][24][0]." <B>**중복테스트**</B>";  // 1년에 두번 예:2008년

if ($aMoon) {
	$iLunYmd_arr = planner123_widget_main::fn_sol2lun_ary($pYear, $pMonth); // 당월 양력에 해당되는 음력일자 어레이 얻기
    for ($i=1; $i < 13; $i++ ) {
        for ($j=1; $j < 32; $j++ ) {
            if ($aMoon[$i][$j][0] != null || $aMoon[$i][$j][1] != null || $aMoon[$i][$j][2] != null) {  // 기념일이 있으면..
                $lunmemMM = $i;
                $lunmemDD = $j;

                for ($k=$pMonth; $k < $pMonth+1; $k++ ) {
                    for ($d=1; $d < 32; $d++ ) {
                        $iLunYmd = explode("-",$iLunYmd_arr[$k][$d]);   // 음력 어레이를 읽어서
                        $iLunMM = $iLunYmd[1];
                        $iLunDD = $iLunYmd[2];
                        $Yundal = $iLunYmd[3];

                        if ($aMoon[$lunmemMM][$lunmemDD][0] != null ) {     // 음력(평달) 기념일에 해당되는 양력 날자에..
                            if ($iLunMM == $lunmemMM  && $iLunDD == $lunmemDD && $Yundal == null ) {
                                $aHoli[$k][$d] = $aHoli[$k][$d].$aMoon[$i][$j][0];
                            }
                        }
                        if ($aMoon[$lunmemMM][$lunmemDD][1] != null ) {     // 음력(윤달) 기념일에 해당되는 양력 날자에..
                            if ($iLunMM == $lunmemMM  && $iLunDD == $lunmemDD && $Yundal != null ) {
                                $aHoli[$k][$d] = $aHoli[$k][$d].$aMoon[$i][$j][1];
                            }
                        }
                        if ($aMoon[$lunmemMM][$lunmemDD][2] != null ) {     // 음력(윤달)및 평달: 윤달 있으면 윤달, 없으면 평달 기념일에 해당되는 양력 날자에..
						$tmp_arr = explode("-",planner123_widget_main::fn_lun2sol($pYear,$lunmemMM,$lunmemDD));  // 당월에 윤달있는지...[4]==1
						  if ($tmp_arr[4] == 1) {
							if ($iLunMM == $lunmemMM  && $iLunDD == $lunmemDD && $Yundal != null ) {
                                $aHoli[$k][$d] = $aHoli[$k][$d].$aMoon[$i][$j][2];
							}
						  } else {
							if ($iLunMM == $lunmemMM  && $iLunDD == $lunmemDD && $Yundal == null ) {
                                $aHoli[$k][$d] = $aHoli[$k][$d].$aMoon[$i][$j][2];
							}
						  }
                        }

					}   // end for
                }       // end for

            }           // end if
        }               // end for
    }                   // end for
}				// end if

//양력기념일 (기념일,국경일,법정기념일 - 휴일아닌경우)
//  $aHoli[5][29] = $aHoli[5][29]." 큰딸생일";
//  $aHoli[6][9] = $aHoli[6][9]." 작은딸생일";
    $aHoli[1][13] = $aHoli[1][13]." Korean American Day";
    $aHoli[2][12] = $aHoli[2][12]." Lincoln’s Birthday";
    $aHoli[2][14] = $aHoli[2][14]." St. Valentines Day";
    $aHoli[2][22] = $aHoli[2][22]." Washington Birth Day";
    $aHoli[3][17] = $aHoli[3][17]." St. Patrick's Day";
    $aHoli[4][1] = $aHoli[4][1]." April Fool's Day";
    $aHoli[10][31] = $aHoli[10][31]." Halloween Day";

    // 몇월 몇번째 무슨요일 형식 기념일 설정 (예: 상공의날- 3월 셋째 수요일은 ($pYear, 월=3, 일=3, 수=3) 형식으로)
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 5, 2, 0));	// 5월 2째 일요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Mother's Day";
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 6, 3, 0));	// 6월 3째 일요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Father's Day";
	$temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 3, 2, 0));	// 3월 둘째주 일요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." <b>DST begins</b>";
	$temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, 11, 1, 0));	// 11월 첫째주 일요일
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." <b>DST ends</b>";

/***
    // 몇월, 끝에서 몇번째 주, 무슨요일 형식 기념일 설정 (예: 저축의날- 10월마지막화요일)
    //상공의날
    $temp02 = explode("-",planner123_widget_main::fn_nslastweekday($pYear, 10, 1, 2));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." 저축의날";
***/
/***
    // 몇월, 몇번째 주, 무슨요일 형식 기념일 설정 (예: 10월 4번째주 금요일) -현재 해당 기념일 없음.
    //테스트용 (예: 10월 4쨰주 금요일)
    $temp02 = explode("-",planner123_widget_main::fn_nsweeknsweekday($pYear, 10, 4, 5));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." 현재없음-테스트";
***/
/***
    // 매월, 몇번째 주, 무슨요일 형식 기념일 설정 (예: 4번째주 금요일) -현재 해당 기념일 없음.
    for ($k=1; $k < 13; $k++ ) {
    $temp02 = explode("-",planner123_widget_main::fn_nsweeknsweekday($pYear, $k, 4, 5));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." <font color=brown>월말결산</font>";
    }
***/
/***
    // 매월, 몇번째 무슨요일 형식 기념일 설정 (예-옵션만기일: 매월 2번째 목요일)
    for ($k=1; $k < 13; $k++ ) {
    $temp02 = explode("-",planner123_widget_main::fn_nsweekday($pYear, $k, 2, 4));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." <font color=brown>옵션만기일</font>";
    }
***/
/***
    // 몇월, 끝에서 몇번째 무슨요일 형식 기념일 설정  (예: Victoria Day=끝에서 2번째 월요일)
    $temp02 = explode("-",planner123_widget_main::fn_nslastweekday($pYear, 5, 2, 1));
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." Victoria Day";
***/
/***
    //(부활절)
    if (function_exists('easter_days')) {	// 부활절함수 있으면...
		$temp01 = explode("-",planner123_widget_main::fn_easterday($pYear));
	} else {
		$temp01 = explode("-",planner123_widget_main::fn_easterday_2($pYear));
	}
    $iYmd =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2], $temp01[0]));
    $iYmdpre =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]-2, $temp01[0]));
    $iYmdnext =date("Y-n-j", mktime(0, 0, 0,$temp01[1], $temp01[2]+1, $temp01[0]));

//  $temp02 = explode("-",$iYmdpre);
//  $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."Good Friday";
    $temp02 = explode("-",$iYmd);
    $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]." 부활절";
//  $temp02 = explode("-",$iYmdnext);
//  $aHoli[$temp02[1]][$temp02[2]] = $aHoli[$temp02[1]][$temp02[2]]."Easter Monday";
***/

    return $aHoli;
}
//------------------------------------------------------------------------

} // end of class

?>
