<?php
    /**
     * @class calendar_plannerXE123
     * @author Keysung Chung (chungfamily.ffhosting.net)
     * @brief 달력/플래너를 출력하는 위젯
     * @version 1.1.0
     **/

	class calendar_plannerXE123 extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {

			$var_version = "PlannerXE123 Widget Ver 1.1.0";

            // loged member --- -->
            // 로그인 정보를 구함
            $logged_info = Context::get('logged_info');
            $member_srl = $logged_info->member_srl;
			$group_list = $logged_info->group_list;
            $usergroup_arr = array();

			if ($member_srl != null) {
				$obj->var_member_srl = $member_srl;	 // user srl
				foreach($group_list as $key => $val) {
					$group_titles .= ",".$val;
				}
				$group_titles=substr($group_titles,1);    // 사용자가 소속된 그룹명칭
				$usergroup_arr = explode(",",$group_titles);
			} 

			// Grant 정보를 구함
            $grant = Context::get('grant');
            $login_manager = $grant->manager; //로그인 당시의 관리자 권한(어드민?)
			
            // 대상 모듈 (mid_list는 기존 위젯의 호환을 위해서 처리하는 루틴을 유지. module_srls로 위젯에서 변경)
            $oModuleModel = &getModel('module');
            if($args->mid_list) {
                $mid_list = explode(",",$args->mid_list);
                if(count($mid_list)) {
                    $module_srls = $oModuleModel->getModuleSrlByMid($mid_list);
                    if(count($module_srls)) $args->module_srls = implode(',',$module_srls);
                    else $args->module_srls = null;
                } 
            }
            // 대상 모듈중 상담기능설정, 문서보기종류, 스킨폴더명, 카테고리색상사용 정보 추출
            if($args->module_srls) {
				$oModuleModel_temp = &getModel('module');
				$module_srls_arr = explode(",",$args->module_srls);

				foreach($module_srls_arr as $key => $val_temp) {
					$module_info_temp = $oModuleModel_temp->getModuleInfoByModuleSrl($val_temp);
					$board_skin_arr[$val_temp] = $module_info_temp->skin; //스킨 폴더명
	                $grant_temp = $oModuleModel_temp->getGrant($module_info_temp, $logged_info);
					if($grant_temp->manager){
						$board_manager_srls .= ",".trim($val_temp);  // 관리권한있는 게시판 srl 리스트
					}
					if($module_info_temp->consultation == 'Y') {
						$consulboard_srls .= ",".trim($val_temp);  // 상담기능 게시판 srl 리스트
					}

					$oModuleModel_temp->syncSkinInfoToModuleInfo($module_info_temp);	//모듈 확장변수(skin)연계
					$document_group_arr[$val_temp] = $module_info_temp->default_document_group; //기본보기 문서종류
					$board_use_category_color_arr[$val_temp] = $module_info_temp->use_category.",".$module_info_temp->use_category_bgcolor; //카테고리사욘및 배경색 옵션
				}

				$consulboard_srls = substr($consulboard_srls,1);
				$consulboard_arr = explode(",", $consulboard_srls);		// 상담기능 게시판 srl 어레이
				$board_manager_srls = substr($board_manager_srls,1);
				$board_manager_arr = explode(",", $board_manager_srls);	// 관리권한있는 상담기능 게시판 srl 어레이
			}
			//$widget_info->testfld = $document_group_arr;  //디버깅을 위해
			//$widget_info->testfld .= $args->module_srls."<br/>상담기능: (".$consulboard_srls.")"."<br/>관리기능: (".$board_manager_srls.")";  //디버깅을 위해

            // 위젯 자체적으로 설정한 변수들을 체크
            // 보기 옵션
            $option_view_arr = explode(',',$args->option_view);

            // 기본 형태
            $default_style = $args->default_style;

            // 배경 색상
            $bg_color = $args->bg_color;

            // 제목
            $title = $args->title;

            // 정렬 대상
            $order_target = $args->order_target;
            if(!in_array($order_target, array('list_order','update_order','extra_value_end'))) $order_target = 'extra_value_end';

            // 정렬 순서
            $order_type = $args->order_type;
            if(!in_array($order_type, array('desc','asc'))) $order_type = 'asc';

            // 출력된 목록 수
            $list_count = (int)$args->list_count;
            if(!$list_count) $list_count = 200;

            // 제목 길이 자르기
            $subject_cut_size = $args->subject_cut_size;
            if(!$subject_cut_size) $subject_cut_size = 0;

            // 내용 길이 자르기
            $content_cut_size = $args->content_cut_size;
            if($content_cut_size == null) $content_cut_size = 240;
			
            // 최근 글 표시 시간
            $duration_new = $args->duration_new;
            if(!$duration_new) $duration_new = 24;
			
			// 대상 모듈이 선택되어 있지 않으면 해당 사이트의 전체 모듈을 대상으로 함
            $site_module_info = Context::get('site_module_info');
            if($args->module_srls) $obj->module_srl = $args->module_srls;
            else if($site_module_info) $obj->site_srl = (int)$site_module_info->site_srl;

            // 모듈의 정보를 구함
            $module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->module_srl);


// planner123 문서목록 얻기 ---------------------------------- -->
            // 당월 년월일 정보를 구함 ------ -->
			$cur_year = Context::get('pYear');
			$cur_month = substr("0".Context::get('pMonth'), -2);   //월 을 "7" 에서 "07"로);
            if ($cur_year == null || $cur_month == null) {
				$cur_year = date('Y');
				$cur_month = date('m');
			}

			// 쿼리 설정/실행/list만들기--- -->
			$obj->sort_index = $order_target;
			$obj->order_type = $order_type=="desc"?"asc":"desc";  // $obj->order_type = $order_type 으로는 반대로 정렬됨 ???
			$obj->sort_index_default = 'extra_value_start';	// 선택값이 null 일때 (일정시작만 입력한 경우)
			$obj->list_count = $list_count;  // 플래너에 표시될 일정수 (예:기본 200개)
			$obj->var_idx1 = '1';    // 확장변수1번: sort target(일정시작)- 통상 값이 있음
			$obj->var_idx2 = '2';	 // 확장변수2번: sort targer(일정종료)- 대부분의 경우 null 값임
			$obj->var_idx8 = '8';	 // 확장변수8번: 공개그룹
			$obj->var_period_start = $cur_year.$cur_month."01";	 // 선택 범위시작 - 당월 01일 >=
			$obj->var_period_end = $cur_year.$cur_month."31";	 // 선택 범위  끝 - 당월 31일 <=
			$obj->var_fld_null = "0";	 // null 대신값 (null이면 이상해짐)

			$tmp_01=explode("/",$this->widget_path); 
			$query_path = $tmp_01[1].'.'.$tmp_01[2];       // 쿼리경로

			// 각 게시판에 설정된 권한에 따라 문서를 분류 하기위해 당월에 일정이 있는 문서를 전부 불러옴 
			// (위젯에서 별도로 권한주는것은 취소)
			$output = executeQueryArray($query_path.'.getDocumentsForPlanner_all', $obj);    // 모든문서

			// document 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');

			// 오류가 생기면 그냥 무시(메시지 넘김으로 수정)
            if(!$output->toBool()) {
				$widget_info->testfld .= "query error: (".$cur_year.",".$cur_month.",".$order_target.",".$order_type.",".$query_path.")";  //디버깅을 위해
			//	return;
			}

			// ---권한에 따른 문서 목록 생성 --
            $modules = array();
			if(count($output->data)) {
				foreach($output->data as $key => $attribute) {
                    $modules[$attribute->module_srl]->mid = $attribute->mid;
                    $modules[$attribute->module_srl]->site_srl = $attribute->site_srl;
					$oDocument_srl = $attribute->document_srl;

					$oDocument = null;
					$oDocument = new documentItem();
					$oDocument->setAttribute($attribute, false);
					$oDocument->category_srl = $attribute->category_srl;
					$oDocument->module_srl = $attribute->module_srl;
					$oDocument->module_skin = $board_skin_arr[$attribute->module_srl];
					$oDocument->use_category_bgcolor = $board_use_category_color_arr[$attribute->module_srl];

		            $tmp_opengroup_arr = explode("|@|",$attribute->extra_value_group);

					// 게시판에 설정된 문서보기 종류에따라 보여줄문서여부 판단
					if (in_array($oDocument->module_srl, $consulboard_arr)) { // 상담기능 게시판 문서일때
						if ($login_manager) {						// 로그인시 관리자(어드민?)
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
						    $document_list[$key] = $oDocument;      // 로그인시 관리자(어드민?)이면 문서를 처리,
						} else if(in_array($oDocument->module_srl, $board_manager_arr)){
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
						    $document_list[$key] = $oDocument;      // 관리자 권한있는 게시판이면 문서를 처리,
						} else if ($attribute->is_notice == "Y" || $attribute->member_srl == $member_srl) {
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
							$document_list[$key] = $oDocument;      //공지문서나 자신의 문서이면 처리.
						}
					} else {  // 상담기능 게시판 문서가 아닐때

						if ($login_manager) {						// 로그인시 관리자(어드민?)
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
						    $document_list[$key] = $oDocument;      // 로그인시 관리자(어드민?)이면 문서를 처리,
						} else if(in_array($oDocument->module_srl, $board_manager_arr)){
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
						    $document_list[$key] = $oDocument;      // 관리 권한있는 게시판의 문서이면 처리,
						} else if ($attribute->is_notice == "Y" || $attribute->member_srl == $member_srl) {
							$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
							$document_list[$key] = $oDocument;      //공지문서나 자신의 문서이면 처리.
						} else {									// 관리자도 아니고 권한도 없다면, 기본 보기문서 종류에 따라 처리

						  switch ($document_group_arr[$oDocument->module_srl]) {  //각 게시판의 기본보기 문서종류
							case "":								// 문서그룹이 없으면 (Ver 1.0 이전버전 감안),
								$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
								$document_list[$key] = $oDocument;      // 문서그룹이 alldocument 이면 문서를 처리,
								break;
							case "alldocument":
								$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
								$document_list[$key] = $oDocument;      // 문서그룹이 alldocument 이면 문서를 처리,
								break;
							case "nonsecured":							//문서그룹이 nonsecured 일때
								if ($attribute->is_notice == "Y" || $attribute->member_srl == $member_srl) {
									$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
		 							$document_list[$key] = $oDocument;       //공지문서나 자신의 문서이면 처리.(위에서처리됨)
								} else if($attribute->is_secret == "N" && $attribute->extra_value_group == null){
								$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
								$document_list[$key] = $oDocument;      // 비밀문서가 아니면서 공개그룹없으면 문서를 처리,
								} else {
									$tmp_flag = "";
									foreach($usergroup_arr as $tmp_key => $val_tmp) {
						    		    if (in_array($val_tmp, $tmp_opengroup_arr)){   
											$tmp_flag = "*";                        //공개그룹 소속.
										}
									}
									if ($tmp_flag == "*") {
										$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
			 					        $document_list[$key] = $oDocument;       //공개그룹 소속이면 처리.
									}
								}
								break;
							case "usergroup":							//문서그룹이 usergroup 일때
								if ($attribute->is_notice == "Y" || $attribute->member_srl == $member_srl) {
									$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
		 							$document_list[$key] = $oDocument;       //공지문서나 자신의 문서이면 처리.(위에서처리됨)
								} else {
									$tmp_flag = "";
									foreach($usergroup_arr as $tmp_key => $val_tmp) {
						    		    if (in_array($val_tmp, $tmp_opengroup_arr)){   
											$tmp_flag = "*";                        //공개그룹 소속.
										}
									}
									if ($tmp_flag == "*") {
										$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
			 					        $document_list[$key] = $oDocument;       //공개그룹 소속이면 처리.
									}
								}
								break;
							case "owner":							//문서그룹이 usergroup 일때
								if ($attribute->is_notice == "Y" || $attribute->member_srl == $member_srl) {
									$GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
		 					        $document_list[$key] = $oDocument;       //공지문서나 자신의 문서이면 처리.(위에서처리됨)
								}
								break;
						  }  // switch 끝
						}	// 관리자도 아니고 권한도 없을때 끝
					} // 상담기능 게시판 문서가 아닐때 끝
				//echo $oDocument_srl." ";  //디버깅용
				}  // foreeach 끝

                $oDocumentModel->setToAllDocumentExtraVars();
			} else {
				$document_list = array();          
			}
// planner123 문서목록 얻기 끝---------------------------------- -->

            // 분류 구함
            $output_category = executeQueryArray($query_path.'.getCategories', $obj_2);
			$category_list = array();
            if($output_category->toBool() && $output_category->data) {
                foreach($output_category->data as $key => $val) {
                    $category_list[$val->category_srl] = $val;
                }
            }

            // 모듈이 하나만 선택되었을 경우 대상 모듈 이름과 링크를 생성
            if(count($modules)==1) {
                $info = array_shift($modules);
                if($info) {
                    $widget_info->mid = $info->mid;
                    if($info->site_srl) {
                        $site_info = $oModuleModel->getSiteInfo($info->site_srl);
                        if($site_info->domain) {
                            $widget_info->more_link = getSiteUrl('http://'.$site_info->domain, '','mid', $widget_info->mid);
                        }
                    } else {
                        $widget_info->more_link = getUrl('','mid',$info->mid);
                        $widget_info->module_name = $info->mid;
                    }
                }
            }

            // 입력된 메인 일정게시판 모듈이 있으면 이것을 메인 일정으로(모듈이 여러개 선택 되었을 경우 사용)
            $main_schedule_module = $args->main_schedule_module;
            if($main_schedule_module != null) $widget_info->mid = $main_schedule_module;

            // 템플릿 파일에서 사용할 변수들을 세팅
			$widget_info->option_view_arr = $option_view_arr;
			$widget_info->bg_color = $bg_color;
            $widget_info->title = $title;
            $widget_info->document_list = $document_list;
            $widget_info->category_list = $category_list;
            $widget_info->subject_cut_size = $subject_cut_size;
            $widget_info->content_cut_size = $content_cut_size;
            $widget_info->duration_new = $duration_new * 60*60;
            $widget_info->module_info = $module_info;
            $widget_info->planner_version = $var_version;

            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            if ($default_style == 'mini') {
            $tpl_file = 'mini_planner';
			}
			else if ($default_style == 'list') {
            $tpl_file = 'list_planner';
			}
			else if ($default_style == 'simple') {
            $tpl_file = 'calendar_planner_simple';
			}
			else if ($default_style == 'standard' || $default_style == 'calendar') {
            $tpl_file = 'calendar_planner';
			}
			else {
            $tpl_file = 'calendar_planner_simple';
			}

			// 플래너에 필요한 함수 include
			if ($default_style == 'calendar' or $default_style == 'standard' or $default_style == 'list') {
				if (!class_exists('calendar123_widget')) {
					require_once 'function/class.calendar123_widget.php';
				}
				if (!class_exists('solar_widget')) {
					require_once 'function/class.solar_widget.php';
				}
				if (!class_exists('planner_ksc_widget')) {
					require_once 'function/class.planner_ksc_widget.php';
				}
			}
			else {
				if (!class_exists('planner_ksc_widget')) {
				require_once 'function/class.planner_ksc_widget.php';
				}
			}

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            $output = $oTemplate->compile($tpl_path, $tpl_file);
            return $output;
        }
    }

?>
