<?php
    /**
     * @class calendar_plannerXE123
     * @author Keysung Chung (chungfamily.ffhosting.net)
     * @brief 달력/플래너를 출력하는 위젯
     * @version 0.2
     **/

	class calendar_plannerXE123 extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 대상 모듈 (mid_list는 기존 위젯의 호환을 위해서 처리하는 루틴을 유지. module_srls로 위젯에서 변경)
            $oModuleModel = &getModel('module');
            if($args->mid_list) {
                $mid_list = explode(",",$args->mid_list);
                if(count($mid_list)) {
                    $module_srls = $oModuleModel->getModuleSrlByMid($mid_list);
                    if(count($module_srls)) $args->module_srls = implode(',',$module_srls);
                    else $args->module_srls = null;
                } 
            }

            // 위젯 자체적으로 설정한 변수들을 체크
            // 보기 옵션
            $option_view_arr = explode(',',$args->option_view);

            // 기본 형태
            $default_style = $args->default_style;

            // 배경 색상
            $bg_color = $args->bg_color;

            // 제목
            $title = $args->title;

            // 정렬 대상
            $order_target = $args->order_target;
            if(!in_array($order_target, array('list_order','update_order','extra_value_end'))) $order_target = 'extra_value_end';

            // 정렬 순서
            $order_type = $args->order_type;
            if(!in_array($order_type, array('desc','asc'))) $order_type = 'desc';

            // 출력된 목록 수
            $list_count = (int)$args->list_count;
            if(!$list_count) $list_count = 50;

            // 제목 길이 자르기
            $subject_cut_size = $args->subject_cut_size;
            if(!$subject_cut_size) $subject_cut_size = 0;

            // 내용 길이 자르기
            $content_cut_size = $args->content_cut_size;
            if($content_cut_size == null) $content_cut_size = 240;
			
			// 대상 모듈이 선택되어 있지 않으면 해당 사이트의 전체 모듈을 대상으로 함
            $site_module_info = Context::get('site_module_info');
            if($args->module_srls) $obj->module_srl = $args->module_srls;
            else if($site_module_info) $obj->site_srl = (int)$site_module_info->site_srl;

            // 모듈의 정보를 구함
            $module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->module_srl);

            // calendar_plannerXE123 위젯에서 정의한 query문을 직접 사용
            if ($order_target != 'extra_value_end') {
				$obj->sort_index = 'documents.'.$order_target;  // list_order 또는 update_order 선택
				$obj->sort_index_default = 'documents.list_order';   // 선택값이 null 일때 (해당 없음)
				$obj->order_type = $order_type=="desc"?"asc":"desc";  // $obj->order_type = $order_type 으로는 반대로 정렬됨 ???
	            $obj->list_count = $list_count;
                $output = executeQueryArray('widgets.calendar_plannerXE123.getNewestDocuments', $obj);
			}
			else {
				$obj->sort_index = $order_target;	// 일정종료일 선택: Alias명 extra_value_end로 sort
				$obj->sort_index_default = 'extra_value_start';	// 선택값이 null 일때 (일정시작만 입력한 경우)
		        $obj->order_type = $order_type;
                $obj->list_count = $list_count;
				$obj->var_idx1 = '1';    // 확장변수1번: sort target(일정시작)- 통상 값이 있음
				$obj->var_idx2 = '2';	 // 확장변수2번: sort targer(일정종료)- 대부분의 경우 null 값임
				$obj->var_value = '2000';	 // 확장변수 값 (일정시작)- 2000년이후
                $output = executeQueryArray('widgets.calendar_plannerXE123.getNewestDocumentsWithExtraVarsForPlanner', $obj);
			} 

            // document 모듈의 model 객체를 받아서 결과를 객체화 시킴
            $oDocumentModel = &getModel('document');

            // 오류가 생기면 그냥 무시
            if(!$output->toBool()) return;

            // 문서 결과가 있으면 각 문서 객체화를 시킴
            $modules = array();
            if(count($output->data)) {
                foreach($output->data as $key => $attribute) {
                    $modules[$attribute->module_srl]->mid = $attribute->mid;
                    $modules[$attribute->module_srl]->site_srl = $attribute->site_srl;
                    $document_srl = $attribute->document_srl;

					$oDocument = null;
                    $oDocument = new documentItem();
                    $oDocument->setAttribute($attribute, false);
					$oDocument->category_srl = $attribute->category_srl;

                    $GLOBALS['XE_DOCUMENT_LIST'][$oDocument->document_srl] = $oDocument;
                    $document_list[$key] = $oDocument;
                }
                $oDocumentModel->setToAllDocumentExtraVars();
            } else {
                $document_list = array();          
            }

            // 분류 구함
            $output_category = executeQueryArray('widgets.calendar_plannerXE123.getCategories', $obj_2);
            if($output_category->toBool() && $output_category->data) {
                foreach($output_category->data as $key => $val) {
                    $category_list[$val->category_srl] = $val;
                }
            }

            // 모듈이 하나만 선택되었을 경우 대상 모듈 이름과 링크를 생성
            if(count($modules)==1) {
                $info = array_shift($modules);
                if($info) {
                    $widget_info->mid = $info->mid;
                    if($info->site_srl) {
                        $site_info = $oModuleModel->getSiteInfo($info->site_srl);
                        if($site_info->domain) {
                            $widget_info->more_link = getSiteUrl('http://'.$site_info->domain, '','mid', $widget_info->mid);
                        }
                    } else {
                        $widget_info->more_link = getUrl('','mid',$info->mid);
                        $widget_info->module_name = $info->mid;
                    }
                }
            }

            // 입력된 메인 일정게시판 모듈이 있으면 이것을 메인 일정으로(모듈이 여러개 선택 되었을 경우 사용)
            $main_schedule_module = $args->main_schedule_module;
            if($main_schedule_module != null) $widget_info->mid = $main_schedule_module;

            // 템플릿 파일에서 사용할 변수들을 세팅
			$widget_info->option_view_arr = $option_view_arr;
			$widget_info->bg_color = $bg_color;
            $widget_info->title = $title;
            $widget_info->document_list = $document_list;
            $widget_info->category_list = $category_list;
            $widget_info->subject_cut_size = $subject_cut_size;
            $widget_info->content_cut_size = $content_cut_size;
            $widget_info->module_info = $module_info;

            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            if ($default_style == 'mini') {
            $tpl_file = 'mini_planner';
			}
			else if ($default_style == 'list') {
            $tpl_file = 'list_planner';
			}
			else if ($default_style == 'simple') {
            $tpl_file = 'calendar_planner_simple';
			}
			else {
            $tpl_file = 'calendar_planner';
			}

			// 플래너에 필요한 함수 include
			if ($default_style == 'calendar' or $default_style == 'list') {
				if (!class_exists('calendar123_widget')) {
					require_once 'function/class.calendar123_widget.php';
				}
				if (!class_exists('solar_widget')) {
					require_once 'function/class.solar_widget.php';
				}
				if (!class_exists('planner_ksc_widget')) {
					require_once 'function/class.planner_ksc_widget.php';
				}
			}
			else {
				if (!class_exists('planner_ksc_widget')) {
				require_once 'function/class.planner_ksc_widget.php';
				}
			}

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            $output = $oTemplate->compile($tpl_path, $tpl_file);
            return $output;
        }
    }

?>
