<?php
    /**
     * 사용자 화면정의
     * 
     * @class  stopsmokingModel
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking 모듈의 View class
     **/

    class stopsmokingView extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {
        	// 모듈정보를 가져온다.
            $oStopsmokingModel = &getModel('stopsmoking');
            $this->module_info = $oStopsmokingModel->getModulesInfo();
            Context::set('module_info',$this->module_info);
         
        	// 스킨 경로를 미리 template_path 라는 변수로 설정함 스킨이 존재하지 않는다면 기본 설정의 스킨으로 설정
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);  	            
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = "default";
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);
        }
        
        /**
         * 결심등록 화면 
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingDecisionWrite
         * @return unknown_type
         */
        function dispStopsmokingDecisionWrite(){
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			// 로그인체크
			if($this->logged_info){
				// 결심이 등록되어 있는지 검사하자.
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            // 관리자가 아니면...
	            if($member_info->is_admin !='Y'){
	            	$args->member_srl = $member_info->member_srl;
	            }
				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$decision = $oStopsmokingModel->getDecision($args);

            	// 금연결심이 있다면
            	if($decision->data==null){
            		// 템플릿 지정 - 생성
	            	$this->setTemplateFile('decision_input');
            	} else {
            		return $this->stop('msg_have_decision');
            	}
	            
			} else {
				return $this->stop('msg_not_logged');
			}
        }
		
    	/**
         * 결심수정 화면 
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingDecisionEdit
         * @return unknown_type
         */
        function dispStopsmokingDecisionEdit(){
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			
			// 로그인체크
			if($this->logged_info){
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            $args->member_srl = $member_info->member_srl;

				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$output = $oStopsmokingModel->getDecision($args);
            	Context::set('decision', $output->data);
            	
	            // 템플릿 지정 - 생성
	            $this->setTemplateFile('decision_input');
			} else {
				return $this->stop('msg_not_logged');
			}
        }
        
        /**
         * 금연시계를 보여준다.
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingTimer
         * @return unknown_type
         */
        function dispStopsmokingTimer(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			
			// 로그인체크
			if($this->logged_info){
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            $args->member_srl = $member_info->member_srl;
	            
				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$decision = $oStopsmokingModel->getDecision($args);

            	// 금연결심이 있다면
            	if($decision->data!=null){
            		// 금연일수를 계산한다.
	            	$standardDateTime = date('Y-m-d H:i:s');
					$comparisonDateTime = zdate($decision->data->stop_date,"Y-m-d H:i:s");
					$timer = $oStopsmokingModel->getDiffDateTime($standardDateTime,$comparisonDateTime);
					
					// 흡연일수를 계산한다.
					$smokingStandardDateTime = zdate($decision->data->stop_date,"Y-m-d H:i:s");
					$smokingComparisonDateTime = zdate($decision->data->start_date,"Y-m-d H:i:s");
					$smokingDay = $oStopsmokingModel->getDiffDateTime($smokingStandardDateTime,$smokingComparisonDateTime);				
					$decision->data->smoking_day = $smokingDay->diffDate;
					
					// 그룹정보를 가져온다.
					$timer->group = $oStopsmokingModel->getGroup($timer, $this->module_info);		
					// 참은담배갯수를 계산한다.
					$timer->stop_cigarette_count = $oStopsmokingModel->getStopCigaretteCount($decision->data, $timer);
					// 그동안 사용한 담배값을 구한다.
					$timer->spend_money = $oStopsmokingModel->getSpendMoney($decision->data);
					// 번돈을 구한다.
					$timer->earn_money = $oStopsmokingModel->getEarnMoney($decision->data, $timer);
					// 연장된생명을 구한다.
					$timer->save_life = $oStopsmokingModel->getSaveLife($decision->data, $timer);			
					// 흡연시작일
					$timer->start_date = $decision->data->start_date;
					// 금연시작일
					$timer->stop_date = $decision->data->stop_date;
					// 금연결심
	            	$timer->decision = $decision->data->decision;
					
	            	Context::set('timer', $timer);
	            	
		            // 템플릿 지정 - 생성
		            $this->setTemplateFile('timer');
            	} else {
            		// 템플릿 지정 - 생성
		            $this->setTemplateFile('decision_input');
            	}
            	
			} else {
				return $this->stop('msg_not_logged');
			}
        }
        
    }
?>