<?php
    /**
     * 데이터베이스 작업
     * 
     * @class  stopsmokingModel
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking 모듈의 Model class
     **/

    class stopsmokingModel extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {

        }
        
    	/**
         * @brief 모듈정보 return
         **/
        function getModulesInfo() {
            static $module_info = null;
            if(is_null($module_info)) {
                // module_config에서 값을 가져온다.
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('stopsmoking');
				
                // module_srl을 기준으로 스킨정보를 가져온다.
                $skin_info->module_srl = $module_info->module_srl;
                $oModuleModel->syncSkinInfoToModuleInfo($module_info);
                if(count($skin_info)) foreach($skin_info as $key => $val) $module_info->{$key} = $val;
                
                // mid값을 기준으로 modules에서 정보를 추출함
                $dummy = $oModuleModel->getModuleInfoByMid($module_info->mid);
                $module_info->module_srl    = $dummy->module_srl;
                $module_info->layout_srl    = $dummy->layout_srl;
                $module_info->site_srl      = $dummy->site_srl;
                $module_info->skin          = $dummy->skin;
                $module_info->browser_title = $dummy->browser_title;
                $module_info->is_default    = $dummy->is_default;

                unset($module_info->grants);
            }
            return $module_info;
        }
        
    	/**
         * decision 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertDecision($args) {
            $output = executeQuery('stopsmoking.insertDecision', $args);         
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * @brief 금연결심모두 가져오기
         **/
        function getDecisionListAll($args) {
            $output = executeQuery('stopsmoking.getDecisionListAll', $args);
            return $output;
        }
        
    	/**
         * decision 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateDecision($args) {
            $output = executeQuery('stopsmoking.updateDecision', $args);      
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * decision 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteDecision($args) {
            $output = executeQuery('stopsmoking.deleteDecision', $args);      
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * history 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertHistory($args) {
            $output = executeQuery('stopsmoking.insertHistory', $args);         
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * @brief 금연결심 1개 가져오기
         **/
        function getDecision($args) {
            $output = executeQuery('stopsmoking.getDecision', $args);
            if(!$output->toBool() || !$output->data) return $output;
            return $output;
        }
        
    	/**
    	 * 
         * @brief 결심 목록 return
         **/
        function getDecisionList($list_count=20, $page=1, $sort_index = 'decision_srl') {
            if(!in_array($sort_index, array('decision_srl'))) $sort_index = 'decision_srl';
            
            $args->sort_index = $sort_index;
            $args->list_count = $list_count;
            $args->page = $page;

            $output = executeQueryArray('stopsmoking.getDecisionList', $args);

            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
    	 * 
         * @brief 실패 목록 return
         **/
        function getHistoryList($list_count=20, $page=1, $sort_index = 'history_srl') {
            if(!in_array($sort_index, array('history_srl'))) $sort_index = 'history_srl';
            
            $args->sort_index = $sort_index;
            $args->list_count = $list_count;
            $args->page = $page;

            $output = executeQueryArray('stopsmoking.getHistoryList', $args);

            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * @brief 금연로그 1개 가져오기
         **/
        function getHistory($args) {
            $output = executeQuery('stopsmoking.getHistory', $args);
            if(!$output->toBool() || !$output->data) return $output;
            return $output;
        }
        
    	/**
         * 날짜의 차이를 계산한 후 년, 월, 주, 일, 시, 분, 초를 포함하여 리턴한다.
         * 
         * @param $standardDateTime    기준날짜
         * @param $comparisonDateTime  비교날짜
         * @return unknown_type
         */
        function getDiffDateTime($standardDateTime, $comparisonDateTime){
        	// timestamp 구하기
			$standardTimestamp = strtotime($standardDateTime);	
        	$comparisonTimestamp = strtotime($comparisonDateTime);	        	
        	$diffTimestamp = $standardTimestamp - $comparisonTimestamp;	// Timestamp차이
        	$diffSign = "plus";
			if($diffTimestamp<0){
        		$diffSign = "minus";
			}
			// 절대값을 구한다.
			$diffTimestampAbs = abs($diffTimestamp);
        	// timestamp차이를 86400으로 나눈 나머지를 구한다.(=시,분,초 차이계산을 위해)
        	// 날짜차이
        	$diffDate = floor($diffTimestampAbs/86400);
        	// 시,분,초 차이 구하기...
        	$restTime = $diffTimestampAbs % 86400;
			$diffHour = floor($restTime / 3600);			
			$diffMinute = floor($restTime % 3600 / 60);
			$diffSecond = floor($restTime % 3600 % 60);

			$result->diffSign = $diffSign;
			$result->diffTimestampAbs = $diffTimestampAbs;
			$result->diffDate = $diffDate;
			$result->diffHour = $diffHour;
			$result->diffMinute = $diffMinute;
			$result->diffSecond = $diffSecond;
        	return $result;
        }
        
    	/**
         * 타이머를 기준으로 그룹정보를 가져온다.
         * 
         * @param $timer
         * @return unknown_type
         */
        function getGroup($timer, $module_info){
       	
        	$oMemberModel = &getModel('member');

        	$group_srl = "";
        	if($timer->diffSign=="plus"){
	        	// 15단계: 3650일
				if($timer->diffTimestampAbs>86400*3650){
					$group_srl = $module_info->group15;
				// 14단계: 1825일
				} else if($timer->diffTimestampAbs>86400*1825){
					$group_srl = $module_info->group14;
				// 13단계: 360일
				} else if($timer->diffTimestampAbs>86400*360){
					$group_srl = $module_info->group13;
				// 12단계: 180일
				} else if($timer->diffTimestampAbs>86400*180){
					$group_srl = $module_info->group12;
				// 11단계: 100일
				} else if($timer->diffTimestampAbs>86400*100){
					$group_srl = $module_info->group11;
				// 10단계: 60일
				} else if($timer->diffTimestampAbs>86400*60){
					$group_srl = $module_info->group10;
				// 09단계: 30일
				} else if($timer->diffTimestampAbs>86400*30){
					$group_srl = $module_info->group09;
				// 08단계: 21일
				} else if($timer->diffTimestampAbs>86400*21){
					$group_srl = $module_info->group08;
				// 07단계: 18일
				} else if($timer->diffTimestampAbs>86400*18){
					$group_srl = $module_info->group07;
				// 06단계: 14일
				} else if($timer->diffTimestampAbs>86400*14){
					$group_srl = $module_info->group06;
				// 05단계: 10일
				} else if($timer->diffTimestampAbs>86400*10){
					$group_srl = $module_info->group05;
				// 04단계: 7일
				} else if($timer->diffTimestampAbs>86400*7){
					$group_srl = $module_info->group04;
				// 03단계: 3일
				} else if($timer->diffTimestampAbs>86400*3){
					$group_srl = $module_info->group03;
				// 02단계: 0초
				} else if($timer->diffTimestampAbs>0){
					$group_srl = $module_info->group02;	
				} 
			// 01단계: 0일
        	} else {
				$group_srl = $module_info->group01;
			}
			$output = $oMemberModel->getGroup($group_srl);
			return $output;
        }
        
    	/**
         * 참은 담배갯수를 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getStopCigaretteCount($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		$result = floor($count * $timer->diffTimestampAbs);
        	} else {
        		$result = 0;
        	}
        	return $result;
        }
        
    	/**
         * 그동안 사용한 담배값을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getSpendMoney($decision){
        	// 초당 소비하는 담배개수를 구한다.
        	$count = $decision->cigarette_count/86400;
        	// 개당가격을 구한다.
        	$price = $decision->cigarette_price/$decision->cigarette_count;
        	$result = floor($count * ($decision->smoking_day * 86400) * $price);
        	return $result;
        }
        
        /**
         * 번돈을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getEarnMoney($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		// 개당가격을 구한다.
        		$price = $decision->cigarette_price/$decision->cigarette_count;
        		$result = floor($count * $timer->diffTimestampAbs * $price);
        	} else {
        		$result = 0;
        	}
        	return $result;
        }
        
   	 	/**
         * 연장된생명을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getSaveLife($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		// 1개비당 5분(300초)
        		$totalSecond = floor($count * $timer->diffTimestampAbs) * 300;
	        	$saveDate = floor($totalSecond/86400);
	        	$saveRestTime = $totalSecond % 86400;
				$saveHour = floor($saveRestTime / 3600);			
				$saveMinute = floor($saveRestTime % 3600 / 60);
				$saveSecond = floor($saveRestTime % 3600 % 60);
        	} 
			$result->saveDate = $saveDate;
			$result->saveHour = $saveHour;
			$result->saveMinute = $saveMinute;
			$result->saveSecond = $saveSecond;
        	return $result;
        }
    }
?>