<?php
    /**
     * 관리자 업무 처리
     * 
     * @class  stopsmokingAdminController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 admin controller class
     **/

    class stopsmokingAdminController extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {

        }
        
    	/**
         * 기본환경설정 수정 처리
         * 대상테이블: modules, module_config
         * 
         * @return unknown_type
         */
        function procStopsmokingAdminSetup() {
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');
            
            // 기본설정가져오기
            $oStopsmokingModel = &getModel('stopsmoking');
            $module_info = $oStopsmokingModel->getModulesInfo();
            // modules 테이블에 입력이 되어 있는지 체크
            $_module_info = $oModuleModel->getModuleInfoByMid($module_info->mid);

            if($module_info->mid && $_module_info) {
                $module_info->module_srl = $_module_info->module_srl;
                $is_registed = true;
            } else {
                $is_registed = false;
            }

            // mid, browser_title, is_default 값이 바뀌면 처리
            $module_info->mid = $args->mid;
            $args->module = 'stopsmoking';
            $args->module_srl = $is_registed?$module_info->module_srl:getNextSequence();

            if($args->is_default == 'Y') {
                $output = $oModuleController->clearDefaultModule();
                if(!$output->toBool()) return $output;
            }
			
            // 입력여부에 따라 업데이트를 할지 인서트를 할지 결정
            if($is_registed) {
                $output = $oModuleController->updateModule($args);
            } else {
                $output = $oModuleController->insertModule($args);
            }           
            if(!$output->toBool()) return $output;

            // module_config에 입력
			$stopsmoking->mid = $args->mid;            
            $stopsmoking->group01 = $args->group01;
            $stopsmoking->group02 = $args->group02;
            $stopsmoking->group03 = $args->group03;
            $stopsmoking->group04 = $args->group04;
            $stopsmoking->group05 = $args->group05;
            $stopsmoking->group06 = $args->group06;
            $stopsmoking->group07 = $args->group07;
            $stopsmoking->group08 = $args->group08;
            $stopsmoking->group09 = $args->group09;
            $stopsmoking->group10 = $args->group10;
            $stopsmoking->group11 = $args->group11;
            $stopsmoking->group12 = $args->group12;
            $stopsmoking->group13 = $args->group13;
            $stopsmoking->group14 = $args->group14;
            $stopsmoking->group15 = $args->group15;
            $output = $oModuleController->insertModuleConfig('stopsmoking', $stopsmoking);

            $this->setMessage("success_saved");
        }
    }

?>