<?php
	/**
     * 관리자 화면정의
     * 
     * @class  stopsmokingAdminView
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking admin view class
     **/

	class stopsmokingAdminView extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {
            // 모듈정보를 가져온다.
            $oStopsmokingModel = &getModel('stopsmoking');
            $this->module_info = $oStopsmokingModel->getModulesInfo();
            Context::set('module_info',$this->module_info);

            // 템플릿정보를 가져온다.
            $this->setTemplatePath($this->module_path."/tpl/");
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }
        
        /**
         * 기본설정 수정화면
         * @return unknown_type
         */
        function dispStopsmokingAdminSetup() {
        	// 회원그룹목록가져오기
        	$oMemberModel = &getModel('member');
        	$output = $oMemberModel->getGroups();
			Context::set('group_list', $output);

        	// 스킨목록가져오기
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록가져오기
            $oLayoutMode = &getModel('layout');
            $layout_list = $oLayoutMode->getLayoutList();
            Context::set('layout_list', $layout_list);
            
            // 템플릿파일이름 정하기
            $this->setTemplateFile('setup');
        }
        
        /**
         * 결심목록
         * @return unknown_type
         */
        function dispStopsmokingAdminDecisionList() {
        	$page = Context::get('page');
            if(!$page) $page = 1;

            $oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->getDecisionList(20, $page, 'start_date');          
			Context::set('page', $output->page);
            Context::set('decision_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿파일이름 정하기
            $this->setTemplateFile('decision_list');
        }
        
		/**
         * 결심보기
         * @return unknown_type
         */
        function dispStopsmokingAdminDecision() {
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

			// 로그인체크
			// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = Context::get('module_info');	            
			$args->module_srl = $module_info->module_srl;

			// 금연결심을 가져온다.
			$oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->getDecision($args);           
            Context::set('decision', $output->data);
            
            // 템플릿 지정 - 생성
            $this->setTemplateFile('decision_view');
        }
        
		/**
         * 실패목록
         * @return unknown_type
         */
        function dispStopsmokingAdminHistoryList() {
        	$page = Context::get('page');
            if(!$page) $page = 1;

            $oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->getHistoryList(20, $page, 'fail_date');

			Context::set('page', $output->page);
            Context::set('history_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿파일이름 정하기
            $this->setTemplateFile('history_list');
        }
        
		/**
         * 로그보기
         * @return unknown_type
         */
        function dispStopsmokingAdminHistory() {
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

			// 로그인체크
			// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = Context::get('module_info');	            
			$args->module_srl = $module_info->module_srl;

			// 금연결심을 가져온다.
			$oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->getHistory($args);           
            Context::set('decision', $output->data);
            
            // 템플릿 지정 - 생성
            $this->setTemplateFile('history_view');
        }
    }
?>