<?php
    /**
     * 금연 기본 클래스, Controller, View, Model은 이 클래스를 상속한다.
     * 
     * @class  stopsmoking
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking 모듈의 high class
     **/
	
	//require_once(_XE_PATH_.'modules/stopsmoking/stopsmoking.config.php');

    class stopsmoking extends ModuleObject {
		
    	/**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
        	// 사용할 디렉토리 생성
            FileHandler::makeDir('./files/cache/stopsmoking');
            
        	// stopsmoking 이라는 mid를 미리 입력한다.
        	// 이 mid는 차후 수정 가능하고 stopsmoking 메인 페이지를 사용하기 위한 더미 형식의 mid로 사용됨.
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $module_info = $oModuleModel->getModuleConfig('stopsmoking');
            if($module_info->mid) {
                $_o = executeQuery('module.getMidInfo', $module_info);
                if(!$_o->data) unset($module_info);
            }

            if(!$module_info->mid) {
                $args->module = 'stopsmoking';				//
                $args->mid = 'stopsmoking';                //
                $args->skin = 'default';	    // 
                $args->browser_title = 'StopSmokingXE';	//
                $args->is_default = 'N';				//
                $args->open_rss = 'N';                  //
                $args->module_srl = getNextSequence();
                
                // 데이터입력(테이블: module)
                $output = $oModuleController->insertModule($args);

                // 금연모듈에서 사용할 그룹을 생성하고 module_config에 입력할 데이터를 설정합니다.
                $stopsmoking->mid = $args->mid;
                $stopsmoking->group01 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group01,"노예","0일, 담배의 소유물로 되어 부림을 당하는 사람");
            	$stopsmoking->group02 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group02,"평민","1일, 금연을 이제 막 시작한 사람");
            	$stopsmoking->group03 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group03,"기사","3일, 중세 유럽에서, 봉건 영주에 속한 무사처럼 금단현상과 싸워야 하는 사람");
            	$stopsmoking->group04 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group04,"남작","7일, 다섯 등급으로 나눈 귀족의 작위 가운데 맨 마지막 작위");
            	$stopsmoking->group05 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group05,"자작","10일, 다섯 등급으로 나눈 귀족의 작위 가운데 넷째");
            	$stopsmoking->group06 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group06,"백작","14일, 다섯 등급으로 나눈 귀족의 작위 가운데 셋째 작위");
            	$stopsmoking->group07 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group07,"후작","18일, 다섯 등급으로 나눈 귀족의 작위 가운데 둘째 작위");
            	$stopsmoking->group08 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group08,"공작","23일, 다섯 등급으로 나눈 귀족의 작위 가운데 첫째 작위");
            	$stopsmoking->group09 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group09,"후왕","30일, 한 나라의 왕");
            	$stopsmoking->group10 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group10,"지존","60일, 임금을 높여 이르는 말");
            	$stopsmoking->group11 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group11,"대왕","100일, 훌륭하고 뛰어난 임금");
            	$stopsmoking->group12 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group12,"황제","180일, 왕이나 제후를 거느리고 나라를 통치하는 임금");
            	$stopsmoking->group13 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group13,"영웅","360일, 지혜와 재능이 뛰어나고 용맹하여 보통 사람이 하기 어려운 일을 해내는 사람");
            	$stopsmoking->group14 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group14,"초인","1825일, 보통 사람으로는 생각할 수 없을 만큼 뛰어난 능력을 가진 사람");
            	$stopsmoking->group15 = getNextSequence();
            	$output = $this->insertGroup($stopsmoking->group15,"신선","3650일, 흡연의 인간 세계를 떠나 자연과 벗하며 산다는 사람. 세속적인 상식에 구애되지 않고, 고통이나 질병도 없으며 죽지 않는다고 한다.");
                $stopsmoking->mid = $args->mid;
                
				// 데이터입력(테이블: module_config)
            	$oModuleController->insertModuleConfig('stopsmoking', $stopsmoking);
            }
            
			return new Object();
        }
		
        /**
         * 모듈이 업데이트되었는지 검사
         * 
         * @return unknown_type
         */
        function checkUpdate() {
            return false;
        }
		
        /**
         * 모듈이 업데이트시 할 일
         * 
         * @return unknown_type
         */
        function moduleUpdate() {
            return new Object(0, 'success_updated');
        }
		
        /**
         * 캐쉬파일 재생성 버튼 클릭시 해야할 일
         * 
         * @return unknown_type
         */
        function recompileCache() {
        }
        
        /**
         * 금연모듈에서 사용할 그룹을 입력한다.
         * 
         * @param $title
         * @param $description
         * @return unknown_type
         */
        function insertGroup($group_srl,$title,$description){
        	$oMemberAdminController = &getAdminController('member');
        	$site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
			$args->group_srl = $group_srl;
			$args->title = $title;
			$args->description = $description;
			$args->is_default = "N";
			$args->is_admin = "N";
			$output = $oMemberAdminController->insertGroup($args);
			return $output;
        }
    }
?>
