<?php
    /**
     * 사용자 화면정의
     * 
     * @class  stopsmokingModel
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking 모듈의 View class
     **/

    class stopsmokingView extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {
        	// 모듈정보를 가져온다.
            $oStopsmokingModel = &getModel('stopsmoking');
            $this->module_info = $oStopsmokingModel->getModulesInfo();
            Context::set('module_info',$this->module_info);
         
        	// 스킨 경로를 미리 template_path 라는 변수로 설정함 스킨이 존재하지 않는다면 기본 설정의 스킨으로 설정
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);  	            
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = "default";
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);
        }
        
        /**
         * 결심등록 화면 
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingDecisionWrite
         * @return unknown_type
         */
        function dispStopsmokingDecisionWrite(){
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			// 로그인체크
			if($this->logged_info){
				// 결심이 등록되어 있는지 검사하자.
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            // 관리자가 아니면...
	            if($member_info->is_admin !='Y'){
	            	$args->member_srl = $member_info->member_srl;
	            }
				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$decision = $oStopsmokingModel->getDecision($args);

            	// 금연결심이 있다면
            	if($decision->data==null){
            		// 템플릿 지정 - 생성
	            	$this->setTemplateFile('decision_input');
            	} else {
            		return $this->stop('msg_have_decision');
            	}
	            
			} else {
				return $this->stop('msg_not_logged');
			}
        }
		
    	/**
         * 결심수정 화면 
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingDecisionEdit
         * @return unknown_type
         */
        function dispStopsmokingDecisionEdit(){
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			
			// 로그인체크
			if($this->logged_info){
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            $args->member_srl = $member_info->member_srl;

				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$output = $oStopsmokingModel->getDecision($args);
            	Context::set('decision', $output->data);
            	
	            // 템플릿 지정 - 생성
	            $this->setTemplateFile('decision_input');
			} else {
				return $this->stop('msg_not_logged');
			}
        }
        
        /**
         * 금연시계를 보여준다.
         * 접속주소: /?module=stopsmoking&act=dispStopsmokingTimer
         * @return unknown_type
         */
        function dispStopsmokingTimer(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			
			// 로그인체크
			if($this->logged_info){
				// site_srl, module_srl, member_srl값을 가져온다.
	            $site_module_info = Context::get('site_module_info');
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $module_info = Context::get('module_info');	            
				$args->module_srl = $module_info->module_srl;
	            $member_info = Context::get('logged_info');
	            // 관리자가 아니면...
	            if($member_info->is_admin !='Y'){
	            	$args->member_srl = $member_info->member_srl;
	            }
				// 금연결심을 가져온다.
				$oStopsmokingModel = &getModel('stopsmoking');
            	$decision = $oStopsmokingModel->getDecision($args);

            	// 금연결심이 있다면
            	if($decision->data!=null){
            		// 금연일수를 계산한다.
	            	$passTime = date('YmdHis') - $decision->data->start_date;
	            	$standardDateTime = date('Y-m-d H:i:s');
					$comparisonDateTime = zdate($decision->data->start_date,"Y-m-d H:i:s");
					$timer = $oStopsmokingModel->getDiffDateTime($standardDateTime,$comparisonDateTime);
			
					// 그룹정보를 가져온다.
					$timer->group = $this->getGroup($timer);
				
					// 참은담배갯수를 계산한다.
					$timer->stop_cigarette_count = $this->getStopCigaretteCount($decision->data, $timer);
					// 그동안 사용한 담배값을 구한다.
					$timer->spend_money = $this->getSpendMoney($decision->data, $timer);
					// 번돈을 구한다.
					$timer->earn_money = $this->getEarnMoney($decision->data, $timer);
					// 연장된생명을 구한다.
					$timer->save_life = $this->getSaveLife($decision->data, $timer);			
					// 금연시작일
					$timer->start_date = $decision->data->start_date;
					// 금연결심
	            	$timer->decision = $decision->data->decision;
					
	            	Context::set('timer', $timer);
	            	
		            // 템플릿 지정 - 생성
		            $this->setTemplateFile('timer');
            	} else {
            		// 템플릿 지정 - 생성
		            $this->setTemplateFile('decision_input');
            	}
            	
			} else {
				return $this->stop('msg_not_logged');
			}
        }
        
        /**
         * 참은 담배갯수를 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getStopCigaretteCount($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		$result = floor($count * $timer->diffTimestampAbs);
        	} else {
        		$result = 0;
        	}
        	return $result;
        }
        
    	/**
         * 그동안 사용한 담배값을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getSpendMoney($decision, $timer){
        	// 초당 소비하는 담배개수를 구한다.
        	$count = $decision->cigarette_count/86400;
        	// 개당가격을 구한다.
        	$price = $decision->cigarette_price/$decision->cigarette_count;
        	$result = floor($count * ($decision->day_count * 86400) * $price);
        	return $result;
        }
        
        /**
         * 번돈을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getEarnMoney($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		// 개당가격을 구한다.
        		$price = $decision->cigarette_price/$decision->cigarette_count;
        		$result = floor($count * $timer->diffTimestampAbs * $price);
        	} else {
        		$result = 0;
        	}
        	return $result;
        }
        
   	 	/**
         * 연장된생명을 구한다.
         * @param $decision
         * @param $timer
         * @return unknown_type
         */
        function getSaveLife($decision, $timer){
        	if($timer->diffSign=='plus'){
        		// 초당 소비하는 담배개수를 구한다.
        		$count = $decision->cigarette_count/86400;
        		// 1개비당 5분(300초)
        		$totalSecond = floor($count * $timer->diffTimestampAbs) * 300;
	        	$saveDate = floor($totalSecond/86400);
	        	$saveRestTime = $totalSecond % 86400;
				$saveHour = floor($saveRestTime / 3600);			
				$saveMinute = floor($saveRestTime % 3600 / 60);
				$saveSecond = floor($saveRestTime % 3600 % 60);
        	} 
			$result->saveDate = $saveDate;
			$result->saveHour = $saveHour;
			$result->saveMinute = $saveMinute;
			$result->saveSecond = $saveSecond;
        	return $result;
        }
        
        /**
         * 타이머를 기준으로 그룹정보를 가져온다.
         * 
         * @param $timer
         * @return unknown_type
         */
        function getGroup($timer){
        	$oMemberModel = &getModel('member');
            	
        	$this->module_info = Context::get('module_info');
        	$group_srl = "";
        	if($timer->diffSign=="plus"){
	        	// 15단계: 3650일
				if($timer->diffTimestampAbs>86400*3650){
					$group_srl = $this->module_info->group15;
				// 14단계: 1825일
				} else if($timer->diffTimestampAbs>86400*1825){
					$group_srl = $this->module_info->group14;
				// 13단계: 360일
				} else if($timer->diffTimestampAbs>86400*360){
					$group_srl = $this->module_info->group13;
				// 12단계: 180일
				} else if($timer->diffTimestampAbs>86400*180){
					$group_srl = $this->module_info->group12;
				// 11단계: 100일
				} else if($timer->diffTimestampAbs>86400*100){
					$group_srl = $this->module_info->group11;
				// 10단계: 60일
				} else if($timer->diffTimestampAbs>86400*60){
					$group_srl = $this->module_info->group10;
				// 09단계: 30일
				} else if($timer->diffTimestampAbs>86400*30){
					$group_srl = $this->module_info->group09;
				// 08단계: 21일
				} else if($timer->diffTimestampAbs>86400*21){
					$group_srl = $this->module_info->group08;
				// 07단계: 18일
				} else if($timer->diffTimestampAbs>86400*18){
					$group_srl = $this->module_info->group07;
				// 06단계: 14일
				} else if($timer->diffTimestampAbs>86400*14){
					$group_srl = $this->module_info->group06;
				// 05단계: 10일
				} else if($timer->diffTimestampAbs>86400*10){
					$group_srl = $this->module_info->group05;
				// 04단계: 7일
				} else if($timer->diffTimestampAbs>86400*7){
					$group_srl = $this->module_info->group04;
				// 03단계: 3일
				} else if($timer->diffTimestampAbs>86400*3){
					$group_srl = $this->module_info->group03;
				// 02단계: 1일
				} else if($timer->diffTimestampAbs>86400){
					$group_srl = $this->module_info->group02;	
				} 
			// 01단계: 0일
        	} else {
				$group_srl = $this->module_info->group01;
			}
			debugPrint($group_srl);
			$output = $oMemberModel->getGroup($group_srl);
			debugPrint($output);
			return $output;
        }

    }
?>