<?php
    /**
     * 사용자 업무 처리
     * 
     * @class  stopsmokingController
     * @author jedison (master@xgenesis.org)
     * @brief  stopsmoking 모듈의 controller class
     **/

    class stopsmokingController extends stopsmoking {

        /**
         * @brief 초기화
         **/
        function init() {
			// 모듈정보를 가져온다.
            $oStopsmokingModel = &getModel('stopsmoking');
            $this->module_info = $oStopsmokingModel->getModulesInfo();
            Context::set('module_info',$this->module_info);          
        }
        
        /**
         * 금연결심등록처리
         * @return unknown_type
         */
        function procStopsmokingDecisionInsert(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
            // 등록할 값 설정
            $args->decision_srl = getNextSequence();					// 일련번호
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = Context::get('module_info');
debugPrint($module_info);
			$args->module_srl = $module_info->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;
			
            // 날짜조합
            $args->start_date = $args->start_date.$args->start_hour.$args->start_minute.$args->start_second;
            
            // stopsmoking_decision 테이블에 등록
            $oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->insertDecision($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('msg_success_decision_insert');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('decision_srl', $args->decision_srl);
        }
        
    	/**
         * 금연결심수정처리
         * @return unknown_type
         */
        function procStopsmokingDecisionUpdate(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
            // 등록할 값 설정
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = Context::get('module_info');	            
			$args->module_srl = $module_info->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;
            
			// 날짜조합
            $args->start_date = $args->start_date.$args->start_hour.$args->start_minute.$args->start_second;
            
            // stopsmoking_decision 테이블 수정
            $oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->updateDecision($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('msg_success_decision_update');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('decision_srl', $args->decision_srl);
        }
        
        /**
         * 금연결심초기화처리
         * @return unknown_type
         */
        function procStopsmokingDecisionInit(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
            $args->history_srl = getNextSequence();					// 일련번호
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = Context::get('module_info');	            
			$args->module_srl = $module_info->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;
			
            // 금연결심을 가져온다.
			$oStopsmokingModel = &getModel('stopsmoking');
            $output = $oStopsmokingModel->getDecision($args);
			
            $args->decision_srl = $output->data->decision_srl;
			$args->cigarette_count = $output->data->cigarette_count;
			$args->cigarette_price = $output->data->cigarette_price;
			$args->cost_etc = $output->data->cost_etc;
			$args->day_count = $output->data->day_count;
			$args->decision = $output->data->decision;
			$args->start_date = $output->data->start_date;

			// stopsmoking_history 입력
            $output = $oStopsmokingModel->insertHistory($args);

            // stopsmoking_decision 삭제
			$output = $oStopsmokingModel->deleteDecision($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('msg_success_init_stopsmoking');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('decision_srl', $args->decision_srl);
        }
    }

?>