/**
 * Code component
 * @author taggon(gonom9@gmail.com)
 */
jQuery(function($){

var keytime = 0;
var tab  = '    ';
var _id   = 1;
var _codes = {};

var editor = xe.getApp('DrEditor')[0];
var code = xe.createPlugin('CODE', {
	configs : {},
	init : function() {
		this.configs = {};
	},
	create : function(seq) {
		var self    = this;
		var config  = editor.getConfig(seq);
		var _editor = config.writeArea.children('div.wArea.code:first');
		var _textarea = _editor.find('textarea');
		var _codetype = _editor.find('select');
		var _set_default = _editor.find('.codetype button');

		this.cast('ADD_DEFAULT_EDITOR_ACTION', [seq, _editor, 'CODE']);

		this.configs[seq] = {
			editor   : _editor,
			textarea : _textarea,
			codetype : _codetype,
			set_default : _set_default
		};

		var event_data = {config:this.configs[seq], self:this};
		_editor.find('div.resizeVertical').bind('mousedown', event_data, this.ondragstart);
		_textarea.bind('keydown', event_data, this.onkeydown);
		_set_default.click(function(){
			$.cookie(
				'code_default_type',
				_codetype.find('>:selected').text(),
				{expires : 7, path : '/'}
			);
			alert(xe.lang.code_make_default2.replace('%s', _codetype.find('>:selected').text()));
		});

		return this.configs[seq];
	},
	get_pos : function(obj, type) {
		var n_before, n_after;

		if (typeof obj[0].selectionStart == 'number') {
			n_before = obj[0].selectionStart;
			n_after  = obj[0].selectionEnd;
		} else if(document.selection) {
			var before = document.selection.createRange().duplicate();
			var after  = document.selection.createRange().duplicate();
			var range  = document.body.createTextRange();

			range.moveToElementText(obj[0]);

			before.collapse(true);
			before.setEndPoint('EndToEnd', range);
			n_before = obj.val().length - before.text.replace(/\r/g,'').length;
			
			after.collapse(false);
			after.setEndPoint('EndToEnd', range);
			n_after = obj.val().length - after.text.replace(/\r/g,'').length;
		}

		if (n_before == n_after || type == 'start') return n_before;
		else if (type == 'end') return n_after;
	},
	set_pos : function(obj, start, end) {
		if (typeof obj[0].setSelectionRange == 'function') {
			obj[0].setSelectionRange(start, end);
		} else if(obj[0].createTextRange) {
			var range = obj[0].createTextRange();

			range.moveStart('character', start);
			range.collapse(true);
			range.moveEnd('character', end-start);
			range.select();
		}
	},
	count : function(text, find) {
		var count = -1, pos = -1;
		do {
			count++;
			text = text.substr(pos+1);
			pos = text.indexOf(find);
		} while(pos >= 0);

		return count;
	},
	onkeydown  : function(event) {
		var ESC = 27, ENTER = 13, SHIFT = 16, CTRL = 17, TAB = 9;
		var key = event.keyCode;

		if (key == CTRL || key == SHIFT) {
			if (event.ctrlKey && event.shiftKey) {
				event.data.config.editor.find('button').eq(2).focus();
				return false;
			}
		}

		if (key != TAB || event.ctrlKey || event.altKey || event.metaKey) return;

		var obj  = $(event.target);
		var self = event.data.self;
		var pos  = {start:self.get_pos(obj, 'start'), end:self.get_pos(obj, 'end')};
		var text = obj.val();
		var seltext, n_ln1, n_ln2, new_start, new_end, len_before, len_after;

		n_ln1 = text.substr(0, pos.start).lastIndexOf('\n');
		n_ln2 = text.substr(pos.end).indexOf('\n');

		if (pos.start != pos.end) {
			new_start = (n_ln1<0)?0:n_ln1+1;
			new_end = (n_ln2<0)?text.length:pos.end+n_ln2;

			seltext = text.substring(new_start, new_end);
			len_before = seltext.length;

			if (event.shiftKey) {
				seltext   = seltext.replace(/(^|\n)(\t| {1,4})/g, '$1');
				len_after = seltext.length;

				obj.val( text.substr(0, new_start) + seltext + text.substr(new_end) );
				self.set_pos(obj, new_start, new_end-(len_before-len_after));
			} else {
				seltext   = seltext.replace(/(^|\n)/g, '$1'+tab);
				len_after = seltext.length;

				obj.val( text.substr(0, new_start) + seltext + text.substr(new_end) );
				self.set_pos(obj, new_start, new_end+(len_after-len_before));
			}
		} else {
			if (event.shiftKey) {
				new_start = Math.max(pos.start - tab.length, n_ln1);
			} else {
				new_start = pos.start + tab.length;
				obj.val(text.substr(0, pos.start) + tab + text.substr(pos.start));
			}
			self.set_pos(obj, new_start, new_start);
		}

		event.keyCode = 0;

		return false;
	},
	ondragstart : function(event) {
		var cfg = event.data.config;

		cfg.start_y = event.pageY;
		cfg.start_h = parseInt(cfg.textarea.css('height'));

		$(document)
			.bind('mousemove', event.data, event.data.self.ondrag)
			.bind('mousedown', event.data, event.data.self.ondragstop)
			.bind('mouseup',   event.data, event.data.self.ondragstop);

		return false;
	},
	ondrag : function(event) {
		var cfg  = event.data.config;
		var diff = event.pageY - cfg.start_y;

		if (cfg.start_h+diff > 50) cfg.textarea.css('height', (cfg.start_h+diff)+'px');

		return false;
	},
	ondragstop : function(event) {
		var cfg  = event.data.config;

		// unbind events
		$(document)
			.unbind('mousemove', event.data.self.ondrag)
			.unbind('mousedown', event.data.self.ondragstop)
			.unbind('mouseup',   event.data.self.ondragstop);

		return false;
	},
	API_SETTING_CONTENT : function(sender, params) {
		var self = this;
		var seq  = params[0];
		var obj  = params[1];

		obj.children('div[editor_component=code_highlighter]').each(function(){
			var t = $(this);
			var code = t.html();
			var type = t.attr('code_type');
			var id   = 'code'+(_id++);

			code = code.replace(/<(br)\s*\/?>\r?\n?|&([lg]t|nbsp|amp);/ig, function(m0,m1,m2){
				if (m1 && m1.toLowerCase() == 'br') return '\n';
				return ({'lt':'<','gt':'>','nbsp':' ','amp':'&'})[m2];
			});
			_codes[id] = code;

			t.attr({
				'class': 'eArea _code',
				'type' : 'code',
				'id'   : id
			}).empty();

			var pre = $('<pre name="code" class="brush:'+type+';" />').text(code).appendTo(t);
		});
	},
	API_GETTING_CONTENT : function(sender, params) {
		var seq = params[0];
		var obj = params[1];

		obj.children('div._code')
			.removeAttr('type')
			.attr('class', 'code')
			.each(function(){
				var t    = $(this);
				var id   = t.attr('id');
				var code = _codes[id] || '';

				code = code.replace(/[&<> \n]/g, function(m0){ return ({'&':'&amp;','<':'&lt;','>':'&gt;',' ':'&nbsp;','\n':'<br />\n'})[m0] });
				t.html(code).removeAttr('id');
			});
	},
	API_AFTER_SET_CONTENT : function(sender, params) {
		var seq = params[0];
		var txt = params[1];

		if (txt.indexOf('code') > 0) {
			SyntaxHighlighter.highlight('code');
		}
	},
	API_OPEN_CODE_EDITOR : function(sender, params) {
		var seq = params[0];
		var box = params[1];
		var bef = params[2];
		var cfg = this.configs[seq];

		if (!cfg) cfg = this.create(seq);

		this.cast('RESET_EDITOR', [seq, cfg.editor, 'CODE']);

		if (box) {
			var id   = box.attr('id');
			var code = _codes[id] || '';
			var type = box.attr('code_type');
			
			cfg.codetype.val(type);
			cfg.textarea.val(code);
			if (cfg.codetype[0].selectedIndex < 0) cfg.codetype[0].selectedIndex = 0;

			box.hide().after(cfg.editor);
		} else if (bef) {
			$(bef).after(cfg.editor);
		} else {
			cfg.editor.appendTo(editor.getConfig(seq).editArea);
		}
		cfg.editor.show().find('textarea:first').focus();
		this.cast('SCROLL_INTO_VIEW', [seq, cfg.editor]);
	},
	API_CLOSE_CODE_EDITOR : function(sender, params) {
		var self = this;
		var seq  = params[0];
		var save = params[1];
		var cfg  = this.configs[seq];
		var code = $.trim(cfg.textarea.val());
		var box  = cfg.editor.prev('div._code:hidden');
	
		if (save && code) {
			var newBox = $('<div />');
			var id     = 'code'+(_id++);
			var type   = cfg.codetype.val();

			_codes[id] = (code = code.replace(/\t/g, tab));
			newBox.attr({id:id, editor_component:'code_highlighter', code_type : type});
			$('<pre name="code" class="brush:'+type+';" />').text(code).appendTo(newBox);

			if (box.length) {
				try { _codes[box.attr('id')] = ''; } catch(e) {};
				box.remove();
			}

			box = newBox;
			this.cast('SAVE_PARAGRAPH', [seq, cfg.editor, box, 'CODE']);
		}

		box.show();

		cfg.editor.hide().appendTo(editor.getConfig(seq).writeArea);
		if(!box.length) box = cfg.editor.prev('div.eArea');
		this.cast('SELECT_PARAGRAPH', [seq, box, box, box]);

		if (save && code) {
			// highlight the code
			SyntaxHighlighter.highlight('code');
		}
	},
	API_AFTER_RESET_EDITOR : function(sender, params) {
		var seq  = params[0];
		var type = params[2];
		var cfg  = this.configs[seq];

		if (type == 'code') {
			cfg.textarea.css({height:'200px'});
			var default_type = $.cookie('code_default_type');

			if (default_type) {
				cfg.codetype.find('>:contains('+default_type+')').attr('selected', 'selected');
				if (cfg.codetype[0].selectedIndex < 0) cfg.codetype[0].selectedIndex = 0;
			} else {
				cfg.codetype[0].selectedIndex = 0;
			}
		}
	}
});
editor.registerPlugin(new code);

});