/**
 * @Jowrney 저니 로그맵 출력용 
 **/

function displayJowrneyLogmap(src, width, height, options) {
	if(src.indexOf('files') == 0) src = request_uri + src;
	
	jQuery(document).ready(function (){

		jQuery("#jowrneyLogmapContainer").css("width", width+"px");
		jQuery("#jowrneyLogmapContainer").css("height", height+"px");

		var map_type;
		if(options.type == 'satellite') 	map_type = google.maps.MapTypeId.SATELLITE;
	    else if(options.type == 'hybrid') 	map_type = google.maps.MapTypeId.HYBRID;
		else if(options.type == 'physical') map_type = google.maps.MapTypeId.TERRAIN;
		else 								map_type = google.maps.MapTypeId.ROADMAP;

		var myOptions = {
			zoom: 8,
			mapTypeId: map_type
		};

		var map = new google.maps.Map(document.getElementById("jowrneyLogmapContainer"), myOptions);
		var georssLayer = new google.maps.KmlLayer(src+'?'+Math.random());
		georssLayer.setMap(map);   
	});

}

