<?php
    /**
     * @class  jowrney_logmap
     * @author Jowrney (jowrney@jowrney.com)
     * 본문에 저니 로그맵 컴포넌트 삽입
     **/

    class jowrney_logmap extends EditorHandler { 

        // upload_target_srl 는 에디터에서 필수로 달고 다녀야 함....
        var $upload_target_srl = 0;
        var $component_path = '';

        // 구글맵 openapi 키 값
        var $api_key = '';

        /**
         * upload_target_srl과 컴포넌트의 경로를 받음
         **/
        function jowrney_logmap($upload_target_srl, $component_path) {
            $this->upload_target_srl = $upload_target_srl;
            $this->component_path = $component_path;
            Context::loadLang($component_path.'lang');
        }

        /**
         * popup window요청시 popup window에 출력할 내용을 추가하면 된다
         **/
        function getPopupContent() {
            // 템플릿을 미리 컴파일해서 컴파일된 소스를 return
            $tpl_path = $this->component_path.'tpl';

            if(!$this->api_key) $tpl_file = 'error.html';
            else $tpl_file = 'popup.html';

            Context::set("tpl_path", $tpl_path);

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }


        /**
         * 에디터 컴포넌트가 별도의 고유 코드를 이용한다면 그 코드를 html로 변경하여 주는 method
         *
         * 이미지나 멀티미디어, 설문등 고유 코드가 필요한 에디터 컴포넌트는 고유코드를 내용에 추가하고 나서
         * DocumentModule::transContent() 에서 해당 컴포넌트의 transHtml() method를 호출하여 고유코드를 html로 변경
         **/
        function transHTML($xml_obj) {
            $src = $xml_obj->attrs->logmap_path;
			$title = $xml_obj->attrs->title;
			$date = $xml_obj->attrs->date;
            $style = $xml_obj->attrs->style;

            preg_match_all('/(width|height)([^[:digit:]]+)([0-9]+)/i',$style,$matches);
            $width = trim($matches[3][0]);
            $height = trim($matches[3][1]);
            if(!$width) $width = 660;
            if(!$height) $height = 500;

            $type = $xml_obj->attrs->logmap_type;
            if($type == 'satellite') $type = 'satellite';
            elseif($type == 'hybrid') $type = 'hybrid';
			elseif($type == 'physical') $type = 'physical';
            else $type = 'normal';

            $src = str_replace(array('&','"'), array('&amp;','&qout;'), $src);
            $src = str_replace('&amp;amp;', '&amp;', $src);

			//In Javascirpt : displayMultimedia(src, width, height, options)
            if(Context::getResponseMethod() != "XMLRPC") return sprintf("
            <script type=\"text/javascript\" src=\"%s\"></script><script type=\"text/javascript\">displayJowrneyLogmap(\"%s\", \"%s\",\"%s\", { \"key\" : \"%s\",\"title\" : \"%s\", \"date\" : \"%s\",\"type\" : \"%s\",  \"component_path\" : \"%s\" });</script>",Context::getRequestUri().'modules/editor/components/jowrney_logmap/jowrney_logmap.js',$src, $width, $height, $this->api_key, $title, $date, $type, $this->component_path);
            else return sprintf("<div style=\"width: %dpx; height: %dpx;\"><span style=\"position:relative; top:%dpx;left:%d\"><img src=\"%s\" /><br />Attached JowrneyLogmap</span></div>", $width, $height, ($height/2-16), ($width/2-31), Context::getRequestUri().'./modules/editor/components/jowrney_logmap/tpl/jowrney_logmap_component.gif');
        }
    }
?>
