/**
 * IFrame component
 * @author taggon(gonom9@gmail.com)
 */
jQuery(function($){

var editor = xe.getApp('DrEditor')[0];
var regex_url = /^http:\/\/\w+[\w\.]*\w+/;
var IFrame = xe.createPlugin('IFrame', {
	configs : {},
	init : function() {
		this.configs = {};
	},
	create : function(seq) {
		var self    = this;
		var config  = editor.getConfig(seq);
		var _editor = config.writeArea.children('div.wArea.iframe:first');
		var _inputs = _editor.find('input[type=text]');
		var _url    = _inputs.eq(0);
		var _desc   = _inputs.eq(1);
		var _iframe = _editor.find('iframe:first');

		this.cast('ADD_DEFAULT_EDITOR_ACTION', [seq, _editor, 'IFRAME']);

		_iframe.attr('allowtransparency', true);
		_url.blur(function(){
			if(regex_url.test(this.value) && _iframe.attr('src') != this.value) {
				_iframe.attr('src', this.value);
			}
		});

		this.configs[seq] = {
			editor  : _editor,
			url     : _url,
			desc    : _desc,
			iframe  : _iframe,
			helper  : _iframe.next('div.helper'),
			start_y : 0,
			start_h : 0
		};

		_editor.find('div.resizeVertical').bind('mousedown', {config:this.configs[seq], self:this}, this.ondragstart);

		return this.configs[seq];
	},
	ondragstart : function(event) {
		var cfg = event.data.config;

		cfg.start_y = event.pageY;
		cfg.start_h = parseInt(cfg.iframe.css('height'));
		cfg.helper.show().css('height', cfg.start_h+'px');
		cfg.iframe.hide();

		$(document)
			.bind('mousemove', event.data, event.data.self.ondrag)
			.bind('mousedown', event.data, event.data.self.ondragstop)
			.bind('mouseup',   event.data, event.data.self.ondragstop);


		return false;
	},
	ondrag : function(event) {
		var cfg  = event.data.config;
		var diff = event.pageY - cfg.start_y;

		if (cfg.start_h+diff > 50) cfg.helper.css('height', (cfg.start_h+diff)+'px');

		return false;
	},
	ondragstop : function(event) {
		var cfg  = event.data.config;

		cfg.iframe.show().css('height', cfg.helper.css('height'));
		cfg.helper.hide();

		// unbind events
		$(document)
			.unbind('mousemove', event.data.self.ondrag)
			.unbind('mousedown', event.data.self.ondragstop)
			.unbind('mouseup',   event.data.self.ondragstop);

		return false;
	},
	API_SETTING_CONTENT : function(sender, params) {
		var self = this;
		var seq  = params[0];
		var obj  = params[1];

		obj.children('div.iframe,iframe').each(function(){
			var t = $(this);
			if (!t.is('div')) t = t.wrap('<div />').parent();
			t.attr('class', 'eArea _iframe').attr('type', 'iframe');
		});
	},
	API_GETTING_CONTENT : function(sender, params) {
		var seq = params[0];
		var obj = params[1];
		var chd = obj.children('div._iframe');

		obj.children('div._iframe').each(function(){
			$(this).attr('class', 'iframe').removeAttr('type');
		});
	},
	API_OPEN_IFRAME_EDITOR : function(sender, params) {
		var seq = params[0];
		var box = params[1];
		var bef = params[2];
		var cfg = this.configs[seq];

		if (!cfg) cfg = this.create(seq);

		this.cast('RESET_EDITOR', [seq, cfg.editor, 'IFRAME']);

		if (box) {
			var ifr = box.find('iframe');
			var src = ifr.attr('src');

			cfg.iframe.attr('src', src).css('height', ifr.css('height'));
			cfg.url.val(src);
			cfg.desc.val( box.children('span').html() );
			box.hide().after(cfg.editor);
		} else if (bef) {
			$(bef).after(cfg.editor);
		} else {
			cfg.editor.appendTo(editor.getConfig(seq).editArea);
		}
		cfg.editor.show().find('input[type=text]:first').focus();
		this.cast('SCROLL_INTO_VIEW', [seq, cfg.editor]);
	},
	API_CLOSE_IFRAME_EDITOR : function(sender, params) {
		var self = this;
		var seq  = params[0];
		var save = params[1];
		var cfg  = this.configs[seq];
		var url  = $.trim(cfg.url.val());
		var box  = cfg.editor.prev('div._iframe:hidden');
	
		if (save && url && regex_url.test(url)) {
			var iframe;
			var desc = $.trim(cfg.desc.val());
			if (desc == cfg.desc.attr('title')) desc = '';

			if (box.length) {
				iframe = box.children('iframe:first');
			} else {
				box = (iframe = $('<iframe frameborder="0" width="100%" style="display:block" />')).wrap('<div />').parent();
				if (desc) box.append('<span />');
			}

			iframe.attr('src', url).attr('title', desc.replace(/<[^>]+>/g, ''));
			if (desc) box.children('span').html(editor.translate_cite(desc));
			else box.children('span').remove();

			iframe.css('height', cfg.iframe.css('height'));

			this.cast('SAVE_PARAGRAPH', [seq, cfg.editor, box, 'IFRAME']);
		}

		box.show();

		cfg.editor.hide().appendTo(editor.getConfig(seq).writeArea);
		if(!box.length) box = cfg.editor.prev('div.eArea');
		this.cast('SELECT_PARAGRAPH', [seq, box, box, box]);
	},
	API_BEFORE_RESET_EDITOR : function(sender, params) {
		var seq  = params[0];
		var type = params[2];
		var cfg  = this.configs[seq];

		if (type == 'IFRAME') {
			cfg.iframe.parent().css('text-align','center');
			cfg.iframe.attr('src', 'about:blank').css({height:'200px'});
		}
	}
});
editor.registerPlugin(new IFrame);

});