var WebClock = function(){
	this.drawTarget = "webClock";
	
	// 
	this.color = "#fff"; //ڻ
	this.backgroundColor = "#000"; //
	this.align = "center"; //(left, center, right)
	this.fontType = "Century Gothic"; //۲
	this.fontSize = 42; //ð ۲ũ(: am,pm   1/2)
	
	this.clockBarHeight = 2; //ʺκ BAR β
	this.clockBarColor = "#ccc"; //ʺκ 
	
	this.calendarFontSize = 15; //޷ºκ ۲ũ
	// 
	this.strMonth = ["January",
					"February",
					"March",
					"April",
					"May",
					"June",
					"July",
					"August",
					"September",
					"October",
					"November",
					"December"];
	this.strWeek =  ["Sun",
					"Mon",
					"Tue",
					"Wed",
					"Thu",
					"Fri",
					"Sat"];
	
	this.start = function(){
		var now = new Date();
		var year = now.getFullYear();
		var month = now.getMonth();
		var day = now.getDate();
		var hours = now.getHours();
		var minutes = now.getMinutes();
		var seconds = now.getSeconds();
		var clockBarWidth = 2 * seconds;
		var strAmPm = hours < 12 ? "AM" : "PM";
		
		hours = hours > 12 ? hours - 12 : hours;
		hours = hours == 0 ? hours + 12 : hours;
		hours = hours < 10 ? "0" + hours : hours;
		minutes = minutes < 10 ? "0" + minutes : minutes;
		seconds = seconds < 10 ? "0" + seconds : seconds;
		
		this.layerCalendar.innerHTML = year + " " + this.strMonth[month] + " " + day + " " + this.strWeek[now.getDay()];
		this.layerTime.innerHTML = hours + ":" + minutes + ":" + seconds;
		this.layerAmPm.innerHTML = strAmPm;
		
		this.layerClockBar.style.width = clockBarWidth + "px";
		setTimeout(function(){oWebClock.start();}, 1000);
	};
	
	this.init = function(){
		this.layerTime = document.createElement("span");
		this.layerAmPm = document.createElement("span");
		this.layerAmPm.style.fontSize = "0.5em";
		
		this.layerCalendar = document.createElement("div");
		this.layerCalendar.style.fontWeight = "bold";
		this.layerCalendar.style.fontSize = this.calendarFontSize + "px";
		
		this.layerClock = document.createElement("div");
		
		this.layerClockBar = document.createElement("div");
		this.layerClockBar.style.fontSize = this.clockBarHeight + "px";
		this.layerClockBar.style.height = this.clockBarHeight + "px";
		this.layerClockBar.style.background = this.clockBarColor;
		
		var layerTarget = document.getElementById(this.drawTarget);
		layerTarget.style.color = this.color;
		layerTarget.style.background = this.backgroundColor;
		layerTarget.style.fontFamily = this.fontType;
		layerTarget.style.fontSize = this.fontSize + "px";
		layerTarget.style.padding = "10px";
		layerTarget.align = this.align;
		layerTarget.appendChild(this.layerClock);
		layerTarget.appendChild(this.layerClockBar);
		layerTarget.appendChild(this.layerCalendar);
		
		this.layerClock.appendChild(this.layerTime);
		this.layerClock.appendChild(this.layerAmPm);
		this.start();
	};
};
var oWebClock = new WebClock();
if(document.all){
	window.attachEvent("onload", function(){oWebClock.init();});
}else{
	window.addEventListener("load", function(){oWebClock.init();}, false);
};