<?php
/**
 * @class MinionInXE (http://www.minion.kr)
 * @author 알쯔 (arzz@arzz.com)
 * @version 1.0
 * @brief 미니온을 XE에 쉽게 연동할 수 있도록 도와주는 위젯입니다.
 **/

class MinionInXE extends WidgetHandler {
	function proc($args) {
		$tpl_path = sprintf('%sskins/%s',$this->widget_path,$args->skin);
		$tpl_file = 'minion.html';

		$code = $args->minioncode;
		$key = $args->minionkey;
		$admin = $args->minionadmin;
		$nick = $args->minionnick;
		$setLvicon = $args->minionlvicon;
		$setNickmark = $args->minionnickmark;
		$setNickcon = $args->minionnickcon;
		$setGroupmark = $args->miniongroupmark;
		$width = isset($args->minionwidth) == true ? $args->minionwidth : '.100';
		$height = isset($args->minionheight) == true ? $args->minionheight : '450';
		$thema = $args->minionthema;
		$type = $args->miniontype;
		$viewmsg = $args->minionviewmsg;
		$userview = $args->minionuserview;

		$width = ereg('\.',$width) == true ? str_replace('.','',$width).'%' : $width;
		$height = ereg('\.',$height) == true ? str_replace('.','',$height).'%' : $height;

		if (isset($code) == false || isset($key) == false) return '미니온코드와 채널키를 설정하신 후 다시 위젯코드를 생성하여 주십시오.';

		$nickname = '';
		$nickcon = '';
		$is_admin = false;

		if (Context::get('is_logged')) {
			$oModuleModel = &getModel('module');
			$logged = Context::get('logged_info');

			if ($nick == '1') {
				$nickname = $logged->nick_name;
			} elseif ($nick == '2') {
				$nickname = $logged->user_id;
			} elseif ($nick == '3') {
				$nickname = $logged->nick_name.'('.$logged->user_id.')';
			} elseif ($nick == '4') {
				$nickname = $logged->user_name;
			} elseif ($nick == '5') {
				$nickname = $logged->user_name.'('.$logged->user_id.')';
			}

			if ($logged->is_admin == 'Y' || in_array($logged->user_id,split(',',$admin)) == true) {
				$is_admin = true;
			}

			if ($setLvicon == '1') {
				$oModuleModel = &getModel('module');
				$pointConfig = $oModuleModel->getModuleConfig('point');
				$pointModel = getModel('point');

				$level = $pointModel->getLevel($pointModel->getPoint($logged->member_srl),$pointConfig->level_step);
				$nickcon = Context::getRequestUri().'modules/point/icons/'.$pointConfig->level_icon.'/'.$level.'.gif';
			}

			if ($setGroupmark == '1') {
				if ($logged->group_mark && $logged->group_mark->src) {
					$nickcon = $nickcon != '' ? $nickcon.',' : '';
					$nickcon.= Context::getRequestUri().array_pop(explode('./',$logged->group_mark->src));
				}
			}

			if ($setNickmark == '1') {
				if ($logged->image_mark && $logged->image_mark->src) {
					$nickcon = $nickcon != '' ? $nickcon.',' : '';
					$nickcon.= $logged->image_mark->src;
				}
			}

			if ($setNickcon == '1') {
				$nickcon = $nickcon != '' ? $nickcon.',' : '';

				if ($logged->image_name && $logged->image_name->src) {
					$nickcon.= $logged->image_name->src;
				} else {
					$nickcon.= '[nickname]';
				}
			}

			$nickname = str_replace(':#:','',$nickname);
			$nickcon = $nickcon == '[nickname]' ? '' : $nickcon;
		}


		$time = time();
		$securitycode = $this->MinionHashCode($key,$nickname,$nickcon,$time);
		$admincode = $is_admin == true ? $this->MinionAdminCode($key,$nickname,$time) : '';

		if ($args->minionmemonly != '1' || ($args->minionmemonly == '1' && Context::get('is_logged'))) {
			Context::set('code',$code);
			Context::set('width',$width);
			Context::set('height',$height);
			Context::set('nickname',urlencode($nickname));
			Context::set('nickcon',urlencode($nickcon));
			Context::set('securitycode',$securitycode);
			Context::set('admincode',$admincode);
			Context::set('thema',$thema);
			Context::set('type',$type);
			Context::set('viewmsg',$viewmsg);
			Context::set('userview',$userview);
			Context::set('time',$time);

			$oTemplate = &TemplateHandler::getInstance();
			return $oTemplate->compile($tpl_path, $tpl_file);
		} else {
			return '';
		}
	}

	function MinionHashCode($key,$nickname,$nickcon,$time) {
		$hash = md5(($key+$time).$nickname.$nickcon);

		return $hash;
	}

	function MinionAdminCode($key,$nickname,$time) {
		$hash = md5(($key+$time).$nickname.$_SERVER['REMOTE_ADDR']);

		return $hash;
	}
}
?>