<?php
    /**
     * @class banner_script
     * @author Simulz (k10206@naver.com)
     * @brief 스크립트를 출력하는 위젯
     * @version 0.1
     **/

    class banner_script extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            $widget_info->script_url = $args->script_url;
            $widget_info->charset = $args->charset ? $args->charset : 'utf-8';

            Context::set('widget_info', $widget_info);

            // 템플릿 컴파일
            $tpl_file = 'widget';
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>
