<?php
    /**
     * @class  wizardxeAdminModel
     * @author zirho (zirho6@gmail.com)
     * @brief  admin model class of wizardxe 
     **/

    class wizardxeAdminModel extends wizardxe {

        /**
         * @brief init
         **/
        function init() {
        }

        /**
         * @brief get wizardxe info
         **/
        function getWizardxeAdminModelGetWizardxe($args) {
            $output = executeQuery('wizardxe.getWizardxe', $args);
            return $output;
        }

        /**
         * @brief get board skins
         **/
        function getWizardxeAdminModelGetBoardSkins() {
            // get board skins
            $oModuleAdminView = &getAdminView('board');
            $oModuleModel = &getModel('module');
			$skin_list = $oModuleModel->getSkins($oModuleAdminView->module_path);
			Context::set('skin_list',$skin_list);

            // return compiled template in tpl
            $oTemplate = &TemplateHandler::getInstance();
            $tpl = $oTemplate->compile($this->module_path.'tpl', 'board_skins');

            $this->add('tpl', $tpl);
			debugPrint($tpl);
        }

        /**
         * @brief layout list info
         **/
        function getWizardxeAdminModelGetLayoutList() {
            $oLayoutModel = &getModel('layout');
            $layout_list = $oLayoutModel->getDownloadedLayoutList();
            return $layout_list;
        }

        /**
         * @brief permission list
         **/
        function getWizardxeAdminModelGetGrantList() {
			// get grands list
			// access and manager grants are virtual
			$oModuleModel = &getModel('module');
			$xml_info = $oModuleModel->getModuleActionXml('board');
			$source_grant_list = $xml_info->grant;

            $grant_list->access->title = Context::getLang('grant_access');
            $grant_list->access->default = 'guest';
            if(count($source_grant_list)) {
                foreach($source_grant_list as $key => $val) {
                    if(!$val->default) $val->default = 'guest';
                    if($val->default == 'root') $val->default = 'manager';
                    $grant_list->{$key} = $val;
                }
            }
            $grant_list->manager->title = Context::getLang('grant_manager');
            $grant_list->manager->default = 'manager';
            Context::set('grant_list', $grant_list);

            // get group list
            $site_module_info = Context::get('site_module_info');
            $oMemberModel = &getModel('member');
            $group_list = $oMemberModel->getGroups($site_module_info->site_srl);
			foreach($group_list as $group_srl => $group_item) if($group_item->is_admin == 'Y') $group_list[$group_srl]->checked = true;
            Context::set('group_list', $group_list);
        }
    }
?>
