<?php
    /**
     * @class  wizardxeAdminView
     * @author zirho (zirho6@gmail.com)
     * @brief  admin view class of wizardxe 
     **/

    class wizardxeAdminView extends wizardxe {

        /**
         * @brief initialize
         **/
        function init() {
			$template_path = sprintf("%stpl",$this->module_path);
			$this->setTemplatePath($template_path);
            $this->setTemplateFile(str_replace('dispWizardxeAdmin','',$this->act));
        }

        /**
         * @brief display board copy
         **/
        function dispWizardxeAdminBoardCopy() {
			
        }

        /**
         * @brief display wizardxe info
         **/
        function dispWizardxeAdminInfo() {
			
            $args = Context::getRequestVars();
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);

			if(!$args->wizardxe_srl || !$output->data){
				$this->setTemplateFile('Manager');
				$this->dispWizardxeAdminManager();
			}

			if(!$output->toBool()) return $output;
			Context::set('wizardxe_info', $output->data);	

            // get layout info
            $oLayoutModel = &getModel('layout');
            $layout_info = $oLayoutModel->getLayout($output->data->layout_srl);
			Context::set('layout_info', $layout_info);

            // get module categories
            $oModuleModel = &getModel('module');
            $module_category = $oModuleModel->getModuleCategories();
            Context::set('module_category', $module_category);		
        }

        /**
         * @brief display manager list
         **/
        function dispWizardxeAdminManager() {
			
            $args->sort_index = "regdate";
            $args->page = Context::get('page');
            $args->list_count = 20;
            $args->page_count = 10;
            $output = executeQueryArray('wizardxe.getWizardxeList', $args);
            if(!$output->toBool()) return $output;
            ModuleModel::syncModuleToSite($output->data);
			
			$oLayoutModel = &getModel('layout');

			if($output->total_count > 0){
				$layouts = array();
				foreach($output->data as $val){
					$layout_info = $oLayoutModel->getLayout($val->layout_srl);
					$layouts[$val->layout_srl] = $layout_info->layout;
				}
				Context::set('layouts', $layouts);
			}

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('wizardxe_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
			
        }

        /**
         * @brief display onclick site create page
         **/
        function dispWizardxeAdminOneclick() {
			
			// get layout list
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$layout_list = $oWizardxeAdminModel->getWizardxeAdminModelGetLayoutList();
			Context::set('layout_list', $layout_list);
			
			// get grant list
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$oWizardxeAdminModel->getWizardxeAdminModelGetGrantList();
        }

        /**
         * @brief display step 1
         **/
        function dispWizardxeAdminStep1() {
        }

        /**
         * @brief display step 2
         **/
        function dispWizardxeAdminStep2() {
			// get wizardxe info
            $args = Context::getRequestVars();
			
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			Context::set('wizardxe_info', $output->data);

			// get layout list
			$layout_list = $oWizardxeAdminModel->getWizardxeAdminModelGetLayoutList();
			Context::set('layout_list', $layout_list);
        }

        /**
         * @brief display step 3
         **/
        function dispWizardxeAdminStep3() {
			// get wizardxe info
            $args = Context::getRequestVars();
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			Context::set('wizardxe_info', $output->data);
        }

        /**
         * @brief display step 4
         **/
        function dispWizardxeAdminStep4() {
			// get wizardxe info
            $args = Context::getRequestVars();
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			Context::set('wizardxe_info', $output->data);

			// get grant list
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$oWizardxeAdminModel->getWizardxeAdminModelGetGrantList();
        }
    }
?>
