<?php
    /**
     * @class  wizardxeAdminController
     * @author zirho (zirho6@gmail.com)
     * @brief  admin Controller class of wizardxe
     **/

    class wizardxeAdminController extends wizardxe {

        /**
         * @brief init fucntion
         **/
        function init() {
        }

        /**  
         * @brief board copy process
         **/
        function procWizardxeAdminBoardCopy() {
			
			$args = Context::getRequestVars();
			$target_mid = $args->menu_url;
			$board_name = $args->board_name;

			$oModuleModel = &getModel('module');	
            $oModuleController = &getController('module');	

            $oAdminboardController = &getAdminController('board');

			$oDocumentModel = &getModel('document');	
            $oDocumentAdminController = &getAdminController('document');

			// 1. get target_module info	
			$tg_args = $oModuleModel->getModuleInfoByMid($target_mid);
			if(!$tg_args) return new Object(-1, 'error');
			
			// get target_module grant info
            $output = executeQueryArray('module.getModuleGrants', $tg_args);
            $grant = array();
            if($output->data) {
				if(!is_array($output->data)) $output->data = array($output->data);
                foreach($output->data as $key => $val) $grant[$val->name][] = $val->group_srl;
            }

			// get document categories
            $dc_args->module_srl = $tg_args->module_srl;
            $dc_args->sort_index = 'list_order';
			unset($output);
            $output = executeQuery('document.getCategoryList', $dc_args);
            if(!$output->toBool()) return $output;
	
			$category_map = array();

            $category_list = $output->data;

			if($category_list)
				foreach($category_list as $val){
					$category_map[$val->category_srl] = getNextSequence();
				}
			
			$target_srl = $tg_args->module_srl;
			unset($tg_args->module_srl);
			$tg_args->mid = $board_name;

			// 2. create new module info
			unset($output);
			$output = $oModuleController->insertModule($tg_args);
            if(!$output->toBool()) return $output;
			
			$tg_args->module_srl = $target_srl;

			// 3. get new module info
			$new_args = $oModuleModel->getModuleInfoByMid($board_name);
			if(!$new_args) return new Object(-1, 'error');
			
			// 4. create new module grant info
			if(count($grant)) $oModuleController->insertModuleGrants($new_args->module_srl, $grant);
			
			// 5. create document categories
			if($category_list){
				if(!is_array($category_list)) $category_list = array($category_list);
				foreach($category_list as $val){
					$val->module_srl = $new_args->module_srl;
					$val->category_srl = $category_map[$val->category_srl];
					if($val->parent_srl) $val->parent_srl = $category_map[$val->parent_srl];
					executeQuery('document.insertCategory', $val);
				}
			}
			//$oDocumentController = &getController('document');
            //$oDocumentController->makeCategoryFile($obj->module_srl);
			
			// 6. copy extra var keys
			unset($output);
            $output = executeQuery('wizardxe.getDocumentExtraKeys', $dc_args);
            if(!$output->toBool()) return $output;
			
			if($output->data){
				if(!is_array($output->data)) $output->data = array($output->data);
				foreach($output->data as $val){
					$val->module_srl = $new_args->module_srl;
					$output = executeQuery('wizardxe.insertDocumentExtraKeys', $val);
				}
			}
			
			// 7. get target documents
			unset($output);
            $output = executeQuery('wizardxe.getDocumentSrls', $dc_args);
            if(!$output->toBool()) return $output;
			
			if(Context::get('include_data')=='Y') {
				// 8. copy documents for new module
				if($output->data){
					if(!is_array($output->data)) $output->data = array($output->data);
					foreach($output->data as $val){
						$copied_result = $oDocumentAdminController->copyDocumentModule(array($val->document_srl), $new_args->module_srl, $category_map[$val->category_srl]);
						$del_ev_args->document_srl = $copied_result->variables['copied_srls'][$val->document_srl];
						executeQuery('wizardxe.deleteDocumentExtraVars', $del_ev_args);
						$get_ev_args->document_srl = $val->document_srl;
						$ev_output = executeQuery('wizardxe.getDocumentExtraVars', $get_ev_args);
						
						// create extra vals for new module
						if($ev_output->data){
							if(!is_array($ev_output->data)) $ev_output->data = array($ev_output->data);
							foreach($ev_output->data as $ev_var){
								$ev_var->module_srl = $new_args->module_srl;
								$ev_var->document_srl = $copied_result->variables['copied_srls'][$val->document_srl];
								executeQuery('wizardxe.insertDocumentExtraVars', $ev_var);
							}
						}
					}	
				}
			}

			// 9. create module part configs
			unset($output);
			$mpc_args->module_srl = $tg_args->module_srl;
            $output = executeQuery('wizardxe.getModulePartConfigs', $mpc_args);
            if(!$output->toBool()) return $output;
			if($output->data){
				if(!is_array($output->data)) $output->data = array($output->data);
				foreach($output->data as $val){
					$val->module_srl = $new_args->module_srl;
					unset($val->regdate);
					executeQuery('module.insertModulePartConfig', $val);
				}	
			}

			// 10. create module skins
			unset($output);
			$ms_args->module_srl = $tg_args->module_srl;
            $output = executeQuery('module.getModuleSkinVars', $ms_args);
            if(!$output->toBool()) return $output;
			if($output->data){
				if(!is_array($output->data)) $output->data = array($output->data);
				foreach($output->data as $val){
					$val->module_srl = $new_args->module_srl;
					unset($val->regdate);
					executeQuery('module.insertModuleSkinVars', $val);
				}	
			}
			
			$this->add('url', getUrl('','mid', $new_args->mid));
            $this->setMessage('success_registed');
        }

        /**  
         * @brief update common browser title 
         **/
        function procWizardxeAdminUpdateTitles() {

            $args = Context::getRequestVars();

			$output = executeQuery('wizardxe.updateWizardxeTitles', $args);
			if(!$output->toBool()) return $output;
			
			unset($output);
            $output = executeQuery('menu.updateMenu', $args);
            if(!$output->toBool()) return $output;
			
			unset($output);
            $output = executeQuery('module.updateModuleCategory', $args);
            if(!$output->toBool()) return $output;

			unset($output);
			$output = executeQuery('wizardxe.getModulesrlsByMenusrl', $args);
			if(!$output->toBool()) return $output;

			unset($output);
			$module_srls = $output->data;
			$output = $this->procWizardxeAdminUpdateModuleBrowsertitle($module_srls);
			if($output && !$output->toBool()) return $output;
        }

        /**  
         * @brief step 1 process
         **/
        function procWizardxeAdminStep1() {

            $args = Context::getRequestVars();
			// 1.1 create menu   
			$output = $this->procWizardxeAdminMenuInsert(&$args);
			if($output && !$output->toBool()) return $output;

			// 1.1.1 create module category   
			unset($output);
			$output = $this->procWizardxeAdminCreateModuleCategory(&$args);
			if($output && !$output->toBool()) return $output;

			$args->wizardxe_srl = getNextSequence();
			$output = executeQuery('wizardxe.insertWizardxe', $args);
			if(!$output->toBool()) return $output;
			
			$args->step = 2;
			$output = executeQuery('wizardxe.updateWizardxeStep', $args);
			if(!$output->toBool()) return $output;

			$this->add('wizardxe_srl', $args->wizardxe_srl);
            $this->setMessage('success_registed');
        }
        /**  
         * @brief step 2 process
         **/
        function procWizardxeAdminStep2() {

            $args = Context::getRequestVars();
            $site_module_info = Context::get('site_module_info');

			// get wizardxe info
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			$wizardxe_info = $output->data;
			$args->menu_srl = $wizardxe_info->menu_srl; 
			$args->title = $wizardxe_info->title; 
			Context::set('wizardxe_info', $wizardxe_info);

			// 2. create layout
			unset($output);
			$output = $this->procWizardxeAdminLayoutInsert(&$args, &$site_module_info);
			if($output && !$output->toBool()) return $output;

			// 3. link menu to layout
			unset($output);
			$output = $this->procWizardxeAdminLayoutMenuInsert(&$args);
			if($output && !$output->toBool()) return $output;
			// success 

			// 10. update wizardxe layout_srl
			unset($output);
			$output = executeQuery('wizardxe.updateWizardxeLayoutsrl', $args);
			if(!$output->toBool()) return $output;
			
			$args->step = 3;
			$output = executeQuery('wizardxe.updateWizardxeStep', $args);
			if(!$output->toBool()) return $output;

			$this->add('wizardxe_srl', $args->wizardxe_srl);
            $this->setMessage('success_registed');
        }

        /**  
         * @brief step 3 process
         **/
        function procWizardxeAdminStep3() {

            $args = Context::getRequestVars();
            $site_module_info = Context::get('site_module_info');

			// get wizardxe info
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			$wizardxe_info = $output->data;
			$args->menu_srl = $wizardxe_info->menu_srl; 
			$args->layout_srl = $wizardxe_info->layout_srl; 
			$args->browser_title = $wizardxe_info->browser_title; 
			$args->module_category_srl = $wizardxe_info->module_category_srl; 
			Context::set('wizardxe_info', $wizardxe_info);

			// 0.1 mid reg validation
			$output = $this->procWizardxeAdminMidsValidation(&$args);
			if($output && !$output->toBool()) return $output;
			if(!$args->midValid) return;
			
			// 1.2 create menu item
			unset($output);
			$output = $this->procWizardxeAdminMenuItemsInsert(&$args);
			if($output && !$output->toBool()) return $output;
			
			// 4.1 create modules 
			unset($output);
			$output = $this->procWizardxeAdminCreateModules(&$args, &$grant, &$group_srls, &$firstMid);
			if($output && !$output->toBool()) return $output;

			// 10.1 update wizardxe first_mid
			unset($output);
			$args->first_mid = $firstMid;
			$output = executeQuery('wizardxe.updateWizardxeFirstmid', $args);
			if(!$output->toBool()) return $output;

			$args->step = 4;
			$output = executeQuery('wizardxe.updateWizardxeStep', $args);
			if(!$output->toBool()) return $output;

			$this->add('wizardxe_srl', $args->wizardxe_srl);
            $this->setMessage('success_registed');
        }

        /**  
         * @brief step 4 process
         **/
        function procWizardxeAdminStep4() {

            $args = Context::getRequestVars();
            $site_module_info = Context::get('site_module_info');

			// get wizardxe info
			$oWizardxeAdminModel = &getAdminModel('wizardxe');
			$output = $oWizardxeAdminModel->getWizardxeAdminModelGetWizardxe($args);
			if(!$output->toBool()) return $output;
			$wizardxe_info = $output->data;
			$args->menu_srl = $wizardxe_info->menu_srl; 
			Context::set('wizardxe_info', $wizardxe_info);
			
			$output = executeQuery('wizardxe.getModulesrlsByMenusrl', $args);
			if(!$output->toBool()) return $output;

			$module_srls = $output->data;
			$this->procWizardxeAdminGrantApply($module_srls);

			$args->step = 5;
			$output = executeQuery('wizardxe.updateWizardxeStep', $args);
			if(!$output->toBool()) return $output;

			$this->add('wizardxe_srl', $args->wizardxe_srl);
			$this->add('url', getUrl('','mid', $wizardxe_info->first_mid));
            $this->setMessage('success_registed');
        }

        /**  
         * @brief WizardXE : one click site creation
         **/
        function procWizardxeAdminOneclick() {
            // get variables
            $args = Context::getRequestVars();
            $site_module_info = Context::get('site_module_info');

			// 0.1 mid reg validation
			$output = $this->procWizardxeAdminMidsValidation(&$args);
			if($output && !$output->toBool()) return $output;
			if(!$args->midValid) return;

			// 1.1 create menu   
			unset($output);
			$output = $this->procWizardxeAdminMenuInsert(&$args);
			if($output && !$output->toBool()) return $output;

			// 1.1.1 create module category   
			unset($output);
			$output = $this->procWizardxeAdminCreateModuleCategory(&$args);
			if($output && !$output->toBool()) return $output;

			// 1.2 create menu item
			unset($output);
			$output = $this->procWizardxeAdminMenuItemsInsert(&$args);
			if($output && !$output->toBool()) return $output;

			// 2. create layout
			unset($output);
			$output = $this->procWizardxeAdminLayoutInsert(&$args, &$site_module_info);
			if($output && !$output->toBool()) return $output;

			// 3. link menu to layout
			unset($output);
			$output = $this->procWizardxeAdminLayoutMenuInsert(&$args);
			if($output && !$output->toBool()) return $output;
			
			// 4.0 create grants info
			unset($output);
			$output = $this->procWizardxeAdminCreateGrants(&$grant, &$group_srls);
			if($output && !$output->toBool()) return $output;
			
			// 4.1 create modules 
			unset($output);
			$output = $this->procWizardxeAdminCreateModules(&$args, &$grant, &$group_srls, &$firstMid);
			if($output && !$output->toBool()) return $output;

			// 9.0 create wizardxe record
			$args->wizardxe_srl = getNextSequence();
			$output = executeQuery('wizardxe.insertWizardxe', $args);
			if(!$output->toBool()) return $output;
			
			$args->step = 5;
			$output = executeQuery('wizardxe.updateWizardxeStep', $args);
			if(!$output->toBool()) return $output;

			$this->add('wizardxe_srl', $args->wizardxe_srl);
			$this->add('url', getUrl('','mid', $firstMid));
			// success 
            $this->setMessage('success_registed');
        }

        /**
         * @brief input mid validation function
         **/
        function procWizardxeAdminMidsValidation(&$args) {
			
			// 0.1 mid reg validation
			$args->midValid = true;
			$mids = array();
			foreach($args as $key => $val){
				if(strpos($key, "_mid") !== false
					&& $args->{str_replace('menu_mid','menu_type',$key)} != 'exist' ){
					$res = preg_match("/^[a-zA-Z][a-zA-Z0-9_-]*$/", $val, $matches);
					if(!$res) $mids[] = $val;
				}
			}

			if(count($mids)){
				$this->setError(1);
				$this->setMessage( sprintf(Context::getLang('msg_invaild_mids'), implode(",", $mids)) );
				$args->midValid = false;
				return;
			}

			// 0.2 mid db validation
			unset($mids);
			$mids = array();
			foreach($args as $key => $val){
				if(strpos($key, "_mid") !== false){
					
					if(strpos($key, "menu_sub_mid") !== false){
						$type = $args->{str_replace("menu_sub_mid","menu_sub_type",$key)};
					}else {
						$type = $args->{str_replace("menu_mid","menu_type",$key)};
					}

					if($type != "exist") $mids[] = $val;
				}
			}

			$val_args->mids = "'".implode("','",$mids)."'";
            $output = executeQuery('wizardxe.getModuleMidsbyMids', $val_args);
			if(!$output->toBool()) return $output;
			unset($val_args);
			if($output->toBool() && $output->data) {
				$list = $output->data;
				if(!$list) return;
				if(!is_array($list)) $list = array($list);
				unset($mids);
				foreach($list as $val) $mids[] = $val->mid;
				//$this->add('mid', $mids[0]);
				$this->setError(1);
				$this->setMessage( sprintf(Context::getLang('msg_already_exist'), implode(",", $mids)) );
				$args->midValid = false;
				return;
			}
        }

        /**
         * @brief create menu 
         **/
        function procWizardxeAdminMenuInsert(&$args) {
			$args->site_srl = (int)$site_module_info->site_srl;
            $args->title = Context::get('title');
            $args->menu_srl = getNextSequence();
            $args->listorder = $args->menu_srl * -1;

            $output = executeQuery('menu.insertMenu', $args);
            if(!$output->toBool()) return $output;

			$this->add('menu_srl', $args->menu_srl);
        }

        /**
         * @brief create menu item 
         **/
        function procWizardxeAdminMenuItemsInsert(&$args) {
			
			$item_args->open_window = 'N';
            $item_args->expand = 'Y';
            $item_args->menu_srl = $args->menu_srl;

			foreach($args as $key => $val){
				if(strpos($key, "menu_item") !== false){

					$idx = str_replace("menu_item","",$key);

					if($args->{"menu_mid".$idx}){						
						$item_args->name = $val;
						$item_args->url = $args->{"menu_mid".$idx};
						$item_args->menu_item_srl = getNextSequence();						
						$item_args->listorder = -1*$item_args->menu_item_srl;
						$output = executeQuery('menu.insertMenuItem', $item_args);
						if(!$output->toBool()) return $output;

						// create sub items 
						foreach($args as $key => $val){
							if(strpos($key, "menu_sub_item_".$idx."_") !== false){

								$sub_idx = str_replace("menu_sub_item_".$idx."_","",$key);

								$sub_item_args->menu_srl = $args->menu_srl;
								$sub_item_args->menu_item_srl = getNextSequence();	
								$sub_item_args->parent_srl = $item_args->menu_item_srl;
								$sub_item_args->menu_id = NULL;
								$sub_item_args->name = $val;
								$sub_item_args->url = $args->{"menu_sub_mid_".$idx."_".$sub_idx};
								$sub_item_args->open_window = 'N';
								$sub_item_args->expand = 'Y';
								$output = executeQuery('menu.insertMenuItem', $sub_item_args);
								if(!$output->toBool()) return $output;
							}
						}
					}
				}
			}
			unset($item_args);

            // renew the xml file 
            $oMenuAdminController = &getAdminController('menu');
            $xml_file = $oMenuAdminController->makeXmlFile($args->menu_srl);
        }

        /**
         * @brief create layout 
         **/
        function procWizardxeAdminLayoutInsert(&$args, &$site_module_info) {

			// get basic layout info
            $args->layout_srl = getNextSequence();
            $oLayoutAdminController = &getAdminController('layout');
            $output = $oLayoutAdminController->insertLayout($args);
            if(!$output->toBool()) return $output;
			
            // need init when layout out is faceOff
            $oLayoutAdminController->initLayout($args->layout_srl, $args->layout);
        }

        /**  
         * @brief set the layout's menu_srl
         **/
        function procWizardxeAdminLayoutMenuInsert(&$args) {
			
            $oLayoutModel = &getModel('layout');
            $oMenuAdminModel = &getAdminModel('menu');
            $oLayoutAdminController = &getAdminController('layout');
            $layout_info = $oLayoutModel->getLayout($args->layout_srl);

            $menus = get_object_vars($layout_info->menu);
            if($menus && count($menus)) {
                foreach($menus as $menu_id => $val) {

                    $menu_srl = $args->menu_srl;
                    if(!$menu_srl) continue;

                    $output = $oMenuAdminModel->getMenu($menu_srl);

                    $menu_srl_list[] = $menu_srl;
                    $menu_name_list[$menu_srl] = $output->title;

                    if(Context::get('apply_layout')=='Y') {
                        $menu_args = null;
                        $menu_args->menu_srl = $menu_srl;
                        $menu_args->site_srl = $layout_info->site_srl;

                        $output = executeQueryArray('layout.getLayoutModules', $menu_args);
                        if($output->data) {
                            $modules = array();
                            for($i=0;$i<count($output->data);$i++) {
                                $modules[] = $output->data[$i]->module_srl;
                            }

                            if(count($modules)) {
                                $update_args->module_srls = implode(',',$modules);
                                $update_args->layout_srl = $args->layout_srl;
                                $output = executeQuery('layout.updateModuleLayout', $update_args);
								if(!$output->toBool()) return $output;
                            }
                        }
                    }
                }
            }

			if($menus) foreach($menus as $name => $vars) $extra_vars->{$name} = $args->menu_srl;

            //menu title save
            $extra_vars->menu_name_list = $menu_name_list;

            // do some extra job when extra_vars type is image
            if($layout_info->extra_var) {
                foreach($layout_info->extra_var as $name => $vars) {
					
					$extra_vars->{$name} = null;

                    if($vars->type=='select') {
						$extra_vars->{$name} = array_shift(array_keys($vars->options));
					}
				}
			}

            $args->extra_vars = serialize($extra_vars);
            $output = $oLayoutAdminController->updateLayout($args);

            if(!$output->toBool()) return $output;
			
        }

        /**  
         * @brief create permission 
         **/
        function procWizardxeAdminCreateGrants(&$grant, &$group_srls) {

			$oModuleModel = &getModel('module');

			$xml_info = $oModuleModel->getModuleActionXML('board');
            $grant_list = $xml_info->grant;
            $grant_list->access->default = 'guest';
            $grant_list->manager->default = 'manager';

            foreach($grant_list as $grant_name => $grant_info) {
                // get default info
                $default = Context::get($grant_name.'_default');

                // -1 = login user , -2 = site user , 0 = everyone
                if(strlen($default)){
                    $grant->{$grant_name}[] = $default;
                    continue;

                // specified group user
                } else {
                    $group_srls = Context::get($grant_name);
                    if($group_srls) {
                        if(strpos($group_srls,'|@|')!==false) $group_srls = explode('|@|',$group_srls);
                        elseif(strpos($group_srls,',')!==false) $group_srls = explode(',',$group_srls);
                        else $group_srls = array($group_srls);
                        $grant->{$grant_name} = $group_srls;
                    }
                    continue;
                }
                $grant->{$group_srls} = array();
            }
        }

        /**  
         * @brief create modules
         **/
        function procWizardxeAdminCreateModules(&$args, &$grant, &$group_srls, &$firstMid) {

			// 4.1 create modules 
			$oModuleController = &getController('module');
			$oModuleModel = &getModel('module');

			$firstMid = "";

			foreach($args as $key => $val){
				if(strpos($key, "_mid") !== false){
					
					$type;
					$name;

					if(strpos($key, "menu_sub_mid") !== false){
						$type = $args->{str_replace("menu_sub_mid","menu_sub_type",$key)};
						$name = $args->{str_replace("menu_sub_mid","menu_sub_item",$key)};
					}else {
						$type = $args->{str_replace("menu_mid","menu_type",$key)};
						$name = $args->{str_replace("menu_mid","menu_item",$key)};
					}

					if(!$firstMid) { $firstMid = $val; $args->first_mid = $val; }

					if($type && $name && ($type != "exist")){
						
						//common module args
						$module_args->module_srl = 0;
						$module_args->module_category_srl = 0;
						$module_args->menu_srl = $args->menu_srl;
						$module_args->layout_srl = $args->layout_srl;
						$module_args->browser_title = $args->browser_title." - ".$name;
						$module_args->is_default = null;
						$module_args->body = null;
						$module_args->mid = $val;
						$module_args->module_category_srl = $args->module_category_srl;
					
						if($type == "page"){
							// set args for page module
							$module_args->module = 'page';
							$module_args->page_caching_interval = 0;
							$module_args->act = 'procPageAdminInsert';
							$output = $oModuleController->insertModule($module_args);
							if(!$output->toBool()) return $output;
							$module_args->module_srl = $output->variables['module_srl'];
						}else if($type == "board"){
							$skin = $args->{str_replace("menu_mid","boardskin",$key)};

							// set args for board module
							$module_args->skin = $skin;
							$module_args->use_category = 'N';
							$module_args->order_target = 'list_order';
							$module_args->order_type = 'asc';
							$module_args->list_count = 20;
							$module_args->search_list_count = 20;
							$module_args->except_notice = 'Y';
							$module_args->use_anonymous = 'N';
							$module_args->consultation = 'N';
							$module_args->page_count = 10;
							$module_args->module = 'board';
							$module_args->act = 'procBoardAdminInsertBoard';
							$output = $oModuleController->insertModule($module_args);
							$module_args->module_srl = $output->variables['module_srl'];
						}

            
						// 4.0 insert module grant info
						$args_grant->module_srl = $module_args->module_srl;
						$output = executeQuery('module.deleteModuleGrants', $args_grant);
						if(!$output->toBool()) return $output;
							
						if($grant){
							foreach($grant as $grant_name => $group_srls) {
								foreach($group_srls as $val_grant) {
									$args_grant = null;
									$args_grant->module_srl = $module_args->module_srl;
									$args_grant->name = $grant_name;
									$args_grant->group_srl = $val_grant;
									$output = executeQuery('module.insertModuleGrant', $args_grant);
									if(!$output->toBool()) return $output;
								}
							}
						}
					}else if($type == "exist") {
						//update layout_srl
						$update_args->menu_srl = $args->menu_srl;
						if($args->apply_layout == 'Y') $update_args->layout_srl = $args->layout_srl;
						$update_args->mid = $val;

						unset($output);
						$output = $oModuleController->updateModuleMenu($update_args);
						if(!$output->toBool()) return $output;

						// 4.0 update module grant info
						unset($output);

						$output->module_srl = $oModuleModel->getModuleSrlByMid($val);

						$module_srl = $output->module_srl[0];
						if(!$module_srl) continue;

						unset($output);
						$output = executeQuery('module.deleteModuleGrants', $args_grant);
						if(!$output->toBool()) return $output;

						if($grant){
							foreach($grant as $grant_name => $group_srls) {
								foreach($group_srls as $val_grant) {
									$args_grant = null;
									$args_grant->module_srl = $module_srl;
									$args_grant->name = $grant_name;
									$args_grant->group_srl = $val_grant;
									$output = executeQuery('module.insertModuleGrant', $args_grant);
									if(!$output->toBool()) return $output;
								}
							}
						}
					}
				}
			}

			if($args->apply_layout == 'Y'){
				$args->menu_srl;

				unset($output);
				$output = $oModuleController->updateModuleLayout($args->layout_srl, array($args->menu_srl));
				if(!$output->toBool()) return $output;
			}
        }

        /**  
         * @brief set module browser title
         **/
        function procWizardxeAdminUpdateModuleBrowsertitle() {

            $args = Context::getRequestVars();
            $site_module_info = Context::get('site_module_info');
			$args->site_srl = $site_module_info->site_srl;

			$args->sort_index = 'listorder';
            $output = executeQuery('menu.getMenuItems', $args);
            if(!$output->toBool()) return $output;

            $oModuleModel = &getModel('module');
			foreach($output->data as $val){

                $args_grant->module_srl = $oModuleModel->getModuleSrlByMid($val->url);
				$args_grant->module_srl = $args_grant->module_srl[0];
				if(!$args_grant->module_srl) continue;

				$args_grant->browser_title = $args->browser_title." - ".$val->name;
				$output = executeQuery('wizardxe.updateModuleBrowsertitle', $args_grant);
				if(!$output->toBool()) return $output;
			}
        }

        /**  
         * @brief apply permission
         **/
        function procWizardxeAdminGrantApply($module_srls) {

			// create grant info
			$this->procWizardxeAdminCreateGrants(&$grant, &$group_srls);

			if($module_srls){

				if(!is_array($module_srls)) $module_srls = array($module_srls);

				foreach($module_srls as $val){
				
					// 4.0 insert module grant info
					$args_grant->module_srl = $val->module_srl;
					$output = executeQuery('module.deleteModuleGrants', $args_grant);
					if(!$output->toBool()) return $output;

					if($grant){
						foreach($grant as $grant_name => $group_srls) {
							foreach($group_srls as $val_grant) {
								$args_grant = null;
								$args_grant->module_srl = $val->module_srl;
								$args_grant->name = $grant_name;
								$args_grant->group_srl = $val_grant;
								$output = executeQuery('module.insertModuleGrant', $args_grant);
								if(!$output->toBool()) return $output;
							}
						}
					}
				}
			}
        }

        /**  
         * @brief create module category
         **/
        function procWizardxeAdminCreateModuleCategory(&$args) {

			$args->module_category_srl = getNextSequence();
            $output = executeQuery('wizardxe.insertModuleCategory', $args);
            return $output;
        }
    }
?>
