<?php
    /**
     * @file   modules/cashbook/lang/ko.lang.php
     * @author jedison (master@xgenesis.org)
     * @brief  CashbookXE's basic language pack
     * 명명규칙: 라벨 - 모듈명_HTML파일명_lbl_이름
     *         버튼 - 모듈명_HTML파일명_btn_이름
     *         폼양식 - <form name과 동일한 이름>
     *         XML Filter 확인메시지 - confirm_이름
     *         메시지: msg_이름
     **/

	/**************************************************************************
	 * 관리자
	 *************************************************************************/

	// tpl > _header.html
	$lang->cashbook = "금전출납부";
	$lang->cashbook_help = "개별 사용자의 금전출납부에 공통적으로 적용되는 설정을 할 수 있습니다.";
	$lang->cmd_cashbook_setup = '기본 설정';
    $lang->cmd_cashbook_config_list = '금전출납부 목록';
    
	// tpl > setup.html
	$lang->create_grant = "생성권한";
    $lang->create_message = '생성안내';
	$lang->create_message_help = '금전출납부 생성시 나타나는 안내글을 입력하실 수 있습니다';
	
	// tpl > list.html
	$lang->confirm_delete_cashbook = "금전출납부를 삭제하시겠습니까?";
	$lang->success_delete = "금전출납부를 삭제했습니다.";
	/**************************************************************************
	 * 사용자
	 *************************************************************************/
	
	// skins
	$lang->search_target = "검색대상";
	
	$lang->msg_you_must_create_at_first = "먼저 금전출납부를 생성하세요. (<a href='/?module=cashbook&act=dispCashbookCreate'>금전출납부생성하기</a>)";
	
	// skins > _header.html
	$lang->admin = "관리자화면";
	$lang->manual = "메뉴얼";
	$lang->logout = "로그아웃";
	$lang->control_panel = "제어판";
	$lang->deal = "거래";
	$lang->car = "차계부";
	$lang->chart = "도표";
	$lang->report = "보고서";
	
	// skins > _menu_control.html
	$lang->config_control = "환경설정";
	$lang->config_basic = "기본설정";
	$lang->config_basic_help = "기본설정을 수정합니다.";
	$lang->config_category = "분류설정";
	$lang->config_category_help = "거래를 등록할 때 사용할 분류설정을 수정합니다. 제어판 > 정보관리 > 분류관리에서 생성한 분류를 사용할 수 있습니다.";
	$lang->config_deal = "거래설정";
	$lang->config_deal_help = "거래(수입/지출/이체 등)에서 사용하는 설정을 수정합니다.";
	$lang->config_grant = "권한설정";
	$lang->config_grant_help = "권한을 수정합니다.";
	$lang->info_management = "정보관리";
	$lang->account_management = "계정관리";
	$lang->customer_management = "거래처관리";
	$lang->category_management = "분류관리";
	$lang->interlock_control = "연동설정";
	$lang->interlock_bank = "은행연동";
	$lang->interlock_credit = "신용카드연동";
	$lang->data_control = "데이터관리";
	$lang->backup = "백업";
	$lang->restore = "복구";
	$lang->init = "초기화";
	
	// skins > create.html, config_basic_edit.html
	$lang->create = "금전출납부 생성";
    $lang->create_help = '금전출납부 생성하기';	
	$lang->browser_title = '금전출납부 이름';
	$lang->browser_title_help = '금전출납부 이름';
	$lang->whos_cashbook = "%s님의 금전출납부";
	$lang->mid = '금전출납부 주소';
	$lang->mid_help = '금전출납부 주소는  http://주소/?mid=모듈이름 처럼 직접 호출할 수 있는 값입니다. (영문+[영문+숫자+_] 만 가능. 최대 40 글자)';
    $lang->family_type = '유형';
    $lang->family_type_01 = '학생 (초등학생)';
    $lang->family_type_02 = '학생 (중학생)';
    $lang->family_type_03 = '학생 (고등학생)';
    $lang->family_type_04 = '학생 (대학생)';
    $lang->family_type_05 = '학생 (대학원이상)';
    $lang->family_type_11 = '직장인 (외벌이)';
    $lang->family_type_12 = '직장인 (맞벌이)';
    $lang->family_type_21 = '모임 (동호회)';
    $lang->family_type_31 = '회사 (개인)';
    $lang->family_type_32 = '회사 (법인)';
    $lang->family_type_help = '유형을 선택하세요.';
    $lang->child_count = '자녀수';
    $lang->child_count_help = '';
    $lang->child_count_00 = '없음';
    $lang->child_count_01 = '1명';
    $lang->child_count_02 = '2명';
    $lang->child_count_03 = '3명';
    $lang->child_count_04 = '4명';
    $lang->child_count_05 = '5명';
    $lang->child_count_06 = '6명';
    $lang->child_count_99 = '7명 이상';
    $lang->month_income = '월소득';
    $lang->month_income_00 = '100만원 이하';
    $lang->month_income_01 = '100~200만원';
    $lang->month_income_02 = '200~300만원';
    $lang->month_income_03 = '300~400만원';
    $lang->month_income_04 = '400~500만원';
    $lang->month_income_05 = '500~600만원';
    $lang->month_income_06 = '600~700만원';
    $lang->month_income_07 = '700~800만원';
    $lang->month_income_08 = '800~900만원';
    $lang->month_income_99 = '900만원 이상';
    $lang->month_income_help = '';
    $lang->start_day = '월시작일';
    $lang->start_day_01 = '01일';
    $lang->start_day_02 = '02일';
    $lang->start_day_03 = '03일';
    $lang->start_day_04 = '04일';
    $lang->start_day_05 = '05일';
    $lang->start_day_06 = '06일';
    $lang->start_day_07 = '07일';
    $lang->start_day_08 = '08일';
    $lang->start_day_09 = '09일';
    $lang->start_day_10 = '10일';
    $lang->start_day_11 = '11일';
    $lang->start_day_12 = '12일';
    $lang->start_day_13 = '13일';
    $lang->start_day_14 = '14일';
    $lang->start_day_15 = '15일';
    $lang->start_day_16 = '16일';
    $lang->start_day_17 = '17일';
    $lang->start_day_18 = '18일';
    $lang->start_day_19 = '19일';
    $lang->start_day_20 = '20일';
    $lang->start_day_21 = '21일';
    $lang->start_day_22 = '22일';
    $lang->start_day_23 = '23일';
    $lang->start_day_24 = '24일';
    $lang->start_day_25 = '25일';
    $lang->start_day_26 = '26일';
    $lang->start_day_27 = '27일';
    $lang->start_day_28 = '28일';
    $lang->start_day_29 = '29일';
    $lang->start_day_30 = '30일';
    $lang->start_day_31 = '31일';
    $lang->start_day_help = '';
	$lang->currency = '통화';
	$lang->currency_KRW = '원(한국)';
	$lang->currency_USD = '달러(미국)';
	$lang->currency_JPY = '엔(일본)';
	$lang->currency_EUR = '유로(유럽연합)';
	$lang->currency_CNY = '위안(중국)';
	$lang->currency_AUD = '달러(호주)';
	$lang->currency_help = '주로 사용할 통화를 선택하세요.';
	// 버튼
	$lang->cmd_makeOk_move_myCashbook = "확인: 금전출납부를 생성한 후 생성된 금전출납부로 이동합니다.";	
	$lang->confirm_config_create = "금전출납부를 생성하시겠습니까?";
	$lang->confirm_config_modify = "수정하시겠습니까?";
	// 필터메시지
	$lang->msg_exists_mid = "같은 mid를 가진 모듈이 존재합니다. 금전출납부 주소를 변경하세요.";
	$lang->msg_success_create_cashbook = "금전출납부가 성공적으로 생성되었습니다.";
	$lang->msg_success_update_config_basic = "기본설정을 수정하였습니다.";
	$lang->msg_success_update_config_grant = "권한설정을 수정하였스빈다.";
	$lang->msg_dont_have_create_grant = "금전출납부를 생성할 권한이 없습니다.<br/> 사이트 관리자에게 문의하세요.";
	$lang->msg_dont_have_admin_grant = "금전출납부를 관리할 권한이 없습니다.";
	
	// skins > config_category_edit.html
	$lang->income_category = "수입 항목 설정";
	$lang->income_category_help = "수입을 등록할 때 사용할 항목을 선택하세요.";
	$lang->outgo_category = "지출 항목 설정";
	$lang->outgo_category_help = "지출을 등록할 때 사용할 항목을 선택하세요.";
	$lang->deal_category = "거래 분류 설정";
	$lang->deal_category_help = "수입 및 지출 등록시 사용할 분류를 선택하세요.";
	$lang->cash_category = "현금계정 항목 설정";
	$lang->cash_category_help = "현금계정에서 사용할 항목을 선택하세요.";
	$lang->bank_category = "은행계정 항목 설정";
	$lang->bank_category_help = "은행계정에서 사용할 항목을 선택하세요.";
	$lang->asset_category = "자산계정 항목 설정";
	$lang->asset_category_help = "자산계정에서 사용할 항목을 선택하세요.";
	$lang->card_category = "카드계정 항목 설정";
	$lang->card_category_help = "카드계정에서 사용할 항목을 선택하세요.";
	$lang->debt_category = "부채계정 항목 설정";
	$lang->debt_category_help = "부채계정에서 사용할 항목을 선택하세요.";
	$lang->customer_category = "거래처 분류 설정";
	$lang->customer_category_help = "거래처에서 사용할 분류를 선택하세요.";
	$lang->msg_success_update_config_category = "분류설정 수정이 정상적으로 수정되었습니다.";
	
	// skins > config_deal_edit.html
	$lang->income_list_count = "수입목록수";
	$lang->income_list_count_help = "수입목록에 표시되는 갯수를 정할 수 있습니다. 0으로 지정될 경우 페이징을 하지 않습니다. (기본값: 20)";
	$lang->outgo_list_count = "지출목록수";
	$lang->outgo_list_count_help = "지출수입목록에 표시되는 갯수를 정할 수 있습니다. 0으로 지정될 경우 페이징을 하지 않습니다. (기본값: 20)";
	$lang->transfer_list_count = "이체목록수";
	$lang->transfer_list_count_help = "이체목록에 표시되는 갯수를 정할 수 있습니다. 0으로 지정될 경우 페이징을 하지 않습니다. (기본값: 20)";
	$lang->month_deal_help = "월간거래에서 사용하는 설정을 수정할 수 있습니다.";
	$lang->lunar_yn = "음력표시";
	$lang->lunar_y = "음력표시함";
	$lang->lunar_n = "음력표시안함";
	$lang->memorial_yn = "기념일표시";
	$lang->memorial_y = "기념일표시함";
	$lang->memorial_n = "기념일표시안함";
	$lang->msg_success_update_config_deal = "거래설정을 정상적으로 수정하였습니다.";
	$lang->msg_denied_cashbook_mid_for_dupe = "설정하신 URL이 이미 사용중입니다.";
	
	// skins > config_grant_edit.html
	$lang->grant_to_owner = "소유자";
	$lang->grant_to_all_user = "모든 사용자";
	$lang->confirm_config_grant_modify = "권한설정을 변경하겠습니까?";
	$lang->msg_success_update_config_grant = "권한설정을 정상적으로 수정하였습니다.";

	// skins > account_input.html
	$lang->account_write = "계정등록";
	$lang->account_write_help = '계정의 종류는 아래와 같습니다.<br/>- 현금계정: 현금<br/>- 은행계정: 일반예금, 정기예금, 정기적금, 기타예금<br/>- 자산계정: 빌려준돈, 부동산, 자동차, 귀금속, 회원권, 기타자산<br/>- 카드계정: 신용카드, 포인트카드<br/>- 부채계정: 빌린돈, 대출, 카드론';
	$lang->account_category_help = '계정에서 사용할 분류를 선택하세요.';
	$lang->account_title = '계정이름';
	$lang->account_title_help = '계정이름이 너무 긴 경우에 각종 조회화면에서 비정상적으로 보이게 될 수 있습니다.';
	$lang->account_day = '최초거래일자';
	$lang->account_day_help = '계정을 처음 금전출납부에 등록하는 일자입니다.<br/>모든 거래(수입, 지출)는 계정을 기준으로 이루어지므로 계정을 먼저 등록한 후 에 거래를 등록할 수 있습니다.';
	$lang->account_basic_amount = '기초잔액';
	$lang->account_basic_amount_help = '최초 등록할 때의 기본금액입니다.잔액은 수정되어도 등록된 거래내용은 변경되지 않습니다.';
	$lang->account_total_asset = '총자산포함';
	$lang->account_total_asset_y = '총자산포함';
	$lang->account_total_asset_n = '총자산미포함';
	$lang->account_total_asset_help = '총자산미포함에 체크를 할 경우, 해당 계정의 잔액은 총자산에서 제외됩니다.';
	$lang->account_memo = '설명';
	$lang->account_memo_help = '계정에 대한 설명을 입력하세요.';
	$lang->confirm_insert_account = "계정을 등록하시겠습니까?";
	$lang->account_edit = "계정수정";
	
	// skins > account_list.html
	$lang->account_list = "계정목록";
	$lang->account_list_help = '추가하실 계정을 아래에서 클릭하세요.<br/>- 현금계정: 현금<br/>- 은행계정: 일반예금, 정기예금, 정기적금, 기타예금<br/>- 자산계정: 빌려준돈, 부동산, 자동차, 귀금속, 회원권, 기타자산<br/>- 카드계정: 신용카드, 포인트카드<br/>- 부채계정: 빌린돈, 대출, 카드론';
	$lang->account_kind = '종류';
	$lang->account_name = '계정이름';
	$lang->account_basic_balance = '기초잔액';
	$lang->cmd_account_cash_write = "현금계정등록";
	$lang->cmd_account_bank_write = "은행계정등록";
	$lang->cmd_account_asset_write = "자산계정등록";
	$lang->cmd_account_card_write = "카드계정등록";
	$lang->cmd_account_debt_write = "부채계정등록";
	$lang->confirm_delete_account = "계정을 삭제하시겠습니까?";
		
	// skins > customer_input.html
	$lang->customer_write = "거래처등록";
	$lang->customer_write_help = "";
	$lang->customer_input_category = "분류";
	$lang->customer_input_category_help = "";
	$lang->customer_name = "이름";
	$lang->customer_name_help = "";
	$lang->customer_phone = "전화";
	$lang->customer_phone_help = "";
	$lang->customer_memo = "메모";
	$lang->customer_memo_help = "";
	$lang->confirm_insert_customer = "거래처를 등록하시겠습니까?";
	$lang->customer_edit = "거래처수정";
	$lang->customer_edit_help = "";
	$lang->confirm_update_customer = "거래처를 수정하시겠습니까?";
	
	// skins > customer_list.html
	$lang->customer_list = "거래처목록";
	$lang->customer_list_help = "사용중인 거래처를 관리할 수 있습니다.";
	$lang->confirm_delete_customer = "거래처를 삭제하시겠습니까?";

	// skins > category_input.html
	$lang->category_write = "분류등록";
	$lang->category_write_help = '금전출납부에 연결할 때, 쉽게 구분할 수 있는 제목을 입력해주세요.';
	
	// skins > category_list.html
	$lang->category_list = "분류목록";
	$lang->category_list_help = '금전출납부에서 사용하는 각종 분류들입니다.';
	
	// skins > category_management.html
	$lang->category_management = '분류관리';
	$lang->category_management_help = "분류관리는 금전출납부에서 사용하는 분류를 구성할 수 있도록 합니다.\n정해진 단계까지 분류를 구성 가능하며 입력하신 분류를 클릭하시면 상세 정보를 입력할 수 있습니다.\n폴더 그림을 클릭하시면 분류를 확장하실 수 있습니다.\n간혹 분류가 정상적으로 나타나지 않으면 \"캐시파일 재생성\" 버튼을 눌러서 정보를 갱신하세요.\n* 정해진 단계 이상의 분류는 제대로 표시되지 않을 수 있습니다.";
	// 버튼
    $lang->confirm_msg_update_category_title = "분류를 변경하시겠습니까?";
    $lang->confirm_category_item_delete = '분류를 삭제하시겠습니까?\n해당 분류를 사용하고 있는 모든 거래가 함께 삭제됩니다. \n주의하여 주십시요';
    
	// category_item_input_tpl.html
	$lang->parent_category_name = '상위분류명';
	$lang->category_name = '분류명';
    $lang->category_memo = '메모';
    $lang->category_use_yn = '사용여부';
    $lang->category_expand = '펼침';
	
    // skins > init.html
    $lang->init_help = "초기화가 완료되면 처음 생성한 상태로 돌아가며 되돌릴 수 없습니다.";
    $lang->confirm_cashbook_init = "초기화를 진행하시겠습니까? ";
    $lang->msg_cashbook_init_success = "초기화가 완료되었습니다.";
    $lang->cmd_init = "초기화를 시작합니다.";
	// ************************************************************************
	// 거래
	// ************************************************************************
	$lang->msg_dont_have_deal_view_grant = "거래를 볼 권한이 없습니다.<br/> 금전출납부 소유자에게 문의하세요.";
	$lang->msg_dont_have_deal_input_grant = "거래를 등록할 권한이 없습니다.<br/> 금전출납부 소유자에게 문의하세요.";
	
	// skins > _menu_deal.html
	$lang->income = "수입";
	$lang->income_list = "수입목록";
	$lang->income_write = "수입등록";
	$lang->outgo = "지출";
	$lang->outgo_list = "지출목록";
	$lang->outgo_write = "지출등록";
	$lang->transfer = "이체";
	$lang->transfer_list = "이체목록";
	$lang->transfer_write = "이체등록";
	$lang->period ="기간";
	$lang->year_deal = "년간거래";
	$lang->month_deal = "월간거래";
	$lang->week_deal = "주간거래";
	$lang->day_deal = "일간거래";
	
	// skins > dashboard_deal.html
	$lang->dashboard = "대시보드";
	$lang->asset_total = '총자산';
	$lang->account_kind = '구분';
	$lang->account_name = '이름';
	$lang->account_balance = '잔액';
	$lang->income = '수입';
	$lang->outgo = '지출';
	$lang->transfer = '이체';
	$lang->customer = '거래처';
	$lang->customer_help = '현재 등록된 거래처 목록입니다.';
	$lang->customer_name = '이름';
	$lang->customer_phone = '전화번호';
    $lang->week_deal_count = '주간거래수';
    $lang->week_deal_count_help = '7일간의 수입/지출/이체 거래수를 표시합니다.';
    
    // skins > deal_list.html, skins > account_list.html, skins > customer_list.html
    $lang->cmd_edit = "수정";
    $lang->cmd_erase = "삭제";
    
    $lang->confirm_delete_income = "수입을 삭제하시겠습니까?";
    $lang->confirm_delete_outgo = "지출을 삭제하시겠습니까?";
    
    // skins > deal_input.html
    $lang->income_edit = "수입수정";
    $lang->outgo_edit = "지출수정";
    $lang->account = "계정";
    $lang->account_help = '계정(현금, 통장, 자산, 카드, 부채)를 선택합니다.<br/>설정 > 계정관리에 등록된 것을 사용합니다.';
    $lang->title = "사용내역";
    $lang->day = '거래일자';
	$lang->day_help = '거래날짜가 다른경우 달력 버튼을 이용하여 날짜를 변경합니다.';
    $lang->amount = '금액';
	$lang->item = '항목';
	$lang->parent_item_header = '::::::::::상위항목::::::::::';
	$lang->child_item_header = '::::::::::하위항목::::::::::';
	$lang->child_item = '하위항목';
    $lang->income_item_help = '수입이 발생한 하위 항목을 선택합니다.<br/>항목을 정확하게 사용해야만 올바른 도표와 보고서를 작성할 수 있습니다.<br/>"설정 > 분류관리 > 수입항목"에서 수입항목을 관리 하실 수 있습니다.';
	$lang->outgo_item_help = '지출이 발생한 하위 항목을 선택합니다.<br/>항목을 정확하게 사용해야만 올바른 도표와 보고서를 작성할 수 있습니다.<br/>"설정 > 분류관리 > 지출항목"에서 지출항목을 관리 하실 수 있습니다.';
	$lang->cashbook_category = "분류";
	$lang->transfer_account = "이체계정";
	//$lang->tag = "";
	$lang->tag_help = "태그를 등록할 때는 콤마(,)로 구분하세요.";
	
	$lang->confirm_insert_income = "수입을 등록하시겠습니까?";
	$lang->confirm_insert_outgo = "지출을 등록하시겠습니까?";
	$lang->confirm_insert_transfer = "이체를 등록하시겠습니까?";
	
	$lang->confirm_update_income = "수입을 수정하시겠습니까?";
	$lang->confirm_update_outgo = "지출을 수정하시겠습니까?";

	// skins > deal_year.html
	$lang->deal_year = "년간거래";
	$lang->deal_year_help = "년간거래";
	// skins > deal_month.html
	$lang->deal_month = "월간거래";
	$lang->deal_month_help = "월간거래";
	$lang->income_sum = "수입총합";
	$lang->outgo_sum = "지출총합";
	$lang->balance  = "합계";
	$lang->year = "년";
	$lang->month = "월";
	// skins > deal_week.html
	$lang->deal_week = "주간거래";
	$lang->deal_week_help = "주간거래";
	// skins > deal_day.html
	$lang->deal_day = "일간거래";
	$lang->deal_day_help = "일간거래";
		
	// ************************************************************************
	// 도표
	// ************************************************************************
	$lang->msg_dont_have_chart_view_grant = "차트를 볼 권한이 없습니다.<br/> 금전출납부 소유자에게 문의하세요.";
	
	// skins > _menu_chart.html
	$lang->deal_chart = "거래그래프";
	$lang->income_item_chart = "수입항목별그래프";
	$lang->outgo_item_chart = "지출항목별그래프";
	$lang->deal_category_chart = "거래분류별그래프";
	$lang->customer_chart = "거래처별그래프";
	$lang->tag_chart = "태그별그래프";
	
	// skins > chart.html
	$lang->deal_chart_help = "거래그래프";
	$lang->income_item_chart_help = "수입항목별그래프";
	$lang->outgo_item_chart_help = "지출항목별그래프";
	$lang->deal_category_chart_help = "거래분류별그래프";
	$lang->customer_chart_help = "거래처별그래프";
	$lang->tag_chart_help = "태그별그래프";
	
	
	// ************************************************************************
	// 보고서
	// ************************************************************************
	$lang->msg_dont_have_report_view_grant = "보고서를 볼 권한이 없습니다.<br/> 금전출납부 소유자에게 문의하세요.";

	
?>
