<?php
    /**
     * 사용자 화면정의
     * 
     * @class  cashbookView
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 View class
     **/

    class cashbookView extends cashbook {
    	/**
         * @brief 초기화
         **/
        function init() {   	
        	// 모델객체생성하기 
        	$oCashbookModel = &getModel('cashbook');

        	// CashbookXE 모듈의 기본정보를 가져온다.
            $this->module_info = $oCashbookModel->getBasicModuleInfo();
            Context::set('module_info',$this->module_info);
            
        	// 스킨 경로를 미리 template_path 라는 변수로 설정함 스킨이 존재하지 않는다면 기본 설정의 스킨으로 설정
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);  	            
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = "default";
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }     
            $this->setTemplatePath($template_path);                        
        }
        
        /**
         * 금전출납부 생성화면
         * 
         * @return unknown_type
         */
        function dispCashbookCreate(){
        	// 모델객체생성하기
        	$oCashbookModel = &getModel('cashbook');
        	$oModuleModel = &getModel('module');

        	// 권한을 검사한다.
        	$hasGrant = $oCashbookModel->hasGrant('create','');
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_create_grant');
            
        	// 스킨 목록을 구해옴
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
            
        	// 템플릿 지정 - 생성
            $this->setTemplateFile('create');
        }
        
    	/**
         * @brief 제어판 > 환경설정 > 기본설정
         * 
         * @return unknown_type
         */
        function dispCashbookConfigBasicEdit(){
        	// 객체생성
        	$oCashbookModel = &getModel('cashbook');
        	
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
        	
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	Context::set('config', $config);
        	
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
			Context::set('isAdmin', $isAdmin);
			
        	// 스킨 목록을 구해옴
            $skin_list = $oCashbookModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
            
            // 분류 목록을 가져옴
            $args->module_srl = $config->module_srl;
            $output = $oCashbookModel->getCategoryListAll($args);          
            Context::set('category_list', $output->data);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('config_basic_edit');
        }
        
    	/**
         * @brief 제어판 > 환경설정 > 분류설정
         * 
         * @return unknown_type
         */
        function dispCashbookConfigCategoryEdit(){
        	// 객체생성
        	$oCashbookModel = &getModel('cashbook');
			
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
        	// 환경설정정보가져오기
            $config = $oCashbookModel->getConfig($args);          
        	Context::set('config', $config);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
            // 분류 목록을 가져옴
            $args->module_srl = $config->module_srl;
            $output = $oCashbookModel->getCategoryListAll($args);   
            Context::set('category_list', $output->data);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('config_category_edit');
        }
		
        /**
         * 제어판 > 환경설정 > 거래설정
         * @return unknown_type
         */
        function dispCashbookConfigDealEdit(){
        	// 객체생성
        	$oCashbookModel = &getModel('cashbook');
        	
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
        	
        	// 설정정보가져오기
            $config = $oCashbookModel->getConfig($args);   	
        	Context::set('config', $config);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('config_deal_edit');
        }
        
    	/**
         * 제어판 > 환경설정 > 권한설정
         * @return unknown_type
         */
        function dispCashbookConfigGrantEdit(){
        	// 객체생성
        	$oCashbookModel = &getModel('cashbook');
        	$oMemberModel = &getModel('member');
        	$oModuleModel = &getModel('module');
        	
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();

        	// 설정정보가져오기
            $config = $oCashbookModel->getConfig($args);
        	Context::set('config', $config);
        	
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
			Context::set('isAdmin', $isAdmin);
			
            // 권한정보가져오기 (conf/module.xml)
            $xml_info = $oModuleModel->getModuleActionXml('cashbook');
            $source_grant_list = $xml_info->grant;
            if(count($source_grant_list)) {
                foreach($source_grant_list as $key => $val) {
                    if(!$val->default) $val->default = 'guest';
                    if($val->default == 'root') $val->default = 'manager';
                    $grant_list->{$key} = $val;
                }
            }
            Context::set('grant_list', $grant_list);
        	
            // 현재 모듈에 설정된 권한 그룹을 가져옴
            $default_grant = array();
            $outputGroup = $oCashbookModel->getGrantGroup($config->module_srl);

            if($config->data) {
                foreach($output->data as $val) {
                    if($val->group_srl == 0) $default_grant[$val->name] = 'all';
                    else if($val->group_srl == -1) $default_grant[$val->name] = 'member';
                    else if($val->group_srl == -2) $default_grant[$val->name] = 'site';
                    else if($val->group_srl == -3) $default_grant[$val->name] = 'owner';
                    else {
                        $selected_group[$val->name][] = $val->group_srl;
                        $default_grant[$val->name] = 'group';
                    }
                }
            }
            Context::set('selected_group', $outputGroup->selected_group);
            Context::set('default_grant', $outputGroup->default_grant);

            // 현재 모듈에 설정된 관리자 아이디를 추출
            $admin_member = $oModuleModel->getAdminId($config->module_srl);
            Context::set('admin_member', $admin_member);

            // 그룹을 가져옴
            $group_list = $oMemberModel->getGroups($this->module_info->site_srl);            
            Context::set('group_list', $group_list);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('config_grant_edit');
        }
        
    	/**
         * @brief 제어판 > 정보관리 > 계정관리 > 계정목록
         * 
         * @return unknown_type
         */
        function dispCashbookAccountList(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
		
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
            // 조건설정
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'kind' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            // 종류검색 (한국어)
							if($search_keyword=='현금'){
								$search_keyword = "1";
							}
                			if($search_keyword=='은행'){
								$search_keyword = "2";
							}
                			if($search_keyword=='자산'){
								$search_keyword = "3";
							}
                			if($search_keyword=='카드'){
								$search_keyword = "4";
							}
                			if($search_keyword=='부채'){
								$search_keyword = "5";
							}
                            $args->s_kind = $search_keyword;
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }

            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 목록수
            $list_count = Context::get('list_count');
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			$args->amount = 0;	// 0보다 큰넘만 가져오기 위한 필수 조건

			// 목록가져오기
            $output = $oCashbookModel->getAccountList($args);

            // 화면에서 사용할 데이터 설정
            Context::set('page', $args->page);
        	Context::set('account_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_list');
        }
        
        /**
         * 제어판 > 정보관리 > 계정관리 > 현금계정등록
         * @return unknown_type
         */
        function dispCashbookAccountCashWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
			Context::set('isAdmin', $isAdmin);
			
            // 거래일자에 기본값을 주기 위해
            $currentDate = $oCashbookModel->getYear($args).$oCashbookModel->getMonth($args).$oCashbookModel->getDay($args); 
			Context::set('currentDate', $currentDate);


        	
        	// 현금계정분류가져오기
            if($args->act=='dispCashbookAccountCashWrite' && $config->cash_account_category > 0){
	            $args->category_srl = $config->cash_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);
	            Context::set('category_list', $output->data);
            }
        	// 은행계정분류가져오기
            if($args->act=='dispCashbookAccountBankWrite' && $config->bank_account_category > 0){
	            $args->category_srl = $config->bank_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output->data);
            }
        	// 자산계정분류가져오기
            if($args->act=='dispCashbookAccountAssetWrite' && $config->asset_account_category > 0){
	            $args->category_srl = $config->asset_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output->data);
            }
        	// 카드계정분류가져오기
            if($args->act=='dispCashbookAccountCardWrite' && $config->card_account_category > 0){
	            $args->category_srl = $config->card_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output->data);
            }
        	// 부채계정분류가져오기
            if($args->act=='dispCashbookAccountDebtWrite' && $config->debt_account_category > 0){
	            $args->category_srl = $config->debt_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output->data);
            }
            
			// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
        /**
         * 제어판 > 정보관리 > 계정관리 > 은행계정등록
         * @return unknown_type
         */
        function dispCashbookAccountBankWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	$this->dispCashbookAccountCashWrite();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 자산계정등록
         * @return unknown_type
         */
        function dispCashbookAccountAssetWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	$this->dispCashbookAccountCashWrite();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 카드계정등록
         * @return unknown_type
         */
        function dispCashbookAccountCardWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	$this->dispCashbookAccountCashWrite();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 부채계정등록
         * @return unknown_type
         */
        function dispCashbookAccountDebtWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	$this->dispCashbookAccountCashWrite();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 현금계정수정
         * @return unknown_type
         */
        function dispCashbookAccountCashEdit(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
			// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
 			// 파라미터설정
			$args->parent_srl = 0;

            $output = $oCashbookModel->getAccount($args);
            Context::set('account', $output);

        	// 현금계정분류가져오기
            if($output->kind==1 && $config->cash_account_category>0){
	            $args->category_srl = $config->cash_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);            
	            Context::set('category_list', $output->data);
            }
            
        	// 은행계정분류가져오기
            if($output->kind==2 && $config->bank_account_category>0){
	            $args->category_srl = $config->bank_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);
	            Context::set('category_list', $output->data);
            }
            
        	// 자산계정분류가져오기
            if($output->kind==3 && $config->asset_account_category>0){
	            $args->category_srl = $config->asset_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);
	            Context::set('category_list', $output->data);
            }
            
            // 카드계정분류가져오기
            if($output->kind==4 && $config->card_account_category>0){
	            $args->category_srl = $config->card_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);
	            Context::set('category_list', $output->data);
            }
	            
        	// 부채계정분류가져오기
            if($output->kind==5 && $config->debt_account_category>0){
	            $args->category_srl = $config->debt_account_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);
	            Context::set('category_list', $output->data);
            }

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 은행계정수정
         * @return unknown_type
         */
        function dispCashbookAccountBankEdit(){
        	$this->dispCashbookAccountCashEdit();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 자산계정수정
         * @return unknown_type
         */
        function dispCashbookAccountAssetEdit(){
        	$this->dispCashbookAccountCashEdit();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 카드계정수정
         * @return unknown_type
         */
        function dispCashbookAccountCardEdit(){
        	$this->dispCashbookAccountCashEdit();
        }
        
    	/**
         * 제어판 > 정보관리 > 계정관리 > 부채계정수정
         * @return unknown_type
         */
        function dispCashbookAccountDebtEdit(){
        	$this->dispCashbookAccountCashEdit();
        }
        
    	/**
         * 제어판 > 정보관리 > 거래처관리 > 거래처목록
         * @return unknown_type
         */
        function dispCashbookCustomerList(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
            // 조건설정
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;

        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			$search_param = $oCashbookModel->getCustomerSearchParameter($search_target,$search_keyword);
			            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "customer_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			Context::set('page', $output->page);

			// 쿼리실행
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCustomerList($args);

            // 데이터담기
			Context::set('page', $output->page);
            Context::set('customer_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿지정
			$this->setTemplateFile('customer_list');
        }
		
    	/**
         * 제어판 > 정보관리 > 거래처관리 > 거래처등록
         * @return unknown_type
         */
        function dispCashbookCustomerWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	// 거래처분류가져오기
            if($config->customer_category > 0){
	            $args->category_srl = $config->customer_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output->data);
            }

			// 템플릿 지정 - 생성
			$this->setTemplateFile('customer_input');
        }
        
    	/**
         * @brief 제어판 > 정보관리 > 거래처관리 > 거래처수정
         * 
         * @return unknown_type
         */
        function dispCashbookCustomerEdit(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	
        	// 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	// 거래처분류가져오기
            if($config->customer_category > 0){
	            $args->category_srl = $config->customer_category;
	            $output = $oCashbookModel->getCategoryItemListAll($args);	            
	            Context::set('category_list', $output);
            }

            $output = $oCashbookModel->getCustomer($args);           
            Context::set('customer', $output);
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('customer_input');
        }
        
    	/**
         * @brief 제어판 > 정보관리 > 분류관리 > 분류목록
         * @return unknown_type
         */
        function dispCashbookCategoryList(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
		
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
            // 조건설정
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
        	// 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "category_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법

            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			Context::set('page', $output->page);
			
			// 쿼리실행
            $output = $oCashbookModel->getCategoryList($args);
      
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('category_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
			
            // 템플릿파일설정
            $this->setTemplateFile('category_list');
        }
        
    	/**
         * @brief 제어판 > 정보관리 > 분류관리 > 분류등록
         * 
         * @return unknown_type
         */
        function dispCashbookCategoryWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
		
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
            $this->setTemplateFile('category_write');
        }
        
    	/**
         * @brief제어판 > 정보관리 > 분류관리 > 분류수정
         **/
        function dispCashbookCategoryManagement() {
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
		
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
			Context::set('isAdmin', $isAdmin);
			
            // 넘어온값이 없으면 목록으로
            if(!$args->category_srl) {
            	return $this->dispCashbookCategoryList();
            }

            // 분류의 정보를 가져옴
            $oCashbookModel = &getModel('cashbook');
			$category_info = $oCashbookModel->getCategory($args->category_srl);

            if($category_info->category_srl != $args->category_srl) {
            	return $this->dispCategoryList();
            }

            Context::set('category_info', $category_info);

            // 레이아웃을 팝업으로 지정
            $this->setTemplateFile('category_management');
        }
        
    	/**
         * @brief 제어판 > 정보관리 > 분류관리 > 분류입력/수정폼
         * 
         * 특정 cashbook_category_srl의 정보를 이용하여 템플릿을 구한후 return
         * 특정 메뉴의 정보를 추가하기 위해 서버에서 tpl을 컴파일 한후 컴파일 된 html을 직접 return
         **/
    	function dispCashbookCategoryItemInputTpl() {
    		$oCashbookModel = &getModel('cashbook');
    		
            // 해당 메뉴의 정보를 가져오기 위한 변수 설정
            $category_item_srl = Context::get('category_item_srl');
            $parent_srl = Context::get('parent_srl');

            // 회원 그룹의 목록을 가져옴
            $oMemberModel = &getModel('member');
            $group_list = $oMemberModel->getGroups();
            Context::set('group_list', $group_list);

            // parent_srl이 있고 cashbook_category_item_srl이 없으면 하부 메뉴 추가임
            if(!$category_item_srl && $parent_srl) {
                // 상위 메뉴의 정보를 가져옴
                $parent_info = $oCashbookModel->getCategoryItem($parent_srl);

                // 추가하려는 메뉴의 기본 변수 설정 
                $item_info->category_item_srl = getNextSequence();
                $item_info->parent_srl = $parent_srl;
                $item_info->parent_category_name = $parent_info->name;

            // root에 메뉴 추가하거나 기존 메뉴의 수정일 경우
            } else {
                // category_item_srl 이 있으면 해당 메뉴의 정보를 가져온다
                if($category_item_srl) {
                	$item_info = $oCashbookModel->getCategoryItem($category_item_srl);
                }

                // 찾아진 값이 없다면 신규 메뉴 추가로 보고 cashbook_category_item_srl값만 구해줌
                if(!$item_info->category_item_srl) {
                    $item_info->category_item_srl = getNextSequence();
                }
            }
            Context::set('item_info', $item_info);

            // template 파일을 직접 컴파일한후 tpl변수에 담아서 return한다.
            $oTemplate = &TemplateHandler::getInstance();
            
            // 일단은 템플릿파일의 위치를 고정시킨다. 나중에 스킨을 받아와서 처리할 것.
            $tpl = $oTemplate->compile($this->module_path.'skins/'.'default/', 'category_item_input_tpl');	//category_item_input_tpl.html파일을의미한다.
			
            // 엔터처리
            $tpl = str_replace("\n"," ",$tpl);
            $tpl = str_replace("\r"," ",$tpl);
            $tpl = str_replace("\n\r"," ",$tpl);
            $this->add('tpl', $tpl);
        }
		
        /**
         * @brief 제어판 > 데이터관리 > 초기화
         * 
         * 금전출납부 초기화면
         * 사용자 기본 액션
         * 
         * @return unknown_type
         */
        function dispCashbookInit(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
		
            // 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	if(!$isAdmin) return new Object(-1,'msg_dont_have_admin_grant');
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('init');
        }

    	/**
         * @brief 거래 > 대시보드
         * 금전출납부 초기화면
         * 사용자 기본 액션
         * 
         * @return unknown_type
         */
        function dispCashbookDealDashboard(){
        	
        	// 모델객체생성하기
        	$oCashbookModel = &getModel('cashbook');
        	
        	// form이나 get으로 요청이 들어온 변수를 할당한다. 
        	$args = Context::getRequestVars();
			
        	// 넘어온 mid가 create 권한을 설정하기 위한 mid인지 검사
        	//$isMidForCreate = $oCashbookModel->isMidForCreate($args->mid);
        	//if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');
        	
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');

			// 설정을 가져온다.
            $config = $oCashbookModel->getConfig($args);
			
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 설정이 있다면
            if($config!=null){
            	// 자산합계산
            	$args->total_asset_yn = "Y";
            	$args->module_srl = $config->module_srl;
            	$args->order_target = "input_date";
            	$args->order_type = "desc";
                   	
            	$output = $oCashbookModel->getAssetSum($args);
           	
				Context::set('asset_total', $output->asset_total);
		        Context::set('account_list', $output->account_list);

		        // 주간거래를 가져온다.
		        $output = $oCashbookModel->getLastWeekDeal();
		        Context::set('deal_week_list', $output->data);
		        
		        // 	거래처가져오기
	            $output = $oCashbookModel->getCustomerList($args);
		        Context::set('customer_list', $output->data);

		        // 설정저장하기
		        Context::set('config', $config);
		        
            	// 템플릿 지정 - 대쉬보드
				$this->setTemplateFile('dashboard_deal');
            } else {
            	return $this->stop('msg_you_must_create_at_first');
            }
        }
        
    	/**
         * @brief 거래 > 수입 > 수입목록
         * 
         * @return unknown_type
         */
        function dispCashbookDealIncomeList(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	

     		// 로그인이 되어 있는지 체크
            // if(!Context::get('is_logged')) return new Object(-1,'msg_not_logged');
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');       	
        	
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			$args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
        	$search_param = $oCashbookModel->getDealSearchParameter($search_target,$search_keyword);

            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 목록수
            $list_count = Context::get('list_count');
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			$args->amount = 0;	// 0보다 큰넘만 가져오기 위한 필수 조건

			// 목록가져오기
            $output = $oCashbookModel->getIncomeList($args);

            // 화면에서 사용할 데이터 설정
            Context::set('page', $args->page);
        	Context::set('deal_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
        /**
         * @brief 거래 > 수입 > 수입등록
         * @return unknown_type
         */
        function dispCashbookDealIncomeWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 로그인이 되어 있는지 체크
            // if(!Context::get('is_logged')) return new Object(-1,'msg_not_logged');
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_input', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_input_grant');
        	
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			$args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 거래일자에 기본값을 주기 위해
            $currentDate = $oCashbookModel->getYear($args).$oCashbookModel->getMonth($args).$oCashbookModel->getDay($args); 
			Context::set('currentDate', $currentDate);

            // 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 계정가져오기
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            $output = $oCashbookModel->getAccountListAll($args);         
            Context::set('account_list', $output->data);
            
	        // 수입항목가져오기
            $args->category_srl = $config->income_item;
	        $args->parent_srl = 0;
	        $output = $oCashbookModel->getCategoryItemListAll($args);        
			Context::set('item_list', $output->data);

			// 거래분류가져오기
			$args->category_srl = $config->deal_category;
			$output = $oCashbookModel->getCategoryItemListAll($args);					
			Context::set('category_list', $output->data);
			
			// 거래처가져오기
			$output = $oCashbookModel->getCustomerList($args);			
			Context::set('customer_list', $output->data);
        	
			// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
        /**
         * @brief 거래 > 수입 > 수입수정
         * @return unknown_type
         */
        function dispCashbookDealIncomeEdit(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_input', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_input_grant');
        	
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl = $config->site_srl;
        	$args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;
			
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 계정목록가져오기
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            // 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 계정가져오기
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            $output = $oCashbookModel->getAccountListAll($args);         
            Context::set('account_list', $output->data);
            
	        // 수입항목가져오기
            $args->category_srl = $config->income_item;
	        $args->parent_srl = 0;
	        $output = $oCashbookModel->getCategoryItemListAll($args);        
			Context::set('item_list', $output->data);

			// 거래분류가져오기
			$args->category_srl = $config->deal_category;
			$output = $oCashbookModel->getCategoryItemListAll($args);					
			Context::set('category_list', $output->data);
			
			// 거래처가져오기
			$output = $oCashbookModel->getCustomerList($args);			
			Context::set('customer_list', $output->data);

            // 수입정보가져오기
            $output = $oCashbookModel->getDeal($args);
            Context::set('deal', $output);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 거래 > 지출 > 지출목록
         * 
         * @return unknown_type
         */
        function dispCashbookDealOutgoList(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
			
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');
        	
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
        	$search_param = $oCashbookModel->getDealSearchParameter($search_target,$search_keyword);
			
        	debugPrint($search_param);
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 목록수
            $list_count = Context::get('list_count');
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			$args->amount = 0;	// 0보다 큰넘만 가져오기 위한 필수 조건

			// 목록가져오기
            $output = $oCashbookModel->getOutgoList($args);
            
            // 화면에서 사용할 데이터 설정
            Context::set('page', $args->page);
        	Context::set('deal_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
        /**
         * @brief 거래 > 지출 > 지출등록
         * @return unknown_type
         */
        function dispCashbookDealOutgoWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_input', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_input_grant');
        	
            // 거래일자에 기본값을 주기 위해
            $currentDate = $oCashbookModel->getYear($args).$oCashbookModel->getMonth($args).$oCashbookModel->getDay($args); 
			Context::set('currentDate', $currentDate);

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 계정가져오기
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            $output = $oCashbookModel->getAccountListAll($args);     
            Context::set('account_list', $output->data);
            
	        // 지출항목가져오기
            $args->category_srl = $config->outgo_item;
	        $args->parent_srl = 0;
	        $output = $oCashbookModel->getCategoryItemListAll($args);            
			Context::set('item_list', $output->data);
			
			// 거래분류가져오기
			$args->category_srl = $config->deal_category;
			$output = $oCashbookModel->getCategoryItemListAll($args);		
			Context::set('category_list', $output->data);
			
			// 거래처가져오기
			$output = $oCashbookModel->getCustomerList($args);			
			Context::set('customer_list', $output->data);
			
			// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 거래 > 지출 > 지출수정
         * @return unknown_type
         */
        function dispCashbookDealOutgoEdit(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_input_grant');

            // 거래일자에 기본값을 주기 위해
            $currentDate = $oCashbookModel->getYear($args).$oCashbookModel->getMonth($args).$oCashbookModel->getDay($args); 
			Context::set('currentDate', $currentDate);

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 계정가져오기
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
	        // 지출항목가져오기
            $args->category_srl = $config->outgo_item;
	        $args->parent_srl = 0;
	        $output = $oCashbookModel->getCategoryItemListAll($args);            
			Context::set('item_list', $output->data);
			
			// 거래분류가져오기
			$args->category_srl = $config->deal_category;
			$output = $oCashbookModel->getCategoryItemListAll($args);		
			Context::set('category_list', $output->data);
			
			// 거래처가져오기
			$output = $oCashbookModel->getCustomerList($args);			
			Context::set('customer_list', $output->data);
			
			// 지출정보가져오기
            $output = $oCashbookModel->getDeal($args);
            Context::set('deal', $output);
            
			// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief @brief 거래 > 이체 > 이체목록
         * 
         * @return unknown_type
         */
        function dispCashbookDealTransferList(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
            
			// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
			
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');
        	
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
        	$search_param = $oCashbookModel->getDealSearchParameter($search_target,$search_keyword);

            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 목록수
            $list_count = Context::get('list_count');
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			$args->transfer_srl = 0;	// 0보다 큰넘만 가져오기 위한 필수 조건

			// 목록가져오기
            $output = $oCashbookModel->getTransferList($args);
            
            // 화면에서 사용할 데이터 설정
            Context::set('page', $args->page);
        	Context::set('deal_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
        /**
         * @brief 거래 > 이체 > 이체등록
         * @return unknown_type
         */
        function dispCashbookDealTransferWrite(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_input_grant');
        	
            // 거래일자에 기본값을 주기 위해
            $currentDate = $oCashbookModel->getYear($args).$oCashbookModel->getMonth($args).$oCashbookModel->getDay($args); 
			Context::set('currentDate', $currentDate);

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
        	// 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 계정가져오기
            $output = $oCashbookModel->getAccountListAll($args);     
            Context::set('account_list', $output->data);

			// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
        /**
         * @brief 거래 > 기간 > 년간거래
         * @return unknown_type
         */
        function dispCashbookDealYear(){
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_year');
        }
        
    	/**
         * @brief 거래 > 기간 > 월간거래
         * @return unknown_type
         */
        function dispCashbookDealMonth(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 	
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');
        	
        	$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
        	if(Context::get('pYear')==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= Context::get('pYear');
        	}
        	if(Context::get('pMonth')==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= Context::get('pMonth');
        	}

        	$oCashbookCalendar = new CashbookCalendar($pYear,$pMonth);      	
        	Context::set('todayYear',$todayYear);
        	Context::set('todayMonth',$todayMonth);
        	Context::set('todayDay',$todayDay);
        	
        	Context::set('pYear',$pYear);
        	Context::set('pMonth',$pMonth);
        	Context::set('cashbookCalendar',$oCashbookCalendar);
			
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 조건설정
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;

        	// 수입총합 가져오기
        	$args->amount = 0;
        	$args->start_day = $pYear . $pMonth . "01";
        	$args->end_day = $pYear . $pMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);

        	if($pMonth<10){
				$tempMonth = "0".$pMonth;
			} else {
				$tempMonth = $pMonth;
			}
			$args->start_day = $pYear . $tempMonth . "01";
			$args->end_day = $pYear . $tempMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);
			
			// 수입총합 가져오기
            $output = $oCashbookModel->getIncomePeriodSum($args);
            Context::set('income_sum', $output);

            // 지출총합 가져오기
            $output = $oCashbookModel->getOutgoPeriodSum($args);
            Context::set('outgo_sum', $output);
			
            // 전월계산하기
            if($pMonth==1){
            	$prevYear = $pYear - 1;
            	$prevMonth = 12;
            } else {
            	$prevYear = $pYear;
            	$prevMonth = $pMonth - 1;
            }
            Context::set('prevYear', $prevYear);
            Context::set('prevMonth', $prevMonth);
            
            // 익월계산하기
        	if($pMonth==12){
            	$nextYear = $pYear + 1;
            	$nextMonth = 1;
            } else {
            	$nextYear = $pYear;
            	$nextMonth = $pMonth + 1;
            }
            Context::set('nextYear', $nextYear);
            Context::set('nextMonth', $nextMonth);
           
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_month');
        }
        
    	/**
         * @brief 거래 > 기간 > 주간거래
         * @return unknown_type
         */
        function dispCashbookDealWeek(){
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_week');
        }
        
    	/**
         * @brief 거래 > 기간 > 일간거래
         * @return unknown_type
         */
        function dispCashbookDealDay(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
            // 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('deal_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_deal_view_grant');
        	
        	$initPeriod = Context::get('initPeriod');
        	if(!$initPeriod) $initPeriod= "N";
        	Context::set('initPeriod',$initPeriod);
        	
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
            // 조건설정
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;
           
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
			
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'day' :
                            $args->s_day = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'item' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_item_name = $search_keyword;
                        break;
                    case 'category' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_category_name = $search_keyword;
                        break;
                    case 'customer' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_customer_name = $search_keyword;
                        break;
                    case 'tag' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_tag = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 시작일, 종료일
        	$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일

        	if(Context::get('startDate')==null){
        		$pYear = $todayYear;
	        	if($pMonth<10){
					$tempMonth = "0".$pMonth;
				} else {
					$tempMonth = $pMonth;
				}
        		$pStartDate = $todayYear . $tempMonth . "01";
        	} else {
        		$pStartDate= Context::get('startDate');
        		$pYear = substr($pStartDate,0,3);
        	}
        	if(Context::get('endDate')==null){
        		$pYear = $todayYear;
        		$pMonth = $todayMonth;
        		if($pMonth<10){
					$tempMonth = "0".$pMonth;
				} else {
					$tempMonth = $pMonth;
				}
        		$oCashbookCalendar = new CashbookCalendar($pYear,$pMonth);
        		$pEndDate = $todayYear . $tempMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);
        	} else {
        		$pEndDate= Context::get('endDate');
        		$pYear = substr($pEndDate,0,3);
        	}
        	$args->start_day = $pStartDate;
        	$args->end_day = $pEndDate;
        	Context::set('startDate',$pStartDate);
        	Context::set('endDate',$pEndDate);

        	$args->amount = 0;
        	
			// 수입총합 가져오기
            $output = $oCashbookModel->getIncomePeriodSum($args);
            Context::set('income_sum', $output);
            
            // 지출총합 가져오기
            $output = $oCashbookModel->getOutgoPeriodSum($args);
            Context::set('outgo_sum', $output);
            
        	// 쿼리실행
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getDealListByPeriod($args);           
            Context::set('deal_list', $output);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_day');
        }
        
        /**
         * 차트 > 대시보드
         * @return unknown_type
         */
        function dispCashbookChartDashboard(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
			// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
        	
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('dashboard_chart');
        }
        
        /**
         * 차트 > 거래차트
         * @return unknown_type
         */
        function dispCashbookChartDeal(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
        	
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');			
        }
        
    	/**
         * 차트 > 수입항목별차트
         * @return unknown_type
         */
        function dispCashbookChartIncomeItem(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
        	
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 차트 > 지출항목별차트
         * @return unknown_type
         */
        function dispCashbookChartOutgoItem(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
        	
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
            
    	/**
         * 차트 > 거래분류별차트
         * @return unknown_type
         */
        function dispCashbookChartDealCategory(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
			
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
                
    	/**
         * 차트 > 거래처별차트
         * @return unknown_type
         */
        function dispCashbookChartCustomer(){ 
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
			
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 차트 > 태그류별차트
         * @return unknown_type
         */
        function dispCashbookChartTag(){
        	// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 권한체크
        	$hasGrant = $oCashbookModel->hasGrant('chart_view', $args->mid);
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_chart_view_grant');
			
        	// 환경설정정보 가져옴
            $config = $oCashbookModel->getConfig($args);
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            
            // 권한을 검사하여 저장한다.
        	$isAdmin = $oCashbookModel->isAdmin($config);
        	Context::set('isAdmin', $isAdmin);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
    }
?>