<?php
    /**
     * 관리자모듈 업무 처리
     * 
     * @class  cashbookAdminController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 admin controller class
     **/

    class cashbookAdminController extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {

        }
        
    	/**
         * 설정 수정
         * 대상테이블: modules, module_config, module_grants
         * 
         * @return unknown_type
         */
        function procCashbookAdminSetup() {
			//form이나 get으로 요청이 들어온 변수를 할당한다.
	        $args = Context::getRequestVars(); 						// form or get
			
            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');
            $oCashbookModel = &getModel('cashbook');
            
            // 금전출납부기본설정가져오기
            $basic_cashbook_module_info = $oCashbookModel->getBasicModuleInfo();

            // 데이터수정(테이블: module_config)
            $cashbook->mid = $args->mid;
            $cashbook->create_message = $args->create_message;
            $oModuleController->insertModuleConfig('cashbook', $cashbook);

            // 데이터입력(테이블: module_grants)
        	$xml_info = $oModuleModel->getModuleActionXML('cashbook');
            $grant_list = $xml_info->grant;
debugPrint($grant_list);
			foreach($grant_list as $grant_name => $grant_info) {
                // default값을 구함
                $default = Context::get($grant_name.'_default');

                // -1 = 로그인 사용자만, -2 = 사이트 가입자만, 0 = 모든 사용자
                if(strlen($default)){
                    $grant->{$grant_name}[] = $default;
                    continue;

                // 특정 그룹 사용자
                } else {
                    $group_srls = Context::get($grant_name);
                    if($group_srls) {
                        if(strpos($group_srls,'|@|')!==false) $group_srls = explode('|@|',$group_srls);
                        elseif(strpos($group_srls,',')!==false) $group_srls = explode(',',$group_srls);
                        else $group_srls = array($group_srls);
                        $grant->{$grant_name} = $group_srls;
                    }
                    continue;
                }
                $grant->{$group_srls} = array();
            }

            $output = executeQuery('module.deleteModuleGrants', $args);
            if(!$output->toBool()) return $output;

            // DB에 권한 저장 
            foreach($grant as $grant_name => $group_srls) {
                foreach($group_srls as $key => $val) {
                    $args->name = $grant_name;
                    $args->group_srl = $val;
                    $output = executeQuery('module.insertModuleGrant', $args);
debugPrint($output);                    
                    if(!$output->toBool()) return $output;
                }
            }

            // 데이터수정(테이블: modules)
            $args->module_srl = $basic_cashbook_module_info->module_srl;
            $output = $oCashbookModel->updateModule($args);
            
            $this->setMessage("success_saved");
        }
        
        function procCashbookAdminDelete(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
	        $args = Context::getRequestVars();
	        
	        $oCashbookAdminModel = &getAdminModel('cashbook');

	        // 1.module_admin
	        $output = $oCashbookAdminModel->deleteModuleAdmins($args);
	        debugPrint($output);
	        // 2.module_grants
	        $oCashbookAdminModel->deleteModuleGrants($args);
	        // 3.module_part_config
	        $oCashbookAdminModel->deleteModulePartConfig($args);
	        // 1.modules
	        $oCashbookAdminModel->deleteModules($args);
	        
        	$this->setMessage("success_delete");
        }
        
    }
?>