<?php
    /**
     * 관리자모듈 업무 처리
     * 
     * @class  cashbookAdminController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 admin controller class
     **/

    class cashbookAdminController extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {

        }
        
    	/**
         * 설정 수정
         * 대상테이블: modules, module_config, module_grants
         * 
         * @return unknown_type
         */
        function procCashbookAdminSetup() {
			//form이나 get으로 요청이 들어온 변수를 할당한다.
	        $args = Context::getRequestVars(); 						// form or get
			
            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');
            $oCashbookModel = &getModel('cashbook');
            
            // 금전출납부기본설정가져오기
            $basic_cashbook_module_info = $oCashbookModel->getBasicModuleInfo();

            // 데이터수정(테이블: module_config)
            $cashbook->mid = $args->mid;
            $cashbook->create_message = $args->create_message;
            $oModuleController->insertModuleConfig('cashbook', $cashbook);
			
            // 데이터입력(테이블: module_grants)         
            $grants = $args->create;         
        	$grant_array = explode('|@|', $grants, 2);
        	foreach($grant_array as $key => $val){
            	$grant["create"][$key] = $val;
            	$oModuleController->insertModuleGrants($args->module_srl, $grant); 
            }
            
            // module_grants에 입력된 데이터가 module_extra_vars에 입력되지 않도록 create 값 초기화
            $args->create = "";
            // module_extra_vars 쓰레기값이 입력되지 않도록 _filter 값 초기화
            $args->_filter = "";
            
            // 데이터수정(테이블: modules, module_extra_vars)
            $args->module_srl = $basic_cashbook_module_info->module_srl;
            $output = $oModuleController->updateModule($args);
            
            $this->setMessage("success_saved");
        }
        
    }
?>