<?php
    /**
     * 사용자 업무 처리
     * conf/module.xml에 작성된 순서대로 function을 정의한다.
     * 
     * @class  cashbookController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 Controller class
     **/

    class cashbookController extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {
        	// 모델객체생성하기
            $oCashbookModel = &getModel('cashbook');
            
            // CashbookXE 모듈의 기본정보를 가져온다.
            $this->module_info = $oCashbookModel->getBasicModuleInfo();
            Context::set('module_info',$this->module_info);
        }
        
    	/**
         * @brief 금전출납부 생성
         **/
        function procCashbookCreate() {
			// 모델객체생성하기
        	$oCashbookModel = &getModel('cashbook');
        	
        	// Context에 저장된 값을 가져온다.
        	$logged_info = Context::get('logged_info');
        	$site_module_info = Context::get('site_module_info');
        	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
        	// 권한을 검사한다.
        	$hasGrant = $oCashbookModel->hasGrant('create');
        	if(!$hasGrant) return new Object(-1,'msg_dont_have_create_grant');

			// 해당 mid가 금지된 mid가 아닌지 검사한다.            
            if(in_array($args->mid, array('www','naver','hangame','promotion','notice','group','team','center','division','tf','faq','question','uit') )) {
            	return new Object(-1,'msg_denied_cashbook_mid');
            }
			
            // 해당 mid가 이미 있는지 검사한다.
            // 모듈에서 사용중인 mid가 있는지를 검사한다.
            $checkDupe = $oCashbookModel->getModule($args);          
            if($checkDupe->data[0]->module_srl) return new Object(-1,'msg_exists_mid');

            // 신청한 금전출납부 이름이 기본 모듈 이름 등과 겹치지 않도록 금지 아이디 목록에 있는지 검사
            if($oCashbookModel->isDeniedID($args->mid)) return new Object(-1,'msg_denied_cashbook_mid');

			// 데이터입력 (테이블: modules, module_extra_vars)
            $args->module_srl = getNextSequence();					// 일련번호
            $args->module = 'cashbook';
            $args->module_category_srl = 0;
            $args->layout_srl = $this->module_info->layout_srl;
            $args->site_srl = $site_module_info->site_srl;
            $args->is_default = 'N';
            $args->open_rss   = 'N';
            $output = $oCashbookModel->insertModule($args);
                                    
			// 기본값 입력하기
			$args->member_srl = $logged_info->member_srl;
			$oCashbookModel->setDefaultAccountData($args);		                                  // 계정
			$output_income_data = $oCashbookModel->setDefaultIncomeData($args);                   // 수입항목
			$output_outgo_data = $oCashbookModel->setDefaultOutgoData($args);	                  // 지출항목
			$output_deal_data = $oCashbookModel->setDefaultDealCategoryData($args);	              // 거래분류
			$output_cash_account_data = $oCashbookModel->setDefaultCashAccountData($args);	      // 현금계정분류
			$output_bank_account_data = $oCashbookModel->setDefaultBankData($args);		          // 은행계정분류
			$output_asset_account_data = $oCashbookModel->setDefaultAssetData($args);		      // 자산계정분류
			$output_card_account_data = $oCashbookModel->setDefaultCardData($args);	              // 카드계정분류
			$output_debt_account_data = $oCashbookModel->setDefaultDebtData($args);	              // 부채계정분류
			$output_customer_data = $oCashbookModel->setDefaultCustomerData($args);	              // 거래처분류
			
            // 데이터입력 (테이블: module_admin)        
            $output = $oCashbookModel->insertAdminId($args->module_srl, $logged_info->user_id);

            // 데이터입력(테이블: module_part_config)
            $part_config_arr = array();
            
            // 데이터설정 (보고서작성기준설정)
            $part_config->family_type = $args->family_type;                      // 가족유형
            $part_config->child_count = $args->child_count;                      // 자녀수
            $part_config->month_income = $args->month_income;                    // 월소득
            $part_config->start_day = $args->start_day;                          // 월시작일
            
            // 데이터설정 (거래내역작성기준설정)
            $part_config->deal_category = $output_deal_data->category_srl;                      // 거래분류  
            $part_config->income_item = $output_income_data->category_srl;                      // 수입항목
            $part_config->outgo_item  = $output_outgo_data->category_srl;                       // 지출항목
            $part_config->cash_account_category = $output_cash_account_data->category_srl;      // 현금계정분류
            $part_config->bank_account_category = $output_bank_account_data->category_srl;      // 은행계정분류
            $part_config->asset_account_category = $output_asset_account_data->category_srl;    // 자산계정분류
            $part_config->card_account_category = $output_card_account_data->category_srl;      // 카드계정분류
            $part_config->debt_account_category = $output_debt_account_data->category_srl;      // 부채계정분류
            $part_config->customer_category = $output_customer_data->category_srl;              // 거래처분류

            // 데이터설정 (화면표시설정)
            $part_config->lunar_yn     = "N";                   // 음력표시여부
            $part_config->memorial_yn     = "N";                // 기념일표시여부
            $part_config->income_list_count = "20";             // 수입목록수
            $part_config->outgo_list_count = "20";              // 지출목록수
            $part_config->transfer_list_count = "20";           // 이체목록수
            $part_config->currency = $args->currency;           // 통화
            $part_config_arr[] = $part_config;
            
            $output = $oCashbookModel->insertModulePartConfig('cashbook', $args->module_srl, $part_config_arr);

            // 데이터입력(테이블: module_grants), -3은 소유자...
            $grant = array();
            $grant["manager"][]           = -3;    // 관리
            $grant["deal_view"][]         = -3;    // 거래보기
            $grant["deal_input"][]        = -3;    // 거래입력
            $grant["chart_view"][]        = -3;    // 차트보기
            $grant["report_view"][]        = -3;   // 보고서보기            
            $output = $oCashbookModel->insertModuleGrants($args->module_srl, $grant);
			
            // filter로 넘겨줄 값설정, $this객체에 add()로 변수를 등록하여 호출하여 XMLRPC로 리턴시 값을 추가함
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('msg_success_create_cashbook');
			}
            $this->add('mid', $args->mid);
            $this->add('mid_url', getUrl('','mid',$args->mid));
        }
        
    	/**
         * 금전출납부 기본설정 수정
         * 
         * @return unknown_type
         */
        function procCashbookConfigUpdate(){
        	// 객체생성
        	$oCashbookModel = &getModel('cashbook');
        	$oModuleController = &getController('module');
        	$oMemberModel = &getModel('member');
        	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
			
            // modules 수정
            if($args->ret_act=="dispCashbookConfigBasicEdit" && $args->mid){
				// 해당 mid가 금지된 mid가 아닌지 검사한다.            
	            if(in_array($args->mid, array('www','naver','hangame','promotion','notice','group','team','center','division','tf','faq','question','uit') )) {
	            	return new Object(-1,'msg_denied_cashbook_title');
	            }

	            // 신청한 금전출납부 이름이 기본 모듈 이름 등과 겹치지 않도록 금지 아이디 목록에 있는지 검사
	            // 금지 아이디 목록 - 기본 모듈과 사용자 지정 금지 아이디
	            if($oMemberModel->isDeniedID($args->mid)) return new Object(-1,'msg_denied_cashbook_title');

	        	// modules 테이블에 입력할 정보 설정
	            $args->is_default = 'N';
	            $args->open_rss = 'N';
	            $output = $oModuleController->updateModule($args);
            }
            
            // module_part_config 수정 (삭제 후 재입력)
            $part_config_arr = array();
            
            // 환경설정정보 가져옴            
            $part_config = $oCashbookModel->getConfig($args);
            // 데이터설정 (보고서작성기준설정)
            if($args->family_type!=null){
            	$part_config->family_type = $args->family_type;                      // 가족유형
            }
            if($args->child_count!=null){
            	$part_config->child_count = $args->child_count;                      // 자녀수
            }
            if($args->month_income!=null){
            	$part_config->month_income = $args->month_income;                    // 월소득
            }
            if($args->start_day!=null){
            	$part_config->start_day = $args->start_day;                          // 월시작일
            }
            // 데이터설정 (거래내역작성기준설정)
            if($args->deal_category!=null){
            	$part_config->deal_category = $args->deal_category;                      // 거래분류
            }
            if($args->income_item!=null){  
            	$part_config->income_item = $args->income_item;                      // 수입항목
            }
            if($args->outgo_item!=null){
            	$part_config->outgo_item  = $args->outgo_item;                       // 지출항목
            }
            if($args->cash_account_category!=null){
            	$part_config->cash_account_category = $args->cash_account_category;      // 현금계정분류
            }
            if($args->bank_account_category!=null){
            	$part_config->bank_account_category = $args->bank_account_category;      // 은행계정분류
            }
            if($args->asset_account_category!=null){
            	$part_config->asset_account_category = $args->asset_account_category;    // 자산계정분류
            }
            if($args->card_account_category!=null){
            	$part_config->card_account_category = $args->card_account_category;      // 카드계정분류
            }
            if($args->debt_account_category!=null){
            	$part_config->debt_account_category = $args->debt_account_category;      // 부채계정분류
            }
        	if($args->customer_category!=null){
            	$part_config->customer_category = $args->customer_category;      // 거래처분류
            }
                       
            // 데이터설정 (화면표시설정)
            if($args->lunar_yn!=null){
            	$part_config->lunar_yn     = $args->lunar_yn;                   // 음력표시여부
            }
        	if($args->memorial_yn!=null){
            	$part_config->memorial_yn     = $args->memorial_yn;                   // 기념일표시여부
            }
            if($args->income_list_count!=null){
            	$part_config->income_list_count = $args->income_list_count;             // 수입목록수
            }
            if($args->outgo_list_count!=null){
            	$part_config->outgo_list_count = $args->outgo_list_count;              // 지출목록수
            }
            if($args->transfer_list_count!=null){
            	$part_config->transfer_list_count = $args->transfer_list_count;           // 이체목록수
            }
            if($args->currency!=null){
            	$part_config->currency = $args->currency;           // 통화
            }
            $part_config_arr[] = $part_config;
            $output = $oCashbookModel->insertModulePartConfig('cashbook', $args->module_srl, $part_config_arr);

            // filter로 넘겨줄 값설정, $this객체에 add()로 변수를 등록하여 호출하여 XMLRPC로 리턴시 값을 추가함
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
				if($args->ret_act=='dispCashbookConfigBasicEdit'){
            		$this->setMessage('msg_success_update_config_basic');
				} else if($args->ret_act=='dispCashbookConfigCategoryEdit') {
					$this->setMessage('msg_success_update_config_category');
				} else if($args->ret_act=='dispCashbookConfigDealEdit') {
					$this->setMessage('msg_success_update_config_deal');
				}
			}
            $this->add('mid_url', getUrl('','mid',$args->mid));
            $this->add('ret_act', $args->ret_act);     
        }
        
        /**
         * 권한설정변경
         * 대상테이블: module
         * @return unknown_type
         */
        function procCashbookConfigGrantUpdate(){       	
			// 객체생성
        	$oCashbookModel = &getModel('cashbook');        	
        	$oModuleController = &getController('module');
        	$oModuleModel = &getModel('module');
        	
        	// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();

            // 설정정보가져오기
            $config = $oCashbookModel->getConfig($args); 

        	// 관리자 아이디 등록
            //$oModuleController->deleteAdminId($config->module_srl);
            $admin_member = Context::get('admin_member');
            if($admin_member) {
                $admin_members = explode(',',$admin_member);
                for($i=0;$i<count($admin_members);$i++) {
                    $admin_id = trim($admin_members[$i]);
                    if(!$admin_id) continue;
                    $oModuleController->insertAdminId($config->module_srl, $admin_id);
                }
            }
            // 권한 정리
            $xml_info = $oModuleModel->getModuleActionXML('cashbook');
            $grant_list = $xml_info->grant;

			foreach($grant_list as $grant_name => $grant_info) {
                // default값을 구함
                $default = Context::get($grant_name.'_default');

                // -1 = 로그인 사용자만, -2 = 사이트 가입자만, 0 = 모든 사용자
                if(strlen($default)){
                    $grant->{$grant_name}[] = $default;
                    continue;

                // 특정 그룹 사용자
                } else {
                    $group_srls = Context::get($grant_name);
                    if($group_srls) {
                        if(strpos($group_srls,'|@|')!==false) $group_srls = explode('|@|',$group_srls);
                        elseif(strpos($group_srls,',')!==false) $group_srls = explode(',',$group_srls);
                        else $group_srls = array($group_srls);
                        $grant->{$grant_name} = $group_srls;
                    }
                    continue;
                }
                $grant->{$group_srls} = array();
            }
            
            // DB에 저장
            $args->module_srl = $config->module_srl;
          
            $output = executeQuery('module.deleteModuleGrants', $args);
            if(!$output->toBool()) return $output;

            // DB에 권한 저장 
            foreach($grant as $grant_name => $group_srls) {
                foreach($group_srls as $key => $val) {
                    $args = null;
                    $args->module_srl = $config->module_srl;
                    $args->name = $grant_name;
                    $args->group_srl = $val;
                    $output = executeQuery('module.insertModuleGrant', $args);
                    if(!$output->toBool()) return $output;
                }
            }
            
            // filter로 넘겨줄 값설정, $this객체에 add()로 변수를 등록하여 호출하여 XMLRPC로 리턴시 값을 추가함
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} 
            $this->add('mid_url', getUrl('','mid',$args->mid));
            $this->add('ret_act', $args->ret_act);     
        }
        
    	/**
         * 계정 입력
         * @return unknown_type
         */
    	function procCashbookAccountInsert() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);

            // 입력할 값 설정
            $args->account_srl = getNextSequence();
			$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
			
            // 데이터입력 (테이블: cashbook_account)
            $output = $oCashbookModel->insertAccount($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            $this->setMessage('success_registed');
			}	
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * 계정 수정
         * @return unknown_type
         */
    	function procCashbookAccountUpdate() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 환경설정정보 가져옴
        	// $config = $oCashbookModel->getConfig($args);
         
            // 데이터수정 (테이블: cashbook_account)
            $output = $oCashbookModel->updateAccount($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('account_srl', $args->account_srl);
        }
        
    	/**
         * 계정삭제
         * @return unknown_type
         */
    	function procCashbookAccountDelete() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
			
            // 환경설정정보 가져옴
            //$config = $oCashbookModel->getConfig($args);

            // 데이터삭제 (테이블: cashbook_account)
            $output = $oCashbookModel->deleteAccount($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
            }
			$this->add('ret_act', $args->ret_act);
            $this->add('account_srl', $args->account_srl);
    	}
    	
    	/**
         * 거래처입력
         * @return unknown_type
         */
    	function procCashbookCustomerInsert() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);

            // 입력할 값 재설정
            $args->customer_srl = getNextSequence();
			$args->site_srl = $config->site_srl;
			$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
			
            // 테이블에 입력
            $output = $oCashbookModel->insertCustomer($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
	            $this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * 거래처 수정
         * @return unknown_type
         */
    	function procCashbookCustomerUpdate() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 입력할 값 재설정
        	$args->site_srl = $config->site_srl;
			$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
			
            // 테이블 수정
            $output = $oCashbookModel->updateCustomer($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
            }
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * 거래처 삭제
         * @return unknown_type
         */
    	function procCashbookCustomerDelete() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
			
        	// 입력할 값 재설정
        	$args->site_srl = $config->site_srl;
			$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;

            // 테이블에서 삭제
            $output = $oCashbookModel->deleteCustomer($args);
		
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
				$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
    	}
        
    	/**
         * @brief 분류 추가
         **/
        function procCashbookCategoryInsert() {
        	// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            
        	// 입력할 값 재설정
            $args->category_srl = getNextSequence();
            $args->site_srl = $config->site_srl;
			$args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
            $args->allow_delete = "Y";
            $args->listorder = $args->category_srl * -1;

            // 테이블에 입력
            $output = $oCashbookModel->insertCategory($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('category_srl', $args->category_srl);
        }
        
    	/**
         * @brief 분류 삭제
         **/
        function procCashbookCategoryDelete() {
			$args->category_srl = Context::get('category_srl');
			
            $oCashbookModel = &getModel('cashbook');
            
            // cashbook_category_item 테이블에서 삭제
            $output = $oCashbookModel->deleteCategoryItems($args);
            
            // cashbook_category 테이블에서 삭제
            $output = $oCashbookModel->deleteCategory($args);
            
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
        }
        
        /**
         * 분류항목을 입력 or 수정
         * 
         * @return unknown_type
         */
        function procCashbookCategoryItemInsert(){
        	$oCashbookModel = &getModel('cashbook');
        	
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);

            // 이미 존재하는지를 확인
            $item_info = $oCashbookModel->getCategoryItem($args->category_item_srl);

            // 존재하게 되면 update를 해준다
            if($item_info->category_item_srl == $args->category_item_srl) {
            	$output = $oCashbookModel->updateCategoryItem($args);          	
            // 존재하지 않으면 insert를 해준다
            } else {
            	$args->site_srl = $config->site_srl;
            	$args->module_srl = $config->module_srl;
            	$args->member_srl = $config->member_srl;
            	$args->category_item_srl = getNextSequence();
                $args->listorder = -1*$args->category_item_srl;
                $output = $oCashbookModel->insertCategoryItem($args);
            }

            // 해당 분류의 정보를 구함
            $category_info = $oCashbookModel->getCategory($args->category_srl);
            $category_title = $category_info->title;

            // XML 파일을 갱신하고 위치을 넘겨 받음
            $xml_file = $this->makeXmlFile($args->category_srl);
		
            $this->add('xml_file', $xml_file);
            $this->add('category_srl', $args->category_srl);
            $this->add('category_item_srl', $args->category_item_srl);
            $this->add('category_title', $category_title);
            $this->add('parent_srl', $args->parent_srl);
        }     
        
    	/**
         * @brief 분류 이동
         **/
        function procCashbookCategoryItemMove() {     	
            $category_srl = Context::get('category_srl');
            $mode = Context::get('mode');
            $parent_srl = Context::get('parent_srl');
            $source_srl = Context::get('source_srl');
            $target_srl = Context::get('target_srl');

            if(!$category_srl || !$mode || !$target_srl) {
            	return new Object(-1,'msg_invalid_request');
            }
            $this->moveCategoryItem($category_srl,$parent_srl,$source_srl,$target_srl,$mode);
        }
        
    	/**
         * @brief 분류 삭제
         **/
        function procCashbookCategoryItemDelete() {
			$oCashbookModel = &getModel('cashbook');
			
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // 정보를 가져온다.
            $category_item_info = $oCashbookModel->getCategoryItem($args->category_item_srl);
            if($category_item_info->parent_srl) {
            	$parent_srl = $category_item_info->parent_srl;
            }

            // 자식 노드가 있는지 체크하여 있으면 삭제 못한다는 에러 출력
            $output = $oCashbookModel->getCategoryChildCount($args);         
            if($output->data->count>0) {
            	return new Object(-1, 'msg_cannot_delete_for_child');
            }

            // category_item 테이블에서 삭제
            $output = $oCashbookModel->deleteCategoryItem($args);

            // 관련 수입 및 지출정보 삭제
			//$output = $oCashbookModel->deleteDealByCategorySrl($args);
debugPrint($output);

            // 해당 메뉴의 정보를 구함
            $category_info = $oCashbookModel->getCategory($args->category_srl);
            $category_title = $category_info->title;

            // XML 파일을 갱신하고 위치을 넘겨 받음
            $xml_file = $this->makeXmlFile($args->category_srl);

            $this->add('xml_file', $xml_file);
            $this->add('category_title', $category_title);
            $this->add('category_item_srl', $parent_srl);
            $this->setMessage('success_deleted');
        }
        
    	/**
         * @brief xml 파일을 갱신
         * 분류 구성 후 간혹 xml파일이 재생성 안되는 경우가 있는데\n
         * 이럴 경우 수동 갱신 기능을 구현해줌\n
         * 개발 중간의 문제인 것 같고 현재는 문제가 생기지 않으나 굳이 없앨 필요 없는 기능
         **/
        function procCashbookCategoryMakeXmlFile() {	
            // 입력값을 체크
            $category_srl = Context::get('category_srl');

            // xml파일 재생성
            $xml_file = $this->makeXmlFile($category_srl);

            // xml파일 경로 리턴
			$this->add('xml_file', $xml_file);
        }
        
    	/**
         * @brief 분류 제목 변경
         **/
        function procCashbookCategoryUpdate() {

            // 입력할 변수 정리
            $args->title = Context::get('title');
            $args->category_srl = Context::get('category_srl');
			
            // cashbook_category 테이블 수정
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateCategory($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief xml 파일을 갱신
         * 분류 구성 후 간혹 xml파일이 재생성 안되는 경우가 있는데\n
         * 이럴 경우 수동 갱신 기능을 구현해줌\n
         * 개발 중간의 문제인 것 같고 현재는 문제가 생기지 않으나 굳이 없앨 필요 없는 기능
         **/
        function procCashbookCategoryItemMakeXmlFile() {

            // 입력값을 체크
            $category_item_srl = Context::get('category_item_srl');
            $selected_item = Context::get('item_srl');

            // xml파일 재생성
            $xml_file = $this->makeItemXmlFile($category_item_srl, $selected_item);
			
            // xml파일 경로 리턴
            $this->add('xml_file', $xml_file);
        }
		
    	/**
         * @brief 초기화하기
         * 
         * @return unknown_type
         */
        function procCashbookInit(){
        	$oCashbookModel = &getModel('cashbook');
        	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = $args = Context::getRequestVars(); 						// form or get
			
            // 설정정보가져오기
            $config = $oCashbookModel->getConfig($args); 

            $args->site_srl = $config->site_srl;
			$args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;
			$args->amount = 0;
			$args->transfer_srl = 0;
			
			// 거래초기화 (amout로 수입,지출,이체구분)
			$check_deal_array = explode("|@|", $args->check_deal);
			for ($i = 0; $i < count($check_deal_array); $i++) {
				
				$check_deal = $check_deal_array[$i];

				// 수입삭제
				if($check_deal=="income"){					
					$output = $oCashbookModel->deleteDealIncomeAll($args);	
				}
				// 지출삭제
				if($check_deal=="outgo"){
					$output = $oCashbookModel->deleteDealOutgoAll($args);
				}
				// 이체삭제
				if($check_deal=="transfer"){
					$output = $oCashbookModel->deleteDealTransferAll($args);				
				}
			}
		
			// 계정초기화(kind로 현금,은행,자산,카드,부채구분)
			$check_account_array = explode("|@|", $args->check_account);
        	for ($i = 0; $i < count($check_account_array); $i++) {
				
				$check_account = $check_account_array[$i];

				// 현금계정삭제, 기본값입력
				if($check_account=="cash"){
					$args->kind = "1";				
					$output = $oCashbookModel->deleteAccountAll($args);
					// 현금계정기본값입력
					$args->family_type=$config->family_type;
					$oCashbookModel->setDefaultAccountData($args);	// 계정
				}
				// 은행계정삭제
				if($check_account=="bank"){
					$args->kind = "2";				
					$output = $oCashbookModel->deleteAccountAll($args);
				}
				// 자산계정삭제
				if($check_account=="asset"){
					$args->kind = "3";				
					$output = $oCashbookModel->deleteAccountAll($args);			
				}
        		// 카드계정삭제
				if($check_account=="card"){
					$args->kind = "4";				
					$output = $oCashbookModel->deleteAccountAll($args);					
				}
        		// 부채계정삭제
				if($check_account=="debt"){
					$args->kind = "5";				
					$output = $oCashbookModel->deleteAccountAll($args);				
				}
			}

			// 거래처초기화
        	$check_customer_array = explode("|@|", $args->check_customer);
        	for ($i = 0; $i < count($check_customer_array); $i++) {
				
				$check_customer = $check_customer_array[$i];
				$check_customer_all_flag = false;
				if($check_customer=="all"){
					$check_customer_all_flag = true;
				}
				
				// 거래처 삭제
				if($check_customer_all_flag){			
					$output = $oCashbookModel->deleteCustomerAll($args);					
				}

			}

			// 분류초기화
        	$check_category_array = explode("|@|", $args->check_category);
        	for ($i = 0; $i < count($check_category_array); $i++) {
				
				$check_category = $check_category_array[$i];
				// 수입항목 삭제, 기본값입력
				if($check_category=="income"){
					$args->category_srl = $config->income_item;
					$output = $oCashbookModel->deleteCategoryAll($args);				
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 수입항목 기본값 입력					
					$output_income_data = $oCashbookModel->setDefaultIncomeData($args);
				}
        		// 지출항목 삭제, 기본값입력
				if($check_category=="income"){
					$args->category_srl = $config->outgo_item;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 지출항목 기본값 입력
					$output_outgo_data = $oCashbookModel->setDefaultOutgoData($args);
				}
        		// 거래분류 삭제
				if($check_category=="deal"){
					$args->category_srl = $config->deal_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 거래분류 기본값 입력
					$output_deal_data = $oCashbookModel->setDefaultDealCategoryData($args);
				}
        		// 현금계정 분류 삭제
				if($check_category=="income"){
					$args->category_srl = $config->cash_account_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 현금계정 분류 기본값 입력
					$output_cash_account_data = $oCashbookModel->setDefaultCashAccountData($args);
				}
        		// 은행계정 분류 삭제
				if($check_category=="bank"){
					$args->category_srl = $config->bank_account_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 은행계정 분류 기본값 입력
					$output_bank_account_data = $oCashbookModel->setDefaultBankData($args);
				}
        		// 자산계정 분류 삭제
				if($check_category=="asset"){
					$args->category_srl = $config->asset_account_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 자산계정 분류 기본값 입력
					$output_asset_account_data = $oCashbookModel->setDefaultAssetData($args);
				}
        		// 카드계정 분류 삭제
				if($check_category=="card"){
					$args->category_srl = $config->card_account_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 카드계정 분류 기본값 입력
					$output_card_account_data = $oCashbookModel->setDefaultCardData($args);
				}
        		// 부채계정 분류 삭제
				if($check_category=="debt"){
					$args->category_srl = $config->debt_account_category;
					$output = $oCashbookModel->deleteCategoryAll($args);					
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 부채계정 분류 기본값 입력
					$output_debt_account_data = $oCashbookModel->setDefaultDebtData($args);
				}
        		// 거래처 분류 삭제
				if($check_category=="customer"){
					$args->category_srl = $config->customer_category;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 거래처 분류 기본값 입력
					$output_customer_data = $oCashbookModel->setDefaultCustomerData($args);
				}

			}
			
			// module_part_config 수정 (삭제 후 재입력)
            $part_config_arr = array();
            
            // 환경설정정보 가져옴            
            $part_config = $oCashbookModel->getConfig($args);

            // 데이터설정 (거래내역작성기준설정)
            if($output_income_data!=null){  
            	$part_config->income_item = $output_income_data->category_srl;                      // 수입항목
            }
            if($output_outgo_data!=null){
            	$part_config->outgo_item  = $output_outgo_data->category_srl;                       // 지출항목
            }
            if($output_deal_data!=null){
            	$part_config->deal_category = $output_deal_data->category_srl;                      // 거래분류
            }
            if($output_cash_account_data!=null){
            	$part_config->cash_account_category = $output_cash_account_data->category_srl;      // 현금계정분류
            }
            if($output_bank_account_data!=null){
            	$part_config->bank_account_category = $output_bank_account_data->category_srl;      // 은행계정분류
            }
            if($output_asset_account_data!=null){
            	$part_config->asset_account_category = $output_asset_account_data->category_srl;    // 자산계정분류
            }
            if($output_card_account_data!=null){
            	$part_config->card_account_category = $output_card_account_data->category_srl;      // 카드계정분류
            }
            if($output_debt_account_data!=null){
            	$part_config->debt_account_category = $output_debt_account_data->category_srl;      // 부채계정분류
            }
        	if($output_customer_data!=null){
            	$part_config->customer_category = $output_customer_data->category_srl;      // 거래처분류
            }
                       
            $part_config_arr[] = $part_config;
            $output = $oCashbookModel->insertModulePartConfig('cashbook', $args->module_srl, $part_config_arr);
            
            $this->add('ret_act', $args->ret_act);	// 돌아갈 액션
            $this->add('deal_srl', $args->deal_srl);
            $this->setMessage('msg_cashbook_init_success');
        }
        
        
        
        /**
         * 거래 (수입, 지출) 등록처리
         * 
         * @return unknown_type
         */
    	function procCashbookDealInsert() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();

			// 지출일경우 금액을 마이너스로 변경
			if($args->ret_act=='dispCashbookDealOutgoList' && $args->amount>0){
				$args->amount = -$args->amount;
			}
			
			// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
            
            // 입력할 값 설정
            $args->deal_srl = getNextSequence();					// 일련번호

            // 데이터입력 (테이블: cashbook_deal)
            $args->site_srl = $config->site_srl;
            $args->module_srl = $config->module_srl;
            $args->member_srl = $config->member_srl;       
            $output = $oCashbookModel->insertDeal($args);
			
            // 데이터입력 (테이블: cashbook_tag, cashbook_tag_deal)
            if($args->tag !=""){    // 넘어온 태그가 있다면
            	$tagTemp = $args->tag;
            	$tagArray = split(",",$tagTemp);
            	for($i=0;$i<count($tagArray);$i++){
            		$argsTag->site_srl = $config->site_srl;
		            $argsTag->module_srl = $config->module_srl;
		            $argsTag->member_srl = $config->member_srl;
		            $argsTag->tag = trim($tagArray[$i]);
		            
            		// 태그가 이미 등록되어 있는지 검사한다.
            		$outputTag = $oCashbookModel->getTag($argsTag);     
            		       		
            		// 태그가 등록되어 있다면
            		if($outputTag->tag_srl > 0){
            			$argsTag->tag_srl = $outputTag->tag_srl;
            		} else {
            			$argsTag->tag_srl = getNextSequence();
						$outputInsertTag = $oCashbookModel->insertTag($argsTag);
            		}
            		
            		// tag_deal에 데이터를 입력한다.
            		$argsTag->tag_deal_srl = getNextSequence();
            		$argsTag->deal_srl = $args->deal_srl;
            		$outputInsertTagDeal = $oCashbookModel->insertTagDeal($argsTag);
            	}
            }
            
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
            
        }
        
    	/**
         * 거래 (수입, 지출) 수정처리
         * @return unknown_type
         */
    	function procCashbookDealUpdate() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
            // 수입,지출여부에 따라 amount 에 - 붙여주기
            if($args->ret_act == 'dispCashbookDealOutgoList'){
            	$args->amount = -$args->amount; 	
            }
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl = $config->site_srl;
        	$args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;

            // 데이터수정(테이블: cashbook_deal)
            $output = $oCashbookModel->updateDeal($args);
	
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
        }
        
    	/**
         * 거래 (수입, 지출) 삭제처리
         * @return unknown_type
         */
    	function procCashbookDealDelete() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();

            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl = $config->site_srl;
        	$args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;
            
            // 데이터삭제 (테이블: cashbook_deal)
            $output = $oCashbookModel->deleteDeal($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
    	}
    	        
    	/**
         * 거래 (이체) 삭제처리
         * @return unknown_type
         */
    	function procCashbookTransferDelete() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl = $config->site_srl;
        	$args->module_srl = $config->module_srl;
        	$args->member_srl = $config->member_srl;

            // 데이터삭제(테이블: cashbook_deal)
            $output = $oCashbookModel->deleteTransfer($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
    	}
    	
    	/**
         * 거래 (이체) 등록처리
         * @return unknown_type
         */
    	function procCashbookTransferInsert() {
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
            // 환경설정정보 가져옴
        	$args = $oCashbookModel->getConfig($args);
        	
        	// 일련번호가져오기
            $args->transfer_srl = getNextSequence();

            // to_account로부터 계정이름을 가져온다.
            $toAccountName = $oCashbookModel->getAccount($args->to_account);
            
			// from_account로부터 계정이름을 가져온다.
            $fromAccountName = $oCashbookModel->getAccount($args->from_account);

            // from > to 를 위한 cashbook_deal 테이블에 입력
            $args->deal_srl = getNextSequence();					// 일련번호
            $args->account_srl = $args->from_account;
            $args->title = $fromAccountName->title." (이체:".$fromAccountName->title." > ".$toAccountName->title.")";
            $output = $oCashbookModel->insertDeal($args);
            
            // to > from 를 위한 cashbook_deal 테이블에 입력
            $args->deal_srl = getNextSequence();					// 일련번호
            $args->account_srl = $args->to_account;
            $args->title = $toAccountName->title." (이체:".$fromAccountName->title." > ".$toAccountName->title.")";
            $output = $oCashbookModel->insertDeal($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
    	}
    	
    /**
         * 실제이동시키기
         * 
         * @param $cashbook_category_srl
         * @param $parent_srl
         * @param $source_srl
         * @param $target_srl
         * @param $mode
         * @return unknown_type
         */
        function moveCategoryItem($category_srl,$parent_srl,$source_srl,$target_srl,$mode){
            // 원본 분류들을 구함
            $oCashbookModel = &getModel('cashbook');

            $target_item = $oCashbookModel->getCategoryItem($target_srl);
            if($target_item->category_item_srl != $target_srl) return new Object(-1,'msg_invalid_request');
			
            // 위치 이동 (순서 조절)
            if($mode == 'move') {
                $args->parent_srl = $parent_srl;
                $args->category_srl = $category_srl;

                if($source_srl) {
                    $source_item = $oCashbookModel->getCategoryItem($source_srl);
                    if($source_item->category_item_srl != $source_srl) {
                    	return new Object(-1,'msg_invalid_request');
                    }
                    $args->listorder = $source_item->listorder-1;
                }  else {
                    
                	$output = $oCashbookModel->getCategoryMaxListorder($args);
                    $args->listorder = (int)$output->data->listorder;
                    if(!$args->listorder) $args->listorder= 0;
                }
                
                $args->parent_srl = $parent_srl;
                $output = $oCashbookModel->updateCategoryItemListorder($args);
                
                $args->parent_srl = $parent_srl;
                $args->category_item_srl = $target_srl;
                $output = $oCashbookModel->updateCategoryItemNode($args);
                
            // 자식으로 추가
            } elseif($mode == 'insert') {
                $args->category_item_srl = $target_srl;
                $args->parent_srl = $parent_srl;
                $args->listorder = -1*getNextSequence();
                $output = $oCashbookModel->updateCategoryItemNode($args);
            }

            $xml_file = $this->makeXmlFile($menu_srl);
            return $xml_file;
        }
        
    	/**
         * @brief 메뉴의 xml 파일을 만들고 위치를 return
         **/
        function makeXmlFile($category_srl) {
            // xml파일 생성시 필요한 정보가 없으면 그냥 return
            if(!$category_srl) return;

            // 분류 정보를 구함
            $args->category_srl = $category_srl;
       
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCategory($category_srl);
            $site_srl = (int)$output->data->site_srl;

            if($site_srl) {
                $oModuleModel = &getModel('module');
                $site_info = $oModuleModel->getSiteInfo($site_srl);
                $domain = $site_info->domain;
            }

            // DB에서category_srl에 해당하는 메뉴 아이템 목록을 listorder순으로 구해옴
            $args->category_srl = $category_srl;
            $args->sort_index = 'listorder';
            $output = $oCashbookModel->getCategoryItemListAll($args);

            // 캐시 파일의 이름을 지정
            $xml_file = sprintf("./files/cache/cashbook/%s.xml.php", $category_srl);

            // 구해온 데이터가 없다면 노드데이터가 없는 xml 파일만 생성
            $list = $output->data;
            
            if(!$list) {
                $xml_buff = "<root />";
                FileHandler::writeFile($xml_file, $xml_buff);
                return $xml_file;
            }

            // 구해온 데이터가 하나라면 array로 바꾸어줌
            if(!is_array($list)) {
            	$list = array($list);
            }

            // 루프를 돌면서 tree 구성
            $list_count = count($list);
            for($i=0;$i<$list_count;$i++) {
                $node = $list[$i];
                $category_item_srl = $node->category_item_srl;
                $parent_srl = $node->parent_srl;

                $tree[$parent_srl][$category_item_srl] = $node;
            }

            // 캐시 파일의 권한과 그룹 설정을 위한 공통 헤더
            $header_script =
                '$lang_type = Context::getLangType(); '.
                '$is_logged = Context::get(\'is_logged\'); '.
                '$logged_info = Context::get(\'logged_info\'); '.
                '$site_srl = '.$site_srl.';'.
                '$site_admin = false;'.
                'if($site_srl) { '.
                '$oModuleModel = &getModel(\'module\');'.
                '$site_module_info = $oModuleModel->getSiteInfo($site_srl); '.
                'Context::set(\'site_module_info\',$site_module_info);'.
                '$grant = $oModuleModel->getGrant($site_module_info, $logged_info); '.
                'if($grant->manager ==1) $site_admin = true;'.
                '}'.
                'if($is_logged) {'.
                    'if($logged_info->is_admin=="Y" || $site_admin) $is_admin = true; '.
                    'else $is_admin = false; '.
                    '$group_srls = array_keys($logged_info->group_list); '.
                '} else { '.
                    '$is_admin = false; '.
                    '$group_srsl = array(); '.
                '} ';

            // xml 캐시 파일 생성 (xml캐시는 따로 동작하기에 session 지정을 해주어야 함)
            $xml_buff = sprintf(
                '<?php '.
                'define(\'__ZBXE__\', true); '.
                'require_once(\'../../../config/config.inc.php\'); '.
                '$oContext = &Context::getInstance(); '.
                '$oContext->init(); '.
                'header("Content-Type: text/xml; charset=UTF-8"); '.
                'header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); '.
                'header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); '.
                'header("Cache-Control: no-store, no-cache, must-revalidate"); '.
                'header("Cache-Control: post-check=0, pre-check=0", false); '.
                'header("Pragma: no-cache"); '.
                '%s'.
                '?>'.
                '<root>%s</root>',
                $header_script,
                $this->getXmlTree($tree[0], $tree, $site_srl, $domain)
            );


            // 파일 저장
            FileHandler::writeFile($xml_file, $xml_buff);

            return $xml_file;
        }
        
    	/**
         * @brief array로 정렬된 노드들을 parent_srl을 참조하면서 recursive하게 돌면서 xml 데이터 생성
         * 메뉴 xml파일은 node라는 tag가 중첩으로 사용되며 이 xml doc으로 관리자 페이지에서 메뉴를 구성해줌\n
         * (tree_menu.js 에서 xml파일을 바로 읽고 tree menu를 구현)
         **/
        function getXmlTree($source_node, $tree, $site_srl, $domain) {
        	// source_node가 있는지 검사
            if(!$source_node) return;
            // source_node가 있다면
            foreach($source_node as $category_item_srl => $node) {
                $child_buff = "";

                // 자식 노드의 데이터 가져옴
                if($category_item_srl&&$tree[$category_item_srl]) {
                	$child_buff = $this->getXmlTree($tree[$category_item_srl], $tree, $site_srl, $domain);
                }

                // 변수 정리
                $names = $this->getCategoryItemNames($node->title, $site_srl);
                foreach($names as $key => $val) {
                    $name_arr_str .= sprintf('"%s"=>"%s",',$key, str_replace('\\','\\\\',htmlspecialchars($val)));
                }
                $name_str = sprintf('$_names = array(%s); print $_names[$lang_type];', $name_arr_str);

                $attribute = sprintf(
                    'node_srl="%s" parent_srl="%s" text="<?php { %s }?>" expand="%s"',
                    $category_item_srl,
                    $node->parent_srl,
                    $name_str,
                    $node->expand
                );

                if($child_buff) {
                	$buff .= sprintf('<node %s>%s</node>', $attribute, $child_buff);
                } else {
                	$buff .=  sprintf('<node %s />', $attribute);
                }
            }

            return $buff;
		}
		
    	/**
         * 수입/지출 등록에서 하위항목 가져오기..
         * @param $category_item_srl
         * @return unknown_type
         */
    	function makeItemXmlFile($category_item_srl, $selected_item) {
			// xml파일 생성시 필요한 정보가 없으면 그냥 return
            if(!$category_item_srl) return;

            // 분류 정보를 구함
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCategoryItem($category_item_srl);
            $site_srl = (int)$output->data->site_srl;

            if($site_srl) {
                $oModuleModel = &getModel('module');
                $site_info = $oModuleModel->getSiteInfo($site_srl);
                $domain = $site_info->domain;
            }

            // DB에서category_item_srl를 parent_srl로 하는 아이템 목록을 listorder순으로 구해옴
            $args->parent_srl = $category_item_srl;
            $args->sort_index = 'listorder';
            $output = $oCashbookModel->getCategoryItemListAll($args);

            // 캐시 파일의 이름을 지정
            $xml_file = sprintf("./files/cache/cashbook/%s.xml.php", $category_item_srl);

            // 구해온 데이터가 없다면 노드데이터가 없는 xml 파일만 생성
            $list = $output->data;
         
            if(!$list) {
                $xml_buff = "<root />";
                FileHandler::writeFile($xml_file, $xml_buff);
                return $xml_file;
            }

            // 구해온 데이터가 하나라면 array로 바꾸어줌
            if(!is_array($list)) {
            	$list = array($list);
            }

            // 루프를 돌면서 node 구성
            $list_count = count($list);
            for($i=0;$i<$list_count;$i++) {
                $node = $list[$i];
               
                $node->selected_item=$selected_item;

                $tree[$i] = $node;
            }

            // 캐시 파일의 권한과 그룹 설정을 위한 공통 헤더
            $header_script =
                '$lang_type = Context::getLangType(); '.
                '$is_logged = Context::get(\'is_logged\'); '.
                '$logged_info = Context::get(\'logged_info\'); '.
                '$site_srl = '.$site_srl.';'.
                '$site_admin = false;'.
                'if($site_srl) { '.
                '$oModuleModel = &getModel(\'module\');'.
                '$site_module_info = $oModuleModel->getSiteInfo($site_srl); '.
                'Context::set(\'site_module_info\',$site_module_info);'.
                '$grant = $oModuleModel->getGrant($site_module_info, $logged_info); '.
                'if($grant->manager ==1) $site_admin = true;'.
                '}'.
                'if($is_logged) {'.
                    'if($logged_info->is_admin=="Y" || $site_admin) $is_admin = true; '.
                    'else $is_admin = false; '.
                    '$group_srls = array_keys($logged_info->group_list); '.
                '} else { '.
                    '$is_admin = false; '.
                    '$group_srsl = array(); '.
                '} ';

            // xml 캐시 파일 생성 (xml캐시는 따로 동작하기에 session 지정을 해주어야 함)
            $xml_buff = sprintf(
                '<?php '.
                'define(\'__ZBXE__\', true); '.
                'require_once(\'../../../config/config.inc.php\'); '.
                '$oContext = &Context::getInstance(); '.
                '$oContext->init(); '.
                'header("Content-Type: text/xml; charset=UTF-8"); '.
                'header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); '.
                'header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); '.
                'header("Cache-Control: no-store, no-cache, must-revalidate"); '.
                'header("Cache-Control: post-check=0, pre-check=0", false); '.
                'header("Pragma: no-cache"); '.
                '%s'.
                '?>'.
                '<root>%s</root>',
                $header_script,
                $this->getItemXmlTree($tree, $site_srl, $domain)
            );

            // 파일 저장
            FileHandler::writeFile($xml_file, $xml_buff);

            return $xml_file;
        }
        
    	/**
         * @brief array로 정렬된 노드들을 parent_srl을 참조하면서 recursive하게 돌면서 xml 데이터 생성
         * 메뉴 xml파일은 node라는 tag가 중첩으로 사용되며 이 xml doc으로 관리자 페이지에서 메뉴를 구성해줌\n
         * (tree_menu.js 에서 xml파일을 바로 읽고 tree menu를 구현)
         **/
        function getItemXmlTree($tree, $site_srl, $domain) {

            // source_node가 있다면
            foreach($tree as $i => $node) {

                // 변수 정리
                $names = $this->getCategoryItemNames($node->title, $site_srl);
                foreach($names as $key => $val) {
                    $name_arr_str .= sprintf('"%s"=>"%s",',$key, str_replace('\\','\\\\',htmlspecialchars($val)));
                }
                $name_str = sprintf('$_names = array(%s); print $_names[$lang_type];', $name_arr_str);

                $attribute = sprintf(
                    'node_srl="%s" parent_srl="%s" text="<?php { %s }?>" selected_item="%s" expand="%s"',
                    $node->category_item_srl,
                    $node->parent_srl,
                    $name_str,
                    $node->selected_item,
                    $node->expand
                );

                $buff .=  sprintf('<node %s />', $attribute);
            }

            return $buff;
		}
		
    	function getCategoryItemNames($source_name, $site_srl = null) {
            if(!$site_srl) {
                $site_module_info = Context::get('site_module_info');
                $site_srl = (int)$site_module_info->site_srl;
            }

            // 언어코드 구함
            $oModuleAdminModel = &getAdminModel('module');
            return $oModuleAdminModel->getLangCode($site_srl, $source_name);
        }
        
        /****************************************************************
         * Flex 
         * - CashbookChart
         ***************************************************************/
		
    	/**
         * Flex에서 HttpService를 이용하여 로그인을 체크한다.
         * 
         * @return unknown_type
         */
        function procCashbookChartCheckLogin(){
    	
        	$logged_info = Context::get('logged_info');	
        	$flex_xml = "<root>";
        	if($logged_info->member_srl > 0){
        		$flex_xml .= "<loginYn>Y</loginYn>";
        	} else {
        		$flex_xml .= "<loginYn>N</loginYn>";
        	}
        	$flex_xml .= "</root>";
			Context::set('flex_xml', $flex_xml);
			
        	// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            // skin에 상관없이 사용하므로 tpl에 위치한다.
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 거래그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
        function procCashbookChartDeal(){      	
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
			        	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
        	$args->amount=0;

        	// 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;

        	// 쿼리실행
            $outputIncome = $oCashbookModel->getCashbookChartDealIncomeList($args);
			$outputOutgo = $oCashbookModel->getCashbookChartDealOutgoList($args);

			$startDate = $args->start_date;
			$endDate = $args->end_date;
			$currentDate = $startDate;

			// xml 구성하기
            $flex_xml = "<root>";
            for($i=0;$i<$endDate-$startDate+1;$i++){
            	$flex_xml .= "<list>";
            	// 날짜
	            //$flex_xml .= "<day>".substr($currentDate,0,4)."-".substr($currentDate,4,2)."-".substr($currentDate,6,2)."</day>";
	            $flex_xml .= "<day>".substr($currentDate,4,2)."-".substr($currentDate,6,2)."</day>";
	            // 수입
	            $incomeEmptyFlag = true;
            	foreach($outputIncome->data as $key => $val) {
            		if( $currentDate == $val->day){
						$flex_xml .= "<income>".$val->amount."</income>";
						$incomeEmptyFlag = false;
					}
				}
				if($incomeEmptyFlag){
					$flex_xml .= "<income>0</income>";
				}
				
				// 지출
            	$outgoEmptyFlag = true;
            	foreach($outputOutgo->data as $k => $v) {
            		if( $currentDate == $v->day){
						$flex_xml .= "<outgo>".-$v->amount."</outgo>";
						$outgoEmptyFlag = false;
					}
				}
				if($outgoEmptyFlag){
					$flex_xml .= "<outgo>0</outgo>";
				}

				$currentDate++;
				$flex_xml .= "</list>";
            }
			
        	$flex_xml .= "</root>";
debugPrint($flex_xml);
			Context::set('flex_xml', $flex_xml);
			
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');

            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 수입항목별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
        function procCashbookChartIncomeItem(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
        	
        	global $lang;
        	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;

        	// 쿼리실행
            $output = $oCashbookModel->getCashbookChartIncomeItemList($args);

            // 수입항목으로 설정된 값이 없을 경우
            if(!$config->income_item>0){
				$flex_xml = "<root>";
				$flex_xml .= "<list>";
				$flex_xml .= "<item>" . $lang->cashbook_not_set_incomeitem_config . "</item>";
				$flex_xml .= "<amount>0</amount>";
				$flex_xml .= "</list>";
				$flex_xml .= "<list>";
				$flex_xml .= "<item>" . $lang->cashbook_need_config . "</item>";
				$flex_xml .= "<amount>0</amount>";
				$flex_xml .= "</list>";
				$flex_xml .= "</root>";
            } else {
	            // 수입항목을 모두 가져온다.
	        	$argsIncomeItem->category_srl = $config->income_item;
	            $argsIncomeItem->parent_srl = 0;
	            $outputIncomeItem = $oCashbookModel->getCategoryItemListAll($argsIncomeItem);
	
	            // xml 구성하기
	            $flex_xml = "<root>";
	            // 수입항목 수만큼 루프를 돌자고
	            foreach($outputIncomeItem->data as $key => $val) {
	            	$flex_xml .= "<list>";
	            	$existAmount = false;
	            	$flex_xml .= "<item>".$val->title."</item>";
		    		foreach($output->data as $k => $v) {
			    		if($val->title==$v->parent_item_name){
							$flex_xml .= "<amount>".$v->amount."</amount>";
							$existAmount = true;
		            	}
		            	
					}
					// amount가 존재하지 않으면
	            	if(!$existAmount) {
						$flex_xml .= "<amount>0</amount>";
		            }
					$flex_xml .= "</list>";
	            }
				$flex_xml .= "</root>";
            }
debugPrint($flex_xml);
            Context::set('flex_xml', $flex_xml);
		
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 지출항목별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function procCashbookChartOutgoItem(){
    		// 객체생성
    		$oCashbookModel = &getModel('cashbook');
    		
    		global $lang;
    		
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
            
        	// 쿼리실행
            $output = $oCashbookModel->getCashbookChartOutgoItemList($args);

    		// 지출항목으로 설정된 값이 없을 경우
            if(!$config->outgo_item>0){
				$flex_xml = "<root>";
				$flex_xml .= "<list>";
				$flex_xml .= "<item>" . $lang->cashbook_not_set_outgoitem_config . "</item>";
				$flex_xml .= "<amount>0</amount>";
				$flex_xml .= "</list>";
				$flex_xml .= "<list>";
				$flex_xml .= "<item>" . $lang->cashbook_need_config . "</item>";
				$flex_xml .= "<amount>0</amount>";
				$flex_xml .= "</list>";
				$flex_xml .= "</root>";
            } else {
	            // 지출항목을 모두 가져온다.
	        	$argsOutgoItem->category_srl = $config->outgo_item;
	            $argsOutgoItem->parent_srl = 0;
	            $outputOutgoItem = $oCashbookModel->getCategoryItemListAll($argsOutgoItem);
	
	            // xml 구성하기
	            $flex_xml = "<root>";
	            // 지출항목 수만큼 루프를 돌자고
	            foreach($outputOutgoItem->data as $key => $val) {
	            	$flex_xml .= "<list>";
	            	$existAmount = false;
	            	$flex_xml .= "<item>".$val->title."</item>";
		    		foreach($output->data as $k => $v) {
			    		if($val->title==$v->parent_item_name){
							$flex_xml .= "<amount>".-$v->amount."</amount>";
							$existAmount = true;
		            	}
		            	
					}
					// amount가 존재하지 않으면
	            	if(!$existAmount) {
						$flex_xml .= "<amount>0</amount>";
		            }
					$flex_xml .= "</list>";
	            }
				$flex_xml .= "</root>";
            }

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
   	 	/**
         * 거래분류별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function procCashbookChartDealCategory(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
            
        	// 쿼리실행
        	$outputIncome = $oCashbookModel->getCashbookChartCategoryIncomeList($args);
			$outputOutgo = $oCashbookModel->getCashbookChartCategoryOutgoList($args);
debugPrint($outputIncome);

			// 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 거래분류모두가져오기
            $argsDealCategory->category_srl = $config->deal_category;
            $outputDealCategory = $oCashbookModel->getCategoryItemListAll($argsDealCategory);
debugPrint($outputDealCategory->data);          
			// xml 구성하기
            $flex_xml = "<root>";
            
            // 수입
            $flex_xml .= "<income>";
            
            // 거래분류의 수가 1개일 경우
            if($outputDealCategory->data->title !=null){
            	$flex_xml .= "<list>";
            	$existAmount = false;
            	$flex_xml .= "<category>".$outputDealCategory->data->title."</category>";
	    		foreach($outputIncome->data as $k => $v) {
		    		if($outputDealCategory->data->title==$v->category_name){
						$flex_xml .= "<amount>".$v->amount."</amount>";
						$existAmount = true;
	            	}
	            	
				}
				// amount가 존재하지 않으면
            	if(!$existAmount) {
					$flex_xml .= "<amount>0</amount>";
	            }
				$flex_xml .= "</list>";
            } else {
	            // 거래분류 수만큼 루프를 돌자고
	            foreach($outputDealCategory->data as $key => $val) {
	            	$flex_xml .= "<list>";
	            	$existAmount = false;
	            	$flex_xml .= "<category>".$val->title."</category>";
		    		foreach($outputIncome->data as $k => $v) {
			    		if($val->title==$v->category_name){
							$flex_xml .= "<amount>".$v->amount."</amount>";
							$existAmount = true;
		            	}
		            	
					}
					// amount가 존재하지 않으면
	            	if(!$existAmount) {
						$flex_xml .= "<amount>0</amount>";
		            }
					$flex_xml .= "</list>";
	            }
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
             // 거래분류의 수가 1개일 경우
            if($outputDealCategory->data->title !=null){
            	$flex_xml .= "<list>";
            	$existAmount = false;
            	$flex_xml .= "<category>".$outputDealCategory->data->title."</category>";
	    		foreach($outputOutgo->data as $k => $v) {
		    		if($outputDealCategory->data->title==$v->category_name){
						$flex_xml .= "<amount>".-$v->amount."</amount>";
						$existAmount = true;
	            	}
	            	
				}
				// amount가 존재하지 않으면
            	if(!$existAmount) {
					$flex_xml .= "<amount>0</amount>";
	            }
				$flex_xml .= "</list>";
            } else {
	    		// 거래처 수만큼 루프를 돌자고
	            foreach($outputDealCategory->data as $key => $val) {
	            	debugPrint("1");
	            	$flex_xml .= "<list>";
	            	$existAmount = false;
	            	$flex_xml .= "<category>".$val->title."</category>";
		    		foreach($outputOutgo->data as $k => $v) {
			    		if($val->title==$v->category_name){
							$flex_xml .= "<amount>".-$v->amount."</amount>";
							$existAmount = true;
		            	}
		            	
					}
					// amount가 존재하지 않으면
	            	if(!$existAmount) {
						$flex_xml .= "<amount>0</amount>";
		            }
					$flex_xml .= "</list>";
	            }
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);
debugPrint($flex_xml);
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 거래처별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function procCashbookChartCustomer(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;

        	// 쿼리실행
        	$outputIncome = $oCashbookModel->getCashbookChartCustomerIncomeList($args);
			$outputOutgo = $oCashbookModel->getCashbookChartCustomerOutgoList($args);
			
			// 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
            // 거래처모두가져오기
			$outputCustomer = $oCashbookModel->getCustomerListAll($args);

			// xml 구성하기
            $flex_xml = "<root>";
            
            // 수입
            $flex_xml .= "<income>";
            // 거래처 수만큼 루프를 돌자고
            foreach($outputCustomer->data as $key => $val) {
            	$flex_xml .= "<list>";
            	$existAmount = false;
            	$flex_xml .= "<customer>".$val->name."</customer>";
	    		foreach($outputIncome->data as $k => $v) {
		    		if($val->name==$v->customer_name){
						$flex_xml .= "<amount>".$v->amount."</amount>";
						$existAmount = true;
	            	}
	            	
				}
				// amount가 존재하지 않으면
            	if(!$existAmount) {
					$flex_xml .= "<amount>0</amount>";
	            }
				$flex_xml .= "</list>";
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
    		// 거래처 수만큼 루프를 돌자고
            foreach($outputCustomer->data as $key => $val) {
            	$flex_xml .= "<list>";
            	$existAmount = false;
            	$flex_xml .= "<customer>".$val->name."</customer>";
	    		foreach($outputOutgo->data as $k => $v) {
		    		if($val->name==$v->customer_name){
						$flex_xml .= "<amount>".-$v->amount."</amount>";
						$existAmount = true;
	            	}
	            	
				}
				// amount가 존재하지 않으면
            	if(!$existAmount) {
					$flex_xml .= "<amount>0</amount>";
	            }
				$flex_xml .= "</list>";
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 태그별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function procCashbookChartTag(){
			// 객체생성
			$oCashbookModel = &getModel('cashbook');
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // 환경설정정보 가져옴
        	$config = $oCashbookModel->getConfig($args);
        	$args->site_srl   = $config->site_srl;
        	$args->module_srl = $config->module_srl;
			$args->member_srl = $config->member_srl;
            
        	// 쿼리실행
        	
			$outputOutgo = $oCashbookModel->getCashbookChartTagOutgoList($args);
			
			// 정렬방법 설정
            $order_target = Context::get('order_target');
            if(!$order_target) $order_target = "input_date";
            $args->order_target = $order_target;
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;
            
			// 태그모두가져오기
			$outputTag = $oCashbookModel->getTagListAll($args);
			// xml 구성하기
            $flex_xml = "<root>";
            
            // 수입
            $flex_xml .= "<income>";
            // 태그 수만큼 루프를 돌자고
            foreach($outputTag->data as $key => $val) {
            	$args->tag = $val->tag;
            	$outputIncome = $oCashbookModel->getCashbookChartTagIncomeList($args);
            	$flex_xml .= "<list>";
            	$flex_xml .= "<tag>".$val->tag."</tag>";
            	if($outputIncome->data[0]->amount!=null){
            		$flex_xml .= "<amount>".$outputIncome->data[0]->amount."</amount>";
            	} else {
            		$flex_xml .= "<amount>0</amount>";
            	}
				$flex_xml .= "</list>";
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
    		// 거래처 수만큼 루프를 돌자고
            foreach($outputTag->data as $key => $val) {
            	$args->tag = $val->tag;
            	$outputOutgo = $oCashbookModel->getCashbookChartTagOutgoList($args);        	
            	$flex_xml .= "<list>";
            	$flex_xml .= "<tag>".$val->tag."</tag>";
            	if($outputOutgo->data[0]->amount!=null){
            		$flex_xml .= "<amount>".-$outputOutgo->data[0]->amount."</amount>";
            	} else {
            		$flex_xml .= "<amount>0</amount>";
            	}
				$flex_xml .= "</list>";
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'skins/default');
        	$this->setTemplateFile('flex_xml');
        }
        
        
    }
?>