<?php
    /**
     * 관리자모듈 화면정의
     * 
     * @class  cashbookAdminView
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook admin view class
     **/

    class cashbookAdminView extends cashbook {

    	/**
         * @brief 초기화
         **/
        function init() {        	
        	// 모델객체생성하기
        	$oCashbookModel = &getModel('cashbook');
        	
        	// CashbookXE 모듈의 기본정보를 가져온다.
            $this->module_info = $oCashbookModel->getBasicModuleInfo();
			Context::set('module_info',$this->module_info);
            
        	// 템플릿정보를 가져온다.
            $this->setTemplatePath($this->module_path."/tpl/");
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }
        
    	/**
         * 설정화면
         * 
         * @return unknown_type
         */
		function dispCashbookAdminSetup() {
			// 모델객체생성하기
			$oModuleModel = &getModel('module');
			$oLayoutMode = &getModel('layout');
			$oCashbookModel = &getModel('cashbook');
			$oMemberModel = &getModel('member');
			
			// 스킨목록가져오기
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록가져오기
            $layout_list = $oLayoutMode->getLayoutList();
            Context::set('layout_list', $layout_list);

            // 현재 모듈에 설정된 권한 그룹을 가져옴
            $output = $oCashbookModel->getGrantGroup($this->module_info->module_srl);   
            Context::set('selected_group', $output->selected_group);
            Context::set('default_grant', $output->default_grant);

            // 그룹을 가져옴
            $group_list = $oMemberModel->getGroups($this->module_info->site_srl);
            Context::set('group_list', $group_list);
            
            // 템플릿파일이름 정하기
            $this->setTemplateFile('setup');
        }
        
    	/**
    	 * 목록 화면
    	 * 
    	 * @return unknown_type
    	 */
        function dispCashbookAdminList(){
       	
			// 모델객체생성하기
			$oCashbookModel = &getModel('cashbook');

			// 페이징설정
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $output = $oCashbookModel->getConfigList(20, $page, 'module_srl');
debugPrint($output);
			Context::set('page', $output->page);
            Context::set('config_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿파일이름 정하기
            $this->setTemplateFile('list');
        }
        
    }
?>