<?php

    class cashbookCustomer extends Object {
    	var $customer_srl     = null;    // 일련번호
    	var $site_srl         = null;    // 사이트일련번호, site.site_srl
    	var $module_srl       = null;    // 모듈일련번호, modules.module_srl
    	var $member_srl       = null;    // 회원일련번호, member.member_srl
    	var $category_srl     = null;
    	var $category_name    = null;    // category_srl을 가지고 category_item에서 추출한 title
    	var $title            = null;    // 화면표시 - 사용내역
    	var $phone              = null;    // 화면표시 - 거래일자
    	var $memo             = null;
    	var $input_date       = null;
    	
    	/**
		 * 생성자
		 * 
		 * @param $customer_srl
		 * @return unknown_type
		 */
        function cashbookCustomer($customer_srl = 0) { 
            if(!$customer_srl) return;
            $this->setCashbookCustomer($customer_srl);
        }
        
    	/**
         * 거래처정보설정
         * 
         * @param $customer_srl
         * @return unknown_type
         */
        function setCashbookCustomer($customer_srl) { 
            $this->customer_srl = $customer_srl;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 정보 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->customer_srl) return;

            $this->customer_srl;
            $output = executeQuery('cashbook.getCustomer', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->customer_srl = $attribute->customer_srl;
        	$this->site_srl = $attribute->site_srl;
            $this->module_srl =  $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->title = $attribute->title;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->customer_srl?true:false;
        }
        
    	/**
         * getter
         * 
         * @return unknown_type
         */
    	function getCustomerSrl() {
            if(!$this->isExists()) return;
            return $this->get('customer_srl');
        }
        
    	function getCategoryName() {
            if(!$this->isExists()) return;
            return $this->get('category_name');
        }
        
    	function getTitle() {
            if(!$this->isExists()) return;
            return $this->get('title');
        }
        
    	function getPhone() {
            if(!$this->isExists()) return;
            return $this->get('phone');
        }
        
    	function getMemo() {
            if(!$this->isExists()) return;
            return $this->get('memo');
        }
    }
    
?>