<?php
    /**
     * 관리자모듈 화면정의
     * 
     * @class  cashbookAdminView
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook admin view class
     **/

    class cashbookAdminView extends cashbook {

    	/**
         * @brief 초기화
         **/
        function init() {
        	// 모듈정보를 가져온다.
            $oCashbookModel = &getModel('cashbook');
            $this->module_info = $oCashbookModel->getModuleInfo();
            Context::set('module_info',$this->module_info);
			
            // 템플릿정보를 가져온다.
            $this->setTemplatePath($this->module_path."/tpl/");
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }

        /**
         * 설치정보수정
         * 
         * @return unknown_type
         */
		function dispCashbookAdminSetup() {
			// 스킨목록가져오기
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록가져오기
            $oLayoutMode = &getModel('layout');
            $layout_list = $oLayoutMode->getLayoutList();
            Context::set('layout_list', $layout_list);
            
            // 템플릿파일이름 정하기
            $this->setTemplateFile('setup');
        }
        
    	/*
         * 금전출납부설정목록
         * 
         * 금전출납부를 개설한 회원의 목록을 볼 수 있다.
         * 
         */
        function dispCashbookAdminConfigList(){

        	$page = Context::get('page');
            if(!$page) $page = 1;

            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getConfigList(20, $page, 'regdate');          
			Context::set('page', $output->page);
            Context::set('config_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿파일이름 정하기
            $this->setTemplateFile('config_list');
        }
        
        /*
         * 금전출납부설정수정
         * 
         * 금전출납부를 개설한 회원의 설정을 수정한다.
         * 
         */
        function dispCashbookAdminConfigEdit(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

        	// 환경설정정보 가져옴
        	$oCashbookModel = &getModel('cashbook');
        	$output = $oCashbookModel->getConfigByModuleSrl($args);
        	Context::set('config', $output);

        	// 스킨 목록을 구해옴
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
	        
            // 분류 목록을 가져옴
            $args->member_srl = $output->member_srl;
            $output = $oCashbookModel->getCategoryAllByMemberSrl($args);
            Context::set('category_list', $output->data);
            
        	// 템플릿파일이름 정하기
            $this->setTemplateFile('config_input');
        }
    }
    
?>