<?php
    /**
     * 사용자 화면정의
     * 
     * @class  cashbookView
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 View class
     **/

    class cashbookView extends cashbook {
    	var $logged_info = null ;    // 이값이 있으면 로그인 상태라고~
    	
    	/**
         * @brief 초기화
         **/
        function init() {
        	
        	// 로그인한 정보를 가져온다.
			$this->logged_info = Context::get('logged_info');
			
			// 로그인체크
			if($this->logged_info){
				
	        	/**
	             * @brief 금전출납부 모듈의 기본 설정은 view에서는 언제든지 사용하도록 load하여 Context setting
	             **/
	            $oCashbookModel = &getModel('cashbook');
	            $oModuleModel = &getModel('module');

	            $current_module_info = Context::get('current_module_info');
	            $current_module_info->layout_srl = $this->module_info->layout_srl = $this->module_info->layout_srl;
	            Context::set('current_module_info', $current_module_info);
            
				/**
	             * 스킨 경로를 미리 template_path 라는 변수로 설정함
	             * 스킨이 존재하지 않는다면 금전출납부 기본 설정의 스킨으로 설정
	             **/
	            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
	            if(!is_dir($template_path)||!$this->module_info->skin) {
	                $this->module_info->skin = $this->module_info->cashbook_default_skin;
	                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
	            }
	            $this->setTemplatePath($template_path);

	            // 로그인한 사용자의 금전출납부 설정을 view에서 언제든지 사용하도록 load하여 Context setting
	            $myCashbookConfig = $oCashbookModel->getConfigByMember();

				Context::set('myCashbookConfig', $myCashbookConfig);		
				Context::set('isMyCashbook', $myCashbookConfig->isMyCashbook());
	
	            // 금전출납부는 별도 레이아웃 동작하지 않도록 변경
	            Context::set('layout', 'none');
	            if(!Context::get('mid')) Context::set('mid', $this->module_info->mid, true);
			} else {
				return $this->stop('msg_not_logged');
			}
        }
        
        /**
         * 금전출납부 초기화면, 사용자 Index Action
         * 
         * @return unknown_type
         */
        function dispCashbookDashboard(){

			// 금전출납부가 존재하면
        	if(Context::get('isMyCashbook')){
					            
	            // mid로 넘어온 module정보를 가져옴
	            $oCashbookModel = &getModel('cashbook');
	            $current_module_info = Context::get('current_module_info');
	            $cashbookConfigByMid = $oCashbookModel->getConfigByMid($current_module_info);

        		// 로그인한 사용자의 member_srl과 현재 mid로 넘어온 module정보에 있는  member_srl이 같은지 검사
        		// dummy mid라면....   		
				if($cashbookConfigByMid->member_srl==null || Context::get('myCashbookConfig')->member_srl==$cashbookConfigByMid->member_srl){
	        		// site_srl, module_srl, member_srl값을 가져온다.
		            $site_module_info = Context::get('site_module_info');	// site_srl
		            $args->site_srl = (int)$site_module_info->site_srl;
		            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
					$args->module_srl = $myCashbookConfig->module_srl;
		            $member_info = Context::get('logged_info');
		            $args->member_srl = $member_info->member_srl;			// member_srl
	            
	        		// 계정목록가져오기
		            $output = $oCashbookModel->getAccountAll($args);
	
		            // 자산계산
		            $asset_total = 0;     // 자산의 합
		            foreach($output->data as $key => $val) {
		            	$amount_total = 0;    // 거래금액의 합을 자산이 시작할 때 초기화한다.	            	
		            	$args->account_srl = $val->getAccountSrl();
						// 계정에 해당하는 거래 가져오기
						$outputDeal = $oCashbookModel->getDealByAccount($args);
						if(count($outputDeal->data)>1) {
			            	foreach($outputDeal->data as $k => $v) {
								$amount_total += $v->amount;
							}
						} else {
							$amount_total += $outputDeal->data->amount;
						}
						$val->amount_total = $amount_total;
						$oCashbookAccount = null;
	                    $oCashbookAccount = new CashbookAccount();
	                    $oCashbookAccount->setAttribute($val);
	                    $account_list[$key] = $oCashbookAccount;               
	                    // 계정기본금액을 자산에 더하기
	                    $asset_total += $val->amount;                 
	                    // 거래금액을 자산에 더하기
	                    $asset_total += $amount_total;
		            }
	
		            Context::set('asset_total', $asset_total);
		            Context::set('account_list', $account_list);
	
		            // 주간거래가져오기
		            // 오늘로부터 7일전 날짜 가져오기
		            $timestamp=mktime(0,0,0,date("n"),date("j"),date("Y"));
					$last_week=strtotime("-1 week",$timestamp);
					$lastWeekYear = date("Y",$last_week);
					$lastWeekMonth = date("n",$last_week);
					$lastWeekDay = date("j",$last_week); 
	
		            $tempYear = date("Y");
		            $tempMonth = date("n");
		            if($tempMonth < 10){
		            	$tempMonth = "0".$tempMonth;
		            }
		            $tempDay = date("j");
		        	if($tempMonth < 10){
		            	$tempDay = "0".$tempDay;
		            }
		            $args->sort_index = "input_date";	// 정렬 컬럼
		            $args->start_day = $lastWeekYear.$lastWeekMonth.$lastWeekDay;
		            $args->end_day = $tempYear.$tempMonth.$tempDay;
		            $output = $oCashbookModel->getDealListByPeriod($args);
		            $deal_week_list;
		            for($i=0;$i<7;$i++){
		            	$tmpTimestamp = mktime(0,0,0,date("n"),date("j")-$i,date("Y"));
						$tmpTime=strtotime("-1 day",$tmpTimestamp);
						$tmpYear = date("Y",$tmpTime);
						$tmpMonth = date("n",$tmpTime);
						$tmpDay = date("j",$tmpTime); 
			            if($tmpMonth < 10){
			            	$tmpMonth = "0".$tmpMonth;
			            }
			        	if($tmpDay < 10){
			            	$tmpDay = "0".$tmpDay;
			            }
		            	$val->day = $tmpYear.$tmpMonth.$tmpDay;
		            	$incomeCount = 0;
		            	$outgoCount = 0;
		            	$transferCount = 0;
		            	// 수입/지출/이체 수 계산하기
		            	if($output->data!=null){
			            	foreach($output->data as $n => $v){
		            			if($v->day==$val->day && $v->amount>0){
		            				$incomeCount++;
		            			}
			            		if($v->day==$val->day && $v->amount<0){
		            				$incomeCount++;
		            			}
			            		if($v->day==$val->day && $v->transfer_srl>0){
		            				$transferCount++;
		            			}
			            	}
		            	}
		            	$val->income_count = $incomeCount;
		            	$val->outgo_count = $outgoCount;
		            	$val->transfer_count = $transferCount/2;
		            	
			            $oCashbookDealCount = null;
	                    $oCashbookDealCount = new CashbookDealCount();
	                    $oCashbookDealCount->setAttribute($val);
	                    $deal_week_list[$i] = $oCashbookDealCount;
		            }
		            
		            Context::set('deal_week_list', $deal_week_list);
					
					// 	거래처가져오기
		            $output = $oCashbookModel->getCustomerListAll($args);
			        Context::set('customer_list', $output->data);
			            
			            // 계정별거래수가져오기
	//		            $args->todayDate = $tempYear.$tempMonth.$tempDay;
	//		            $args->yesterdayDate = $tempYear.$tempMonth.($tempDay-1);
	//		            $output = $oCashbookModel->getDealCountWithAccount($args);
			        
		            Context::set('today', $tempYear.$tempMonth.$tempDay);
		            
		        	// 템플릿 지정 - 대쉬보드
		            $this->setTemplateFile('dashboard');
				} else {
					return $this->stop('cashbook_not_yours');	// 자기자신의 금전출납부가 아닌 남의 금전출납부임
				}
        	} else {
        		// 스킨 목록을 구해옴
	            $oModuleModel = &getModel('module');
	            $skin_list = $oModuleModel->getSkins($this->module_path);
	            Context::set('skin_list',$skin_list);
            
        		// 템플릿 지정 - 생성
	            $this->setTemplateFile('create');
        	}

        }
        
        /**
         * @brief 수입 > 수입목록
         * 
         * @return unknown_type
         */
        function dispCashbookIncomeList(){
		
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'day' :
                            $args->s_day = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'item' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_item_name = $search_keyword;
                        break;
                    case 'category' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_category_name = $search_keyword;
                        break;
                    case 'customer' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_customer_name = $search_keyword;
                        break;
                    case 'tag' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_tag = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			Context::set('page', $output->page);
			
			// 기타조건
			$args->amount = 0;	// 0보다 큰넘만 가져와라...

            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getIncomeList($args);
        	Context::set('deal_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
        /**
         * @brief 수입 > 수입등록
         * 
         * @return unknown_type
         */
        function dispCashbookIncomeWrite(){

			// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 계정가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            $myCashbookConfig = Context::get('myCashbookConfig');
            
            // 수입항목가져오기
            if($myCashbookConfig->income_category_srl>0){
	            $args->category_srl = $myCashbookConfig->income_category_srl;
	            $args->parent_srl = 0;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
debugPrint($output);	            
	            Context::set('item_list', $output->data);
            }

            // 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            } 
      
        	// 거래처가져오기
            $output = $oCashbookModel->getCustomerListAll($args);
	        Context::set('customer_list', $output->data);
            
	        // 거래일자에 기본값을 주기 위해
			$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
        	if($args->pYear==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= $args->pYear;
        	}
        	if($args->pMonth==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= $args->pMonth;
        	}
        	if($args->pDay==null){
        		$pDay = $todayDay;
        	} else {
        		$pDay= $args->pDay;
        	}
        	if($pMonth<10){
				$tempMonth = "0".$pMonth;
			} else {
				$tempMonth = $pMonth;
			}
        	if($pDay<10){
				$tempDay = "0".$pDay;
			} else {
				$tempDay = $pDay;
			}
		
			Context::set('currentDate', $pYear.$tempMonth.$tempDay);
			
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 수입 > 수입수정
         * 
         * @return unknown_type
         */
        function dispCashbookIncomeEdit(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
			
        	// 계정목록가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            // 수입항목가져오기
            $myCashbookConfig = Context::get('myCashbookConfig');
            $args->category_srl = $myCashbookConfig->income_category_srl;
            $args->parent_srl = 0;
            $output = $oCashbookModel->getCategoryItemParentList($args);
            Context::set('item_list', $output->data);
            
            // 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);            
	            Context::set('category_list', $output->data);
            }
            
        	// 거래처가져오기
            $output = $oCashbookModel->getCustomerListAll($args);
	        Context::set('customer_list', $output->data);
            
            // 수입정보가져오기
            $args->deal_srl = Context::get('deal_srl');
            $output = $oCashbookModel->getDeal($args);

            Context::set('deal', $output);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 지출 > 지출목록
         * 
         * @return unknown_type
         */
        function dispCashbookOutgoList(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'day' :
                            $args->s_day = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'item' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_item_name = $search_keyword;
                        break;
                    case 'category' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_category_name = $search_keyword;
                        break;
                    case 'customer' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_customer_name = $search_keyword;
                        break;
                    case 'tag' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_tag = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			
			// 기타조건
			$args->amount = 0;	// 0보다 작은넘만 가져와라...

            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getOutgoList($args);
        
			Context::set('page', $output->page);
            Context::set('deal_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
    	/**
         * @brief 지출 > 지출등록
         * 
         * @return unknown_type
         */
        function dispCashbookOutgoWrite(){        	
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl

        	// 계정가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            $myCashbookConfig = Context::get('myCashbookConfig');
            
            // 지출항목가져오기
            if($myCashbookConfig->income_category_srl>0){
	            $args->category_srl = $myCashbookConfig->outgo_category_srl;
	            $args->parent_srl = 0;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('item_list', $output->data);
            }

            // 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            } 
      
        	// 거래처가져오기
            $output = $oCashbookModel->getCustomerListAll($args);
	        Context::set('customer_list', $output->data);
			
	        // 거래일자에 기본값을 주기 위해
			$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
        	if($args->pYear==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= $args->pYear;
        	}
        	if($args->pMonth==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= $args->pMonth;
        	}
        	if($args->pDay==null){
        		$pDay = $todayDay;
        	} else {
        		$pDay= $args->pDay;
        	}
        	if($pMonth<10){
				$tempMonth = "0".$pMonth;
			} else {
				$tempMonth = $pMonth;
			}
        	if($pDay<10){
				$tempDay = "0".$pDay;
			} else {
				$tempDay = $pDay;
			}
		
			Context::set('currentDate', $pYear.$tempMonth.$tempDay);
			
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
	    }
        
    	/**
         * @brief 지출 > 지출수정
         * 
         * @return unknown_type
         */
        function dispCashbookOutgoEdit(){
        	
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
			
        	// 계정목록가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            // 지출항목가져오기
            $myCashbookConfig = Context::get('myCashbookConfig');
            $args->category_srl = $myCashbookConfig->outgo_category_srl;
            $args->parent_srl = 0;
            $output = $oCashbookModel->getCategoryItemParentList($args);
            Context::set('item_list', $output->data);
            
        	// 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
        	// 거래처가져오기
            $output = $oCashbookModel->getCustomerListAll($args);
	        Context::set('customer_list', $output->data);
            
            // 지출정보가져오기
            $args->deal_srl = Context::get('deal_srl');
            $output = $oCashbookModel->getDeal($args);

            Context::set('deal', $output);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 이체 > 이체목록
         * 
         * @return unknown_type
         */
        function dispCashbookTransferList(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "deal_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'day' :
                            $args->s_day = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			
			// 기타조건
			$args->transfer_srl = 0;	// 0보다 큰넘만 가져와라...

            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getTransferList($args);
        
			Context::set('page', $output->page);
            Context::set('deal_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_list');
        }
        
    	/**
         * @brief 이체 > 이체등록
         * 
         * @return unknown_type
         */
        function dispCashbookTransferWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
			
        	// 계정목록가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            // 지출항목가져오기
            $myCashbookConfig = Context::get('myCashbookConfig');
            $args->category_srl = $myCashbookConfig->outgo_category_srl;
            $args->parent_srl = 0;
            $output = $oCashbookModel->getCategoryItemParentList($args);
            Context::set('item_list', $output->data);
            
            // 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
            // 거래일자에 기본값을 주기 위해
			$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
        	if($args->pYear==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= $args->pYear;
        	}
        	if($args->pMonth==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= $args->pMonth;
        	}
        	if($args->pDay==null){
        		$pDay = $todayDay;
        	} else {
        		$pDay= $args->pDay;
        	}
        	if($pMonth<10){
				$tempMonth = "0".$pMonth;
			} else {
				$tempMonth = $pMonth;
			}
        	if($pDay<10){
				$tempDay = "0".$pDay;
			} else {
				$tempDay = $pDay;
			}
		
			Context::set('currentDate', $pYear.$tempMonth.$tempDay);
			
            // 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * @brief 이체 > 이체수정
         * 
         * @return unknown_type
         */
        function dispCashbookTransferEdit(){
        	
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
			
        	// 계정목록가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountListAll($args);
            Context::set('account_list', $output->data);
            
            // 지출항목가져오기
            $myCashbookConfig = Context::get('myCashbookConfig');
            $args->category_srl = $myCashbookConfig->outgo_category_srl;
            $args->parent_srl = 0;
            $output = $oCashbookModel->getCategoryItemParentList($args);
            Context::set('item_list', $output->data);
            
            // 거래분류가져오기
            if($myCashbookConfig->deal_category_srl>0){
	            $args->category_srl = $myCashbookConfig->deal_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
            // 지출정보가져오기
            $args->deal_srl = Context::get('deal_srl');
            $output = $oCashbookModel->getDeal($args);

            Context::set('deal', $output);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_input');
        }
        
    	/**
         * 거래 > 년간거래
         * 
         * @return unknown_type
         */
        function dispCashbookDealYear(){
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_year');
        }
        
        /**
         * 거래 > 월간거래
         * 
         * @return unknown_type
         */
        function dispCashbookDealMonth(){
        	$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
        	if(Context::get('pYear')==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= Context::get('pYear');
        	}
        	if(Context::get('pMonth')==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= Context::get('pMonth');
        	}

        	$oCashbookCalendar = new CashbookCalendar($pYear,$pMonth);
        	Context::set('todayYear',$todayYear);
        	Context::set('todayMonth',$todayMonth);
        	Context::set('todayDay',$todayDay);
        	
        	Context::set('pYear',$pYear);
        	Context::set('pMonth',$pMonth);
        	Context::set('cashbookCalendar',$oCashbookCalendar);
			
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 수입총합 가져오기
        	$oCashbookModel = &getModel('cashbook');
        	$args->amount = 0;
        	$args->start_day = $pYear . $pMonth . "01";
        	$args->end_day = $pYear . $pMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);

        	if($pMonth<10){
				$tempMonth = "0".$pMonth;
			} else {
				$tempMonth = $pMonth;
			}
			$args->start_day = $pYear . $tempMonth . "01";
			$args->end_day = $pYear . $tempMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);
			// 수입총합 가져오기
            $output = $oCashbookModel->getIncomeSum($args);
            Context::set('income_sum', $output);
            // 지출총합 가져오기
            $output = $oCashbookModel->getOutgoSum($args);
            Context::set('outgo_sum', $output);
			
            // 전월계산하기
            if($pMonth==1){
            	$prevYear = $pYear - 1;
            	$prevMonth = 12;
            } else {
            	$prevYear = $pYear;
            	$prevMonth = $pMonth - 1;
            }
            Context::set('prevYear', $prevYear);
            Context::set('prevMonth', $prevMonth);
            
            // 익월계산하기
        	if($pMonth==12){
            	$nextYear = $pYear + 1;
            	$nextMonth = 1;
            } else {
            	$nextYear = $pYear;
            	$nextMonth = $pMonth + 1;
            }
            Context::set('nextYear', $nextYear);
            Context::set('nextMonth', $nextMonth);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_month');
        }
        
    	/**
         * 거래 > 주간거래
         * 
         * @return unknown_type
         */
        function dispCashbookDealWeek(){
        	$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일
			
        	if(Context::get('pYear')==null){
        		$pYear = $todayYear;
        	} else {
        		$pYear= Context::get('pYear');
        	}
        	if(Context::get('pMonth')==null){
        		$pMonth = $todayMonth;
        	} else {
        		$pMonth= Context::get('pMonth');
        	}

        	$oCashbookCalendar = new CashbookCalendar($pYear,$pMonth);
        	Context::set('todayYear',$todayYear);
        	Context::set('todayMonth',$todayMonth);
        	Context::set('todayDay',$todayDay);
        	
        	Context::set('pYear',$pYear);
        	Context::set('pMonth',$pMonth);
        	Context::set('cashbookCalendar',$oCashbookCalendar);
        	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_week');
        }
        
    	/**
         * @brief 거래 > 일간거래
         * 
         * @return unknown_type
         */
        function dispCashbookDealDay(){
        	$initPeriod = Context::get('initPeriod');
        	if(!$initPeriod) $initPeriod= "N";
        	Context::set('initPeriod',$initPeriod);
        	
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="item") $order_target = "item_name";
            if($order_target=="category") $order_target = "category_name";
            if($order_target=="customer") $order_target = "customer_name";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
			
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'day' :
                            $args->s_day = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'item' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_item_name = $search_keyword;
                        break;
                    case 'category' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_category_name = $search_keyword;
                        break;
                    case 'customer' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_customer_name = $search_keyword;
                        break;
                    case 'tag' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_tag = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 시작일, 종료일
        	$todayYear = date("Y");	// 당일년도
			$todayMonth = date("n");	// 당일월
			$todayDay = date("j");	// 당일일

        	if(Context::get('startDate')==null){
        		$pYear = $todayYear;
	        	if($pMonth<10){
					$tempMonth = "0".$pMonth;
				} else {
					$tempMonth = $pMonth;
				}
        		$pStartDate = $todayYear . $tempMonth . "01";
        	} else {
        		$pStartDate= Context::get('startDate');
        		$pYear = substr($pStartDate,0,3);
        	}
        	if(Context::get('endDate')==null){
        		$pYear = $todayYear;
        		$pMonth = $todayMonth;
        		if($pMonth<10){
					$tempMonth = "0".$pMonth;
				} else {
					$tempMonth = $pMonth;
				}
        		$oCashbookCalendar = new CashbookCalendar($pYear,$pMonth);
        		$pEndDate = $todayYear . $tempMonth . $oCashbookCalendar->getMonthCount($pYear,$pMonth);
        	} else {
        		$pEndDate= Context::get('endDate');
        		$pYear = substr($pEndDate,0,3);
        	}
        	$args->start_day = $pStartDate;
        	$args->end_day = $pEndDate;
        	Context::set('startDate',$pStartDate);
        	Context::set('endDate',$pEndDate);
        	
        	// 수입총합 가져오기
        	$oCashbookModel = &getModel('cashbook');
        	$args->amount = 0;
			// 수입총합 가져오기
            $output = $oCashbookModel->getIncomeSum($args);
debugPrint($output);            
            Context::set('income_sum', $output);
            // 지출총합 가져오기
            $output = $oCashbookModel->getOutgoSum($args);
            Context::set('outgo_sum', $output);
            
        	// 쿼리실행
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getDealListByPeriod($args);
            Context::set('deal_list', $output->data);

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('deal_day');
        }
        
    	/**
         * 통계 > 거래그래프
         * @return unknown_type
         */
        function dispCashbookDealChart(){
        	debugPrint("dispCashbookDealChart");
        	// XE설치위치 구하기
        	debugPrint(getUrl());
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 통계 > 수입항목별그래프
         * @return unknown_type
         */
        function dispCashbookIncomeItemChart(){      	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 통계 > 지출항목별그래프
         * @return unknown_type
         */
        function dispCashbookOutgoItemChart(){      	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 통계 > 거래처별그래프
         * @return unknown_type
         */
        function dispCashbookCustomerChart(){      	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 통계 > 분류별그래프
         * @return unknown_type
         */
        function dispCashbookCategoryChart(){      	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
    	/**
         * 통계 > 태그류별그래프
         * @return unknown_type
         */
        function dispCashbookTagChart(){      	
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('chart');
        }
        
        /**
         * @brief 설정 > 계정목록
         * 
         * @return unknown_type
         */
        function dispCashbookAccountList(){

            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "account_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
			
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'kind' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            // 종류검색 (한국어)
							if($search_keyword=='현금'){
								$search_keyword = "CASH";
							}
                			if($search_keyword=='은행'){
								$search_keyword = "BANK";
							}
                			if($search_keyword=='자산'){
								$search_keyword = "ASSET";
							}
                			if($search_keyword=='카드'){
								$search_keyword = "CARD";
							}
                			if($search_keyword=='부채'){
								$search_keyword = "DEBT";
							}
                            $args->s_kind = $search_keyword;
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'amount' :
                            $args->s_amount = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_more' :
                            $args->s_amount_more = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'amount_less' :
                            $args->s_amount_less = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }

            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			
			// 계정목록 가져오기
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccountList($args);
debugPrint($output);
            Context::set('page', $output->page);
            Context::set('account_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_list');
        }
        
   		 /**
         * @brief 설정 > 계정목록 > 계정수정
         * 
         * @return unknown_type
         */
        function dispCashbookAccountEdit(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');
            
        	// 계정정보가져오기
            $args->account_srl = Context::get('account_srl');
            
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getAccount($args);
debugPrint($output);            
            Context::set('account', $output);

        	// 현금계정분류가져오기
            if($output->kind=='CASH' && $myCashbookConfig->cash_category_srl>0){
	            $args->category_srl = $myCashbookConfig->cash_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
        	// 은행계정분류가져오기
            if($output->kind=='BANK' && $myCashbookConfig->bank_category_srl>0){
	            $args->category_srl = $myCashbookConfig->bank_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
        	// 자산계정분류가져오기
            if($output->kind=='ASSET' && $myCashbookConfig->asset_category_srl>0){
	            $args->category_srl = $myCashbookConfig->asset_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
            
            // 카드계정분류가져오기
            if($output->kind=='CARD' && $myCashbookConfig->card_category_srl>0){
	            $args->category_srl = $myCashbookConfig->card_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }
	            
        	// 부채계정분류가져오기
            if($output->kind=='DEBT' && $myCashbookConfig->debt_category_srl>0){
	            $args->category_srl = $myCashbookConfig->debt_category_srl;
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            Context::set('category_list', $output->data);
            }

        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
        /**
         * @brief 설정 > 계정목록 > 현금계정추가
         * 
         * @return unknown_type
         */
        function dispCashbookAccountCashWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');
			
        	// 현금계정분류가져오기
            if($myCashbookConfig->cash_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->cash_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);	            
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * @brief 설정 > 계정목록 > 은행계정추가
         * 
         * @return unknown_type
         */
        function dispCashbookAccountBankWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');
			
        	// 은행계정분류가져오기
            if($myCashbookConfig->bank_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->bank_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);	            
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * @brief 설정 > 계정목록 > 자산계정추가
         * 
         * @return unknown_type
         */
        function dispCashbookAccountAssetWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');

        	// 자산계정분류가져오기
            if($myCashbookConfig->asset_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->asset_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);	            
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * @brief 설정 > 계정목록 > 카드계정추가
         * 
         * @return unknown_type
         */
        function dispCashbookAccountCardWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');

        	// 카드계정분류가져오기
            if($myCashbookConfig->card_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->card_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);	            
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * @brief 설정 > 계정목록 > 부채계정추가
         * 
         * @return unknown_type
         */
        function dispCashbookAccountDebtWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			$args->parent_srl = 0;
			
			$myCashbookConfig = Context::get('myCashbookConfig');
			$oCashbookModel = &getModel('cashbook');

        	// 부채계정분류가져오기
            if($myCashbookConfig->debt_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->debt_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);	            
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('account_input');
        }
        
    	/**
         * @brief 설정 > 거래처목록
         * 
         * @return unknown_type
         */
        function dispCashbookCustomerList(){

            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "customer_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
        	// 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);
			
        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'category' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_category_name = $search_keyword;
                        break;
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'phone' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_phone = $search_keyword;
                        break;
                    case 'memo' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_memo = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			Context::set('page', $output->page);
			
			// 기타조건
			$args->amount = 0;	// 0보다 큰넘만 가져와라...

			// 쿼리실행
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCustomerList($args);
debugPrint($output);
            // 데이터담기
			Context::set('page', $output->page);
            Context::set('customer_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
        	// 템플릿지정
			$this->setTemplateFile('customer_list');
        }
        
    	/**
         * @brief 설정 > 거래처등록
         * 
         * @return unknown_type
         */
        function dispCashbookCustomerWrite(){
			// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			// 금전출납부설정가져오기
        	$myCashbookConfig = Context::get('myCashbookConfig');
        	
        	// 거래처분류가져오기
            if($myCashbookConfig->customer_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->customer_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('customer_input');
        }
        
    	/**
         * @brief 설정 > 거래처수정
         * 
         * @return unknown_type
         */
        function dispCashbookCustomerEdit(){
			// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
			// 금전출납부설정가져오기
        	$myCashbookConfig = Context::get('myCashbookConfig');
        	
        	// 거래처분류가져오기
            if($myCashbookConfig->customer_category_srl>0){
            	// 파라미터설정
            	$args->category_srl = $myCashbookConfig->customer_category_srl;
            	$args->parent_srl = 0;
            	// 쿼리실행
            	$oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->getCategoryItemParentList($args);
	            // 데이터담기
	            Context::set('category_list', $output->data);
            }
			
            $args->customer_srl = Context::get('customer_srl');
            
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCustomer($args);
            Context::set('customer', $output);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('customer_input');
        }
        
        /**
         * @brief 설정 > 분류목록
         * @return unknown_type
         */
        function dispCashbookCategoryList(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 정렬
            $order_target = Context::get('order_target');	// order_target
            if(!$order_target) $order_target = "input_date";
            if($order_target=="no") $order_target = "category_srl";
            $args->order_target = $order_target;	// 정렬 컬럼
            $order_type = Context::get('order_type');	// order_type
            if(!$order_type) $order_type = "desc";
            $args->order_type = $order_type;         // 정렬 방법
            
            // 검색
            $search_target = trim(Context::get('search_target'));	// search_target
            Context::set('search_target', $search_target);
            $search_keyword = trim(Context::get('search_keyword'));	// search_keyword
			Context::set('search_keyword', $search_keyword);

        	if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'title' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_title = $search_keyword;
                        break;
                    case 'input_date' :
                            $args->s_input_date = ereg_replace("[^0-9]","",$search_keyword);
                        break;
                    case 'input_date_more' :
                            $args->s_input_date_more = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                    case 'input_date_less' :
                            $args->s_input_date_less = substr(ereg_replace("[^0-9]","",$search_keyword) . '00000000000000',0,14);
                        break;
                }
            }
            
            // 목록수
            $list_count = Context::get('list_count');	// list_count
            if(!$list_count) $list_count= 20;
            $args->list_count = $list_count;
            
			// 페이지
        	$page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;
			Context::set('page', $output->page);
			
			// 쿼리실행
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCategoryList($args);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('category_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
			
            // 템플릿파일설정
            $this->setTemplateFile('category_list');
        }
        
        /**
         * @brief 설정 > 분류등록
         * 
         * @return unknown_type
         */
        function dispCashbookCategoryWrite(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 선택된 분류의 정보를 구해서 세팅 
            $category_srl = Context::get('category_srl');

            if($category_srl) {
                // 분류의 정보를 가져옴
                $oCashbookModel = &getModel('cashbook');
                $category_info = $oCashbookModel->getCategory($category_srl);
                if($category_info->category_srl == $category_srl) {
                	Context::set('category_info', $category_info);
                }
            }

            $this->setTemplateFile('category_write');
        }
        
    	/**
         * @brief 설정 > 분류관리
         **/
        function dispCashbookCategoryManagement() {
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 선택된 분류의 정보를 구해서 세팅 
            $category_srl = Context::get('category_srl');
			
            // 넘어온값이 없으면 목록으로
            if(!$category_srl) {
            	return $this->dispCashbookCategoryList();
            }

            // 분류의 정보를 가져옴
            $oCashbookModel = &getModel('cashbook');
			$category_info = $oCashbookModel->getCategory($category_srl);

            if($category_info->category_srl != $category_srl) {
            	return $this->dispCategoryList();
            }

            Context::set('category_info', $category_info);

            // 레이아웃을 팝업으로 지정
            $this->setTemplateFile('category_management');
        }
        
        /**
         * @brief 설정 > 환경설정
         * 
         * @return unknown_type
         */
        function dispCashbookConfigEdit(){
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 환경설정정보 가져옴
        	$oCashbookModel = &getModel('cashbook');
        	Context::set('config', $oCashbookModel->getConfigByMember());
        	
        	// 스킨 목록을 구해옴
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
	        
            // 분류 목록을 가져옴
            $output = $oCashbookModel->getCategories($args);
            Context::set('category_list', $output->data);
            
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('config_edit');
        }
        
        /**
         * 초기화
         * @return unknown_type
         */
        function dispCashbookInit(){
        	// 템플릿 지정 - 생성
			$this->setTemplateFile('init');
        }

    }
    
?>