<?php

    class cashbookConfig extends Object {
    	var $mid                   = null;    // modules에 저장된 mid 
    	var $browser_title         = null;    // 
    	var $config_srl            = null;    // 일련번호
    	var $site_srl              = null;    // 사이트일련번호, site.site_srl
    	var $module_srl            = null;    // 모듈일련번호, modules.module_srl
		var $member_srl            = null;    // 회원일련번호, member.member_srl
		var $family_type           = null;    // 가계유형, cashbook.family_type
		var $child_count           = null;    // 자녀수, cashbook.child_count
		var $month_income          = null;    // 월소득, cashbook.month_income
		var $start_day             = null;    // 월시작일, cashbook.start_day
		var $income_category_srl   = null;    // 수입항목
		var $outgo_category_srl    = null;    // 지출항목
		var $deal_category_srl     = null;    // 거래분류
		var $cash_category_srl     = null;	  // 현금계정분류
		var $bank_category_srl     = null;    // 은행계정분류
		var $asset_category_srl    = null;    // 자산계정분류
		var $card_category_srl     = null;    // 카드계정분류
		var $debt_category_srl     = null;    // 부채계정분류
		var $customer_category_srl = null;    // 거래처분류
		var $lunar_yn              = null;    // 음력표시여부
		var $memorial_yn           = null;    // 기념일표시여부
		var $currency              = null; 
		/**
		 * 생성자
		 * 
		 * @param $cashbook_srl
		 * @return unknown_type
		 */
        function cashbookConfig($config_srl = 0) { 
            if(!$config_srl) return;
            $this->setCashbookConfig($config_srl);
        }
        
    	/**
         * 인설정 세팅하기
         * 
         * @param $config_srl
         * @return unknown_type
         */
        function setCashbookConfig($config_srl) { 
            $this->module_srl = $this->config_srl = $config_srl;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 설정 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->config_srl) return;

            $args->module_srl = $this->config_srl;
            $output = executeQuery('cashbook.getConfig', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->config_srl = $attribute->config_srl;
        	$this->site_srl = $attribute->site_srl;
            $this->module_srl =  $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->family_type = $attribute->family_type;
            $this->child_count = $attribute->child_count;
            $this->month_income = $attribute->month_income;
            $this->start_day = $attribute->start_day;
            $this->income_category_srl = $attribute->income_category_srl;
            $this->outgo_category_srl = $attribute->outgo_category_srl;
            $this->deal_category_srl = $attribute->deal_category_srl;
            $this->cash_category_srl = $attribute->cash_category_srl;
            $this->bank_category_srl = $attribute->bank_category_srl;
            $this->asset_category_srl = $attribute->asset_category_srl;
            $this->card_category_srl = $attribute->card_category_srl;
            $this->debt_category_srl = $attribute->debt_category_srl;
            $this->customer_category_srl = $attribute->customer_category_srl;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->config_srl?true:false;
        }
        
    	/**
         * 소유여부
         * 
         * @param $planet
         * @return unknown_type
         */
    	function isMyCashbook($cashbookConfig = null) {
            if(!$this->isExists()) return;
            if(!Context::get('is_logged')) return false;
            $logged_info = Context::get('logged_info');
            if($cashbookConfig) return $logged_info->member_srl == $cashbookConfig->get('member_srl');
            return $logged_info->member_srl == $this->get('member_srl');
        }
        
    	/**
         * getter
         * 
         * @return unknown_type
         */
    	function getFamilyType() {
            if(!$this->isExists()) return;
            return $this->get('family_type');
        }
    	
        function getChildCount() {
            if(!$this->isExists()) return;
            return $this->get('child_count');
        }
        
    	function getMonthIncome() {
            if(!$this->isExists()) return;
            return $this->get('month_income');
        }
        
    	function getStartDay() {
            if(!$this->isExists()) return;
            return $this->get('start_day');
        }
        
    	function getIncomeCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('income_category_srl');
        }
        
    	function getOutgoCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('outgo_category_srl');
        }
        
    	function getDealCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('deal_category_srl');
        }
        
    	function getCashCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('cash_category_srl');
        }
        
    	function getBankCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('bank_category_srl');
        }
        
    	function getAssetCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('asset_category_srl');
        }
        
    	function getCardCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('card_category_srl');
        }
        
    	function getDebtCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('debt_category_srl');
        }
        
    	function getCustomerCategorySrl() {
            if(!$this->isExists()) return;
            return $this->get('customer_category_srl');
        }
		
    	function getLunarYn() {
            if(!$this->isExists()) return;
            return $this->get('lunar_yn'); 
        }
        
    	function getMemorialYn() {
            if(!$this->isExists()) return;
            return $this->get('memorial_yn'); 
        }
        
    	function getCurrency() {
            if(!$this->isExists()) return;
            return $this->get('currency'); 
        }
        
   		function getBrowserTitle() {
            if(!$this->isExists()) return;
            return $this->get('browser_title');
        }

        function getCashbookTitle() {
            if(!$this->isExists()) return;
            return $this->get('cashbook_title');
        }
        
    	function getMid() {
            if(!$this->isExists()) return;
            return $this->get('mid');
        }
		
    	function getSiteSrl() {
            if(!$this->isExists()) return;
            return $this->get('site_srl');
        }
        function getMemberSrl() {
            if(!$this->isExists()) return;
            return $this->get('member_srl');
        }

        function getModuleSrl() {
            if(!$this->isExists()) return;
            return $this->module_srl;
        }

        function getConfigSrl() {
            if(!$this->isExists()) return;
            return $this->config_srl;
        }

        function getCashbookMid() {
            if(!$this->isExists()) return;
            return $this->get('mid');
        }

        function getNickName() {
            if(!$this->isExists()) return;
            return $this->get('nick_name'); 
        }

        function getUserName() {
            if(!$this->isExists()) return;
            return $this->get('user_name'); 
        }

        function getUserID() {
            if(!$this->isExists()) return;
            return $this->get('getUserID'); 
        }
    }
?>