<?php
    /**
     * 쿼리를 실행하는 클래스
     * 
     * @class  cashbookModel
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 Model class
     **/

    class cashbookModel extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {

        }
		
    	/**
         * @brief 모듈정보 return
         **/
        function getModuleInfo() {
            static $module_info = null;
            if(is_null($module_info)) {
            	
                // module module_info의 값을 구함
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('cashbook');

                $skin_info->module_srl = $module_info->module_srl;
                $oModuleModel->syncSkinInfoToModuleInfo($skin_info);

                // cashbook dummy module의 is_default 값을 구함
                $dummy = $oModuleModel->getModuleInfoByMid($module_info->mid);
                $module_info->is_default = $dummy->is_default;
                $module_info->module_srl = $dummy->module_srl;
                $module_info->browser_title = $dummy->browser_title;
                $module_info->layout_srl = $dummy->layout_srl;
                
                //if(count($skin_info)) foreach($skin_info as $key => $val) $module_info->{$key} = $val;

                unset($module_info->grants);
            }
            return $module_info;
        }
		
        /**
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateModule($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.updateModule', $args);
            if(!$output->toBool()) return $output;

            $output->add('module_srl', $args->module_srl);
            
            return $output;
        }
		
    	/**
         * modules 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteModules($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteModules', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * @brief 기본 설정 저장
         * 금전출납부의 전체 설정은 module config를 이용해서 저장함
         * 대상 : 기본 금전출납부 스킨, 권한, 스킨 정보
         **/
        function insertModuleInfo($module_info) {
            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('cashbook', $module_info);
        }

    	/**
         * @brief 금전출납부 설정 목록 return
         **/
        function getConfigList($list_count=20, $page=1, $sort_index = 'module_srl') {
            if(!in_array($sort_index, array('module_srl'))) $sort_index = 'module_srl';
            
            $args->sort_index = $sort_index;
            $args->list_count = $list_count;
            $args->page = $page;

            $output = executeQueryArray('cashbook.getConfigList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookConfig = null;
                    $oCashbookConfig = new CashbookConfig();
                    $oCashbookConfig->setAttribute($val);
                    $output->data[$key] = null;
                    $output->data[$key] = $oCashbookConfig;
                }
            }
            return $output;
        }
        
    	/**
         * @brief 금전출납부 설정 1개 가져오기
         **/
        function getConfigByMember() {

            // 로그인을 하지 않았을 경우
            if(!$member_srl && !Context::get('is_logged')) return new CashbookConfig();
            
            // 로그인을 했을 경우
            if(!$member_srl) {
                $logged_info = Context::get('logged_info');
                $args->member_srl = $logged_info->member_srl;
            } else {
                $args->member_srl = $member_srl;
            }

            // member_srl을 가지고 금전출납부 설정을 가져온다.
            $output = executeQuery('cashbook.getConfigByMember', $args);

            // 금전출납부가 없으면
            if(!$output->toBool() || !$output->data) {
            	return new CashbookConfig();
            }

            // 가져온 값을 리턴할 변수에 담는다.
            $oCashbookConfig = new CashbookConfig();
            $oCashbookConfig->setAttribute($output->data);

            return $oCashbookConfig;
        }
		
    	/**
         * @brief 관리자화면에서 금전출납부 설정 1개 가져오기
         **/
        function getConfigByModuleSrl($args) {

            // module_srl을 가지고 금전출납부 설정을 가져온다.
            $output = executeQuery('cashbook.getConfigByModuleSrl', $args);

            // 금전출납부가 없으면
            if(!$output->toBool() || !$output->data) {
            	return new CashbookConfig();
            }

            // 가져온 값을 리턴할 변수에 담는다.
            $oCashbookConfig = new CashbookConfig();
            $oCashbookConfig->setAttribute($output->data);

            return $oCashbookConfig;
        }
        
    	/**
         * @brief 설정 1개 가져오기
         **/
        function getConfigByMid($args) {

			// 쿼리실행
            $output = executeQuery('cashbook.getConfigByMid', $args);
debugPrint($output);
            // 금전출납부가 없으면
            if(!$output->toBool() || !$output->data) {
            	return new CashbookConfig();
            }

            // 가져온 값을 리턴할 변수에 담는다.
            $oCashbookConfig = new CashbookConfig();
            $oCashbookConfig->setAttribute($output->data);

            return $oCashbookConfig;
        }
        
    	/**
         * @brief 설정 1개 가져오기
         **/
        function getConfig($args) {

			// 쿼리실행
            $output = executeQuery('cashbook.getConfig', $args);
            
            // 금전출납부가 없으면
            if(!$output->toBool() || !$output->data) {
            	return new CashbookConfig();
            }

            // 가져온 값을 리턴할 변수에 담는다.
            $oCashbookConfig = new CashbookConfig();
            $oCashbookConfig->setAttribute($output->data);

            return $oCashbookConfig;
        }
        
    	/**
         * @brief 금전출납부 설정 입력
         * cashbook 테이블에 데이터를 입력한다.
         * 대상테이블: config
         * 
         * @param $output   cashbook.controller.php 에 있는 
         *                  $oModuleController->insertModule($oModuleModel) 함수 실행결과
         * @return unknown_type
         */
        function insertConfig($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.insertConfig', $args);
            if(!$output->toBool()) {
            	return $output;
            }

            $output->add('module_srl', $args->module_srl);
            
            return $output;
        }

        
    	/**
         * @brief 금전출납부 설정 수정
         * 
         * cashbook 테이블에 입력된 데이터를 수정한다.
         **/
        function updateConfig($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.updateConfig', $args);
            if(!$output->toBool()) return $output;

            // controller에서 사용하기위해
            $output->add('module_srl', $args->module_srl);
            $output->add('category_srl', $args->category_srl);
            
            return $output;
        }
        
    	/**
         * cashbook_config 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteConfig($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteConfig', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
        /**
         * 수입 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getIncomeList($args) {
            $output = executeQueryArray('cashbook.getIncomeList', $args);
debugPrint($output);
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 지출 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getOutgoList($args) {
        	
            $output = executeQueryArray('cashbook.getOutgoList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
		
    	/**
         * 이체 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getTransferList($args) {
            $output = executeQueryArray('cashbook.getTransferList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 거래 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getDealList($args) {
            $output = executeQueryArray('cashbook.getDealList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 주간거래수 가져오기
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getDealCountOnWeek($args) {
            $output = executeQueryArray('cashbook.getDealCountOnWeek', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookAccount = null;
                    $oCashbookAccount = new CashbookAccount();
                    $oCashbookAccount->setAttribute($val);
                    $output->data[$key] = $oCashbookAccount;
                }
            }
            return $output;
        	
        }
        
   	 	/**
         * 계정별 거래수 가져오기 (현재 사용안함)
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getDealCountWithAccount($args) {
            $output = executeQueryArray('cashbook.getDealCountWithAccount', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookAccount = null;
                    $oCashbookAccount = new CashbookAccount();
                    $oCashbookAccount->setAttribute($val);
                    $output->data[$key] = $oCashbookAccount;
                }
            }
            return $output;
        	
        }
        
    	/**
         * @brief 거래 1개 가져오기
         **/
        function getDealByAccount($args) {

			// 쿼리실행
            $output = executeQuery('cashbook.getDealByAccount', $args);

            if(!$output->toBool()) return $output;

            if(count($output->data)>1) {
                foreach($output->data as $key => $val) {              	
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            } else {
            	$oCashbookDeal = null;
				$oCashbookDeal = new CashbookDeal();			
				$oCashbookDeal->setAttribute($output->data);
				$output->data = $oCashbookDeal;
            }
            return $output;
        }
        
        /**
         * @brief 거래 1개 가져오기
         **/
        function getDeal($args) {

			// 쿼리실행
            $output = executeQuery('cashbook.getDeal', $args);
            
            // 금전출납부가 없으면
            if(!$output->toBool() || !$output->data) {
            	return new CashbookDeal();
            }

            // 가져온 값을 리턴할 변수에 담는다.
            $oCashbookDeal = new CashbookDeal();
            $oCashbookDeal->setAttribute($output->data);

            return $oCashbookDeal;
        }
                
    	/**
         * cashbook_deal 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertDeal($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.insertDeal', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * cashbook_deal 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateDeal($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.updateDeal', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

    	/**
         * cashbook_deal 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteDeal($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteDeal', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
		
    	/**
         * cashbook_deal 에서 이체거래삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteTransfer($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteTransfer', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * 수입거래삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteDealIncomeAll($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteDealIncomeAll', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * 지출거래삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteDealOutgoAll($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteDealOutgoAll', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * 이체거래삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteDealTransferAll($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteDealTransferAll', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
   	 	/**
         * 계정목록
         * 
         * @param $sort_index
         * @return unknown_type
         */
        function getAccountList($args) {
	
            $output = executeQueryArray('cashbook.getAccountList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookAccount = null;
                    $oCashbookAccount = new CashbookAccount();
                    $oCashbookAccount->setAttribute($val);
                    $output->data[$key] = $oCashbookAccount;
                }
            }

            return $output;
        	
        }
        
    	/**
         * 계정목록
         * 
         * @param $sort_index
         * @return unknown_type
         */
        function getAccountListAll($args) {
	
            $output = executeQueryArray('cashbook.getAccountListAll', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookAccount = null;
                    $oCashbookAccount = new CashbookAccount();
                    $oCashbookAccount->setAttribute($val);
                    $output->data[$key] = $oCashbookAccount;
                }
            }

            return $output;
        	
        }
        
    	/**
         * 계정전체가져오기
         * 
         * @param $sort_index
         * @return unknown_type
         */
        function getAccountAll($args) {
	
            $output = executeQueryArray('cashbook.getAccountAll', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookAccount = null;
                    $oCashbookAccount = new CashbookAccount();
                    $oCashbookAccount->setAttribute($val);
                    $output->data[$key] = $oCashbookAccount;
                }
            }

            return $output;
        	
        }
        
    	/**
         * @brief DB 에 생성된 한개의 정보를 구함
         * 
         * @return unknown_type
         */
        function getAccount($args) {
            $output = executeQuery('cashbook.getAccount', $args);
debugPrint($output);            
            if(!$output->data) {
            	return;
            }
        	$oCashbookAccount = null;
			$oCashbookAccount = new CashbookAccount();
            $oCashbookAccount->setAttribute($output->data);
            
            return $oCashbookAccount;
        }
                
    	/**
         * cashbook_account 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertAccount($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.insertAccount', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * cashbook_account 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateAccount($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.updateAccount', $args);
debugPrint($output);
            if(!$output->toBool()) return $output;

            return $output;
        }

    	/**
         * cashbook_account 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteAccount($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteAccount', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

    	/**
         * 계정삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteAccountAll($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteAccountAll', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

        /**
         * 전체 분류 목록을 구해옴
         * 
         * @return unknown_type
         */
        function getCategoryList($obj) {
            $member_info = Context::get('logged_info'); // 회원정보가져오기
            $args->member_srl = $member_info->member_srl;
            $args->sort_index = $obj->sort_index;
            $args->page = $obj->page?$obj->page:1;
            $args->list_count = $obj->list_count?$obj->list_count:20;
            $args->page_count = $obj->page_count?$obj->page_count:10;

            // 쿼리 실행
            $output = executeQuery('cashbook.getCategoryList', $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            return $output;
        }
            
    	/**
         * 수입/지출 등록시 대분류 항목을 가져온다.
         * 
         * @param $args
         * @return unknown_type
         */
        function getCategoryItemParentList($args){

        	// 쿼리실행
            $output =  executeQuery("cashbook.getCategoryItemParentList", $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) {
            	return $output;
            }
        	if(count($output->data)>1) {
                foreach($output->data as $key => $val) {   
                    $oCashbookItem = null;
                    $oCashbookItem = new CashbookItem();
                    $oCashbookItem->setAttribute($val);
                    $output->data[$key] = $oCashbookItem;
                }
            } else {
            	$oCashbookItem = new CashbookItem();
                $oCashbookItem->setAttribute($output->data);
                $output->data = $oCashbookItem;
            }
            return $output;
        }
                
    	/**
         * 분류 목록 전부 가져온다.
         * 
         * @return unknown_type
         */
        function getCategories($args) {
            $member_info = Context::get('logged_info'); // 회원정보가져오기
            $args->member_srl = $member_info->member_srl;

            // 쿼리 실행
            $output = executeQuery('cashbook.getCategories', $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            return $output;
        }
        
    	/**
         * member_srl을 기준으로 분류 목록 전부 가져온다.
         * 
         * @return unknown_type
         */
        function getCategoryAllByMemberSrl($args) {
            // 쿼리 실행
            $output = executeQuery('cashbook.getCategoryAllByMemberSrl', $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            return $output;
        }
        
        /**
         * @brief DB 에 생성된 한개의 메뉴 정보를 구함
         * 생성된 메뉴의 DB정보+XML정보를 return
         * @return unknown_type
         */
        function getCategory($category_srl) {
            // 일단 DB에서 정보를 가져옴
            $args->category_srl = $category_srl;
            $output = executeQuery('cashbook.getCategory', $args);
            if(!$output->data) return;

            $category_info = $output->data;
            $category_info->xml_file = sprintf('./files/cache/cashbook/%s.xml.php',$category_srl);
            $category_info->php_file = sprintf('./files/cache/cashbook/%s.php',$category_srl);
            return $category_info;
        }
        
        /**
         * cashbook_category 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertCategory($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.insertCategory', $args);
            if(!$output->toBool()) {
            	return $output;
            }
			
            $output->add('category_srl', $args->category_srl);
            
            return $output;
        }
        
    	/**
         * cashbook_category 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateCategory($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.updateCategory', $args);

            if(!$output->toBool()) {
            	return $output;
            }
			
			$output->add('category_srl', $args->category_srl);
             
            return $output;
        }
        
    	/**
         * @brief 특정 cashbook_category_srl의 아이템 정보를 return
         * 이 정보중에 group_srls의 경우는 , 로 연결되어 들어가며 사용시에는 explode를 통해 array로 변환 시킴
         **/
        function getCategoryItem($category_item_srl) {
            // category_item_srl이 있으면 해당 분류의 정보를 가져온다
            $args->category_item_srl = $category_item_srl;
            $output = executeQuery('cashbook.getCategoryItem', $args);

            $node = $output->data;
            if($node->group_srls) $node->group_srls = explode(',',$node->group_srls);
            else $node->group_srls = array();

            $tmp_name = unserialize($node->name);
            if($tmp_name && count($tmp_name) ) {
                $selected_lang = array();
                $rand_name = $tmp_name[Context::getLangType()];
                if(!$rand_name) $rand_name = array_shift($tmp_name);
                $node->name = $rand_name;
            }
            return $node;
        }

    	/**
         * cashbook_category_item 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertCategoryItem($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.insertCategoryItem', $args);
            if(!$output->toBool()) return $output;
			
            $output->add('category_item_srl', $args->category_item_srl);
            $output->add('category_srl', $args->category_srl);
            
            return $output;
        }
        
    	/**
         * cashbook_category_item 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateCategoryItem($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.updateCategoryItem', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
		
		/**
		 * 분류 아이템 목록을 listorder순으로 구해옴
		 * 
		 * @param $args
		 * @return unknown_type
		 */
    	function getCategoryItems($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.getCategoryItems', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
		 * 분류 아이템 목록을 listorder순으로 구해옴
		 * 
		 * @param $args
		 * @return unknown_type
		 */
    	function getCategoryItems2($args) {
		
            // 쿼리실행
            $output = executeQuery('cashbook.getCategoryItems2', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
        /**
         * 가장 큰 listorder를 가져온다.
         * 
         * @param $args
         * @return unknown_type
         */
    	function getCategoryMaxListorder($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.getCategoryMaxListorder', $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;

            return $output;
        }
        
        /**
         * listorder를 업데이트한다.
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateCategoryItemListorder($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.updateCategoryItemListorder', $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;

            return $output;
        }
        
		/**
		 * node를 수정한다.
		 * @param $args
		 * @return unknown_type
		 */
    	function updateCategoryItemNode($args) {
            // 쿼리실행
            $output =  executeQuery('cashbook.updateCategoryItemNode', $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;

            return $output;
        }
        

    	function getCategoryChildMenuCount($args) {
            // 쿼리실행
            $output =  executeQuery('cashbook.getCategoryChildMenuCount', $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;

            return $output;
        }
        
        /**
         * 분류항목 1개삭제
         * @param $args
         * @return unknown_type
         */
    	function deleteCategoryItem($args) {
            // 쿼리실행
            $output =  executeQuery("cashbook.deleteCategoryItem", $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * 분류항목들 삭제
         * @param $args
         * @return unknown_type
         */
    	function deleteCategoryItems($args) {
            // 쿼리실행
            $output =  executeQuery("cashbook.deleteCategoryItems", $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * 분류 삭제
         * @param $args
         * @return unknown_type
         */
    	function deleteCategory($args) {
            // 쿼리실행
            $output =  executeQuery("cashbook.deleteCategory", $args);
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;
            return $output;
        }

    	/**
         * 분류 삭제
         * @param $args
         * @return unknown_type
         */
    	function deleteCategoryAll($args) {
            // 쿼리실행
            $output =  executeQuery("cashbook.deleteCategoryAll", $args);
            
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * 분류항목 삭제
         * @param $args
         * @return unknown_type
         */
    	function deleteCategoryItemAll($args) {
            // 쿼리실행
            $output =  executeQuery("cashbook.deleteCategoryItemAll", $args);
            
            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()) return $output;
            return $output;
        }
        
    	/**
         * 거래처 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getCustomerList($args) {

            $output = executeQueryArray('cashbook.getCustomerList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookCustomer = null;
                    $oCashbookCustomer = new CashbookCustomer();
                    $oCashbookCustomer->setAttribute($val);
                    $output->data[$key] = $oCashbookCustomer;
                }
            }
            return $output;
        }
        
    	/**
         * 거래처전체 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getCustomerListAll($args) {

            $output = executeQueryArray('cashbook.getCustomerListAll', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookCustomer = null;
                    $oCashbookCustomer = new CashbookCustomer();
                    $oCashbookCustomer->setAttribute($val);
                    $output->data[$key] = $oCashbookCustomer;
                }
            }
            return $output;
        	
        }
        
    	/**
         * @brief DB 에 생성된 한개의 정보를 구함
         * 
         * @return unknown_type
         */
        function getCustomer($args) {
            $output = executeQuery('cashbook.getCustomer', $args);
            if(!$output->data) {
            	return;
            }
            return $output->data;
        }
        
    	/**
         * cashbook_customer 입력
         * 
         * @param $args
         * @return unknown_type
         */
    	function insertCustomer($args) {
            // 쿼리실행
            $output = executeQuery('cashbook.insertCustomer', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * cashbook_customer 수정
         * 
         * @param $args
         * @return unknown_type
         */
    	function updateCustomer($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.updateCustomer', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }

    	/**
         * cashbook_customer 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteCustomer($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteCustomer', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
    	/**
         * cashbook_customer 삭제
         * 
         * @param $args
         * @return unknown_type
         */
    	function deleteCustomerAll($args) {

            // 쿼리실행
            $output = executeQuery('cashbook.deleteCustomerAll', $args);
            if(!$output->toBool()) return $output;

            return $output;
        }
        
		/**
         * 월간 수입 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getIncomeMonthlyList($args) {	
            $output = executeQueryArray('cashbook.getIncomeMonthlyList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 월간 지출 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getOutgoMonthlyList($args) { 
            $output = executeQueryArray('cashbook.getOutgoMonthlyList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 월간 이체 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getTransferMonthlyList($args) {    
            $output = executeQueryArray('cashbook.getTransferMonthlyList', $args);
            
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
    	/**
         * 수입 총합
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getIncomeSum($args) {
            $output = executeQueryArray('cashbook.getIncomeSum', $args);
         
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                }
            }
            return $oCashbookDeal;
        	
        }
        
   		/**
         * 지출 총합
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getOutgoSum($args) {
            $output = executeQueryArray('cashbook.getOutgoSum', $args);

            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                }
            }
            return $oCashbookDeal;
        	
        }
        
    	/**
         * 기간별 거래 목록
         * 
         * @param $list_count
         * @param $page
         * @param $sort_index
         * @return unknown_type
         */
        function getDealListByPeriod($args) {
            $output = executeQueryArray('cashbook.getDealListByPeriod', $args);
            if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
            return $output;
        	
        }
        
        /**
         * Flex > 거래그래프: 수입
         * @param $args
         * @return unknown_type
         */
        function getFlexDealChartIncomeList($args){
        	$output = executeQueryArray('cashbook.getFlexDealChartIncomeList', $args);
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
        /**
         * Flex > 거래그래프: 지출
         * @param $args
         * @return unknown_type
         */
    	function getFlexDealChartOutgoList($args){
        	$output = executeQueryArray('cashbook.getFlexDealChartOutgoList', $args);
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 수입별항목그래프
         * @param $args
         * @return unknown_type
         */
    	function getFlexIncomeItemChartList($args){
        	$output = executeQueryArray('cashbook.getFlexIncomeItemChartList', $args);
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 지출별항목그래프
         * @param $args
         * @return unknown_type
         */
    	function getFlexOutgoItemChartList($args){
        	$output = executeQueryArray('cashbook.getFlexOutgoItemChartList', $args);
       	
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 거래처별항목그래프, 수입막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexCustomerIncomeChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexCustomerIncomeChartList', $args);

        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 거래처별항목그래프, 지출막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexCustomerOutgoChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexCustomerOutgoChartList', $args);
       	
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 분류별항목그래프, 수입막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexCategoryIncomeChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexCategoryIncomeChartList', $args);

        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 분류별항목그래프, 지출막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexCategoryOutgoChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexCategoryOutgoChartList', $args);
       	
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 태그별항목그래프, 수입막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexTagIncomeChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexTagIncomeChartList', $args);

        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
        
    	/**
         * Flex > 분류별항목그래프, 지출막대
         * @param $args
         * @return unknown_type
         */
    	function getFlexTagOutgoChartList($args){ 
        	$output = executeQueryArray('cashbook.getFlexTagOutgoChartList', $args);
       	
        	if(!$output->toBool()) return $output;

            if(count($output->data)) {
                foreach($output->data as $key => $val) {
                    $oCashbookDeal = null;
                    $oCashbookDeal = new CashbookDeal();
                    $oCashbookDeal->setAttribute($val);
                    $output->data[$key] = $oCashbookDeal;
                }
            }
        	return $output;
        }
    }

?>