<?php

    class cashbookDealChart extends Object {
    	var $date = null;
    	var $income = null;
    	var $outgo = null;
    	
    	
    	/**
		 * 생성자
		 * 
		 * @param $deal_srl
		 * @return unknown_type
		 */
        function cashbookDealChart($date = 0) { 
            if(!$date) return;
            $this->setCashbookDealChart($date);
        }
        
    	/**
         * 거래정보설정
         * 
         * @param $config_srl
         * @return unknown_type
         */
        function setCashbookDealChart($date) { 
            $this->date = $date;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 정보 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->date) return;

            $this->date;
            $output = executeQuery('cashbook.getCashbookFlexDealChart', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->date = $attribute->date;
        	$this->income = $attribute->income;
            $this->outgo =  $attribute->outgo;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->date?true:false;
        }
        
    	/**
         * getter
         * 
         * @return unknown_type
         */
    	function getDate() {
            if(!$this->isExists()) return;
            return $this->get('date');
        }
        
    	function getIncome() {
            if(!$this->isExists()) return;
            return $this->get('income');
        }
        
    	function getOutgo() {
            if(!$this->isExists()) return;
            return $this->get('outgo');
        }
    }
    
?>