<?php
    /**
     * CashbookXE 기본 클래스, Controller, View, Model은 이 클래스를 상속한다.
     * 
     * @class  cashbook
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 high class
     **/
	
	require_once(_XE_PATH_.'modules/cashbook/cashbook.config.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.account.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.customer.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.item.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.deal.php');
	//require_once(_XE_PATH_.'modules/cashbook/cashbook.solar.php');
	//require_once(_XE_PATH_.'modules/cashbook/cashbook.calendar123.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.calendar.php');
	require_once(_XE_PATH_.'modules/cashbook/cashbook.dealcount.php');
	
    class cashbook extends ModuleObject {
		
    	/**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
        	// 사용할 디렉토리 생성
            FileHandler::makeDir('./files/cache/cashbook');
            
        	/**
             * cashbook 이라는 mid를 미리 입력해 놓음
             * 이 mid는 차후 수정 가능하고 cashbook 메인 페이지를 사용하기 위한 더미 형식의 mid로 사용됨.
             **/
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $module_info = $oModuleModel->getModuleConfig('cashbook');
            if($module_info->mid) {
                $_o = executeQuery('module.getMidInfo', $module_info);
                if(!$_o->data) unset($module_info);
            }

            if(!$module_info->mid) {
                $args->module = 'cashbook';				//
                $args->mid = 'cashbook';                //
                $args->skin = 'cashbook_default';	    // 
                $args->browser_title = 'CashbookXE';	//
                $args->is_default = 'N';				//
                $args->open_rss = 'N';                  //
                $args->module_srl = getNextSequence();
                
                // 데이터입력(테이블: module)
                $output = $oModuleController->insertModule($args);
                $cashbook->mid = $args->mid;
                
				// 데이터입력(테이블: module_config)
            	$oModuleController->insertModuleConfig('cashbook', $cashbook);
            }
            
			return new Object();
        }
		
        /**
         * 모듈이 업데이트되었는지 검사
         * 
         * @return unknown_type
         */
        function checkUpdate() {
            return false;
        }
		
        /**
         * 모듈이 업데이트시 할 일
         * 
         * @return unknown_type
         */
        function moduleUpdate() {
            return new Object(0, 'success_updated');
        }
		
        /**
         * 캐쉬파일 재생성 버튼 클릭시 해야할 일
         * 
         * @return unknown_type
         */
        function recompileCache() {
        }
    }
?>
