<?php
    /**
     * 관리자모듈 업무 처리
     * 
     * @class  cashbookAdminController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 admin controller class
     **/

    class cashbookAdminController extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {

        }

        /**
         * 기본환경설정 수정
         * 대상테이블: modules, module_config
         * 
         * @return unknown_type
         */
        function procCashbookAdminSetup() {

            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');
            
            // 금전출납부기본설정가져오기
            $oCashbookModel = &getModel('cashbook');
            $module_info = $oCashbookModel->getModuleInfo();

            // 이미 등록된 금전출납부의 유무 체크
            $_module_info = $oModuleModel->getModuleInfoByMid($module_info->mid);
         
            if($module_info->mid && $_module_info) {
                $module_info->module_srl = $_module_info->module_srl;
                $is_registed = true;
            } else {
                $is_registed = false;
            }

            // mid, browser_title, is_default 값이 바뀌면 처리
            $module_info->mid = $args->mid = Context::get('mid');
            $args->browser_title = Context::get('browser_title');
            $args->is_default = Context::get('is_default');
            $args->skin = Context::get('default_skin');
            $args->layout_srl = Context::get('layout_srl');

            $args->module = 'cashbook';
            $args->module_srl = $is_registed?$module_info->module_srl:getNextSequence();

            if($args->is_default == 'Y') {
                $output = $oModuleController->clearDefaultModule();
                if(!$output->toBool()) return $output;
            }
			
            // 입력여부에 따라 업데이트를 할지 인서트를 할지 결정
            if($is_registed) {
                $output = $oModuleController->updateModule($args);
            } else {
                $output = $oModuleController->insertModule($args);
            }
            if(!$output->toBool()) return $output;

            // 그외 정보 처리
            $module_info->default_skin = Context::get('default_skin');
			
            // 생성메시지가져오기
            $module_info->create_message = Context::get('create_message');
            $module_info->use_signup = Context::get('use_signup');
            if($module_info->use_signup != 'Y') $module_info->use_signup = 'N';
			
            // 모델을 가져온 후 입력메서드 실행
            $oCashbookModel = &getModel('cashbook');
            $oCashbookModel->insertModuleInfo($module_info);

            $this->setMessage("success_saved");
        }
        
        /**
         * 설정수정 처리
         * 
         * @return unknown_type
         */
        function procCashbookAdminConfigUpdate(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

			// 해당 mid가 금지된 mid가 아닌지 검사한다.            
            if(in_array($args->mid, array('www','naver','hangame','promotion','notice','group','team','center','division','tf','faq','question','uit') )) {
            	return new Object(-1,'msg_denied_cashbook_title');
            }

            // 신청한 금전출납부 이름이 기본 모듈 이름 등과 겹치지 않도록 금지 아이디 목록에 있는지 검사
            // 금지 아이디 목록 - 기본 모듈과 사용자 지정 금지 아이디
            $oMemberModel = &getModel('member');
            if($oMemberModel->isDeniedID($args->mid)) return new Object(-1,'msg_denied_cashbook_title');

        	// modules 테이블에 입력할 정보 설정
            $args->is_default = 'N';
            $args->open_rss = 'N';
            
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateModule($args);
          
			// cashbook_config 테이블 수정
            $output = $oCashbookModel->updateConfig($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('module_srl',$output->get('module_srl'));
        }
        
        /**
         * 설정삭제 처리
         * 
         * @return unknown_type
         */
        function procCashbookAdminConfigDelete(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get
            
            // 입력할 값 설정
			$args->amount = 0;
			$args->transfer_srl = 0;

            $oCashbookModel = &getModel('cashbook');
            // cashbook_config 해당 데이터를 삭제한다.
            $output = $oCashbookModel->deleteConfig($args);
            
            // modules에서 데이터를 삭제한다.
            $output = $oCashbookModel->deleteModules($args);

            // cashbook_account 에서 데이터를 삭제한다.
        		// 현금계정삭제
				$args->kind = "CASH";				
				$output = $oCashbookModel->deleteAccountAll($args);
				// 은행계정삭제
				$args->kind = "BANK";				
				$output = $oCashbookModel->deleteAccountAll($args);
				// 자산계정삭제
				$args->kind = "ASSET";				
				$output = $oCashbookModel->deleteAccountAll($args);			
        		// 카드계정삭제
				$args->kind = "CARD";				
				$output = $oCashbookModel->deleteAccountAll($args);
        		// 부채계정삭제
				$args->kind = "DEBT";				
				$output = $oCashbookModel->deleteAccountAll($args);
            // cashbook_category 에서 데이터를 삭제한다.
            $output = $oCashbookModel->deleteCategoryAll($args);
            // cashbook_category_item 에서 데이터를 삭제한다.
            $output = $oCashbookModel->deleteCategoryItemAll($args);
            // cashbook_customer 에서 데이터를 삭제한다.
            $output = $oCashbookModel->deleteCustomerAll($args);
            // cashbook_deal 에서 데이터를 삭제한다.
        		// 수입삭제
				$output = $oCashbookModel->deleteDealIncomeAll($args);	
				// 지출삭제
				$output = $oCashbookModel->deleteDealOutgoAll($args);
				// 이체삭제
				$output = $oCashbookModel->deleteDealTransferAll($args);			
        }
    }
?>