<?php

    class cashbookDeal extends Object {
    	var $deal_srl         = null;    // 일련번호
    	var $site_srl         = null;    // 사이트일련번호, site.site_srl
    	var $module_srl       = null;    // 모듈일련번호, modules.module_srl
    	var $member_srl       = null;    // 회원일련번호, member.member_srl
    	var $account_srl      = null;
    	var $title            = null;    // 화면표시 - 사용내역
    	var $day              = null;    // 화면표시 - 거래일자
    	var $amount           = null;    // 화면표시 - 금액
    	var $waste_yn         = null;
    	var $item_srl         = null;
    	var $category_srl     = null;
    	var $category_name    = null;    // 화면표시 - 분류
    	var $customer_srl     = null;
    	var $customer_name    = null;    // 화면표시 - 거래처
    	var $tag              = null;
    	var $memo             = null;
    	var $input_date       = null;
    	var $parent_item_name = null;    // 화면표시 - 상위항목
    	var $item_name        = null;    // 화면표시 - 하위항목
    	var $sum              = null;    // 총합
    	var $transfer_srl     = null;    // 이체일련번호
    	/**
		 * 생성자
		 * 
		 * @param $deal_srl
		 * @return unknown_type
		 */
        function cashbookDeal($deal_srl = 0) { 
            if(!$deal_srl) return;
            $this->setCashbookDeal($deal_srl);
        }
        
    	/**
         * 거래정보설정
         * 
         * @param $config_srl
         * @return unknown_type
         */
        function setCashbookDeal($deal_srl) { 
            $this->deal_srl = $deal_srl;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 정보 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->deal_srl) return;

            $this->deal_srl;
            $output = executeQuery('cashbook.getDeal', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->deal_srl = $attribute->deal_srl;
        	$this->site_srl = $attribute->site_srl;
            $this->module_srl =  $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->day = $attribute->day;
            $this->amount = $attribute->amount;
            $this->sum = $attribute->sum;
            $this->parent_item_name = $attribute->parent_item_name;
            $this->customer_name = $attribute->customer_name;
            $this->category_name = $attribute->category_name;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->deal_srl?true:false;
        }
        
    	/**
         * getter
         * 
         * @return unknown_type
         */       
    	function getDealSrl() {
            if(!$this->isExists()) return;
            return $this->get('deal_srl');
        }
	
        function getAccountSrl() {
            if(!$this->isExists()) return;
            return $this->get('account_srl');
        }
                
    	function getTitle() {
            if(!$this->isExists()) return;
            return $this->get('title');
        }
        
    	function getDay() {
            if(!$this->isExists()) return;
            return $this->get('day');
        }
        
    	function getAmount() {
            if(!$this->isExists()) return;
            return $this->get('amount');
        }
        
        function getWasteYn(){
        	if(!$this->isExists()) return;
            return $this->get('waste_yn');
        }
        
    	function getItemParentSrl(){
        	if(!$this->isExists()) return;
            return $this->get('item_parent_srl');
        }
        
    	function getItemSrl(){
        	if(!$this->isExists()) return;
            return $this->get('item_srl');
        }
        
    	function getCategorySrl(){
        	if(!$this->isExists()) return;
            return $this->get('category_srl');
        }
        
    	function getCategoryName(){
        	if(!$this->isExists()) return;
            return $this->get('category_name');
        }
        
    	function getCustomerSrl(){
        	if(!$this->isExists()) return;
            return $this->get('customer_srl');
        }
        
    	function getCustomerName(){
        	if(!$this->isExists()) return;
            return $this->get('customer_name');
        }
        
    	function getTag(){
        	if(!$this->isExists()) return;
            return $this->get('tag');
        }
        
    	function getMemo(){
        	if(!$this->isExists()) return;
            return $this->get('memo');
        }
        
    	function getItemName(){
        	if(!$this->isExists()) return;
            return $this->get('item_name');
        }
        
    	function getParentItemName(){
        	if(!$this->isExists()) return;
            return $this->get('parent_item_name');
        }
        
    	function getSum(){
        	if(!$this->isExists()) return;
            return $this->get('sum');
        }
        
		function getTransferSrl(){
        	if(!$this->isExists()) return;
            return $this->get('transfer_srl');
        }
    }
    
?>