<?php
    /**
     * 사용자 업무 처리
     * 
     * @class  cashbookController
     * @author jedison (master@xgenesis.org)
     * @brief  cashbook 모듈의 Controller class
     **/

    class cashbookController extends cashbook {

        /**
         * @brief 초기화
         **/
        function init() {
       	
            $oCashbookModel = &getModel('cashbook');
            $oModuleModel = &getModel('module');
            // module_info 가져오기
            Context::set('module_info',$this->module_info = $oCashbookModel->getModuleInfo());
           
            // 로그인한 사용자의 금전출납부 설정을 controller에서 언제든지 사용하도록 load하여 Context setting
			Context::set('myCashbookConfig', $oCashbookModel->getConfigByMember());
	
            // 권한설정
            $this->grant = $oModuleModel->getGrant($this->module_info, Context::get('logged_info'), $this->xml_info);
            Context::set('grant', $this->grant);
       
        }
        
    	/**
         * @brief 금전출납부 생성
         **/
        function procCashbookCreate() {
  	
        	// 로그인이 되어 있는지 체크
            if(!Context::get('is_logged')) return new Object(-1,'msg_not_logged');

            // 권한이 있는지 체크
            if(!$this->grant->create) return new Object(-1,'msg_not_permitted');

            // 금전출납부를 이미생성했는지 검사
            $oCashbookModel = &getModel('cashbook');
            $myCashbook = $oCashbookModel->getConfigByMember();
            if($myCashbook->isExists()) return new Object(-1,'msg_cashbook_exists');

            // Context에 있는 값을 가져와서 파라미터에 할당
            $args->mid = Context::get("mid");	// module 테이블에서 mid로 사용할 값이다.
            
			// 해당 mid가 금지된 mid가 아닌지 검사한다.            
            if(in_array($args->mid, array('www','naver','hangame','promotion','notice','group','team','center','division','tf','faq','question','uit') )) {
            	return new Object(-1,'msg_denied_cashbook_mid');
            }
			
            // 해당 mid가 이미 있는지 검사한다.
            $checkDupe = $oCashbookModel->getConfigByMid($args);
            if($checkDupe->module_srl) return new Object(-1,'msg_cashbook_exists_mid');

            // 신청한 금전출납부 이름이 기본 모듈 이름 등과 겹치지 않도록 금지 아이디 목록에 있는지 검사
            // 금지 아이디 목록 - 기본 모듈과 사용자 지정 금지 아이디
            $oMemberModel = &getModel('member');              
            if($oMemberModel->isDeniedID($args->mid)) return new Object(-1,'msg_denied_cashbook_mid');

			// modules, module_config 테이블에 데이터 입력하기
	        	// 입력할 정보 설정
	        	//form이나 get으로 요청이 들어온 변수를 할당한다.
	            $args = Context::getRequestVars(); 						// form or get
	        	// 필요한 값 재설정
	            $args->module_srl = getNextSequence();					// 일련번호
	            $args->module = 'cashbook';
	            $site_module_info = Context::get('site_module_info');	// site_srl
	            $args->site_srl = (int)$site_module_info->site_srl;
	            $args->is_default = 'N';
	            $args->open_rss = 'N';
	
	            // 쿼리실행 > module.controller에 맡겨서 modules 에 필요한 정보를 입력한다.
	            $oModuleController = &getController('module');
	            $output = $oModuleController->insertModule($args);

            	// cashbook_config 테이블에 입력
            	// 입력할 정보 설정
            	$args->config_srl = getNextSequence();		    // 일련번호
            	// site_srl은 위에서 이미 설정됨
            	$args->module_srl = $output->get('module_srl');	// module_srl
	            $member_info = Context::get('logged_info');
	            $args->member_srl = $member_info->member_srl;			// member_srl	

				// 쿼리실행
	            $oCashbookModel = &getModel('cashbook');
	            $output = $oCashbookModel->insertConfig($args);
	
			// 기본값 입력하기
			$this->setDefaultAccountData($args);	// 계정
			$this->setDefaultIncomeData($args);		// 수입항목
			$this->setDefaultOutgoData($args);		// 지출항목
			
            // filter로 넘겨줄 값설정, $oCashbookModel->insertCashbook($args) 실행에 문제가 없었을 경우 아래의 코드가 실행된다.
            // $this객체에 add()로 변수를 등록하여 호출하여 XMLRPC로 리턴시 값을 추가함
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('mid', $args->mid);
            $this->add('mid_url', getUrl('','mid',$args->mid));
        }
        
        /**
         * 금전출납부 설정 수정
         * 
         * @return unknown_type
         */
        function procCashbookConfigUpdate(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

			// 해당 mid가 금지된 mid가 아닌지 검사한다.            
            if(in_array($args->mid, array('www','naver','hangame','promotion','notice','group','team','center','division','tf','faq','question','uit') )) {
            	return new Object(-1,'msg_denied_cashbook_title');
            }

            // 신청한 금전출납부 이름이 기본 모듈 이름 등과 겹치지 않도록 금지 아이디 목록에 있는지 검사
            // 금지 아이디 목록 - 기본 모듈과 사용자 지정 금지 아이디
            $oMemberModel = &getModel('member');
            if($oMemberModel->isDeniedID($args->mid)) return new Object(-1,'msg_denied_cashbook_title');

        	// modules 테이블에 입력할 정보 설정
            $args->is_default = 'N';
            $args->open_rss = 'N';
            
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateModule($args);
            
			// cashbook_config 테이블 수정
            $output = $oCashbookModel->updateConfig($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('module_srl',$output->get('module_srl'));
            
        }
        
        /**
         * 거래 (수입, 지출) 입력
         * @return unknown_type
         */
    	function procCashbookDealInsert() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

			// 지출일경우 금액을 마이너스로 변경
			if($args->ret_act=='dispCashbookOutgoList' && $args->amount>0){
				$args->amount = -$args->amount;
			}
			
            // 입력할 값 설정
            $args->deal_srl = getNextSequence();					// 일련번호
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->insertDeal($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
            
        }
        
    	/**
         * 거래 (수입, 지출) 수정
         * @return unknown_type
         */
    	function procCashbookDealUpdate() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateDeal($args);
	
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
        }

    	/**
         * 거래 (수입, 지출) 삭제
         * @return unknown_type
         */
    	function procCashbookDealDelete() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 삭제
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->deleteDeal($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
    	}
        
    	/**
         * 이체 등록
         * @return unknown_type
         */
    	function procCashbookTransferInsert() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            $args->transfer_srl = getNextSequence();
            
            $oCashbookModel = &getModel('cashbook');
                        
            // to_account로부터 계정이름을 가져온다.
            $args1->account_srl = Context::get('to_account');
            $toAccountName = $oCashbookModel->getAccount($args1);
            
			// from_account로부터 계정이름을 가져온다.
			$args1->account_srl = Context::get('from_account');
            $fromAccountName = $oCashbookModel->getAccount($args1);

            // from > to 를 위한 cashbook_deal 테이블에 입력
            $args->deal_srl = getNextSequence();					// 일련번호
            $args->account_srl = Context::get('from_account');
            $args->title = $fromAccountName->title." (이체:".$fromAccountName->title." > ".$toAccountName->title.")";
            $args->amount = -Context::get('amount');
            $output = $oCashbookModel->insertDeal($args);
            
            // to > from 를 위한 cashbook_deal 테이블에 입력
            $args->deal_srl = getNextSequence();					// 일련번호
            $args->account_srl = Context::get('to_account');
            $args->title = $toAccountName->title." (이체:".$fromAccountName->title." > ".$toAccountName->title.")";
            $args->amount = Context::get('amount');
            $output = $oCashbookModel->insertDeal($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);
    	}

    	/**
         * 이체 삭제
         * @return unknown_type
         */
    	function procCashbookTransferDelete() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	

            // cashbook_deal 삭제
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->deleteTransfer($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('deal_srl', $args->deal_srl);

    	}
    	
    	/**
         * 계정 입력
         * @return unknown_type
         */
    	function procCashbookAccountInsert() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 입력할 값 재설정
            $args->account_srl = getNextSequence();
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl

			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl

            // cashbook_account 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->insertAccount($args);
	
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
            $this->setMessage('success_registed');
			}	
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * 계정 수정
         * @return unknown_type
         */
    	function procCashbookAccountUpdate() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
          
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateAccount($args);

            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('account_srl', $args->account_srl);
        }
        
		/**
         * 계정삭제
         * @return unknown_type
         */
    	function procCashbookAccountDelete() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->deleteAccount($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
            }
			$this->add('ret_act', $args->ret_act);
            $this->add('account_srl', $args->account_srl);
    	}
    	
    	/**
         * 거래처입력
         * @return unknown_type
         */
    	function procCashbookCustomerInsert() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 입력할 값 재설정
            $args->customer_srl = getNextSequence();                // 일련번호
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');             // member_srl
            $args->member_srl = $member_info->member_srl;			

            // cashbook_account 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->insertCustomer($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
	            $this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * 거래처 수정
         * @return unknown_type
         */
    	function procCashbookCustomerUpdate() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateCustomer($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
            if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
            }
            $this->add('ret_act', $args->ret_act);
        }
        
		/**
         * 거래처 삭제
         * @return unknown_type
         */
    	function procCashbookCustomerDelete() {
    		//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 						// form or get

            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
            // cashbook_deal 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->deleteCustomer($args);
		
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){            
            	$this->setMessage($output->getMessage());
			} else {
				$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
    	}
    	
    	/**
         * @brief 분류 추가
         **/
        function procCashbookCategoryInsert() {
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 입력할 값 재설정
            $args->category_srl = getNextSequence();
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            $args->listorder = $args->category_srl * -1;			// listorder

            // cashbook_category 테이블에 입력
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->insertCategory($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_registed');
			}
            $this->add('ret_act', $args->ret_act);
            $this->add('category_srl', $args->category_srl);
        }
        
    	/**
         * @brief 분류 삭제
         **/
        function procCashbookCategoryDelete() {
			$args->category_srl = Context::get('category_srl');
			
            $oCashbookModel = &getModel('cashbook');
            
            // cashbook_category_item 테이블에서 삭제
            $output = $oCashbookModel->deleteCategoryItems($args);
            
            // cashbook_category 테이블에서 삭제
            $output = $oCashbookModel->deleteCategory($args);
            
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_deleted');
			}
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 분류 제목 변경
         **/
        function procCashbookCategoryUpdate() {

            // 입력할 변수 정리
            $args->title = Context::get('title');
            $args->category_srl = Context::get('category_srl');
			
            // cashbook_category 테이블 수정
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->updateCategory($args);
			
            // filter로 넘겨줄 값설정
            $this->setError($output->getError());
			if($output->getError()!=0){
            	$this->setMessage($output->getMessage());
			} else {
            	$this->setMessage('success_updated');
			}
            $this->add('ret_act', $args->ret_act);
        }

    	/**
         * @brief xml 파일을 갱신
         * 분류 구성 후 간혹 xml파일이 재생성 안되는 경우가 있는데\n
         * 이럴 경우 수동 갱신 기능을 구현해줌\n
         * 개발 중간의 문제인 것 같고 현재는 문제가 생기지 않으나 굳이 없앨 필요 없는 기능
         **/
        function procCashbookCategoryMakeXmlFile() {
        	
            // 입력값을 체크
            $category_srl = Context::get('category_srl');
//
//            // 해당 분류의 정보를 구함
//            $oCashbookModel = &getModel('cashbook');
//            $category_info = $oCashbookModel->getCategory($category_srl);

            // xml파일 재생성
            $xml_file = $this->makeXmlFile($category_srl);
            
            // xml파일 경로 리턴
			$this->add('xml_file', $xml_file);
        }
        
    	
    	/**
         * @brief xml 파일을 갱신
         * 분류 구성 후 간혹 xml파일이 재생성 안되는 경우가 있는데\n
         * 이럴 경우 수동 갱신 기능을 구현해줌\n
         * 개발 중간의 문제인 것 같고 현재는 문제가 생기지 않으나 굳이 없앨 필요 없는 기능
         **/
        function procCashbookCategoryItemMakeXmlFile() {

            // 입력값을 체크
            $category_item_srl = Context::get('category_item_srl');
            $selected_item = Context::get('item_srl');

            // xml파일 재생성
            $xml_file = $this->makeItemXmlFile($category_item_srl, $selected_item);
			
            // xml파일 경로 리턴
            $this->add('xml_file', $xml_file);
        }
        
        /**
         * @brief 특정 cashbook_category_srl의 정보를 이용하여 템플릿을 구한후 return
         * 특정 메뉴의 정보를 추가하기 위해 서버에서 tpl을 컴파일 한후 컴파일 된 html을 직접 return
         **/
    	function procCashbookCategoryItemInputTpl() {
    		$oCashbookModel = &getModel('cashbook');
    		
            // 해당 메뉴의 정보를 가져오기 위한 변수 설정
            $category_item_srl = Context::get('category_item_srl');
            $parent_srl = Context::get('parent_srl');

            // 회원 그룹의 목록을 가져옴
            $oMemberModel = &getModel('member');
            $group_list = $oMemberModel->getGroups();
            Context::set('group_list', $group_list);

            // parent_srl이 있고 cashbook_category_item_srl이 없으면 하부 메뉴 추가임
            if(!$category_item_srl && $parent_srl) {
                // 상위 메뉴의 정보를 가져옴
                $parent_info = $oCashbookModel->getCategoryItem($parent_srl);

                // 추가하려는 메뉴의 기본 변수 설정 
                $item_info->category_item_srl = getNextSequence();
                $item_info->parent_srl = $parent_srl;
                $item_info->parent_category_name = $parent_info->name;

            // root에 메뉴 추가하거나 기존 메뉴의 수정일 경우
            } else {
                // category_item_srl 이 있으면 해당 메뉴의 정보를 가져온다
                if($category_item_srl) {
                	$item_info = $oCashbookModel->getCategoryItem($category_item_srl);
                }

                // 찾아진 값이 없다면 신규 메뉴 추가로 보고 cashbook_category_item_srl값만 구해줌
                if(!$item_info->category_item_srl) {
                    $item_info->category_item_srl = getNextSequence();
                }
            }
            Context::set('item_info', $item_info);

            // template 파일을 직접 컴파일한후 tpl변수에 담아서 return한다.
            $oTemplate = &TemplateHandler::getInstance();
            
            // 일단은 템플릿파일의 위치를 고정시킨다. 나중에 스킨을 받아와서 처리할 것.
            $tpl = $oTemplate->compile($this->module_path.'skins/'.'cashbook_default/', 'category_item_input_tpl');	//category_item_input_tpl.html파일을의미한다.
			
            // 엔터처리
            $tpl = str_replace("\n"," ",$tpl);
            $tpl = str_replace("\r"," ",$tpl);
            $tpl = str_replace("\n\r"," ",$tpl);
            $this->add('tpl', $tpl);
        }
        
        /**
         * 분류항목을 입력 or 수정
         * 
         * @return unknown_type
         */
        function procCashbookCategoryItemInsert(){
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            
        	// 입력할 값 재설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl

			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
            // 이미 존재하는지를 확인
            $oCashbookModel = &getModel('cashbook');
            $item_info = $oCashbookModel->getCategoryItem($args->category_item_srl);

            // 존재하게 되면 update를 해준다
            if($item_info->category_item_srl == $args->category_item_srl) {
            	$output = $oCashbookModel->updateCategoryItem($args);
            // 존재하지 않으면 insert를 해준다
            } else {
            	$args->category_item_srl = getNextSequence();
                $args->listorder = -1*$args->category_item_srl;
                $output = $oCashbookModel->insertCategoryItem($args);
            }

            // 해당 분류의 정보를 구함
            $category_info = $oCashbookModel->getCategory($args->category_srl);
            $category_title = $category_info->title;

            // XML 파일을 갱신하고 위치을 넘겨 받음
            $xml_file = $this->makeXmlFile($args->category_srl);
		
            $this->add('xml_file', $xml_file);
            $this->add('category_srl', $args->category_srl);
            $this->add('category_item_srl', $args->category_item_srl);
            $this->add('category_title', $category_title);
            $this->add('parent_srl', $args->parent_srl);
        }        
        
    	/**
         * @brief 분류 이동
         **/
        function procCashbookCategoryItemMove() {
            $category_srl = Context::get('category_srl');
            $mode = Context::get('mode');
            $parent_srl = Context::get('parent_srl');
            $source_srl = Context::get('source_srl');
            $target_srl = Context::get('target_srl');

            if(!$category_srl || !$mode || !$target_srl) {
            	return new Object(-1,'msg_invalid_request');
            }
            $this->moveCategoryItem($category_srl,$parent_srl,$source_srl,$target_srl,$mode);
        }
        
        
    	/**
         * @brief 분류항목 삭제
         **/
        function procCashbookCategoryItemDelete() {
            // 변수 정리
            $args = Context::gets('category_srl','category_item_srl');

            $oCashbookModel = &getModel('cashbook');

            // 원정보를 가져옴
            $category_item_info = $oCashbookModel->getCategoryItem($args->menu_item_srl);
            if($category_item_info->parent_srl) {
            	$parent_srl = $category_item_info->parent_srl;
            }

            // 자식 노드가 있는지 체크하여 있으면 삭제 못한다는 에러 출력
            $output = $oCashbookModel->getCategoryChildMenuCount($args);
            if($output->data->count>0) {
            	return new Object(-1, 'msg_cannot_delete_for_child');
            }

            // DB에서 삭제
            $output = $oCashbookModel->deleteCategoryItem($args);

            // 해당 메뉴의 정보를 구함
            $category_info = $oCashbookModel->getCategory($args->category_srl);
            $category_title = $category_info->title;

            // XML 파일을 갱신하고 위치을 넘겨 받음
            $xml_file = $this->makeXmlFile($args->category_srl);

            $this->add('xml_file', $xml_file);
            $this->add('category_title', $category_title);
            $this->add('category_item_srl', $parent_srl);
            $this->setMessage('success_deleted');
        }
        
    		
        /**
         * 초기화하기
         * 
         * @param $args
         * @return unknown_type
         */
        function procCashbookInit(){
	
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = $args = Context::getRequestVars(); 						// form or get
			
            // 입력할 값 설정
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl	
            
			$args->amount = 0;
			$args->transfer_srl = 0;
			
            $oCashbookModel = &getModel('cashbook');

			// 거래초기화 (amout로 수입,지출,이체구분)
			$check_deal_array = explode("|@|", $args->check_deal);
			for ($i = 0; $i < count($check_deal_array); $i++) {
				
				$check_deal = $check_deal_array[$i];
				$check_deal_all_flag = false;
				if($check_deal=="all"){
					$check_deal_all_flag = true;
				}
				
				// 수입삭제
				if($check_deal_all_flag || $check_deal=="income"){					
					$output = $oCashbookModel->deleteDealIncomeAll($args);	
				}
				// 지출삭제
				if($check_deal_all_flag || $check_deal=="outgo"){
					$output = $oCashbookModel->deleteDealOutgoAll($args);
				}
				// 이체삭제
				if($check_deal_all_flag || $check_deal=="transfer"){
					$output = $oCashbookModel->deleteDealTransferAll($args);				
				}
			}
			
			// 계정초기화(kind로 현금,은행,자산,카드,부채구분)
			$check_account_array = explode("|@|", $args->check_account);
        	for ($i = 0; $i < count($check_account_array); $i++) {
				
				$check_account = $check_account_array[$i];
				$check_account_all_flag = false;
				if($check_account=="all"){
					$check_account_all_flag = true;
				}
				
				// 현금계정삭제, 기본값입력
				if($check_account_all_flag || $check_account=="cash"){
					$args->kind = "CASH";				
					$output = $oCashbookModel->deleteAccountAll($args);
					// 현금계정입력
					$this->setDefaultAccountData($args);	// 계정
				}
				// 은행계정삭제
				if($check_account_all_flag || $check_account=="bank"){
					$args->kind = "BANK";				
					$output = $oCashbookModel->deleteAccountAll($args);
				}
				// 자산계정삭제
				if($check_account_all_flag || $check_account=="asset"){
					$args->kind = "ASSET";				
					$output = $oCashbookModel->deleteAccountAll($args);			
				}
        		// 카드계정삭제
				if($check_account_all_flag || $check_account=="card"){
					$args->kind = "CARD";				
					$output = $oCashbookModel->deleteAccountAll($args);					
				}
        		// 부채계정삭제
				if($check_account_all_flag || $check_account=="debt"){
					$args->kind = "DEBT";				
					$output = $oCashbookModel->deleteAccountAll($args);				
				}
			}
			
			// 거래처초기화
        	$check_customer_array = explode("|@|", $args->check_customer);
        	for ($i = 0; $i < count($check_customer_array); $i++) {
				
				$check_customer = $check_customer_array[$i];
				$check_customer_all_flag = false;
				if($check_customer=="all"){
					$check_customer_all_flag = true;
				}
				
				// 거래처 삭제
				if($check_customer_all_flag){			
					$output = $oCashbookModel->deleteCustomerAll($args);					
				}

			}
			// 분류초기화
        	$check_category_array = explode("|@|", $args->check_category);
        	for ($i = 0; $i < count($check_category_array); $i++) {
				
				$check_category = $check_category_array[$i];
				$check_category_all_flag = false;
				if($check_category=="all"){
					$check_category_all_flag = true;
				}
				
				// 수입항목 삭제, 기본값입력
				if($check_category_all_flag || $check_category=="income"){
					$args->category_srl = $myCashbookConfig->income_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 수입항목입력
					$this->setDefaultIncomeData($args);		// 수입항목
				}
        		// 지출항목 삭제, 기본값입력
				if($check_category_all_flag || $check_category=="income"){
					$args->category_srl = $myCashbookConfig->outgo_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
					// 지출항목입력
					$this->setDefaultOutgoData($args);		// 지출항목
				}
        		// 거래분류 삭제
				if($check_category_all_flag || $check_category=="deal"){
					$args->category_srl = $myCashbookConfig->deal_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 현금계정 분류 삭제
				if($check_category_all_flag || $check_category=="income"){
					$args->category_srl = $myCashbookConfig->cash_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 은행계정 분류 삭제
				if($check_category_all_flag || $check_category=="bank"){
					$args->category_srl = $myCashbookConfig->bank_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 자산계정 분류 삭제
				if($check_category_all_flag || $check_category=="asset"){
					$args->category_srl = $myCashbookConfig->asset_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 카드계정 분류 삭제
				if($check_category_all_flag || $check_category=="card"){
					$args->category_srl = $myCashbookConfig->card_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 부채계정 분류 삭제
				if($check_category_all_flag || $check_category=="debt"){
					$args->category_srl = $myCashbookConfig->debt_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}
        		// 거래처 분류 삭제
				if($check_category_all_flag || $check_category=="customer"){
					$args->category_srl = $myCashbookConfig->customer_category_srl;
					$output = $oCashbookModel->deleteCategoryAll($args);
					$output = $oCashbookModel->deleteCategoryItemAll($args);
				}

			}

            $this->add('ret_act', $args->ret_act);	// 돌아갈 액션
            $this->add('deal_srl', $args->deal_srl);
            $this->setMessage('success_registed');
        }
        
        /**
         * 초기값으로 설정하기
         * 초기값 설정대상: cashbook_account
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultAccountData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');
        	
            // 기본값 입력하기 - cashbook_account 테이블
            // 입력할 정보 설정
            $args->account_srl = getNextSequence();		// 일련번호
            // site_srl, module_srl, member_srl 은 args에 담겨서 왔음
            $args->kind = "CASH";
            
            $tempYear = date("Y");
            $tempMonth = date("n");
            if($tempMonth < 10){
            	$tempMonth = "0".$tempMonth;
            }
            $tempDay = date("j");
        	if($tempMonth < 10){
            	$tempDay = "0".$tempDay;
            }
            $args->day = $tempYear.$tempMonth.$tempDay;
            $args->title = "내지갑";
            $args->amount = "0";
			$args->total_asset_yn = "Y";
            // cashbook_account 테이블에 입력
            $output = $oCashbookModel->insertAccount($args);
           
			return $output;
        } 
        
        /**
         * 
         * @return unknown_type
         */
        function setDefaultCategory($args, $title){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');
        	
        	// 입력할 정보 설정
			$args->category_srl = getNextSequence();		// 일련번호
			// site_srl, module_srl, member_srl 은 위에서 이미 설정됨
			$args->title= $title;
			$args->allow_delete= "N";
			$args->listorder = $args->category_srl * -1;	// listorder
			
            // 쿼리실행
            $output = $oCashbookModel->insertCategory($args);
            return $output;
        }
        
        function setDefaultCategoryItem($args, $parent_srl, $categor_srl, $title){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');
        	
        	// 입력할 정보 설정
            $args->category_item_srl = getNextSequence();		// 일련번호
            // site_srl, module_srl, member_srl 은 위에서 이미 설정됨
            $args->parent_srl = $parent_srl;	// parent_srl
            $args->category_srl = $categor_srl;	// category_srl
			$args->title = $title;
			// allow_delete 은 위에서 이미 설정됨
			$args->listorder = $args->category_item_srl * -1;	// listorder
			
			// 쿼리실행
            $output = $oCashbookModel->insertCategoryItem($args);
            
            return $output;
        }
        
        /**
         * 수입항목 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultIncomeData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"수입항목");
			$output1 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"근로소득");		
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"기본급");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"잔업수당");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"연/월차수당");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"설날상여금");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"휴가상여금");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"추석상여금");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"연말상여금");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"퇴직금");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output2 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"사업소득");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"매출");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output3 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"임대소득");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"전세보증금");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"월세보증금");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"월세");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output4 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"금융소득");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"주식배당금");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"채권배당금");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"예금이자");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"적금이자");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output5 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"증여소득");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"부모");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"형제");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output6 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타소득");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"기타");

			// 설정 수정하기 - cashbook_config
			// 수정할 정보 설정
			$args->income_category_srl = $output->get('category_srl');
			// 쿼리실행
			$output = $oCashbookModel->updateConfig($args);
				            
            return $output;
        }
        
    	/**
         * 지출항목 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultOutgoData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"지출항목");
			$output1 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"식비");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"주식");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"부식");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"외식");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"과일류");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"과자류");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"음료");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"주류");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"차류");
			$this->setDefaultCategoryItem($args,$output1->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output2 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"주거비");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"전기요금");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"수도요금");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"가스요금");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"관리비");
			$this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"월세");
		    $this->setDefaultCategoryItem($args,$output2->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output3 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"통신비");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"인터넷요금");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"휴대폰사용료");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"집전화요금");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"인터넷전화요금");
			$this->setDefaultCategoryItem($args,$output3->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output4 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"생활용품비");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"가구");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"가전");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"주방");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"욕실");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"잡화");
			$this->setDefaultCategoryItem($args,$output4->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output5 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"의복비");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"의류비");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"패션잡화");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"세탁소비");
			$this->setDefaultCategoryItem($args,$output5->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output6 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"미용비");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"사우나");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"화장품");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"미용실비");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"피부관리");
			$this->setDefaultCategoryItem($args,$output6->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output7 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"건강비");
			$this->setDefaultCategoryItem($args,$output7->get('category_item_srl'),$output->get('category_srl'),"병원비");
			$this->setDefaultCategoryItem($args,$output7->get('category_item_srl'),$output->get('category_srl'),"약품비");
			$this->setDefaultCategoryItem($args,$output7->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output8 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"문화비");
			$this->setDefaultCategoryItem($args,$output8->get('category_item_srl'),$output->get('category_srl'),"관람/입장료");
			$this->setDefaultCategoryItem($args,$output8->get('category_item_srl'),$output->get('category_srl'),"도서구입비");
			$this->setDefaultCategoryItem($args,$output8->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output9 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"교육비");
			$this->setDefaultCategoryItem($args,$output9->get('category_item_srl'),$output->get('category_srl'),"등록금");
			$this->setDefaultCategoryItem($args,$output9->get('category_item_srl'),$output->get('category_srl'),"학원비");
			$this->setDefaultCategoryItem($args,$output9->get('category_item_srl'),$output->get('category_srl'),"교재비");
			$this->setDefaultCategoryItem($args,$output9->get('category_item_srl'),$output->get('category_srl'),"학용품비");
			$this->setDefaultCategoryItem($args,$output9->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output10 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"육아비");
			$this->setDefaultCategoryItem($args,$output10->get('category_item_srl'),$output->get('category_srl'),"육아용품");
			$this->setDefaultCategoryItem($args,$output10->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output11 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"경조사");
			$this->setDefaultCategoryItem($args,$output11->get('category_item_srl'),$output->get('category_srl'),"경조사비");
			$this->setDefaultCategoryItem($args,$output11->get('category_item_srl'),$output->get('category_srl'),"선물");
			$this->setDefaultCategoryItem($args,$output11->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output12 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"모임");
			$this->setDefaultCategoryItem($args,$output12->get('category_item_srl'),$output->get('category_srl'),"회비");
			$this->setDefaultCategoryItem($args,$output12->get('category_item_srl'),$output->get('category_srl'),"유흥비");
			$this->setDefaultCategoryItem($args,$output12->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output13 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"교통비");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"지하철");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"택시");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"시내버스");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"고속버스");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"열차");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"비행기");
			$this->setDefaultCategoryItem($args,$output13->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output14 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"용돈");
			$this->setDefaultCategoryItem($args,$output14->get('category_item_srl'),$output->get('category_srl'),"부모");
			$this->setDefaultCategoryItem($args,$output14->get('category_item_srl'),$output->get('category_srl'),"자녀");
			$this->setDefaultCategoryItem($args,$output14->get('category_item_srl'),$output->get('category_srl'),"처가");
			$this->setDefaultCategoryItem($args,$output14->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output15 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"세금");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"근로소득세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"사업소득세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"양도소득세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"교육세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"농특세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"주민세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"재산세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"증여세");
			$this->setDefaultCategoryItem($args,$output15->get('category_item_srl'),$output->get('category_srl'),"취득세");
			$output16 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"카드대금");
			$this->setDefaultCategoryItem($args,$output16->get('category_item_srl'),$output->get('category_srl'),"카드대금");
			$output17 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"자동차");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차할부금");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차보험료");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차장식품");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차소모품");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"세차비");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"주유비");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"통행료");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"주차비");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차검사비");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차수리비");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"자동차세금");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"범칙금");
			$this->setDefaultCategoryItem($args,$output17->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output18 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"저축");
			$this->setDefaultCategoryItem($args,$output18->get('category_item_srl'),$output->get('category_srl'),"예금");
			$this->setDefaultCategoryItem($args,$output18->get('category_item_srl'),$output->get('category_srl'),"적금");
			$this->setDefaultCategoryItem($args,$output18->get('category_item_srl'),$output->get('category_srl'),"펀드");
			$this->setDefaultCategoryItem($args,$output18->get('category_item_srl'),$output->get('category_srl'),"연금");
			$this->setDefaultCategoryItem($args,$output18->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output19 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"보험");
			$this->setDefaultCategoryItem($args,$output19->get('category_item_srl'),$output->get('category_srl'),"종신보험");
			$this->setDefaultCategoryItem($args,$output19->get('category_item_srl'),$output->get('category_srl'),"상해보험");
			$this->setDefaultCategoryItem($args,$output19->get('category_item_srl'),$output->get('category_srl'),"의료보험");
			$this->setDefaultCategoryItem($args,$output19->get('category_item_srl'),$output->get('category_srl'),"연금보험");
			$this->setDefaultCategoryItem($args,$output19->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output20 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기부");
			$this->setDefaultCategoryItem($args,$output20->get('category_item_srl'),$output->get('category_srl'),"정치단체");
			$this->setDefaultCategoryItem($args,$output20->get('category_item_srl'),$output->get('category_srl'),"종교단체");
			$this->setDefaultCategoryItem($args,$output20->get('category_item_srl'),$output->get('category_srl'),"시민단체");
			$this->setDefaultCategoryItem($args,$output20->get('category_item_srl'),$output->get('category_srl'),"기타");
			$output21 = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타");
			$this->setDefaultCategoryItem($args,$output21->get('category_item_srl'),$output->get('category_srl'),"기타");
			// 설정 수정하기 - cashbook_config
			// 수정할 정보 설정
			$args->outgo_category_srl = $output->get('category_srl');
			// 쿼리실행
			$output = $oCashbookModel->updateConfig($args);

            return $output;
        }
        
        /**
         * 현금계정 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultCashData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"현금계정분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"내지갑");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"비상금");
        	return $output;
        }
        
    	/**
         * 은행계정 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultBankData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"은행계정분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"보통예금");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"정기적금");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"정기예금");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"대출");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타예금");
        	return $output;
        }
        
    	/**
         * 자산계정 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultAssetData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"자산계정분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"부동산");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"자동차");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"회원권");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"귀금속");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"빌려준돈");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타자산");
        	return $output;
        }
        
    	/**
         * 카드계정 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultCardData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"카드계정분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"신용카드");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"카드론");
        	return $output;
        }
        
    	/**
         * 부채계정 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultDebtData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"부채계정분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"빌린돈");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타부채");
        	return $output;
        }
        
    	/**
         * 거래처 분류 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultCustomerData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"거래처분류");
			$output = $this->setDefaultCategoryItem($args,0,$output->get('category_srl'),"기타");
        	return $output;
        }
        
    	/**
         * 거래분류 기본값 입력
         * 
         * @param $args
         * @return unknown_type
         */
        function setDefaultDealData($args){
        	// 모델객체생성
        	$oCashbookModel = &getModel('cashbook');

			$output = $this->setDefaultCategory($args,"거래분류");
        	return $output;
        }
    	/**
         * 실제이동시키기
         * 
         * @param $cashbook_category_srl
         * @param $parent_srl
         * @param $source_srl
         * @param $target_srl
         * @param $mode
         * @return unknown_type
         */
        function moveCategoryItem($category_srl,$parent_srl,$source_srl,$target_srl,$mode){
            // 원본 분류들을 구함
            $oCashbookModel = &getModel('cashbook');

            $target_item = $oCashbookModel->getCategoryItem($target_srl);
            if($target_item->category_item_srl != $target_srl) return new Object(-1,'msg_invalid_request');
			
            // 위치 이동 (순서 조절)
            if($mode == 'move') {
                $args->parent_srl = $parent_srl;
                $args->category_srl = $category_srl;

                if($source_srl) {
                    $source_item = $oCashbookModel->getCategoryItem($source_srl);
                    if($source_item->category_item_srl != $source_srl) {
                    	return new Object(-1,'msg_invalid_request');
                    }
                    $args->listorder = $source_item->listorder-1;
                }  else {
                    
                	$output = $oCashbookModel->getCategoryMaxListorder($args);
                    $args->listorder = (int)$output->data->listorder;
                    if(!$args->listorder) $args->listorder= 0;
                }
                
                $args->parent_srl = $parent_srl;
                $output = $oCashbookModel->updateCategoryItemListorder($args);
                
                $args->parent_srl = $parent_srl;
                $args->category_item_srl = $target_srl;
                $output = $oCashbookModel->updateCategoryItemNode($args);
                
            // 자식으로 추가
            } elseif($mode == 'insert') {
                $args->category_item_srl = $target_srl;
                $args->parent_srl = $parent_srl;
                $args->listorder = -1*getNextSequence();
                $output = $oCashbookModel->updateCategoryItemNode($args);
            }

            $xml_file = $this->makeXmlFile($menu_srl);
            return $xml_file;
        }
        
        /**
         * @brief 메뉴의 xml 파일을 만들고 위치를 return
         **/
        function makeXmlFile($category_srl) {

            // xml파일 생성시 필요한 정보가 없으면 그냥 return
            if(!$category_srl) return;

            // 분류 정보를 구함
            $args->category_srl = $category_srl;
            
            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCategory($category_srl);
            
            $site_srl = (int)$output->data->site_srl;

            if($site_srl) {
                $oModuleModel = &getModel('module');
                $site_info = $oModuleModel->getSiteInfo($site_srl);
                $domain = $site_info->domain;
            }

            // DB에서category_srl에 해당하는 메뉴 아이템 목록을 listorder순으로 구해옴
            $args->category_srl = $category_srl;
            $args->sort_index = 'listorder';
            
            $output = $oCashbookModel->getCategoryItems($args);

            // 캐시 파일의 이름을 지정
            $xml_file = sprintf("./files/cache/cashbook/%s.xml.php", $category_srl);
            $php_file = sprintf("./files/cache/cashbook/%s.php", $category_srl);

            // 구해온 데이터가 없다면 노드데이터가 없는 xml 파일만 생성
            $list = $output->data;
            if(!$list) {
                $xml_buff = "<root />";
                FileHandler::writeFile($xml_file, $xml_buff);
                FileHandler::writeFile($php_file, '<?php if(!defined("__ZBXE__")) exit(); ?>');
                return $xml_file;
            }

            // 구해온 데이터가 하나라면 array로 바꾸어줌
            if(!is_array($list)) {
            	$list = array($list);
            }

            // 루프를 돌면서 tree 구성
            $list_count = count($list);
            for($i=0;$i<$list_count;$i++) {
                $node = $list[$i];
                $category_item_srl = $node->category_item_srl;
                $parent_srl = $node->parent_srl;

                $tree[$parent_srl][$category_item_srl] = $node;
            }

            // 캐시 파일의 권한과 그룹 설정을 위한 공통 헤더
            $header_script =
                '$lang_type = Context::getLangType(); '.
                '$is_logged = Context::get(\'is_logged\'); '.
                '$logged_info = Context::get(\'logged_info\'); '.
                '$site_srl = '.$site_srl.';'.
                '$site_admin = false;'.
                'if($site_srl) { '.
                '$oModuleModel = &getModel(\'module\');'.
                '$site_module_info = $oModuleModel->getSiteInfo($site_srl); '.
                'Context::set(\'site_module_info\',$site_module_info);'.
                '$grant = $oModuleModel->getGrant($site_module_info, $logged_info); '.
                'if($grant->manager ==1) $site_admin = true;'.
                '}'.
                'if($is_logged) {'.
                    'if($logged_info->is_admin=="Y" || $site_admin) $is_admin = true; '.
                    'else $is_admin = false; '.
                    '$group_srls = array_keys($logged_info->group_list); '.
                '} else { '.
                    '$is_admin = false; '.
                    '$group_srsl = array(); '.
                '} ';

            // xml 캐시 파일 생성 (xml캐시는 따로 동작하기에 session 지정을 해주어야 함)
            $xml_buff = sprintf(
                '<?php '.
                'define(\'__ZBXE__\', true); '.
                'require_once(\'../../../config/config.inc.php\'); '.
                '$oContext = &Context::getInstance(); '.
                '$oContext->init(); '.
                'header("Content-Type: text/xml; charset=UTF-8"); '.
                'header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); '.
                'header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); '.
                'header("Cache-Control: no-store, no-cache, must-revalidate"); '.
                'header("Cache-Control: post-check=0, pre-check=0", false); '.
                'header("Pragma: no-cache"); '.
                '%s'.
                '?>'.
                '<root>%s</root>',
                $header_script,
                $this->getXmlTree($tree[0], $tree, $site_srl, $domain)
            );

            // php 캐시 파일 생성
            $php_output = $this->getPhpCacheCode($tree[0], $tree, $site_srl, $domain);
            $php_buff = sprintf(
                '<?php '.
                'if(!defined("__ZBXE__")) exit(); '.
                '%s; '.
                '%s; '.
                '$category->list = array(%s); '.
                '?>',
                $header_script,
                $php_output['name'],
                $php_output['buff']
            );

            // 파일 저장
            FileHandler::writeFile($xml_file, $xml_buff);
            FileHandler::writeFile($php_file, $php_buff);

            return $xml_file;
        }
        
        /**
         * 수입/지출 등록에서 하위항목 가져오기..
         * @param $category_item_srl
         * @return unknown_type
         */
    	function makeItemXmlFile($category_item_srl, $selected_item) {

            // xml파일 생성시 필요한 정보가 없으면 그냥 return
            if(!$category_item_srl) return;

            // 분류 정보를 구함
            $args->category_item_srl = $category_item_srl;

            $oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getCategoryItem($category_item_srl);
          
            $site_srl = (int)$output->data->site_srl;

            if($site_srl) {
                $oModuleModel = &getModel('module');
                $site_info = $oModuleModel->getSiteInfo($site_srl);
                $domain = $site_info->domain;
            }

            // DB에서category_item_srl를 parent_srl로 하는 아이템 목록을 listorder순으로 구해옴
            $args->parent_srl = $category_item_srl;
            $args->sort_index = 'listorder';
            
            $output = $oCashbookModel->getCategoryItems2($args);

            // 캐시 파일의 이름을 지정
            $xml_file = sprintf("./files/cache/cashbook/%s.xml.php", $category_item_srl);
            $php_file = sprintf("./files/cache/cashbook/%s.php", $category_item_srl);

            // 구해온 데이터가 없다면 노드데이터가 없는 xml 파일만 생성
            $list = $output->data;
         
            if(!$list) {
                $xml_buff = "<root />";
                FileHandler::writeFile($xml_file, $xml_buff);
                FileHandler::writeFile($php_file, '<?php if(!defined("__ZBXE__")) exit(); ?>');
                return $xml_file;
            }

            // 구해온 데이터가 하나라면 array로 바꾸어줌
            if(!is_array($list)) {
            	$list = array($list);
            }

            // 루프를 돌면서 node 구성
            $list_count = count($list);
            for($i=0;$i<$list_count;$i++) {
                $node = $list[$i];
               
                $node->selected_item=$selected_item;

                $tree[$i] = $node;
            }

            // 캐시 파일의 권한과 그룹 설정을 위한 공통 헤더
            $header_script =
                '$lang_type = Context::getLangType(); '.
                '$is_logged = Context::get(\'is_logged\'); '.
                '$logged_info = Context::get(\'logged_info\'); '.
                '$site_srl = '.$site_srl.';'.
                '$site_admin = false;'.
                'if($site_srl) { '.
                '$oModuleModel = &getModel(\'module\');'.
                '$site_module_info = $oModuleModel->getSiteInfo($site_srl); '.
                'Context::set(\'site_module_info\',$site_module_info);'.
                '$grant = $oModuleModel->getGrant($site_module_info, $logged_info); '.
                'if($grant->manager ==1) $site_admin = true;'.
                '}'.
                'if($is_logged) {'.
                    'if($logged_info->is_admin=="Y" || $site_admin) $is_admin = true; '.
                    'else $is_admin = false; '.
                    '$group_srls = array_keys($logged_info->group_list); '.
                '} else { '.
                    '$is_admin = false; '.
                    '$group_srsl = array(); '.
                '} ';

            // xml 캐시 파일 생성 (xml캐시는 따로 동작하기에 session 지정을 해주어야 함)
            $xml_buff = sprintf(
                '<?php '.
                'define(\'__ZBXE__\', true); '.
                'require_once(\'../../../config/config.inc.php\'); '.
                '$oContext = &Context::getInstance(); '.
                '$oContext->init(); '.
                'header("Content-Type: text/xml; charset=UTF-8"); '.
                'header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); '.
                'header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); '.
                'header("Cache-Control: no-store, no-cache, must-revalidate"); '.
                'header("Cache-Control: post-check=0, pre-check=0", false); '.
                'header("Pragma: no-cache"); '.
                '%s'.
                '?>'.
                '<root>%s</root>',
                $header_script,
                $this->getItemXmlTree($tree, $site_srl, $domain)
            );

            // 파일 저장
            FileHandler::writeFile($xml_file, $xml_buff);

            return $xml_file;
        }
        
    	/**
         * @brief array로 정렬된 노드들을 parent_srl을 참조하면서 recursive하게 돌면서 xml 데이터 생성
         * 메뉴 xml파일은 node라는 tag가 중첩으로 사용되며 이 xml doc으로 관리자 페이지에서 메뉴를 구성해줌\n
         * (tree_menu.js 에서 xml파일을 바로 읽고 tree menu를 구현)
         **/
        function getItemXmlTree($tree, $site_srl, $domain) {

            // source_node가 있다면
            foreach($tree as $i => $node) {

                // 변수 정리
                $names = $this->getCategoryItemNames($node->title, $site_srl);
                foreach($names as $key => $val) {
                    $name_arr_str .= sprintf('"%s"=>"%s",',$key, str_replace('\\','\\\\',htmlspecialchars($val)));
                }
                $name_str = sprintf('$_names = array(%s); print $_names[$lang_type];', $name_arr_str);

                $attribute = sprintf(
                    'node_srl="%s" parent_srl="%s" text="<?php { %s }?>" selected_item="%s" expand="%s"',
                    $node->category_item_srl,
                    $node->parent_srl,
                    $name_str,
                    $node->selected_item,
                    $node->expand
                );

                $buff .=  sprintf('<node %s />', $attribute);
            }

            return $buff;
		}
		
    	/**
         * @brief array로 정렬된 노드들을 parent_srl을 참조하면서 recursive하게 돌면서 xml 데이터 생성
         * 메뉴 xml파일은 node라는 tag가 중첩으로 사용되며 이 xml doc으로 관리자 페이지에서 메뉴를 구성해줌\n
         * (tree_menu.js 에서 xml파일을 바로 읽고 tree menu를 구현)
         **/
        function getXmlTree($source_node, $tree, $site_srl, $domain) {
        	// source_node가 있는지 검사
            if(!$source_node) return;
            // source_node가 있다면
            foreach($source_node as $category_item_srl => $node) {
                $child_buff = "";

                // 자식 노드의 데이터 가져옴
                if($category_item_srl&&$tree[$category_item_srl]) {
                	$child_buff = $this->getXmlTree($tree[$category_item_srl], $tree, $site_srl, $domain);
                }

                // 변수 정리
                $names = $this->getCategoryItemNames($node->title, $site_srl);
                foreach($names as $key => $val) {
                    $name_arr_str .= sprintf('"%s"=>"%s",',$key, str_replace('\\','\\\\',htmlspecialchars($val)));
                }
                $name_str = sprintf('$_names = array(%s); print $_names[$lang_type];', $name_arr_str);

                $attribute = sprintf(
                    'node_srl="%s" parent_srl="%s" text="<?php { %s }?>" expand="%s"',
                    $category_item_srl,
                    $node->parent_srl,
                    $name_str,
                    $node->expand
                );

                if($child_buff) {
                	$buff .= sprintf('<node %s>%s</node>', $attribute, $child_buff);
                } else {
                	$buff .=  sprintf('<node %s />', $attribute);
                }
            }

            return $buff;
		}
		
    	function getCategoryItemNames($source_name, $site_srl = null) {
            if(!$site_srl) {
                $site_module_info = Context::get('site_module_info');
                $site_srl = (int)$site_module_info->site_srl;
            }

            // 언어코드 구함
            $oModuleAdminModel = &getAdminModel('module');
            return $oModuleAdminModel->getLangCode($site_srl, $source_name);
        }
        
    	/**
         * @brief array로 정렬된 노드들을 php code로 변경하여 return
         * 메뉴에서 메뉴를 tpl에 사용시 xml데이터를 사용할 수도 있지만 별도의 javascript 사용이 필요하기에
         * php로 된 캐시파일을 만들어서 db이용없이 바로 메뉴 정보를 구할 수 있도록 한다
         * 이 캐시는 ModuleHandler::displayContent() 에서 include하여 Context::set() 한다
         **/
        function getPhpCacheCode($source_node, $tree, $site_srl, $domain) {
            $output = array("buff"=>"", "url_list"=>array());
            if(!$source_node) return $output;

            foreach($source_node as $menu_item_srl => $node) {
                // 자식 노드가 있으면 자식 노드의 데이터를 먼저 얻어옴
                if($category_item_srl&&$tree[$category_item_srl]) {
                	$child_output = $this->getPhpCacheCode($tree[$category_item_srl], $tree, $site_srl, $domain);
                } else {
                	$child_output = array("buff"=>"", "url_list"=>array());
                }

                // 변수 정리
                $names = $this->getCategoryItemNames($node->name, $site_srl);
                foreach($names as $key => $val) {
                    $name_arr_str .= sprintf('"%s"=>"%s",',$key, str_replace(array('\\','"'),array('\\\\','&quot;'),$val));
                }
                $name_str = sprintf('$_names[%d] = array(%s); %s', $node->category_item_srl, $name_arr_str, $child_output['name']);

                // 변수 정리
                $memo_str = $node->memo;
                $use_yn = $node->use_yn;
                $child_buff = $child_output['buff'];
                
                // 속성을 생성한다 ( url_list를 이용해서 선택된 메뉴의 노드에 속하는지를 검사한다. 꽁수지만 빠르고 강력하다고 생각;;)
                $attribute = sprintf(
                    '"node_srl"=>"%s",
                    "parent_srl"=>"%s",
                    "text"=>(%s?$_names[%d][$lang_type]:""),
					"memo"=>"%s",
                    "use_yn"=>"%s", 
                    "list"=>array(%s)',
                    $node->category_item_srl,
                    $node->parent_srl,
                    $node->category_item_srl,
                    $memo_str,
                    $use_yn,
                    $child_buff
                );

                // buff 데이터를 생성한다
                $output['buff'] .=  sprintf('%s=>array(%s),', $node->category_item_srl, $attribute);
                $output['name'] .= $name_str;
            }
            return $output;
        }

   		 /**
         * Flex에서 HttpService를 이용하여 로그인을 체크한다.
         * 
         * @return unknown_type
         */
        function procCashbookFlexCheckLogin(){
    	
        	$logged_info = Context::get('logged_info');
			
        	$flex_xml = "<root>";
        	if($logged_info->member_srl > 0){
        		$flex_xml .= "<loginYn>Y</loginYn>";
        	} else {
        		$flex_xml .= "<loginYn>N</loginYn>";
        	}
        	$flex_xml .= "</root>";
			Context::set('flex_xml', $flex_xml);
			
        	// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
        /**
         * 거래그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
        function getCashbookFlexDealChart(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
            $outputIncome = $oCashbookModel->getFlexDealChartIncomeList($args);
			$outputOutgo = $oCashbookModel->getFlexDealChartOutgoList($args);

			$startDate = $args->start_date;
			$endDate = $args->end_date;
			$currentDate = $startDate;
			// xml 구성하기
            $flex_xml = "<root>";
            for($i=0;$i<$endDate-$startDate+1;$i++){
            	$flex_xml .= "<list>";
            	// 날짜
	            //$flex_xml .= "<day>".substr($currentDate,0,4)."-".substr($currentDate,4,2)."-".substr($currentDate,6,2)."</day>";
	            $flex_xml .= "<day>".substr($currentDate,4,2)."-".substr($currentDate,6,2)."</day>";
	            // 수입
	            $incomeEmptyFlag = true;
            	foreach($outputIncome->data as $key => $val) {
            		if( $currentDate == $val->day){
						$flex_xml .= "<income>".$val->amount."</income>";
						$incomeEmptyFlag = false;
					}
				}
				if($incomeEmptyFlag){
					$flex_xml .= "<income>0</income>";
				}
				
				// 지출
            	$outgoEmptyFlag = true;
            	foreach($outputOutgo->data as $k => $v) {
            		if( $currentDate == $v->day){
						$flex_xml .= "<outgo>".-$v->amount."</outgo>";
						$outgoEmptyFlag = false;
					}
				}
				if($outgoEmptyFlag){
					$flex_xml .= "<outgo>0</outgo>";
				}

				$currentDate++;
				$flex_xml .= "</list>";
            }
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);
			
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 수입항목별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
        function getCashbookFlexIncomeItemChart(){
        	//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getFlexIncomeItemChartList($args);
debugPrint($output);
			// xml 구성하기
            $flex_xml = "<root>";
            if($output->data!=null){
				foreach($output->data as $key => $val){
					$flex_xml .= "<list>";
					$flex_xml .= "<item>";
					$flex_xml .= $val->parent_item_name;
	            	$flex_xml .= "</item>";
	            	$flex_xml .= "<amount>";
	            	$flex_xml .= $val->amount;
	            	$flex_xml .= "</amount>";
	            	$flex_xml .= "</list>";
				}
            } else {
            	$flex_xml .= "<list>";
				$flex_xml .= "<item></item>";
            	$flex_xml .= "<amount></amount>";
            	$flex_xml .= "</list>";
            }
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);
	
			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 지출항목별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function getCashbookFlexOutgoItemChart(){
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
            $output = $oCashbookModel->getFlexOutgoItemChartList($args);

			// xml 구성하기
            $flex_xml = "<root>";
            if($output->data!=null){
				foreach($output->data as $key => $val){
					$flex_xml .= "<list>";
					$flex_xml .= "<item>";
					$flex_xml .= $val->parent_item_name;
	            	$flex_xml .= "</item>";
	            	$flex_xml .= "<amount>";
	            	$flex_xml .= -$val->amount;
	            	$flex_xml .= "</amount>";
	            	$flex_xml .= "</list>";
				}
            } else {
            	$flex_xml .= "<list>";
				$flex_xml .= "<item></item>";
            	$flex_xml .= "<amount></amount>";
            	$flex_xml .= "</list>";
            }
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 거래처별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function getCashbookFlexCustomerChart(){
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
        	$outputIncome = $oCashbookModel->getFlexCustomerIncomeChartList($args);
			$outputOutgo = $oCashbookModel->getFlexCustomerOutgoChartList($args);

			// xml 구성하기
            $flex_xml = "<root>";
            // 수입
            $flex_xml .= "<income>";
            if($outputIncome->data!=null){
	            foreach($outputIncome->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<customer>".$val->customer_name."</customer>";
					$flex_xml .= "<amount>".$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputOutgo->data!=null){
	            	foreach($outputOutgo->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<customer>".$val->customer_name."</customer>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<customer></customer>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
            if($outputOutgo->data!=null){
	            foreach($outputOutgo->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<customer>".$val->customer_name."</customer>";
					$flex_xml .= "<amount>".-$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputIncome->data!=null){
	            	foreach($outputIncome->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<customer>".$val->customer_name."</customer>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<customer></customer>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 분류별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function getCashbookFlexCategoryChart(){
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
        	$outputIncome = $oCashbookModel->getFlexCategoryIncomeChartList($args);
			$outputOutgo = $oCashbookModel->getFlexCategoryOutgoChartList($args);

			// xml 구성하기
            $flex_xml = "<root>";
            // 수입
            $flex_xml .= "<income>";
            if($outputIncome->data!=null){
	            foreach($outputIncome->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<category>".$val->category_name."</category>";
					$flex_xml .= "<amount>".$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputOutgo->data!=null){
	            	foreach($outputOutgo->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<category>".$val->category_name."</category>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<category></category>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
            if($outputOutgo->data!=null){
	            foreach($outputOutgo->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<category>".$val->category_name."</category>";
					$flex_xml .= "<amount>".-$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputIncome->data!=null){
	            	foreach($outputIncome->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<category>".$val->category_name."</category>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<category></category>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
        
    	/**
         * 태그별그래프에서 사용할 데이터를 가져온다.
         * 
         * @return unknown_type
         */
    	function getCashbookFlexTagChart(){
			//form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 
            $args->amount=0;
            
            // site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');	// site_srl
            $args->site_srl = (int)$site_module_info->site_srl;
            $myCashbookConfig = Context::get('myCashbookConfig');	// module_srl
			$args->module_srl = $myCashbookConfig->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;			// member_srl
            
        	// 쿼리실행
        	$oCashbookModel = &getModel('cashbook');
        	$outputIncome = $oCashbookModel->getFlexTagIncomeChartList($args);
			$outputOutgo = $oCashbookModel->getFlexTagOutgoChartList($args);

			// xml 구성하기
            $flex_xml = "<root>";
            // 수입
            $flex_xml .= "<income>";
            if($outputIncome->data!=null){
	            foreach($outputIncome->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<tag>".$val->customer_name."</tag>";
					$flex_xml .= "<amount>".$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputOutgo->data!=null){
	            	foreach($outputOutgo->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<tag>".$val->customer_name."</tag>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<tag></tag>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</income>";

			// 지출
            $flex_xml .= "<outgo>";
            if($outputOutgo->data!=null){
	            foreach($outputOutgo->data as $key => $val) {
	            	$flex_xml .= "<list>";
					$flex_xml .= "<tag>".$val->customer_name."</tag>";
					$flex_xml .= "<amount>".-$val->amount."</amount>";
					$flex_xml .= "</list>";
				}
            } else {
            	if($outputIncome->data!=null){
	            	foreach($outputIncome->data as $key => $val) {
		            	$flex_xml .= "<list>";
						$flex_xml .= "<tag>".$val->customer_name."</tag>";
						$flex_xml .= "<amount>0</amount>";
						$flex_xml .= "</list>";
					}
            	} else {
            		$flex_xml .= "<list>";
					$flex_xml .= "<tag></tag>";
					$flex_xml .= "<amount></amount>";
					$flex_xml .= "</list>";
            	}
            }
			$flex_xml .= "</outgo>";
			
        	$flex_xml .= "</root>";

			Context::set('flex_xml', $flex_xml);

			// response를 XMLRPC로 변환
            Context::setResponseMethod('XMLRPC');
            
            // xml을 출력할 템플릿지정
            $this->setTemplatePath($this->module_path.'tpl');
        	$this->setTemplateFile('flex_xml');
        }
    }
?>