<?php

    class cashbookInfo extends Object {
    	var $cashbook_srl = null;    // cashbook_srl 일련번호 (가상?) 
    	var $module_srl = null;      // 모듈일련번호, modules.module_srl
		var $member_srl = null;      // 회원일련번호, member.member_srl
		var $family_type = null;     // 가계유형, cashbook.family_type
		var $child_count = null;     // 자녀수, cashbook.child_count
		var $month_income = null;    // 월소득, cashbook.month_income
		var $start_day = null;       // 월시작일, cashbook.start_day
		
		/**
		 * 생성자
		 * 
		 * @param $cashbook_srl
		 * @return unknown_type
		 */
        function cashbookInfo($cashbook_srl = 0) { 
            if(!$cashbook_srl) return;
            $this->setCashbook($cashbook_srl);
        }
    	
        /**
         * 금전출납부 정보설정
         * 
         * @param $cashbook_srl
         * @return unknown_type
         */
        function setCashbook($cashbook_srl) { 
            $this->module_srl = $this->cashbook_srl = $cashbook_srl;
            $this->_loadFromDB();
        }
        
        /**
         * DB에 저장된 설정 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->cashbook_srl) return;

            $args->module_srl = $this->cashbook_srl;
            $output = executeQuery('cashbook.getCashbook', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
        /**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
            if(!$attribute->module_srl) {
                $this->cashbook_srl = null;
                return;
            }
            $this->module_srl = $this->cashbook_srl = $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->colorset = $attribute->colorset;

            $this->adds($attribute);
        }
        
        /**
         * 홈여부판단 (주소/모듈명)
         * 
         * @return unknown_type
         */
    	function isHome() {
    		debugPrint("dddd");
            $module_info = Context::get('module_info');
            if($this->getModuleSrl() == $module_info->module_srl) return true;
            return false;
        }
        
        /**
         * 존재여부리턴
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->cashbook_srl?true:false;
        }
        
        /**
         * 금전출납부 소유여부 판단
         * 
         * @param $planet
         * @return unknown_type
         */
    	function isMyCashbook($cashbook = null) {
            if(!$this->isExists()) return;
            if(!Context::get('is_logged')) return false;
            $logged_info = Context::get('logged_info');
            if($cashbook) return $logged_info->member_srl == $cashbook->get('member_srl');
            return $logged_info->member_srl == $this->get('member_srl');
        }
        
        /**
         * getter
         * 
         * @return unknown_type
         */
    	function getFamilyType() {
            if(!$this->isExists()) return;
            return $this->get('family_type');
        }
    	
        function getChildCount() {
            if(!$this->isExists()) return;
            return $this->get('child_count');
        }
        
    	function getMonthIncome() {
            if(!$this->isExists()) return;
            return $this->get('month_income');
        }
        
    	function getStartDay() {
            if(!$this->isExists()) return;
            return $this->get('start_day');
        }
        
   		function getBrowserTitle() {
            if(!$this->isExists()) return;
            debugPrint($this->get('browser_title'));
            return $this->get('browser_title');
        }

        function getCashbookTitle() {
            if(!$this->isExists()) return;
            return $this->get('cashbook_title');
        }
        
    	function getMid() {
            if(!$this->isExists()) return;
            return $this->get('mid');
        }

        function getMemberSrl() {
            if(!$this->isExists()) return;
            return $this->get('member_srl');
        }

        function getModuleSrl() {
            if(!$this->isExists()) return;
            return $this->getCashbookSrl();
        }

        function getCashbookSrl() {
            if(!$this->isExists()) return;
            return $this->cashbook_srl;
        }

        function getCashbookMid() {
            if(!$this->isExists()) return;
            return $this->get('mid');
        }

        function getNickName() {
            if(!$this->isExists()) return;
            return $this->get('nick_name'); 
        }

        function getUserName() {
            if(!$this->isExists()) return;
            return $this->get('user_name'); 
        }

        function getUserID() {
            if(!$this->isExists()) return;
            return $this->get('getUserID'); 
        }
        
        /**
         * 컬러셋 가져오기
         * skin/스킨이름/_header.html에서 사용한다.
         * 
         * @return unknown_type
         */
    	function getColorset() {
            if($this->isHome() || !$this->colorset) {
                $module_info = Context::get('module_info');
                return $module_info->colorset;
            }
            return $this->colorset;

        }
    }
?>