<?php

    class cashbookItem extends Object {
    	var $category_item_srl= null    ;    // 일련번호
    	var $module_srl        = null;    // 모듈일련번호, modules.module_srl
		var $member_srl        = null;    // 회원일련번호, member.member_srl
    	var $title             = null    ;    // 제목
    	var $color             = null    ;    // 색
    	
    	/**
		 * 생성자
		 * 
		 * @param $category_item_srl
		 * @return unknown_type
		 */
        function cashbookItem($category_item_srl= 0) { 
            if(!$category_item_srl) return;
            $this->setCashbookItem($category_item_srl);
        }
        
    	/**
         * 
         * 
         * @param $category_item_srl
         * @return unknown_type
         */
        function setCashbookItem($category_item_srl) { 
            $this->cashbook_item_srl= $category_item_srl;
            $this->_loadFromDB();
        }
        
    	/**
         * DB에 저장된 설정 가져오기
         * @return unknown_type
         */
    	function _loadFromDB() {
            if(!$this->category_item_srl) return;

            $args->category_item_srl= $this->category_item_srl;
            $output = executeQuery('cashbook.getCategoryItem', $args);
            if(!$output->toBool()||!$output->data) return;

            $this->setAttribute($output->data);
        }
        
    	/**
         * 객체를 받아서 값을 세팅한다.
         * 
         * @param $attribute
         * @return unknown_type
         */
        function setAttribute($attribute) {
        	$this->category_item_srl= $attribute->category_item_srl;
        	$this->site_srl =  $attribute->site_srl;
            $this->module_srl =  $attribute->module_srl;
            $this->member_srl = $attribute->member_srl;
            $this->title = $attribute->title;
            $this->adds($attribute);
        }
        
    	/**
         * 존재여부
         * 
         * @return unknown_type
         */
    	function isExists() {
            return $this->category_item_srl?true:false;
        }
        
    	/**
         * getter
         * @return unknown_type
         */
    	function getCategoryItemSrl(){
			if(!$this->isExists()) return;
            return $this->get('category_item_srl'); 
        }
        
    	function getTitle(){
			if(!$this->isExists()) return;
            return $this->get('title'); 
        }
    }
?>